#include <allegro.h>
#include "menu.h"
#include "globals.h"


FONT *menu_font;


int display_menu() {

    int temp_x, temp_y, temp_b;

    while(!close_button_pressed) {

        for(;;) {

			temp_x = mouse_x;
			temp_y = mouse_y;
			temp_b = mouse_b;

			if (temp_b & 1) {

				if (temp_x > 300 && temp_x < 350 && temp_y > 158 && temp_y < 220)
					return 1;

				if (temp_x > 360 && temp_x < 410 && temp_y > 158 && temp_y < 220)
					return 2;

				if (temp_x > 420 && temp_x < 470 && temp_y > 158 && temp_y < 220)
					return 3;

				if (temp_x > 480 && temp_x < 530 && temp_y > 158 && temp_y < 220)
					return 4;

			}

			draw_menu();

		}

    }

    return 0;

}


void draw_menu() {

    char menu_msg[256];
    int n;

    menu_font = load_font("gfx/font.pcx", NULL, NULL);

    clear_to_color(board_buffer, makecol(0, 0, 0));
    textprintf_ex(board_buffer, menu_font, 60, 150, makecol(220, 200, 200), -1, "Players:");
    for (n = 0; n < MAX_PLAYERS; n++) {

        sprintf(menu_msg, "%d", n + 1);
        textprintf_centre_ex(board_buffer, menu_font, 350 + 60 * n, 150, makecol(220, 200, 200), -1, menu_msg);

    }
    circle(board_buffer, mouse_x, mouse_y, 30, makecol(255, 0, 0));
    blit(board_buffer, screen, 0, 0, 0, 0, board_buffer->w, board_buffer->h);

}
