#include <allegro.h>
#include "globals.h"
#include "graphics.h"
#include "log.h"
#include "structs.h"


char gfx_msg[256];


void draw_board() {

    blit(blank_board, board_buffer, 0, 0, 0, 0, blank_board->w, blank_board->h);
    add_to_log("Blitted blank_board to board_buffer.\n");
    draw_barriers(board_buffer);
    draw_tokens(board_buffer);

    blit(board_buffer, main_buffer, 0, 0, 0, 0, board_buffer->w, board_buffer->h);
    add_to_log("Blitted board_buffer to main buffer.\n");
    blit(turn_buffer, main_buffer, 0, 0, 0, TURN_BUFFER_Y, turn_buffer->w, turn_buffer->h);
    add_to_log("Blitted turn_buffer to main buffer.\n");
	scare_mouse();
    blit(main_buffer, screen, 0, 0, 0, 0, main_buffer->w, main_buffer->h);
    unscare_mouse();
    add_to_log("Blitted main buffer to screen.\n");

}


void draw_barriers(BITMAP *buffer) {

    int n;

    for (n = 0; n < NUM_BARRIERS; n++) {

        draw_sprite(buffer, barrier, EDGE_OFFSET + barriers[n].x * barrier->w, EDGE_OFFSET + barriers[n].y * barrier->h);
        sprintf(gfx_msg, "Blitted barrier[%d], at (%d, %d) to buffer.\n", n, barriers[n].x, barriers[n].y);
        add_to_log(gfx_msg);

    } // for (n = 0; n < NUM_BARRIERS; n++)

}


void draw_tokens(BITMAP *buffer) {

    int m, n;

    for (m = 0; m < MAX_PLAYERS; m++) {

        for (n = 0; n < NUM_TOKENS; n++) {

			draw_sprite(buffer, player[m], EDGE_OFFSET + player_tokens[m][n].x * player[m]->w, EDGE_OFFSET + player_tokens[m][n].y * player[m]->h);
			sprintf(gfx_msg, "Blitted token[%d][%d], at (%d, %d) to buffer.\n", m, n, player_tokens[m][n].x, player_tokens[m][n].y);
			add_to_log(gfx_msg);

        } // for (n = 0; n < NUM_TOKENS; n++)

    } // for (m = 0; m < MAX_PLAYERS; m++)

}
