#include <stdio.h>
#include <allegro.h>
#include <time.h>
#include "init.h"
#include "globals.h"
#include "log.h"
#include "menu.h"
#include "turn.h"


char main_msg[256];
int game_over;
volatile int close_button_pressed = 0;


void close_button_handler(void) {

    close_button_pressed = TRUE;
}
END_OF_FUNCTION(close_button_handler)


int main() {

    int n, game_over, num_players;

    begin_logging("malefiz.log");

    add_to_log("Calling setup().\n");
    setup();
    add_to_log("Returned from setup().\n");

    LOCK_FUNCTION(close_button_handler);
    set_close_button_callback(close_button_handler);

    num_players = display_menu();
    sprintf(main_msg, "num_players set to %d.\n", num_players);
    add_to_log(main_msg);

    set_mouse_sprite(mouse);
    show_mouse(screen);

    game_over = 0;
    while(!close_button_pressed) {

		for (n = 0; n < num_players; n++) {

			if(take_turn(n, num_players)) {

				game_over = 1;
				break;

			if(key[KEY_ESC])
				close_button_pressed = TRUE;

			}

		} // for (n = 0; n < num_players; n++)

    }

    end_logging();
    return 0;
}
END_OF_MAIN()
