#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "log.h"


FILE *log_file;
char temp[64], log_time[64];
time_t now;


void begin_logging(char *filename) {

    log_file = fopen(filename, "w");
    if (log_file == NULL) {

        printf("Error creating log file: %s.\n", filename);
        exit(1);
    }

    add_to_log("Logging begun.\n");

}


void end_logging() {

    add_to_log("Logging ends.\n");
    fclose(log_file);

}


void add_to_log(char *info) {

    time(&now);
    strcpy(temp, ctime(&now));
    strncpy(log_time, temp, strlen(temp) - 1);  // remove trailing \n from temp
    fprintf(log_file, "%s: %s", log_time, info);
    fflush(log_file);

}
