#include <allegro.h>
#include <time.h>
#include <stdlib.h>
#include "init.h"
#include "globals.h"
#include "log.h"
#include "graphics.h"
#include "structs.h"
#include "menu.h"


int board[18][19] = {

    { -1, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { -1,  0,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0, -1 },
    { -1,  0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1 },
    { -1,  0,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0, -1 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1,  9, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { -1, -1, -1, -1, -1, -1, -1,  0,  0,  9,  0,  0, -1, -1, -1, -1, -1, -1, -1 },
    { -1, -1, -1, -1, -1, -1, -1,  0, -1, -1, -1,  0, -1, -1, -1, -1, -1, -1, -1 },
    { -1, -1, -1, -1, -1,  0,  0,  9,  0,  0,  0,  9,  0,  0, -1, -1, -1, -1, -1 },
    { -1, -1, -1, -1, -1,  0, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1, -1, -1, -1 },
    { -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1, -1, -1 },
    { -1, -1, -1,  0, -1, -1, -1,  0, -1, -1, -1,  0, -1, -1, -1,  0, -1, -1, -1 },
    { -1,  9,  0,  0,  0,  9,  0,  0,  0,  9,  0,  0,  0,  9,  0,  0,  0,  9, -1 },
    { -1,  0, -1, -1, -1,  0, -1, -1, -1,  0, -1, -1, -1,  0, -1, -1, -1,  0, -1 },
    { -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }

};
location player_tokens[MAX_PLAYERS][NUM_TOKENS], player_tokens_start[MAX_PLAYERS][NUM_TOKENS];
location barriers[NUM_BARRIERS];
location valid_moves[NUM_TOKENS][10];
BITMAP *player[MAX_PLAYERS], *player_start[MAX_PLAYERS], *dice[6], *barrier, *border, *token_moved;
BITMAP *free_space, *blank_board, *board_buffer, *turn_buffer, *mouse, *main_buffer, *home_bay, *skip_turn;
int moves_count[NUM_TOKENS], left_button;
char init_msg[256];


void setup() {

// set PRNG seed
    srand(time(0));
    add_to_log("Seed for PRNG generated.\n");

	start_allegro();
	init_gfx();
	init_barriers();
	init_player_tokens();
	create_blank_board_bitmap();

}


// Get allegro up and running
void start_allegro() {

	int depth;

    allegro_init();
    add_to_log("Initiated Allegro.\n");

    install_timer();
    add_to_log("Timer system installed.\n");

    install_keyboard();
    add_to_log("Keyboard system installed.\n");

    install_mouse();
    add_to_log("Mouse system installed.\n");

    if ((depth = desktop_color_depth()) != 0)
        set_color_depth(depth);
    else {

        allegro_message("Error getting desktop colour depth.\n");
        add_to_log("Error getting desktop colour depth.\n");
        exit(1);

    }
    sprintf(init_msg, "Colour depth set to %d.\n", depth);
    add_to_log(init_msg);

    if (set_gfx_mode(GFX, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_WIDTH, SCREEN_HEIGHT) != 0) {

        allegro_message("Couldn't set graphics mode: %dx%d.\n", SCREEN_WIDTH, SCREEN_HEIGHT);
        sprintf(init_msg, "Couldn't set graphics mode: %dx%d.\n", SCREEN_WIDTH, SCREEN_HEIGHT);
        add_to_log(init_msg);
        exit(1);

    }
    sprintf(init_msg, "Set graphics mode to %dx%d.\n", SCREEN_WIDTH, SCREEN_HEIGHT);
    add_to_log(init_msg);

}


// load graphics and create buffers
void init_gfx() {

	int n;

    for (n = 1; n <= MAX_PLAYERS; n++) {

        sprintf(init_msg, "gfx/player_%d.bmp", n);
        player[n - 1] = load_bitmap(init_msg, NULL);
        if (!player[n - 1]) {

            allegro_message("Couldn't load \"player_%d.bmp\".\n", n);
            sprintf(init_msg, "Couldn't load \"player_%d.bmp\".\n", n);
            add_to_log(init_msg);
            exit(1);

        }
        sprintf(init_msg, "Player %d graphics loaded.\n", n);
        add_to_log(init_msg);

    } // for (n = 1; n <= MAX_PLAYERS; n++)

    for (n = 1; n <= MAX_PLAYERS; n++) {

        sprintf(init_msg, "gfx/p%d_start.bmp", n);
        player_start[n - 1] = load_bitmap(init_msg, NULL);
        if (!player_start[n - 1]) {

            allegro_message("Couldn't load \"p%d_start.bmp\".\n", n);
            sprintf(init_msg, "Couldn't load \"p%d_start.bmp\".\n", n);
            add_to_log(init_msg);
            exit(1);

        }
        sprintf(init_msg, "Player %d start graphics loaded.\n", n);
        add_to_log(init_msg);

    } // for (n = 1; n <= MAX_PLAYERS; n++)

	for (n = 0; n < 6; n++) {

        sprintf(init_msg, "gfx/dice_%d.bmp", n + 1);
        dice[n] = load_bitmap(init_msg, NULL);
        if (!dice[n]) {

            allegro_message("Couldn't load \"dice_%d.bmp\".\n", n + 1);
            sprintf(init_msg, "Couldn't load \"dice_%d.bmp\".\n", n + 1);
            add_to_log(init_msg);
            exit(1);

        }
        sprintf(init_msg, "Dice %d graphics loaded.\n", n + 1);
        add_to_log(init_msg);

    } // for (n = 0; n < 6; n++)

    barrier = load_bitmap("gfx/barrier.bmp", NULL);
    if (!barrier) {
        allegro_message("Couldn't load \"barrier.bmp\".\n");
        add_to_log("Couldn't load \"barrier.bmp\".\n");
        exit(1);
    }
    add_to_log("Barier graphics loaded.\n");

    free_space = load_bitmap("gfx/free_space.bmp", NULL);
    if (!free_space) {
        allegro_message("Couldn't load \"free_space.bmp\".\n");
        add_to_log("Couldn't load \"free_space.bmp\".\n");
        exit(1);
    }
    add_to_log("Free space graphics loaded.\n");

    mouse = load_bitmap("gfx/mouse.bmp", NULL);
    if (!mouse) {
        allegro_message("Couldn't load \"mouse.bmp\".\n");
        add_to_log("Couldn't load \"mouse.bmp\".\n");
        exit(1);
    }
    add_to_log("Mouse graphics loaded.\n");

    border = load_bitmap("gfx/border.bmp", NULL);
    if (!border) {
        allegro_message("Couldn't load \"border.bmp\".\n");
        add_to_log("Couldn't load \"border.bmp\".\n");
        exit(1);
    }
    add_to_log("Border graphics loaded.\n");

    home_bay = load_bitmap("gfx/home_bay.bmp", NULL);
    if (!home_bay) {
        allegro_message("Couldn't load \"home_bay.bmp\".\n");
        add_to_log("Couldn't load \"home_bay.bmp\".\n");
        exit(1);
    }
    add_to_log("Home bay graphics loaded.\n");

    token_moved = load_bitmap("gfx/token_moved.bmp", NULL);
    if (!token_moved) {
        allegro_message("Couldn't load \"token_moved.bmp\".\n");
        add_to_log("Couldn't load \"token_moved.bmp\".\n");
        exit(1);
    }
    add_to_log("Token moved graphics loaded.\n");

    skip_turn = load_bitmap("gfx/skip_turn.bmp", NULL);
    if (!skip_turn) {
        allegro_message("Couldn't load \"skip_turn.bmp\".\n");
        add_to_log("Couldn't load \"skip_turn.bmp\".\n");
        exit(1);
    }
    add_to_log("Skip Turn graphics loaded.\n");

    blank_board = create_bitmap(SCREEN_WIDTH, SCREEN_HEIGHT);
    if (!blank_board) {
        allegro_message("Couldn't create blank_board bitmap.\n");
        add_to_log("Couldn't create blank_board bitmap.\n");
        exit(1);
    }
    add_to_log("Created blank_board bitmap.\n");

    board_buffer = create_bitmap(SCREEN_WIDTH, SCREEN_HEIGHT);
    if (!board_buffer) {
        allegro_message("Couldn't create board_buffer bitmap.\n");
        add_to_log("Couldn't create board_buffer bitmap.\n");
        exit(1);
    }
    add_to_log("Created board_buffer bitmap.\n");

    turn_buffer = create_bitmap(SCREEN_WIDTH, TURN_BUFFER_HEIGHT);
    if (!turn_buffer) {
        allegro_message("Couldn't create turn_buffer bitmap.\n");
        add_to_log("Couldn't create turn_buffer bitmap.\n");
        exit(1);
    }
    add_to_log("Created turn_buffer bitmap.\n");

    main_buffer = create_bitmap(SCREEN_WIDTH, SCREEN_HEIGHT);
    if (!main_buffer) {
        allegro_message("Couldn't create main_buffer bitmap.\n");
        add_to_log("Couldn't create main_buffer bitmap.\n");
        exit(1);
    }
    add_to_log("Created main_buffer bitmap.\n");

}


// move through the board array to get board locations for barriers
void init_barriers() {

	int barrier_num = 0, x, y;

    for (y = 0; y < 16; y++) {

        for (x = 0; x < 19; x++) {

			if (board[y][x] == BARRIER_POSITION) {

				barriers[barrier_num].x = x;
				barriers[barrier_num].y = y;
				sprintf(init_msg, "Added barrier[%d] to array of bariers.\n", barrier_num);
				add_to_log(init_msg);

				barrier_num++;

			} // if (board[y][x] == 9)

        } // for (x = 0; x < 19; x++)

    } // for (y = 0; y < 16; y++)

}


// set initial player token locations
void init_player_tokens() {

	int m, n;

	player_tokens_start[0][0].x = 2;
	player_tokens_start[0][0].y = 15;
	add_to_log("Setting start location of player 1's 1st token to (2, 15).\n");
	player_tokens_start[0][1].x = 3;
	player_tokens_start[0][1].y = 15;
	add_to_log("Setting start location of player 1's 2nd token to (3, 15).\n");
	player_tokens_start[0][2].x = 4;
	player_tokens_start[0][2].y = 15;
	add_to_log("Setting start location of player 1's 3rd token to (4, 15).\n");
	player_tokens_start[0][3].x = 2;
	player_tokens_start[0][3].y = 16;
	add_to_log("Setting start location of player 1's 4th token to (2, 16).\n");
	player_tokens_start[0][4].x = 4;
	player_tokens_start[0][4].y = 16;
	add_to_log("Setting start location of player 1's 5th token to (4, 16).\n");

	player_tokens_start[1][0].x = 14;
	player_tokens_start[1][0].y = 15;
	add_to_log("Setting start location of player 2's 1st token to (14 15).\n");
	player_tokens_start[1][1].x = 15;
	player_tokens_start[1][1].y = 15;
	add_to_log("Setting start location of player 2's 2nd token to (15, 15).\n");
	player_tokens_start[1][2].x = 16;
	player_tokens_start[1][2].y = 15;
	add_to_log("Setting start location of player 2's 3rd token to (16, 15).\n");
	player_tokens_start[1][3].x = 14;
	player_tokens_start[1][3].y = 16;
	add_to_log("Setting start location of player 2's 4th token to (14, 16).\n");
	player_tokens_start[1][4].x = 16;
	player_tokens_start[1][4].y = 16;
	add_to_log("Setting start location of player 2's 5th token to (16, 16).\n");

	player_tokens_start[2][0].x = 6;
	player_tokens_start[2][0].y = 15;
	add_to_log("Setting start location of player 3's 1st token to (6, 15).\n");
	player_tokens_start[2][1].x = 7;
	player_tokens_start[2][1].y = 15;
	add_to_log("Setting start location of player 3's 2nd token to (7, 15).\n");
	player_tokens_start[2][2].x = 8;
	player_tokens_start[2][2].y = 15;
	add_to_log("Setting start location of player 3's 3rd token to (8, 15).\n");
	player_tokens_start[2][3].x = 6;
	player_tokens_start[2][3].y = 16;
	add_to_log("Setting start location of player 3's 4th token to (6, 16).\n");
	player_tokens_start[2][4].x = 8;
	player_tokens_start[2][4].y = 16;
	add_to_log("Setting start location of player 3's 5th token to (8, 16).\n");

	player_tokens_start[3][0].x = 10;
	player_tokens_start[3][0].y = 15;
	add_to_log("Setting start location of player 4's 1st token to (10, 15).\n");
	player_tokens_start[3][1].x = 11;
	player_tokens_start[3][1].y = 15;
	add_to_log("Setting start location of player 4's 2nd token to (11, 15).\n");
	player_tokens_start[3][2].x = 12;
	player_tokens_start[3][2].y = 15;
	add_to_log("Setting start location of player 4's 3rd token to (12, 15).\n");
	player_tokens_start[3][3].x = 10;
	player_tokens_start[3][3].y = 16;
	add_to_log("Setting start location of player 4's 4th token to (10, 16).\n");
	player_tokens_start[3][4].x = 12;
	player_tokens_start[3][4].y = 16;
	add_to_log("Setting start location of player 4's 5th token to (12, 16).\n");

// set player tokens to their start locations
	for (m = 0; m < MAX_PLAYERS; m++) {

		for ( n = 0; n < NUM_TOKENS; n++)
			player_tokens[m][n] = player_tokens_start[m][n];

	}

}


// creates the blank_board bitmap
void create_blank_board_bitmap() {

	int x, y;

    clear_to_color(blank_board, BOARD_COLOUR);
    add_to_log("Set blank_board colour.\n");

    for (y = 0; y < 16; y++) {

        for (x = 0; x < 19; x++) {

            if (board[y][x] >= EMPTY_POSITION) {

                draw_sprite(blank_board, free_space, EDGE_OFFSET + x * free_space->w, EDGE_OFFSET + y * free_space->h);
                sprintf(init_msg, "Blitted board[%d][%d] to blank_board.\n", y, x);
                add_to_log(init_msg);

            } // if (board[y][x] >= 0)

        } // for (x = 0; x < 19; x++)

    } // for (y = 0; y < 16; y++)

// blit starting locations to blank_board
    draw_sprite(blank_board, player_start[0], EDGE_OFFSET + player_start[0]->w * 3, EDGE_OFFSET + player_start[0]->h * 14);
    add_to_log("Blitted player 1 start indicator to blank_board.\n");
    draw_sprite(blank_board, player_start[1], EDGE_OFFSET + player_start[1]->w * 15, EDGE_OFFSET + player_start[1]->h * 14);
    add_to_log("Blitted player 2 start indicator to blank_board.\n");
    draw_sprite(blank_board,  player_start[2], EDGE_OFFSET + player_start[2]->w * 7, EDGE_OFFSET + player_start[2]->h * 14);
    add_to_log("Blitted player 3 start indicator to blank_board.\n");
    draw_sprite(blank_board,  player_start[3], EDGE_OFFSET + player_start[3]->w * 11, EDGE_OFFSET + player_start[3]->h * 14);
    add_to_log("Blitted player 4 start indicator to blank_board.\n");

// blit home_bays to blank_board
	draw_sprite(blank_board, home_bay, EDGE_OFFSET + player_start[0]->w * 3 - 35, EDGE_OFFSET + player_start[0]->h * 14 + 25);
	add_to_log("Blitted player 1's home bay to blank_board.\n");
    draw_sprite(blank_board, home_bay, EDGE_OFFSET + player_start[1]->w * 15 - 35, EDGE_OFFSET + player_start[1]->h * 14 + 25);
	add_to_log("Blitted player 2's home bay to blank_board.\n");
    draw_sprite(blank_board, home_bay, EDGE_OFFSET + player_start[2]->w * 7 - 35, EDGE_OFFSET + player_start[2]->h * 14 + 25);
 	add_to_log("Blitted player 3's home bay to blank_board.\n");
	draw_sprite(blank_board, home_bay, EDGE_OFFSET + player_start[3]->w * 11 - 35, EDGE_OFFSET + player_start[3]->h * 14 + 25);
	add_to_log("Blitted player 4's home bay to blank_board.\n");

}
