#include <allegro.h>
#include <stdlib.h>
#include "structs.h"
#include "globals.h"
#include "graphics.h"
#include "turn.h"
#include "move.h"
#include "log.h"


char turn_msg[256];
int selected_token;


int take_turn(int player_num, int num_players) {

    int n, roll, temp_x, temp_y, skipped = 0, total_moves = 0, turn_taken = 0;

    sprintf(turn_msg, "Player %d's turn begins.\n", player_num + 1);
    add_to_log(turn_msg);

    roll = (rand() % 5) + 1;
    sprintf(turn_msg, "Rolled a %d.\n", roll);
    add_to_log(turn_msg);

    clear_to_color(turn_buffer, BOARD_COLOUR);
    textprintf_ex(turn_buffer, menu_font, 20, 10, makecol(0, 0, 0), -1, "Player %d rolls...", player_num + 1);
    draw_sprite(turn_buffer, dice[roll - 1], DICE_X, DICE_Y);

    draw_board();

	check_moves_for_all_tokens(player_num, roll);

	for (n = 0; n < NUM_TOKENS; n++)
		total_moves += moves_count[n];

	if (total_moves > 0) {

		if (left_button) {

			while (left_button) {

				if (!mouse_b & 1)
					left_button = 0;

			} // while (left_button)

		} // if (left_button)

		while(!turn_taken) {

			if(key[KEY_ESC])
				close_button_pressed = TRUE;

			get_first_click(player_num);

			turn_taken = get_second_click(player_num);

		} // while(!turn_taken)

		check_for_other_players(player_num, num_players);

		check_for_barriers(player_num);

		if (check_if_won(player_num))
			return 1;
		else
			return 0;

	}
	else {

		scare_mouse();
		draw_sprite(screen, skip_turn, SKIP_TURN_X, TURN_BUFFER_Y + SKIP_TURN_Y);
		unscare_mouse();

		while (!skipped && !close_button_pressed) {

			temp_x = mouse_x;
			temp_y = mouse_y;

			if (mouse_b & 1) {

				if (temp_x > SKIP_TURN_X && temp_x < SKIP_TURN_X + skip_turn->w && temp_y > TURN_BUFFER_Y + SKIP_TURN_Y && temp_y < TURN_BUFFER_Y + SKIP_TURN_Y + skip_turn->h)
					skipped = 1;

			} // if (mouse_b & 1)

			if(key[KEY_ESC])
				close_button_pressed = TRUE;

		} // while (!skipped && !close_button_pressed)

		return 0;

	} // else

}


void check_moves_for_all_tokens(int player_num, int moves) {

	int n, x, y;
    location temp;

    for (n = 0; n < NUM_TOKENS; n++) {

    	temp.x = player_tokens[player_num][n].x;
    	temp.y = player_tokens[player_num][n].y;

    	sprintf(turn_msg, "Player %d's token %d is at (%d, %d).\n", player_num + 1, n + 1, temp.x, temp.y);
    	add_to_log(turn_msg);

    	if (temp.y > 13) {

    		temp.y = 14;

    		switch(player_num) {

				case 0: temp.x = 3;
						break;
				case 1: temp.x = 15;
						break;
				case 2: temp.x = 7;
						break;
				case 3: temp.x = 11;

    		} // switch(player_num)

    		sprintf(turn_msg, "Moved player %d's token %d to (%d, %d).\n", player_num + 1, n + 1, temp.x, temp.y);
    		add_to_log(turn_msg);

    	} // (temp.y > 13)

		moves_count[n] = 0;
		find_valid_moves(player_num, n, temp, moves, 0);

		if (moves_count[n] > 0) {

			x = EDGE_OFFSET + player_tokens[player_num][n].x * player[player_num]->w;
			y = EDGE_OFFSET + player_tokens[player_num][n].y * player[player_num]->h;
			scare_mouse();
			draw_sprite(screen, border, x, y);
			unscare_mouse();

		} // if (moves_count[n] > 0)

    } // for (n = 0; n < NUM_TOKENS; n++)

}


void get_first_click(int player_num) {

	int n, x1, y1, x2, y2, temp_x, temp_y;

	selected_token = -1;

	while (selected_token == -1 && !close_button_pressed) {

		temp_x = mouse_x + 12;
		temp_y = mouse_y + 12;

//		temp_x = mouse_x;
//		temp_y = mouse_y;

		if(mouse_b & 1) {

			x1 = (temp_x - EDGE_OFFSET) / free_space->w;
			y1 = (temp_y - EDGE_OFFSET) / free_space->h;

			for (n = 0; n < NUM_TOKENS; n++) {


/*				x1 = EDGE_OFFSET + player_tokens[player_num][n].x * player[player_num]->w - 4;  // 4 is tolerance
				y1 = EDGE_OFFSET + player_tokens[player_num][n].y * player[player_num]->h - 4;
				x2 = EDGE_OFFSET + player_tokens[player_num][n].x * player[player_num]->w + 24;  // 4 is tolerance
				y2 = EDGE_OFFSET + player_tokens[player_num][n].y * player[player_num]->h + 24;*/

//				if (temp_x > x1 && temp_x < x2 && temp_y > y1 && temp_y < y2) {
				if (x1 == player_tokens[player_num][n].x && y1 == player_tokens[player_num][n].y) {

					selected_token = n;

					x1 = EDGE_OFFSET + player_tokens[player_num][selected_token].x * player[player_num]->w;
					y1 = EDGE_OFFSET + player_tokens[player_num][selected_token].y * player[player_num]->h;

					scare_mouse();
					draw_sprite(screen, token_moved, x1, y1);
					set_mouse_sprite(player[player_num]);
					unscare_mouse();
					sprintf(turn_msg, "Player %d selected token %d at (%d, %d).\n", player_num + 1, selected_token + 1, player_tokens[player_num][selected_token].x, player_tokens[player_num][selected_token].y);
					add_to_log(turn_msg);

					break;

				} // if (temp_x > x1 && temp_x < x2 && temp_y > y1 && temp_y < y2)

			} // for (n = 0; n < NUM_TOKENS; n++)

		} // if(mouse_b & 1)

		if(key[KEY_ESC])
			close_button_pressed = TRUE;

	}

	for (n = 0; n < moves_count[selected_token]; n++) {

		x1 = EDGE_OFFSET + valid_moves[selected_token][n].x * player[player_num]->w + 1;
		y1 = EDGE_OFFSET + valid_moves[selected_token][n].y * player[player_num]->h + 1;
		x2 = EDGE_OFFSET + (valid_moves[selected_token][n].x + 1) * player[player_num]->w - 2;
		y2 = EDGE_OFFSET + (valid_moves[selected_token][n].y + 1) * player[player_num]->h - 2;

		scare_mouse();
		rect(screen, x1, y1, x2, y2, BORDER_COLOUR);
		unscare_mouse();

	} // for (n = 0; n < moves_count[selected_token]; n++)

}


int get_second_click(int player_num) {

	int temp_x, temp_y, x1, y1, x2, y2, n, move_made = 0;

	while (!move_made && !close_button_pressed) {

		temp_x = mouse_x + 12; // tolerance
		temp_y = mouse_y + 12;

		if (mouse_b & 1) {

			x1 = (temp_x - EDGE_OFFSET) / free_space->w;
			y1 = (temp_y - EDGE_OFFSET) / free_space->h;

			for (n = 0; n < moves_count[selected_token]; n++) {

				if (x1 == valid_moves[selected_token][n].x && y1 == valid_moves[selected_token][n].y && board[y1][x1] != player_num + 1) {

					board[player_tokens[player_num][selected_token].y][player_tokens[player_num][selected_token].x] = EMPTY_POSITION;
					player_tokens[player_num][selected_token].x = x1;
					player_tokens[player_num][selected_token].y = y1;
					board[y1][x1] = player_num + 1;

					move_made = 1;
					sprintf(turn_msg, "Player %d moved token %d to (%d, %d).\n", player_num + 1, selected_token + 1, x1, y1);
					add_to_log(turn_msg);
					break;

				} // if (x1 == valid_moves[selected_token][n].x && y1 == valid_moves[selected_token][n].y)

			} // for (n = 0; n < moves_count[selected_token]; n++)

		} // if (mouse_b & 1)

		if (mouse_b & 2) {

			x1 = EDGE_OFFSET + player_tokens[player_num][selected_token].x * player[player_num]->w;
			y1 = EDGE_OFFSET + player_tokens[player_num][selected_token].y * player[player_num]->h;

			scare_mouse();
			draw_sprite(screen, player[player_num], x1, y1);

			for (n = 0; n < moves_count[selected_token]; n++) {

				x1 = EDGE_OFFSET + valid_moves[selected_token][n].x * player[player_num]->w + 1;
				y1 = EDGE_OFFSET + valid_moves[selected_token][n].y * player[player_num]->h + 1;
				x2 = EDGE_OFFSET + (valid_moves[selected_token][n].x + 1) * player[player_num]->w - 2;
				y2 = EDGE_OFFSET + (valid_moves[selected_token][n].y + 1) * player[player_num]->h - 2;

				rect(screen, x1, y1, x2, y2, BOARD_COLOUR);

			} // for (n = 0; n < moves_count[selected_token]; n++)

			set_mouse_sprite(mouse);
			unscare_mouse();

			return 0;

		}

		if(key[KEY_ESC])
			close_button_pressed = TRUE;

	} // while (!move_made)

	scare_mouse();
	set_mouse_sprite(mouse);
	unscare_mouse();

	left_button = 1;

	return 1;

}


void check_for_other_players(int player_num, int num_players) {

	int m, n, temp_x, temp_y;

	for (m = 0; m < num_players; m++) {

		if (player_num != m) {

			sprintf(turn_msg, "Checking player %d's move against player %d's tokens.\n", player_num + 1, m + 1);
			add_to_log(turn_msg);

			temp_x = player_tokens[player_num][selected_token].x;
			temp_y = player_tokens[player_num][selected_token].y;

			for (n = 0; n < NUM_TOKENS; n++) {

				if (temp_x == player_tokens[m][n].x && temp_y == player_tokens[m][n].y) {

					player_tokens[m][n].x = player_tokens_start[m][n].x;
					player_tokens[m][n].y = player_tokens_start[m][n].y;
					sprintf(turn_msg, "Player %d landed on player %d.\n", player_num + 1, m + 1);
					add_to_log(turn_msg);

				} // if (temp_x == player_tokens[m][n].x && temp_y == player_tokens[m][n].y)

			} // for (n = 0; n < NUM_TOKENS; n++)

		} // if (player_num != m)

	} // for (m = 0; m < num_players; m++)

}


void check_for_barriers(int player_num) {

	int n, temp_x, temp_y, temp_mouse_x, temp_mouse_y, x1, x2, y1, y2, barrier_moved;

	for (n = 0; n < NUM_BARRIERS; n++) {

		temp_x = player_tokens[player_num][selected_token].x;
		temp_y = player_tokens[player_num][selected_token].y;

		if (temp_x == barriers[n].x && temp_y == barriers[n].y) {

			x1 = EDGE_OFFSET + player_tokens[player_num][selected_token].x * player[player_num]->w;
			y1 = EDGE_OFFSET + player_tokens[player_num][selected_token].y * player[player_num]->h;

			scare_mouse();
			draw_sprite(screen, free_space, x1, y1);
			draw_sprite(screen, player[player_num], x1, y1);
			set_mouse_sprite(barrier);
			unscare_mouse();

			barrier_moved = 0;
			while (!barrier_moved && !close_button_pressed) {

				temp_mouse_x = mouse_x + 12;
				temp_mouse_y = mouse_y + 12;

				if (mouse_b & 1) {

					x2 = (temp_mouse_x - EDGE_OFFSET) / free_space->w;
					y2 = (temp_mouse_y - EDGE_OFFSET) / free_space->h;

					if (board[y2][x2] == 0 && y2 < 13) {

						barriers[n].x = x2;
						barriers[n].y = y2;
						board[y2][x2] = BARRIER_POSITION;

						x1 = EDGE_OFFSET + x2 * barrier->w;
						y1 = EDGE_OFFSET + y2 * barrier->w;
						draw_sprite(screen, barrier, x1, y1);

						barrier_moved = 1;

						scare_mouse();
						set_mouse_sprite(mouse);
						unscare_mouse();

					} // if (board[y2][x2] == 0 && y2 < 13)

				} // if (mouse_b & 1)

			} // while (!barrier_moved)

			left_button = 1;

		} // if (temp_x == barriers[n].x && temp_y == barriers[n].y)

	} // for (n = 0; n < NUM_BARRIERS; n++)

}


int check_if_won(int player_num) {

	if (player_tokens[player_num][selected_token].x == 9 && player_tokens[player_num][selected_token].y == 0)
		return 1;
	else
		return 0;

}
