#ifndef VECTOR2_H
#define VECTOR2_H

#include <cmath>
using namespace std;

/************THE VECTOR IS ALWAYS KEPT NORMALIZED****************/
class Vector2
{
private:
    float x,y;
    float mag;
    
    /****************UTILITY FUNCTIONS************************/
    Vector2 add(Vector2 op2);
    Vector2 mult(float scalar);
    Vector2 neg(void);
    void normalize(void);
    
public:
    /****************INITILIZATION FUNCTIONS********************/
    void setVector(float _x, float _y, float _mag=-1);
    Vector2();
    Vector2(float _x, float _y, float _mag=-1);
    ~Vector2();

    /****************DATA ACCESS FUNCTIONS********************/
    float retXAsPos(void)   { return x*mag; }
    float retYAsPos(void)   { return y*mag; }
    float retXAsDir(void)   { return x; }
    float retYAsDir(void)   { return y; }
    float retMag(void)      { return mag; }
    void zero(void)         { x=0; y=0; mag=0; }

    /***************OVERLOADED OPERATORS************************/
    Vector2 operator-(void);
    Vector2 operator+(Vector2 &op2);    
    Vector2 operator-(Vector2 &op2);
    Vector2 operator+=(Vector2 &op2);  
    Vector2 operator-=(Vector2 &op2); 
    Vector2 operator*(float &scalar); 
    float operator|(Vector2 &op2);  
    
    
    Vector2 rotate(float ang);  //rotates it ang radians
    float dotProd(Vector2 &op2);
    Vector2 retNormal(void);
};

Vector2 makeVector2(float x, float y, float mag=-1);

#endif

