#include "vector2.h"

void Vector2::setVector(float _x, float _y, float _mag)
{
    x=_x;
    y=_y;
    normalize();
    
    if(_mag>=0)
        mag=_mag;
}

Vector2::Vector2()
{
    x=0; y=0; mag=0;
}

Vector2::Vector2(float _x, float _y, float _mag)
{
    setVector(_x,_y,_mag);
}

Vector2::~Vector2()
{

}

/*****************UTILITY FUNCTIONS*****************************/
void Vector2::normalize(void)
{
    mag = sqrt(x*x+y*y);
    
    if(mag!=0)
    {
        x/=mag;
        y/=mag;
    }
}

Vector2 Vector2::add(Vector2 op2)
{
    Vector2 ret;
    ret.x=x; ret.y=y; ret.mag=mag;
    
    ret.x*=ret.mag;
    ret.y*=ret.mag;
    
    ret.x += op2.x*op2.mag;
    ret.y += op2.y*op2.mag;
    
    ret.normalize();
    
    return ret;
}

Vector2 Vector2::mult(float scalar)
{
    Vector2 ret;
    ret.x=x; ret.y=y; ret.mag=mag;
    
    ret.mag*=scalar;
    
    return ret;
}

Vector2 Vector2::neg(void)
{
    Vector2 ret;
    ret.x=x; ret.y=y; ret.mag=mag;
    
    ret.x*=-1;
    ret.y*=-1;
    
    return ret;
}

/***************OVERLOADED OPERATORS**********************/
Vector2 Vector2::operator-(void)
{
    return this->neg();
}

Vector2 Vector2::operator+(Vector2 &op2)
{
    return this->add(op2);
} 

Vector2 Vector2::operator-(Vector2 &op2)
{
    return this->add(op2.neg());
}
 
Vector2 Vector2::operator+=(Vector2 &op2)
{
    *this = this->add(op2);
}

Vector2 Vector2::operator-=(Vector2 &op2)
{
    *this = this->add(op2.neg());
}
 
Vector2 Vector2::operator*(float &scalar)
{
    return this->mult(scalar);
} 

float Vector2::operator|(Vector2 &op2)
{
    return (*this).dotProd(op2);
}




Vector2 Vector2::rotate(float ang)
{
    Vector2 ret;
    
    ret.x =  retXAsPos()*cos(ang) + retYAsPos()*sin(ang);
    ret.y = -retXAsPos()*sin(ang) + retYAsPos()*cos(ang);
    ret.normalize();
    
    return ret;
} 

Vector2 Vector2::retNormal(void)
{
    Vector2 ret;
    
    ret.setVector(-y,x,mag);
    
    return ret;
}

float Vector2::dotProd(Vector2 &op2)
{
    return retXAsDir()*op2.retXAsDir() + retYAsDir()*op2.retYAsDir();
}


Vector2 makeVector2(float x, float y, float mag)
{
    Vector2 ret(x,y,mag);
    return ret;
}
