#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <cmath>
#include "Allegro.h"
#include "standards.h"
using namespace std;

#include "data.h"

#include "vector2.h"

#include "standards.h"
#include "Object.h"
#include "CAnim.h"
#include "Tile.h"
#include "Powerup.h"
#include "Map.h"
#include "Actor.h"
#include "Lep.h"

/*****************************PROTOTYPE DECLERATIONS***************************/
void programStartup(void);
void allegroStartup(void);
void logicLoop(void);
void graphicsLoop(void);
void resetTimers(void);
void calcFps(void);
void displayFps(void);
void pageFlipping(void);
void quit(void);

void menuGraphics(void);
void menuLogic(void);

void getKeys(void);

void gameStart(void);

void scrollRight(void);
void initPhrases(void);
void checkWinLoose(void);

void nextLevel(void);
void restartLevel(void);
void ingameMenuGraphics(void);
void ingameMenuLogic(void);

void displayStory(void);
void moveStory(void);

void displayWin(void);
void moveWin(void);

/*****************************CONSTANTS****************************************/
#define S_W 800
#define S_H 600
#define DEPTH   32

/*****************************TIMER STUFF**************************************/
int igLoops=0;
int ilLoops=0;
volatile int msec=0;     
void goSec()
{
    msec++;
}
END_OF_FUNCTION(goSec);

int secHistory[SEC_HISTORY];
int secHistoryDepth;
float fps;
int frames_skipped=0;


/*****************************GLOBAL VARIABLES*********************************/
BITMAP *backgr;
BITMAP *page[2];
int curPage=0;

Actor testActor;
Map curMap;
Lep lep;

DATAFILE *data;

float sx=0,sy=0;

float scrollSpeed=7;
float scrollAccel=0;
float normScrollSpeed=7;

TPhrases *phrases;
TPhrases english,french;

int gameState=GS_MENU;

char *displayText;
int countdown=0;

int curLevel=1;
int nLevels=4;

bool paused=false;
bool ingameMenu=false;
int storyFrame=0;

/*****************************MAIN FUNCTION************************************/
int main(void)
{
    programStartup();

    
    float incr=(float)1/(float)TARGET_FPS*(float)BPS;
    float count=msec+incr;

    initPhrases();
    while(gameState!=GS_QUIT)
    {
        //if(key[KEY_ESC])
        //    gameState=GS_MENU;
    
        
        calcFps();
        
        if(fps > TARGET_FPS)
        {
            if(gameState==GS_MENU)
                menuGraphics();
            else if(gameState==GS_STORY )
                displayStory();
            else
            {
                graphicsLoop(); 
            }
        }
        else
            frames_skipped++;
        
        if(msec>=(int)count)
        {
            if(gameState==GS_MENU)
                menuLogic();
            else if(gameState==GS_STORY)
                moveStory();
            else if(gameState==GS_WIN_GAME)
                moveWin();
            else
            {
                if(ingameMenu==true)
                    ingameMenuLogic();
                logicLoop();
            }
            count=msec + incr;
        } 
    }
    quit();
}
END_OF_MAIN();

void quit(void)
{
    toLog("Quitting");
    unload_datafile(data);
}


/*****************************MAIN GAME LOOPS**********************************/
void logicLoop(void)
{
    static bool keyPressed=false;
    ilLoops++;
    
    if(countdown==0 && paused==false)
    {
        testActor.resetForces();
        curMap.move();
        
        lep.move();
        
        if(gameState!=GS_WIN_LEVEL && gameState!=GS_LOOSE_LEVEL)
            getKeys();
        
        scrollRight();
        testActor.move(&curMap);
        
        checkWinLoose();
    }
    if(countdown>0 && paused==false)
    {
        countdown--;
        if(countdown==0)
            play_sample((SAMPLE*)data[splash].dat, 255, 128, 1000, FALSE);
    }
    
    if(gameState==GS_WIN_LEVEL)
    {
        if(key[KEY_SPACE])
            nextLevel();
    }
    else if(gameState==GS_LOOSE_LEVEL)
    {
        if(key[KEY_SPACE])
            restartLevel();
    }
    
    if(key[KEY_P] || key[KEY_ESC])
    {
        if(keyPressed==false)
        {
            keyPressed=true;
            
            if(key[KEY_P])
                paused = (paused==true)?false:true;
                
            if(key[KEY_ESC])
            {
                ingameMenu = (ingameMenu==true)?false:true;
                paused = (paused==true)?false:true;
            }
        }
    }
    else
        keyPressed=false;

    
}

void graphicsLoop(void)
{
    igLoops++;
    clear_to_color(backgr,makecol(200,200,250));
    //clear_to_color(backgr,makecol(250,150,30));
    
    curMap.drawSun(backgr,(int)sx,(int)sy);
    
    lep.draw(backgr,(int)sx,(int)sy);
    testActor.draw(backgr,(int)sx,(int)sy);
    
    
    curMap.draw(backgr,(int)sx,(int)sy);
    
    if(gameState==GS_WIN_LEVEL)
    {
        textprintf_centre(backgr,(FONT*)data[font1].dat,400,200,makecol(100,100,100),phrases->phrase[10]);
        textprintf_centre(backgr,(FONT*)data[font1].dat,401,201,makecol(200,0,0),phrases->phrase[10]);
        textprintf_centre(backgr,(FONT*)data[font2].dat,400,300,makecol(0,0,0),phrases->phrase[12]);
    }
    else if(gameState==GS_LOOSE_LEVEL)
    {
        textprintf_centre(backgr,(FONT*)data[font1].dat,400,200,makecol(100,100,100),phrases->phrase[11]);
        textprintf_centre(backgr,(FONT*)data[font1].dat,401,201,makecol(200,0,0),phrases->phrase[11]);
        textprintf_centre(backgr,(FONT*)data[font2].dat,400,300,makecol(0,0,0),phrases->phrase[12]);
    }
    
    if(countdown>0)
    {
        textprintf_centre(backgr,(FONT*)data[font1].dat,400,270,makecol(100,100,100),phrases->phrase[15]);
        textprintf_centre(backgr,(FONT*)data[font3].dat,400,300,makecol(100,100,100),"%d",(int)((float)countdown)/30+1);
    }
    
    //displayFps();    
    
    textprintf(backgr,(FONT*)data[font2].dat,10,10,makecol(100,100,100),"%s %d / %d %s",phrases->phrase[13],(curLevel-1)*439,nLevels*439,phrases->phrase[14]);
    textprintf(backgr,(FONT*)data[font2].dat,11,11,makecol(200,125,0),"%s %d / %d %s",phrases->phrase[13],(curLevel-1)*439,nLevels*439,phrases->phrase[14]);
    
    if(ingameMenu==true)
        ingameMenuGraphics();
    
    if(gameState == GS_WIN_GAME)
        displayWin();
    
    
    pageFlipping();
}


bool finished=false;
void checkWinLoose(void)
{
    finished=testActor.checkFinished(&curMap);
    
    if(finished==true)
    {
        if(gameState==GS_GAME)  //no one has won yet
        {
            gameState=GS_WIN_LEVEL;
        }
        else if(gameState==GS_WILL_LOOSE)
        {
            gameState=GS_LOOSE_LEVEL;
        }
    }
    
    
    finished=lep.checkFinished(&curMap);
    if(finished==true)
    {
        lep.setSpeed(0);
        if(gameState==GS_GAME)  //no one has won yet
        {
            gameState=GS_WILL_LOOSE;
        }
    }
}

void getKeys(void)
{
    if(key[KEY_LEFT])
        testActor.keyLeft();
    else if(key[KEY_RIGHT])
        testActor.keyRight();
        
    if(key[KEY_UP])
        testActor.keyUp();
    else if(key[KEY_DOWN])
        testActor.keyDown();
}

void scrollRight(void)
{
    if(testActor.retPos().retXAsPos()-sx < testActor.retWidth()/2+10 )
    {
        //testActor.keyRight();
        Vector2 pos = testActor.retPos();
        pos.setVector(sx+testActor.retWidth()/2+10,pos.retYAsPos());
        testActor.setPos(pos);
    }

    

    if(testActor.retPos().retXAsPos()-sx >= S_W/2 )
    {
        do
            sx++;
        while (testActor.retPos().retXAsPos()-sx >= S_W/2);
    }
    else
    {
        if(scrollSpeed > normScrollSpeed + .4)
           scrollSpeed -= .4;
    }
    if(scrollSpeed < normScrollSpeed)
        scrollSpeed +=.4;
    
    sx+=scrollSpeed;
    if(sx<0)
        sx=0;
        
    if(sx+S_W>=MAP_WIDTH*TILE_WIDTH)
        sx=MAP_WIDTH*TILE_WIDTH-S_W;
    
    if(testActor.retPos().retYAsPos() + testActor.retHeight() > S_W)
    {
        scrollSpeed=-50;
        testActor.setPos(makeVector2(sx+ testActor.retWidth()-50, -testActor.retHeight()/2));
        testActor.setVel(makeVector2(0,GRAV));
    }
}

/*****************************INITALIZATION FUNCTIONS**************************/
void gameStart(void)
{
    
    /*terrain[0].create(makeVector2(0,400));
    terrain[0].addPoint(makeVector2(50,360));
    terrain[0].addPoint(makeVector2(80,350));
    terrain[0].addPoint(makeVector2(150,375));
    terrain[0].addPoint(makeVector2(250,450));
    terrain[0].addPoint(makeVector2(400,500));
    terrain[0].addPoint(makeVector2(700,470));
    terrain[0].addPoint(makeVector2(800,470));
    
    
    nTerrain=1;
    
    Line bottom,right,top,left;
    
    bottom.create(makeVector2(-60,50),makeVector2(120,0));
    right.create(makeVector2(60,50),makeVector2(0,-100));
    top.create(makeVector2(60,-50),makeVector2(-120,0));
    left.create(makeVector2(-60,-50),makeVector2(0,100));
    
    //testActor.create(makeVector2(400,400),bottom,right,top,left);
    testActor.create(makeVector2(600,100),makeVector2(-60,50),
                                          makeVector2(60,50),
                                          makeVector2(60,-50),
                                          makeVector2(-60,-50));*/
                                          
    //testActor.setAngle(M_PI/4);
    
    TActorAtts atts;
    
    atts.xAccel=2.5;
    atts.jumpPower=20;
    atts.friction=.4;
    
    atts.maxSpeed=15;
    
    testActor.create(makeVector2(60,470),120,160,atts,"animations/pirate.anm");
    testActor.setDatafile(data);
    
    lep.create(400,70,115,111);
    lep.setSpeed(7);
    lep.setAnim("animations/lep.anm");
    
    curMap.init();
    
    char mapFile[40];
    switch(curLevel)
    {
        case 1:
            strcpy(mapFile,"map1.bmp");
            lep.setSpeed(8);
            break;
        case 2:
            strcpy(mapFile,"map2.bmp");
            lep.setSpeed(8);
            break;
        case 3:
            strcpy(mapFile,"map3.bmp");
            lep.setSpeed(8);
            break;
        case 4:
            strcpy(mapFile,"map4.bmp");
            lep.setSpeed(8);
            break;    
    }
    
    if(curMap.create(mapFile,"anims.txt")==true)
    {
        toLog("Map Loaded");
    }
    
    scrollSpeed=7;
    sx=0;
    sy=0;
    
    countdown=150;
    paused=false;
    ingameMenu=false;
    storyFrame=0;
}

void programStartup(void)
{
    toLog("Program startup");
    allegroStartup();
    
    toLog("Crating video bitmaps");
    page[0]=create_video_bitmap(SCREEN_W,SCREEN_H);
    page[1]=create_video_bitmap(SCREEN_W,SCREEN_H);
    rectfill(page[0],0,0,SCREEN_W,SCREEN_H,0);
    rectfill(page[1],0,0,SCREEN_W,SCREEN_H,0);
    curPage=0;
    backgr=page[curPage];

    if(!page[0] || !page[1])
    {
        toLog("Error allocating video memory");
        quit();
    }
    toLog("Video pages created\n");
    
    data=load_datafile("data.dat");
    
    resetTimers();
}

void allegroStartup(void)
{
    toLog("Allegro startup\n");
    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();

    set_color_depth(DEPTH);
    
    toLog("Initializing graphics");
    if(set_gfx_mode(GFX_AUTODETECT_WINDOWED,S_W,S_H,0,0)<0)
    {
        toLog("Error setting graphics mode\n");
        quit();
    }
    toLog("Graphics mode set\n");

    toLog("Initializing sound");
    if(install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL)<0)
    {
        toLog("Error setting sound\n");
        quit();
        exit(0);
    }
    toLog("Sound set up\n");
    
    srand(0);

    text_mode(-1);
     
    set_volume(200,130);

    toLog("Setting up timers\n");
    LOCK_VARIABLE(msec);
    LOCK_FUNCTION(goSec);
	install_int_ex(goSec, BPS_TO_TIMER(BPS)); //setup counter to fire BPS times a second
}

/****************************FPS AND TIMER ROUTINES****************************/
void resetTimers(void)
{
    msec=0;
    igLoops=0;
    ilLoops=0;
    
    for(int n=0 ; n<SEC_HISTORY ; n++)
    {
        secHistory[n]=0;
    }
    secHistoryDepth=0;
}

void calcFps(void)
{
    static int iLastlLoops=0;
    
    if(secHistoryDepth<SEC_HISTORY)
    {
        secHistory[secHistoryDepth]=(int)msec;
        secHistoryDepth++;
    }
    else
    {
        for(int n=0 ; n<SEC_HISTORY-1 ; n++)
        {
            secHistory[n] = secHistory[n+1];
        }
        secHistory[SEC_HISTORY-1]=msec;
    }

    fps=((float)(secHistoryDepth-1) / (float)(secHistory[secHistoryDepth-1]-secHistory[0])) * BPS;
}

void displayFps(void)
{
    textprintf(backgr,font,0,0,makecol(255,0,0),"logalical fps %0.0f",((float)ilLoops / (float)msec) * BPS);
    textprintf(backgr,font,0,10,makecol(255,0,0),"graphical fps: %0.0f",fps);
    textprintf(backgr,font,0,20,makecol(255,0,0),"frames skipped: %d",frames_skipped);
}

/*************************GRAPHICAL RELATED ROUTINES***************************/
void pageFlipping(void)
{
    show_video_bitmap(backgr);
    curPage = (curPage+1)%2;
    backgr = page[curPage];
}

void initPhrases(void)
{
    strcpy(english.phrase[0],"Play");
    strcpy(french.phrase[0],"Commence");
    
    strcpy(english.phrase[1],"Quit");
    strcpy(french.phrase[1],"Sort");
    
    strcpy(english.phrase[2],"En Francais");
    strcpy(french.phrase[2],"In English");
    
    strcpy(english.phrase[3],"English");
    strcpy(french.phrase[3],"Francais");
    
    strcpy(english.phrase[4],"Speed Boost!!");
    strcpy(french.phrase[4],"Vitesse Superbe!!");
    
    strcpy(english.phrase[5],"Arghhh :(");
    strcpy(french.phrase[5],"Arghhh :(");
    
    strcpy(english.phrase[6],"Speed: ");
    strcpy(french.phrase[6],"Vitesse: ");
    
    strcpy(english.phrase[7],"Jump Boost!!");
    strcpy(french.phrase[7],"Saut Superbe!!");
    
    strcpy(english.phrase[8],"Ouch!");
    strcpy(french.phrase[8],"Aie!");
    
    strcpy(english.phrase[9],"Jump: ");
    strcpy(french.phrase[9],"Saut: ");
    
    strcpy(english.phrase[10],"Victory, you got the gold");
    strcpy(french.phrase[10],"Succes, vous avez trouve l'or");    
    
    strcpy(english.phrase[11],"Too Late! The Leprechaun saved his gold");
    strcpy(french.phrase[11],"Essayez Encore!");      

    strcpy(english.phrase[12],"Hit Space");
    strcpy(french.phrase[12],"Pressez Espace!"); 

    strcpy(english.phrase[13],"Ransom: ");
    strcpy(french.phrase[13],"Racon: "); 
    
    strcpy(english.phrase[14],"Doubloons");
    strcpy(french.phrase[14],"Morceaux"); 

    strcpy(english.phrase[15],"Go for the gold!");
    strcpy(french.phrase[15],"Allez pour l'or!"); 

    strcpy(english.phrase[16],"Continue");
    strcpy(french.phrase[16],"Continue"); 
    
    strcpy(english.phrase[17],"Restart Level");
    strcpy(french.phrase[17],"Essaye Encore"); 
    
    strcpy(english.phrase[18],"Back to Menu");
    strcpy(french.phrase[18],"Sort"); 

    strcpy(english.phrase[19],"Use arrow keys to move, up to jump");
    strcpy(french.phrase[19],"Deplace le pirate avec les fleches"); 

    strcpy(english.phrase[20],"Speedhack 2004 Entry");
    strcpy(french.phrase[20],"Speedhack 2004 Entry"); 
    
    strcpy(english.phrase[21],"Richard Cassan");
    strcpy(french.phrase[21],"Richard Cassan"); 

    strcpy(english.phrase[22],"You have collected enough money to save Wendy!");
    strcpy(french.phrase[22],"Vous avez gagner!"); 

    strcpy(english.phrase[23],"Thank's for playing");
    strcpy(french.phrase[23],"Merci"); 

    phrases=&english;
    //phrases = &french;
}

int selected=0;
void menuGraphics(void)
{
    //clear_to_color(backgr,makecol(200,200,250));
    blit((BITMAP*)data[title].dat,backgr,0,0,0,0,S_W,S_H);
    
    textprintf_centre(backgr,(FONT*)data[font1].dat,400,390,makecol(0,0,0),phrases->phrase[0]);
    textprintf_centre(backgr,(FONT*)data[font1].dat,400,460,makecol(0,0,0),phrases->phrase[2]);
    textprintf_centre(backgr,(FONT*)data[font1].dat,400,530,makecol(0,0,0),phrases->phrase[1]);

    switch(selected)
    {
        case 0:
            textprintf_centre(backgr,(FONT*)data[font1].dat,401,391,makecol(200,0,0),phrases->phrase[0]);    
            break;
        case 1:
            textprintf_centre(backgr,(FONT*)data[font1].dat,401,461,makecol(200,0,0),phrases->phrase[2]);
            break;
        case 2:
            textprintf_centre(backgr,(FONT*)data[font1].dat,401,531,makecol(200,0,0),phrases->phrase[1]);
            break;
    }
    
    textprintf(backgr,(FONT*)data[font2].dat,30,560,makecol(200,0,0),phrases->phrase[19]);
    
    textprintf(backgr,(FONT*)data[font2].dat,650,540,makecol(0,0,0),phrases->phrase[20]);
    textprintf(backgr,(FONT*)data[font2].dat,650,560,makecol(0,0,0),phrases->phrase[21]);
    
    pageFlipping();
}

void menuLogic(void)
{
    static bool keyPressed=false;

    if(key[KEY_UP] || key[KEY_DOWN] || key[KEY_ENTER])
    {
        if(keyPressed==false)
        {
            keyPressed=true;
            if(key[KEY_UP])
                selected--;
            else if(key[KEY_DOWN])
                selected++;
                
            if(selected<0)
                selected=2;
            else if(selected>2)
                selected=0;
         
            play_sample((SAMPLE*)data[click].dat, 255, 128, 1000, FALSE);
                
            if(key[KEY_ENTER])
            {
                if(selected==0)
                {
                    gameState=GS_STORY;
                    curLevel=1;
                    gameStart();
                    play_midi((MIDI*)data[song1].dat,TRUE);

                }
                else if(selected==1)
                {
                    if(phrases==&english)
                        phrases=&french;
                    else if(phrases==&french)
                        phrases=&english;

                }
                else
                {
                    gameState=GS_QUIT;
                }
              
                       
            }       
        }
        
    }
    else
        keyPressed=false;
}

void nextLevel(void)
{
    curLevel++;
    if(curLevel>nLevels)
    {
        gameState=GS_WIN_GAME;
    }
    else
    {
        gameStart();
        gameState=GS_GAME;
    }
}

void restartLevel(void)
{
    gameStart();
    gameState=GS_GAME;
}

void ingameMenuGraphics(void)
{
    //rectfill(backgr,0,290,S_W,480,makecol(100,100,100));

    for(int n=0 ; n<S_H/2 ; n++)
        line(backgr,0,n*2,S_W,n*2,makecol(200,200,200));

    textprintf_centre(backgr,(FONT*)data[font1].dat,400,300,makecol(0,0,0),phrases->phrase[16]);
    textprintf_centre(backgr,(FONT*)data[font1].dat,400,370,makecol(0,0,0),phrases->phrase[17]);
    textprintf_centre(backgr,(FONT*)data[font1].dat,400,440,makecol(0,0,0),phrases->phrase[18]);

    switch(selected)
    {
        case 0:
            textprintf_centre(backgr,(FONT*)data[font1].dat,401,301,makecol(200,0,0),phrases->phrase[16]);    
            break;
        case 1:
            textprintf_centre(backgr,(FONT*)data[font1].dat,401,371,makecol(200,0,0),phrases->phrase[17]);
            break;
        case 2:
            textprintf_centre(backgr,(FONT*)data[font1].dat,401,441,makecol(200,0,0),phrases->phrase[18]);
            break;
    }
    
}

void ingameMenuLogic(void)
{
    static bool keyPressed=false;

    if(key[KEY_UP] || key[KEY_DOWN] || key[KEY_ENTER])
    {
        if(keyPressed==false)
        {
            keyPressed=true;
            if(key[KEY_UP])
                selected--;
            else if(key[KEY_DOWN])
                selected++;
                
            if(selected<0)
                selected=2;
            else if(selected>2)
                selected=0;
         
                
            if(key[KEY_ENTER])
            {
                if(selected==0)
                {
                    ingameMenu=false;
                    paused=false;
                }
                else if(selected==1)
                {
                    restartLevel();
                }
                else
                    gameState=GS_MENU;
              
                       
            }       
        }
        
    }
    else
        keyPressed=false;
}

BITMAP *temp;
void displayStory(void)
{
    clear_to_color(backgr,makecol(0,0,0));
    
    if(storyFrame>=0 && storyFrame<4)
    {
        temp = (BITMAP*)data[story1+storyFrame].dat;
        blit(temp,backgr,0,0,(S_W-temp->w)/2,5,S_W,S_H);
    }
        
    textprintf_centre(backgr,(FONT*)data[font2].dat,400,570,makecol(250,0,0),phrases->phrase[12]);    
    pageFlipping();
}

void moveStory(void)
{
    static bool keyPressed=false;
    
    if(key[KEY_SPACE])
    {
        if(keyPressed==false)
        {
            keyPressed=true;
            storyFrame++;
            if(storyFrame>=4)   //end of the story
                gameState=GS_GAME;
        }
    }
    else
        keyPressed=false;
}

void displayWin(void)
{
    textprintf_centre(backgr,(FONT*)data[font1].dat,400,270,makecol(200,0,0),phrases->phrase[22]);    
    textprintf_centre(backgr,(FONT*)data[font1].dat,400,310,makecol(200,0,0),phrases->phrase[23]);    

    textprintf_centre(backgr,(FONT*)data[font2].dat,400,570,makecol(0,0,0),phrases->phrase[12]);    
}

void moveWin(void)
{
    static bool keyPressed=true;
    
    if(key[KEY_SPACE])
    {
        if(keyPressed==false)
        {
            gameState=GS_MENU;
        }
    }
    else
        keyPressed=false;
}
