// Class automatically generated by Dev-C++ New Class wizard

#ifndef ACTOR_H
#define ACTOR_H

#include "data.h"

#include "standards.h"
#include "Vector2.h"
#include "Object.h" // inheriting class's header file
#include "CAnim.h"
#include "Tile.h"
#include <cstring>
using namespace std;

#include "Map.h"

/*
     _________2
   3|         |
    |         | 
    |         | 
    |_________| 1
     0        
*/

#define LEFT true
#define RIGHT false


typedef struct
{
    float xAccel;
    float jumpPower; 
    float friction;
    float maxSpeed;   
    
}TActorAtts;


class Actor : public Object
{
private:
    Vector2 pos;
    Vector2 vel, accel;
    int width,height;       //used for bounding box collision

    TActorAtts orig, atts;
    bool jumped, onGround;
    
    CAnim anim;
    bool dir;
    
    int nSpeedups, nJumpups;      //the number of speedup powerups currently possessed
    int nMaxSpeedups;
    
    DATAFILE *data;
    
    char displayString[80];
    int displayTimeLeft;

public:
    Actor();
    ~Actor();
    void init(void);
    
    void create(Vector2 _pos, int _width, int _height, TActorAtts _orig, char *animFile=NULL);
    void setPos(Vector2 _pos) {pos=_pos;}
    void setVel(Vector2 _vel) {vel = _vel;}
    void setDatafile(DATAFILE *_data) {data = _data;}
       
    void draw(BITMAP *backgr, int sx, int sy);
    void move(Map *map);
    bool checkDown(Map *map);
    
    void keyLeft(void);
    void keyUp(void);
    void keyDown(void);
    void keyRight(void);
    
    Vector2 retPos(void) {return pos;}
    Vector2 retVel(void) {return vel;}
    int retWidth(void) {return width;}
    int retHeight(void) {return height;}
    
    
    void resetForces(void);
    void jump(void);
    void applyFriction(void);
    
    bool checkFinished(Map *map);
};

#endif // ACTOR_H

