// Class automatically generated by Dev-C++ New Class wizard

#include "Actor.h" // class's header file


extern TPhrases *phrases;

Actor::Actor()
{
    Object::init();
    init();
}

Actor::~Actor()
{
}

void Actor::init(void)
{
    Object::init();
    
    vel.setVector(0,0);
    accel.setVector(0,GRAV);
    dir=RIGHT;
    
    nSpeedups=0; nJumpups=0;
    nMaxSpeedups=4;
    
    displayTimeLeft=0;

}

void Actor::create(Vector2 _pos, int _width, int _height, TActorAtts _orig, char *animFile)
{
    init();
    pos = _pos;
    width = _width;
    height = _height;
    
    orig=_orig;
    atts=orig;
    
    if(animFile)
        anim.create(animFile);
    
    exist=true;
}

void Actor::draw(BITMAP *backgr, int sx, int sy)
{
    if(exist==true)
    {
        /*rect(backgr,(int)pos.retXAsPos()-width/2 -sx,(int)pos.retYAsPos()-height/2 -sy,
                    (int)pos.retXAsPos()+width/2 -sx,(int)pos.retYAsPos()+height/2 -sy,
                    makecol(255,0,0));*/
                    
        //anim.draw(backgr, (int)pos.retXAsPos()-width/2 -sx, (int)pos.retYAsPos()-height/2 -sy);    
    
        if(vel.retXAsDir() > 0)
            dir=RIGHT;
        else if(vel.retXAsDir() < 0)
            dir=LEFT;
        
        /*if(dir==RIGHT)
            draw_sprite(backgr,anim.return_current_frame(),(int)pos.retXAsPos()-width/2 -sx, (int)pos.retYAsPos()-height/2 -sy);
        else
            draw_sprite_h_flip(backgr,anim.return_current_frame(),(int)pos.retXAsPos()-width/2 -sx, (int)pos.retYAsPos()-height/2 -sy);
*/
        if(dir==RIGHT)
            anim.draw(backgr,(int)pos.retXAsPos()-width/2 -sx, (int)pos.retYAsPos()-height/2 -sy);
        else
            anim.draw_h_flipped(backgr,(int)pos.retXAsPos()-width/2 -sx, (int)pos.retYAsPos()-height/2 -sy);


    
        //draws the speed powerup bar
        textprintf(backgr,(FONT*)data[font2].dat,550,17,makecol(0,0,0),"%s",phrases->phrase[6]);
        draw_sprite(backgr,(BITMAP*)data[powerup_bar].dat,650, 30-13);

        for(int n=0 ; n<nSpeedups ; n++)
            draw_sprite(backgr,(BITMAP*)data[powerup1].dat,650 + n*30, 30-13);
            
        if(nSpeedups<0)
            for(int n=0 ; n<-nSpeedups ; n++)
                draw_sprite(backgr,(BITMAP*)data[powerup2].dat,650 + n*30, 30-13);        
        

        //draws the jump powerup bar
        textprintf(backgr,(FONT*)data[font2].dat,550,47,makecol(0,0,0),"%s",phrases->phrase[9]);
        draw_sprite(backgr,(BITMAP*)data[powerup_bar].dat,650, 60-13);
         
        for(int n=0 ; n<nJumpups ; n++)
            draw_sprite(backgr,(BITMAP*)data[powerup1].dat,650 + n*30, 60-13);
            
        if(nSpeedups<0)
            for(int n=0 ; n<-nJumpups ; n++)
                draw_sprite(backgr,(BITMAP*)data[powerup2].dat,650 + n*30, 60-13);       
        
        
        
        if(displayTimeLeft>0)
            textprintf_centre(backgr,(FONT*)data[font1].dat,400,100,makecol(200,0,0),"%s",displayString);
        
    }
    
    
}


void Actor::move(Map *map)
{
    bool hit;
    float speed;
    int powerupType=POWERUP_NONE;
    
    if(exist==true)
    {
        pos+=vel;
        
        //if(abval(vel.retXAsPos()) < atts.maxSpeed)
        vel+=accel;
        
        speed = abval(vel.retXAsPos());
        
        if( speed == 0)
            anim.setSpeed(0);
        else
        {
            if(atts.maxSpeed > speed)
                anim.setSpeed( (int)ceil(atts.maxSpeed-speed));
            else
                anim.setSpeed(1);
        }
        
        
        
        hit=checkDown(map);
        powerupType = map->checkColWithPowerup((int)pos.retXAsPos()-width/2,(int)pos.retYAsPos()-height/2,width,height);
        
        if(powerupType == POWERUP_SPEEDUP)
        {
            if(nSpeedups < nMaxSpeedups)
            {
                atts.maxSpeed+=1;
                atts.xAccel+=.1;
            
                strcpy(displayString,phrases->phrase[4]);
                displayTimeLeft=40;
            
                nSpeedups++;
                play_sample((SAMPLE*)data[arghh].dat, 255, 128, 1000, FALSE);
            }
        }
        else if(powerupType == POWERUP_SPEEDDOWN)
        {
            if(nSpeedups> -nMaxSpeedups+1)
            {
                atts.maxSpeed-=1;
                atts.xAccel-=.1;

                strcpy(displayString,phrases->phrase[5]);
                displayTimeLeft=40;            
            
                nSpeedups--;
                play_sample((SAMPLE*)data[chirp].dat, 255, 128, 1000, FALSE);
            }
        }
        else if(powerupType == POWERUP_JUMPUP)
        {
            if(nJumpups < nMaxSpeedups)
            {
                atts.jumpPower+=2;
                
                strcpy(displayString,phrases->phrase[7]);
                displayTimeLeft=40;
            
                nJumpups++;
                play_sample((SAMPLE*)data[arghh].dat, 255, 128, 1000, FALSE);
            }
        }
        else if(powerupType == POWERUP_JUMPDOWN)
        {
            if(nJumpups > -nMaxSpeedups+1)
            {
                atts.jumpPower-=2;
                
                strcpy(displayString,phrases->phrase[8]);
                displayTimeLeft=40;
            
                nJumpups--;
                play_sample((SAMPLE*)data[chirp].dat, 255, 128, 1000, FALSE);
            }
        }        
        //checkLeft(map);
        
        anim.move();
        
        if(displayTimeLeft>0)
            displayTimeLeft--;
    }
}


bool Actor::checkDown(Map *map)
{
    bool ret;
    Tile *colTile;
    if(vel.retYAsPos()>0)
    {
        for(int i=-width/2 ; i<width/2 ; i++)
        {
            for(int j=height/2 ; j<height/2+vel.retYAsPos() ; j++)
            {
                colTile= map->checkColWithPoint((int)pos.retXAsPos()+i,
                                                (int)pos.retYAsPos()+j);
                                                
                if(colTile)
                {
                    //vel.setY(0);
                    vel.setVector(vel.retXAsPos(),0);
                    Vector2 offset = makeVector2(0,j-height/2-2);
                    pos+=offset;
                    onGround=true;
                    jumped=false;
                }
            }
        }
    }
    
    if(vel.retYAsPos()!=0)
        onGround=false;
    
    return ret;
}

void Actor::resetForces(void)
{
    accel.setVector(0,GRAV); 
    applyFriction();  
}

void Actor::keyLeft(void)
{
    //if(onGround==true)    //can only accelerate while on the ground
    {
        Vector2 change;
        
        if(vel.retXAsPos()>-atts.maxSpeed)
        {
            if(onGround==true)
                change.setVector(-atts.xAccel,0);
            else
                change.setVector(-atts.xAccel/2,0);
        }    
        accel+=change;
    }
}

void Actor::keyRight(void)
{
    //if(onGround==true)//can only accelerate while on the ground
    {
        Vector2 change;
        
        if(vel.retXAsPos()<atts.maxSpeed)
        {
            if(onGround==true)
                change.setVector(atts.xAccel,0);
            else
                change.setVector(atts.xAccel/2,0);
        }    
        accel+=change;
    }
}

void Actor::keyUp(void)
{
    if(jumped==false && onGround==true)
    {
        jump();
        jumped=true;
    }
}

void Actor::keyDown(void)
{

}

void Actor::jump(void)
{
    Vector2 change;
    change.setVector(0,-atts.jumpPower);
    accel+=change;
}

void Actor::applyFriction(void)
{
    //if(onGround==true)
    {
        if(abval(vel.retXAsPos()) > atts.friction )
        {
            if(vel.retXAsPos()>0)
                vel.setVector(vel.retXAsPos()-atts.friction,vel.retYAsPos());
            else
                vel.setVector(vel.retXAsPos()+atts.friction,vel.retYAsPos());
        }
        else
            vel.setVector(0,vel.retYAsPos());
    }
}

bool Actor::checkFinished(Map *map)
{
    bool ret=false;
    if(exist==true)
    {
        if(pos.retXAsPos() >= map->retFinishPos() )
            ret=true;
    }
    return ret;
}



