#include "Tile.h" // class's header file

Tile::Tile()
{
    init();
}

Tile::~Tile()
{
}

void Tile::init(void)
{
    Object::init();
    
}

void Tile::create(unsigned char _shape, unsigned char _behavour)
{
    shape = _shape;
    behavour = _behavour;
    exist=true;
    seed = rand()%5000;
    
    lifeLeft=3;
    if(behavour==BREAK_AWAY)
        lifeLeft=2;

}

void Tile::lifeDown(void)
{
    if(lifeLeft>0)
    {
        lifeLeft--;
        if(lifeLeft==0)
            shape=EMPTY;
    }
}

void Tile::draw(BITMAP *backgr, int x, int y)
{
    int colour;
    if(exist==true)
    {
        if(shape==EMPTY)
            colour = makecol(200,200,200);
        else if(shape==FULL)
        {
            colour = makecol(0,0,255);
            
            //rect(backgr,x +1,y +1,x+TILE_WIDTH,y+TILE_HEIGHT,colour);
            drawCloud(backgr, x,y);
        }
    }
}

void Tile::drawCloud(BITMAP *backgr, int x, int y)
{
    int xPos,yPos,r,darkness;
    
    srand(seed);
    for(int n=0 ; n<lifeLeft ; n++)
    {

        xPos = rand()%TILE_WIDTH;
        yPos = rand()%TILE_HEIGHT;
        r = rand()%5 + 20 ;
        darkness = rand()%20 + 230;
        
        circlefill(backgr,x+xPos,y+yPos,r,makecol(darkness,darkness,darkness)); 
    }
}


