#include "Map.h" // class's header file

Map::Map()
{
    init();
}

Map::~Map()
{
}

void Map::init(void)
{
    Object::init();
    for(int i=0 ; i<MAP_WIDTH ; i++)
    {
        for(int j=0 ; j<MAP_HEIGHT ; j++)
        {
            map[i][j].init();
            map[i][j].create(EMPTY,NORMAL);
        }
    }
    
    finishPos=0;
    
    nPowerups=0;
    for(int n=0 ; n<MAX_POWERUPS ; n++)
        powerup[n].init();
}

void Map::drawSun(BITMAP *backgr, int sx, int sy)
{
    /*circlefill(backgr,800 - sx/14,600,650,makecol(250,200,30));
    circlefill(backgr,800 - sx/14,600,450,makecol(250,210,30));
    circlefill(backgr,800 - sx/14,600,450,makecol(250,220,30));*/
    //circlefill(backgr,800 - sx/14,600,270,makecol(250,200,30));        
    circlefill(backgr,800 - sx/14,600,250,makecol(250,250,30));




    //circlefill(backgr,800 - sx/14,600,200,makecol(250,250,0));
}

void Map::addPowerup(char *animName, int x, int y, int type)
{
    CAnim anim;
    
    //toLog(animName);
    
    anim.create(animName);
    
    powerup[nPowerups].create(anim,x,y,type);
    nPowerups++;
    if(nPowerups>=MAX_POWERUPS)
        nPowerups=MAX_POWERUPS-1;
}

bool Map::create(char *filename, char *animationFile)
{
    BITMAP *image;
    bool ret=false;
    if(filename)
    {
        image = load_bitmap(filename,NULL);
        ret = create(image,animationFile);
        destroy_bitmap(image);
        exist=true;
    }
    else
        create();
        
    return ret;
}



bool Map::create(BITMAP *image, char* animationFile)
{
    bool ret=false;
    
    FILE *animFile;
    int nAnims=0;
    char animName[20][50];
    if(animationFile)
    {
        animFile = fopen(animationFile,"rt");
        if(animFile)
        {
            fscanf(animFile,"%d",&nAnims);
            for(int n=0 ; n<nAnims ; n++)
            {
                fscanf(animFile,"%s",animName[n]);    
            }
        }
    }
    
    if(image)
    {
        int pixel,r,g,b;
        
        init();
        
        //load in the map        
        for(int i=0 ; i<image->w && i<MAP_WIDTH ; i++)
        {
            for(int j=0 ; j<image->h && j<MAP_HEIGHT ; j++)
            {
                pixel = _getpixel32(image,i,j);
                r=getr32(pixel);
                g=getg32(pixel);
                b=getb32(pixel);
                
                if(r==0 && g==0 && b==0)    //black finish line
                {
                    finishPos=i*TILE_WIDTH;
                }
                
                if(r==255 && g==255 && b==255)    //empty tile
                {
                    map[i][j].create(EMPTY,NORMAL);
                }
                else if(r==0 && g==0 && b==255)  //blue pixel means notmal tile
                {
                    map[i][j].create(FULL,NORMAL);
                }
                else if(r==0 && g==0 && b==150)  //dark blue means break away tile
                {
                    map[i][j].create(FULL,BREAK_AWAY);
                }
                else if(r==0 && g==255 && b==0) //speed up powerup
                {
                    if(nAnims>=1)
                        addPowerup(animName[0],(i-1)*TILE_WIDTH,(j-1)*TILE_WIDTH,POWERUP_SPEEDUP);
                }
                else if(r==255 && g==0 && b==0) //speed down powerup
                {
                    if(nAnims>=2)
                        addPowerup(animName[1],(i-1)*TILE_WIDTH,(j-1)*TILE_WIDTH,POWERUP_SPEEDDOWN);
                }
                else if(r==0 && g==255 && b==255)   //cyan jump up powerup
                {
                    if(nAnims>=3)
                        addPowerup(animName[2],(i-1)*TILE_WIDTH,(j-1)*TILE_WIDTH,POWERUP_JUMPUP);

                }
                else if(r==255 && g==0 && b==255)   //majenta jump down powerup
                {
                    if(nAnims>=4)
                        addPowerup(animName[3],(i-1)*TILE_WIDTH,(j-1)*TILE_WIDTH,POWERUP_JUMPDOWN);

                }
                else if(r==255 && g==255 && b==0)   //yellow pot of gold
                {
                    if(nAnims>=5)
                        addPowerup(animName[4],(i-1)*TILE_WIDTH,(j-1)*TILE_WIDTH,POWERUP_NONE);

                }
                
            }
            exist=true;
        }
        ret=true;
    }
    else
    {
        //create a blank map
        init();
        exist=true;
    }
    
    
    return ret;
}


Tile* Map::checkColWithPoint(int x, int y)
{
    Tile* ret=NULL;
    if(exist==true)
    {
        int tx,ty;
     
        //x+=TILE_WIDTH/2;
        //y+=TILE_HEIGHT/2;
              
        tx =(int)( ((float)x)/TILE_WIDTH );
        ty =(int)( ((float)y)/TILE_HEIGHT);
        
        if(tx>=0 && ty>=0 && tx<MAP_WIDTH && ty<MAP_HEIGHT)
        {
            if(map[tx][ty].retShape()!=EMPTY && map[tx][ty].retBehavour()!=GHOST)
            {
                ret=&map[tx][ty];
            
                if(map[tx][ty].retBehavour()==BREAK_AWAY)
                {
                    map[tx][ty].lifeDown();
                }
            }
        }
        
    
    }
    return ret;
}

void Map::draw(BITMAP *backgr, int sx, int sy)
{
    if(exist==true)
    {
        int leftmostTile,topmostTile,rightmostTile,bottommostTile;
        
        leftmostTile =  (int)(((float)(sx))/TILE_WIDTH);
        topmostTile =  (int)(((float)(sy))/TILE_HEIGHT);
        rightmostTile =  (int)(((float)(sx))/TILE_WIDTH) + S_W/TILE_WIDTH + 2;
        bottommostTile = (int)(((float)(sy))/TILE_HEIGHT) + S_H/TILE_HEIGHT +2;
    
        for(int i=leftmostTile ; i<rightmostTile ; i++)
        {
            for(int j=topmostTile ; j<bottommostTile ; j++)
            {
                map[i][j].draw(backgr,i*TILE_WIDTH - sx,j*TILE_HEIGHT -sy);    
            }
        }    
        
        for(int i=0 ; i<nPowerups ; i++)
            powerup[i].draw(backgr,sx,sy);
    }
}

void Map::move(void)
{
    if(exist==true)
    {
        for(int n=0 ; n<nPowerups ; n++)
            powerup[n].move();
    }
}

int Map::checkColWithPowerup(int x, int y, int w, int h)
{
    int ret=POWERUP_NONE;
    if(exist==true)
    {
        for(int n=0 ; n<nPowerups ; n++)
        {
            ret = powerup[n].checkColWithBox(x,y,w,h);
            if(ret!=POWERUP_NONE)
                break;
        }
    
    }
    return ret;
}

