/**
        Tumbler 1.0
        Copyright (C) 2008, Fayl

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see http://www.gnu.org/licenses/.
*/
#include <OpenLayer.hpp>
#include <fstream>
#include <time.h>
#include <FMOD/fmod.h>

#include "Menu.h"
#include "logf.h"
//-----//
//Wyczyszczenie log.txt na początku programu
void ClearLog()
{
    std::ofstream CLEAR("log.txt",std::ios::trunc);
    const time_t tt = time(NULL);
    CLEAR << "Log started: " << ctime(&tt) << "\n";
    if (CLEAR.is_open()) CLEAR.close();
}
//-----//
void OLInit(int depth)
{
    if (ol::Setup::SetupProgram())
        logf("* Allegro & OpenLayer initialized\n");
    else
    {
        logf("! Could not initialize Allegro/OL! ");
        logf(allegro_error);
        rest(500); exit(1);
    }
   /* if (desktop_color_depth() != 0)
        ol::Setup::SetupScreen(640,480,WINDOWED,desktop_color_depth());
    else*/
    if (ol::Setup::SetupScreen(640,480,WINDOWED,depth))
        logf("* Screen initialized (640x480x32bpp)\n");
    else
    {
        logf("! Error initializing screen! ");
        logf(allegro_error);
        rest(500); exit(1);
    }

    if (install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL) == 0 && FSOUND_Init(44100, 32, 0))
        logf("* Sound installed\n");
    else
    {
        logf("! Sound could not be installed! ");
        logf(allegro_error);
        rest(500); exit(1);
    }
    set_display_switch_mode(SWITCH_BACKGROUND);
}
/*
  MAIN: Initializuje Allegro & wywoluje CMenu::Init()
*/
int main(int argc, char *argv[])
{
    ClearLog();
    //if (argc > 1 && !strcmp("-16",argv[1]))
    //    OLInit(16);
    /*else */OLInit(32); //inicjalizacja allegro & OL
    menu.MenuInit(); //inicjalizacja menu
    logf("* Exiting program.");

    allegro_exit();
    return 0;
} END_OF_MAIN()
