#ifndef PARTICLES_H_
#define PARTICLES_H_

#include <OpenLayer.hpp>
//-----//
class CParticle
{
    protected:
        int life;
        int x, y;

        CParticle(int _life, int _x, int _y)
            : life(_life), x(_x), y(_y)
        {}

        virtual void ProcessParticle() = 0;
        virtual void DrawParticle() const = 0;

    public:
        CParticle() {}
        void CreateDust(int,int,bool);
        void CreateStars(int,int,int);
        void CreateExplo(int,int,int);
        void CreateAdditiveCircle(int,int,float,int,ol::Rgba);
        void CreateTeleCircle(int,int,ol::Rgba,int);
        void ProcessParticles();
        void DrawParticles() const;
        void ParticleInit();
        void Destroy();
        void DestroyParticles();
};
extern CParticle *defpart;
//
class CParticleDust : public CParticle
{
    float vx, vy;
    ol::Rgba cl;

    void ProcessParticle();
    void DrawParticle() const;

    public:
        CParticleDust(int _life, int _x, int _y, float _vx, float _vy, ol::Rgba _cl)
            : CParticle(_life,_x,_y), vx(_vx), vy(_vy), cl(_cl)
        {}
};

class CParticleStars : public CParticle
{
    float vx, vy;
    int cl_type;
    int rotation;

    void ProcessParticle();
    void DrawParticle() const;
    void CreateStarsEx();

    public:
        CParticleStars(int _life, int _x, int _y, float _vx, float _vy, int _cl_type)
            : CParticle(_life,_x,_y), vx(_vx), vy(_vy), cl_type(_cl_type), rotation(0)
        {}
};

class CParticleExplo : public CParticle
{
    float vx, vy;
    int index;
    int type;
    int rotation;

    void ProcessParticle();
    void DrawParticle() const;

    public:
        CParticleExplo(int _life, int _x, int _y, float _vx, float _vy, int _i, int _type)
            : CParticle(_life,_x,_y), vx(_vx), vy(_vy), index(_i), type(_type), rotation(0)
        {}
};

class CParticleAdditiveCircle : public CParticle
{
    float v;
    int radius, max_radius;
    ol::Rgba cl;

    void ProcessParticle();
    void DrawParticle() const;

    public:
        CParticleAdditiveCircle(int _x, int _y, float _v, int _max_r, ol::Rgba _cl)
            : CParticle(1,_x,_y), v(_v), radius(0), max_radius(_max_r), cl(_cl)
        {}
};
//-----//
class CParticleTeleCircle : public CParticle
{
    int radius;
    ol::Rgba cl;
    bool circle_in;

    void ProcessParticle();
    void DrawParticle() const;

    public:
        CParticleTeleCircle(int _x, int _y, ol::Rgba _cl, bool _in)
            : CParticle(1,_x,_y), cl(_cl), circle_in(_in)
        {
            radius = (circle_in) ? 50 : 0;
        }
};
//-----//
#endif
