#include "Particles.h"
//-----//
#include <OpenLayer.hpp>
#include <iostream>
#include <list>

#include "Object.h"
#include "ConstEnums.h"

//-----//
CParticle *defpart;
std::list<CParticle*> part;
ol::Bitmap BmpParticle;
//-----//
/*
  CREATEEXPLO,CREATEDUST,CREATESTARS:
        Tworzą obiekty na których oparte są efekty cząsteczkowe
*/
//-----//
void CParticle::CreateExplo(int _x, int _y, int _type)
{
    for (int i = 0; i < 16; ++i)
    {
        CParticle *PrtPtr = new CParticleExplo(30 + rand()%15,
            _x + (i/4)*12, _y + (i%4)*12, rand()%13 - 6, rand()%13, i, _type);
        part.push_back(PrtPtr);
    }
}
//-----//
void CParticle::CreateDust(int _x, int _y, bool fire = false)
{
    CParticle *PrtPtr;
    for (int i = 0; i < 60; ++i)
    {
        if (!fire)
        {
            float clr = rand()%6/10.0+0.2;
            PrtPtr = new CParticleDust(20 + rand()%40,
                _x + rand()%64, _y, rand()%19 - 9, rand()%45 - 35, ol::Rgba(clr,clr,clr));
        }
        else
            PrtPtr = new CParticleDust(20 + rand()%40,
                _x + rand()%64, _y, rand()%19 - 9, rand()%45 - 35, ol::Rgba(rand()%6/10.0+0.2,0.2,0.0));
        part.push_back(PrtPtr);
    }
}
//-----//
void CParticle::CreateStars(int _x, int _y, int clpack)
{
    for (int i = 0; i < 15; ++i)
    {
        CParticle *PrtPtr = new CParticleStars(50, _x + rand()%31 - 15, _y + rand()%31 - 15,
            rand()%11 - 5, rand()%25 - 15, clpack);
        part.push_back(PrtPtr);
    }
}
void CParticleStars::CreateStarsEx()
{
    CParticle *PrtPtr = new CParticleStars(life-2, x, y, (vx > 0) ? vx - 1 : vx + 1, (vy > 0) ? vx - 2 : vy + 2, cl_type);
    part.push_back(PrtPtr);
}
//-----//
void CParticle::CreateAdditiveCircle(int _x, int _y, float _v, int _max_r, ol::Rgba cl)
{
    CParticle *PrtPtr = new CParticleAdditiveCircle(_x,_y,_v,_max_r,cl);
    part.push_back(PrtPtr);
}
//-----//
void CParticle::CreateTeleCircle(int _x, int _y, ol::Rgba _cl, int _in)
{
    CParticle *PrtPtr = new CParticleTeleCircle(_x,_y,_cl,_in);
    part.push_back(PrtPtr);
}
//-----//
/*
  PROCESSPARTICLES: Obliczane są przemieszczenia i inne podobne parametry cząsteczek
*/
void CParticleDust::ProcessParticle()
{
    --life;
    vx = vx * 3 / 4;
    vy = vy * 4 / 5;
    x += static_cast<int>(vx);
    y -= static_cast<int>(vy);
}
//
void CParticleStars::ProcessParticle()
{
    --life;
    vy -= 0.1;
    vx -= vx/100;
    x += static_cast<int>(vx);
    y -= static_cast<int>(vy);
    //rotation = (rotation + 1)%16;
    if (life > 2 && life % 10 == 0) CreateStarsEx();
}
//
void CParticleExplo::ProcessParticle()
{
    --life;
    vy -= 1;
    vx = vx * 9 / 10;
    x += static_cast<int>(vx);
    y -= static_cast<int>(vy);
    ++rotation;
    //rotation = abs((rotation + rand()%5 - 2)%16);
}
//
void CParticleAdditiveCircle::ProcessParticle()
{
    if (v >= 2.0) v -= 1.0;
    radius += static_cast<int>(v);
    if (radius >= max_radius) life = 0;
}
//
void CParticleTeleCircle::ProcessParticle()
{
    radius += (circle_in) ? -1 : 1;
    if ((radius == 50 && !circle_in) || (!radius && circle_in)) life = 0;
}
//
void CParticle::ProcessParticles()
{
    for (std::list<CParticle*>::iterator iter = part.begin(); iter != part.end(); )
    {
        (*iter)->ProcessParticle();
        if ((*iter)->life <= 0 || (*iter)->x < -10 || (*iter)->y < -10 ||
                                  (*iter)->x > 640 || (*iter)->y > 480)
        {
            delete *iter;
            iter = part.erase(iter);
            continue;
        }
        ++iter;
    }
}
//-----//
/*
  DRAWPARTICLES: Wyrysowuje wszystkie cząsteczki na buforze na podstawie listy
*/
void CParticleDust::DrawParticle() const
{
    ol::Circle(x, y, life / 4).Draw(cl.WithAlpha(life/64.0));
}
//
void CParticleStars::DrawParticle() const
{
    /*switch (cl_type)
    {
        case 0: ol::Circle(x, y, life/6).Draw(ol::Rgba::RED.WithAlpha(life/50.0)); break;
        case 1: ol::Circle(x, y, life/6).Draw(ol::Rgba::GREEN.WithAlpha(life/50.0)); break;
        case 2: ol::Circle(x, y, life/6).Draw(ol::Rgba::BLUE.WithAlpha(life/50.0)); break;
    }*/
    //ol::Blenders::Set(ol::ADDITIVE_BLENDER);
    float r = rand()%50/200.0-0.25;
    ol::Circle(x, y, life/2).Draw(ol::Rgba(cltext[cl_type][0] + r, cltext[cl_type][1] + r,
                                           cltext[cl_type][2] + r).WithAlpha(life/50.0));
    //ol::Blenders::Set(ol::ALPHA_BLENDER);
}
//
void CParticleExplo::DrawParticle() const
{
    ObjBmp.Blit(x - (type - 1)*48, y, ol::Clipped((type - 1)*48 + (index%4)*12, 0, 12, 12));
}
//
void CParticleAdditiveCircle::DrawParticle() const
{
    ol::Blenders::Set(ol::ADDITIVE_BLENDER);
    ol::Circle(x, y, radius).Draw(cl.WithAlpha(0.5), cl.WithAlpha(0.0));
    ol::Blenders::Set(ol::ALPHA_BLENDER);
}
//
void CParticleTeleCircle::DrawParticle() const
{
    ol::Circle(x, y, radius).Draw(cl, cl.WithAlpha(0.3));
    ObjBmp.BlitStretched(x - 336 - 24 + (50 - radius)/4, y - 24 + (50 - radius)/4,
                        432 - (50 - radius)*5, 48 - (50 - radius)/2,
                        ol::Clipped(336, 0, 48, 48) + ol::Tinted(ol::Rgba(0.0, 0.0, 0.0, 0.3)),
                        static_cast<float>(radius)/50.0);
}
//
void CParticle::DrawParticles() const
{
    for (std::list<CParticle*>::iterator iter = part.begin(); iter != part.end(); ++iter)
        (*iter)->DrawParticle();
}
//-----//
/*
  INIT: Tworzy bitmapy używane przez efekty cząsteczkowe
*/
void CParticle::ParticleInit()
{
   // BmpParticle.Load("G/ztar.png");
}
//-----//
void CParticle::DestroyParticles()
{
    if (!part.empty())
    {
        for (std::list<CParticle*>::iterator iter = part.begin(); iter != part.end(); ++iter)
            delete *iter;
        part.clear();
    }
}
//-----//
void CParticle::Destroy()
{
   // BmpParticle.Destroy();
}
