#ifndef OBJECT_H_H_
#define OBJECT_H_H_
//-----//
#include <OpenLayer.hpp>
#include <list>
#include "ConstEnums.h"
//-----//
class CObject
{
    int type;

    protected:
        int x, y; //położenie obiektu [w pikselach]
        int m_fall_speed;
        bool can_fall, falling; //czy klocek podlega sile grawitacji
        bool can_collide; //czy inne obiekty się z nim mogą zderzyć
        ol::Rgba m_color; //glow
        int m_start_pos;
        int glow_rad;
        //
        int FindAdjacentBlocks(bool[][8],int&) const;
        std::list<CObject*>::iterator DestroyBlocks(bool[][8]);
        int GetNumberOfTypeBlocks(int) const;
        bool CheckFallDown(const CObject*,const CObject*) const;
        bool CheckFallUp(const CObject*,const CObject*) const;
        //virtual void AdjustAGBlocks() {};
    //
    public:
        void Gravity();
        void DrawObjs(int);
        void SwapCoords(int);
        void CheckDestroyBlocks(int);
        void CheckBlocksAtPlace();
        int FindBlocksAtPlaces(bool[][8]);
        void DestroyAllBlocks();
        void DestroyBlock(int,int);
        void CreateBlock(int,int,int,bool=false,bool=false);
        void CreateObjectMap(int[][8]);
        int GetNumberOfBlocksLeft() const;
        int GetTypeAtXY(int,int) const;
        void AdjustAGBlocks();

        CObject() {}
        CObject(int _x, int _y, bool _can_fall, bool _can_coll, ol::Rgba _cl, int _type, int _gl_rad)
            : type(_type),
              x(_x),
              y(_y),
              m_fall_speed(8),
              can_fall(_can_fall),
              falling(false),
              can_collide(_can_coll),
              m_color(_cl),
              m_start_pos(_y),
              glow_rad(_gl_rad)
        {}
        virtual ~CObject() {}
};
//
class CObjectNormal : public CObject
{
    public:
        CObjectNormal(int _x, int _y, ol::Rgba _cl, int _type)
            : CObject(_x,_y,true,true,_cl,_type,40)
        {}
};
//
class CObjectWall : public CObject
{
    public:
        CObjectWall(int _x, int _y)
            : CObject(_x,_y,false,true,ol::Rgba(0.5,0.5,0.5,0.2),BLOCK_WALL,40)
        {}
};
class CObjectAG : public CObject
{
    public:
        CObjectAG(int _x, int _y)
            : CObject(_x,_y,true,true,ol::Rgba(0.0,0.0,0.0,0.8),BLOCK_AG,40)
        {}
};
//
class CObjectMagic : public CObject
{
    public:
        CObjectMagic(int _x, int _y)
            : CObject(_x,_y,true,true,ol::Rgba(1.0,1.0,1.0,0.8),BLOCK_MAGIC,40)
        {}
};
//
class CObjectTele : public CObject
{
    public:
        CObjectTele(int _x, int _y)
            : CObject(_x,_y,true,true,ol::Rgba(rand()%10/10.0,rand()%10/10.0,rand()%10/10.0,1.0),BLOCK_TELE,40)
        {}
};
//
class CObjectPlacement : public CObject
{
    public:
        CObjectPlacement(int _x, int _y)
            : CObject(_x,_y,false,false,ol::Rgba::BLACK,BLOCK_PLACEMENT,1)
        {}
};
extern CObject *obj;
extern ol::Bitmap ObjBmp;
//-----//
#endif
