#include "Object.h"
//-----//
#include <OpenLayer.hpp>
#include <list>

#include "Game.h"
#include "Menu.h"
#include "Particles.h"
#include "ConstEnums.h"
#include "logf.h"
CObject *obj = new CObject(-1,-1,false,false,ol::Rgba::BLACK,-1,40);
std::list<CObject*> objlist;
ol::Bitmap ObjBmp;
//BITMAP *BmpObjs = NULL;
//-----//
/*
  ADJUSTAGBLOCKS:
*/
void CObject::AdjustAGBlocks()
{
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        if ((*iter)->type == BLOCK_AG)
            (*iter)->m_start_pos = 0;
}
//-----//
/*
   GETNUMBEROFBLOCKSLEFT:
*/
int CObject::GetNumberOfBlocksLeft() const
{
    int block_count = 0;
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        if ((*iter)->type != BLOCK_WALL && (*iter)->type != BLOCK_PLACEMENT)
            ++block_count;
    return block_count;
}
//-----//
/*
  GETTYPEATXY:
*/
int CObject::GetTypeAtXY(int _x, int _y) const
{
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        if ((*iter)->x == _x && (*iter)->y == _y)
            return (*iter)->type;
    return 0;
}
//-----//
/*
  CREATEOBJECTMAP:
*/
void CObject::CreateObjectMap(int map[][8])
{
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        map[(*iter)->x/48][(*iter)->y/48] = (*iter)->type;
}
//-----//
/*
  CREATEBLOCK:
*/
void CObject::CreateBlock(int _x, int _y, int _type, bool _can_fall/** = false*/, bool _can_coll/** = false*/)
{
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        if ((*iter)->x == _x && (*iter)->y == _y)
        {
            delete *iter;
            objlist.erase(iter);
            break;
        }
    CObject *ObjPtr;
    switch (_type)
    {
        case BLOCK_YELLOW: ObjPtr = new CObjectNormal(_x,_y,ol::Rgba::YELLOW,_type); break;
        case BLOCK_GREEN: ObjPtr = new CObjectNormal(_x,_y,ol::Rgba::GREEN,_type); break;
        case BLOCK_BLUE: ObjPtr = new CObjectNormal(_x,_y,ol::Rgba::BLUE,_type); break;
        case BLOCK_RED: ObjPtr = new CObjectNormal(_x,_y,ol::Rgba::RED,_type); break;
        case BLOCK_MAGIC: ObjPtr = new CObjectMagic(_x,_y); break;
        case BLOCK_WALL: ObjPtr = new CObjectWall(_x,_y); break;
        case BLOCK_TELE: ObjPtr = new CObjectTele(_x,_y); break;
        case BLOCK_AG: ObjPtr = new CObjectAG(_x,_y); break;
        case BLOCK_PLACEMENT: ObjPtr = new CObjectPlacement(_x,_y); break;
    }

    if (_type == BLOCK_TELE)
        objlist.push_front(ObjPtr); //teleporty MUSZ by na pocztku
    else
        objlist.push_back(ObjPtr);
}
//-----//
void CObject::DestroyBlock(int _x, int _y)
{
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        if ((*iter)->x == _x && (*iter)->y == _y)
        {
            delete *iter;
            objlist.erase(iter);
            return;
        }
}
//-----//
/*
  SWAPCOORDS: Zamiana koordynatw obiektw po obrocie planszy
*/
void CObject::SwapCoords(const int dir)
{
    int tmpval;
    if (dir == LEFT)
    {
        //(x,y) -> (y,7-x)
        for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        {
            tmpval = (*iter)->x;
            (*iter)->x = (*iter)->y;
            (*iter)->y = 7*48 - tmpval;
            if ((*iter)->type == BLOCK_MAGIC) (*iter)->m_start_pos = (*iter)->y;
            else if ((*iter)->type == BLOCK_AG) (*iter)->m_start_pos = 0;
        }
    }
    else if (dir == RIGHT)
    {
        //(x,y) -> (7-y,x)
        for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        {
            tmpval = (*iter)->y;
            (*iter)->y = (*iter)->x;
            (*iter)->x = 7*48 - tmpval;
            if ((*iter)->type == BLOCK_MAGIC) (*iter)->m_start_pos = (*iter)->y;
            else if ((*iter)->type == BLOCK_AG) (*iter)->m_start_pos = 0;
        }
    }
}
//-----//
bool CObject::CheckFallDown(const CObject *c1, const CObject *c2) const
{
    if ((c1->y + 48 == c2->y //czy obiekt ley pole poniej obiektu danego?
      && c1->x == c2->x
      && c2->can_collide) //czy obiekt szukany moe kolidowa?
      || c1->y >= 7*48) //koniec planszy
      return true;
    return false;
}
//-----//
bool CObject::CheckFallUp(const CObject *c1, const CObject *c2) const
{
    if (((c1->y - 48 >= c2->y //czy obiekt ley pole poniej obiektu danego?
      && c1->y - 80 <= c2->y)
      && c1->x == c2->x
      && c2->can_collide) //czy obiekt szukany moe kolidowa?
      || c1->y <= 0) //koniec planszy
      return true;
    return false;
}
//-----//
/*
  GRAVITY: Przeszukiwane s wszystkie obiekty by zadziaaa grawitacja - gdy
           obiekt nie spada, przeszukiwana jest lista by sprawdzi czy jest co
           pod nim; gdy ju spada - czy co co go moe zatrzyma;
*/
void CObject::Gravity()
{
    bool fall_flag = false, first_to_enter_else = false;
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); )
    {
        if (!(*iter)->can_fall)
        {
            ++iter;
            continue;
        }
        if ((g.GetSthFalling() || g.GetCheckGravity() || g.GetAfterRotation()
            || (*iter)->type == BLOCK_AG) && !(*iter)->falling) //gdy obiekt nie spada
        { //jeli nic na planszy nie spada to znaczy e ju si ustablilizowao
            bool start_fall = true;
            if ((*iter)->type == BLOCK_TELE)
            {
                int tmpy = 48*7;
                //start_fall = false;
                for (std::list<CObject*>::iterator iter2 = objlist.begin(); iter2 != objlist.end(); )
                {
                    if ((*iter)->y == tmpy) break;
                    if ((*iter2)->y == tmpy && (*iter2)->x == (*iter)->x && (*iter2)->can_collide)
                    {
                        tmpy -= 48;
                        iter2 = objlist.begin();
                    }
                    else ++iter2;
                }
                if ((*iter)->y < tmpy)
                {
                    g.SetSthFalling(true);
                    defpart->CreateTeleCircle((*iter)->x+48,(*iter)->y+48,(*iter)->m_color,true);
                    (*iter)->y = tmpy;
                    defpart->CreateTeleCircle((*iter)->x+48,(*iter)->y+48,(*iter)->m_color,false);
                    iter = objlist.begin();
                    fall_flag = true;
                }
                ++iter;
                continue;
            }
            else
            for (std::list<CObject*>::iterator iter2 = objlist.begin(); iter2 != objlist.end(); ++iter2)
            {
                if (((*iter)->type == BLOCK_AG && (CheckFallUp((*iter),(*iter2)))) ||
                   ((*iter)->type != BLOCK_AG && CheckFallDown((*iter),(*iter2))))
                {//czy pole pod obiektem jest zajte?
                    start_fall = false;
                    break;
                }
            }
            if ((*iter)->type == BLOCK_MAGIC && (*iter)->m_start_pos != (*iter)->y)
                start_fall = false;

            if (start_fall) //pocztek spadania
            {
                if ((*iter)->type == BLOCK_MAGIC)
                    (*iter)->m_start_pos = (*iter)->y;
                (*iter)->falling = true;
                fall_flag = false;
                g.SetSthFalling(true);
            }
        }
        //
        else if (g.GetSthFalling() && (*iter)->falling) //gdy obiekt ju wczeniej spada
        {
            bool stop_fall = false;

            if (!first_to_enter_else) //flaga na wypadek gdyby zaden obiekt *jeszcze* nie spada
            {
                first_to_enter_else = true;
                fall_flag = true;
            }
            if ((*iter)->type == BLOCK_MAGIC && (*iter)->y == (*iter)->m_start_pos + 48)
                stop_fall = true; //blok magiczny spada tylko jedno pole na obrt!

            for (std::list<CObject*>::iterator iter2 = objlist.begin(); iter2 != objlist.end(); ++iter2)
            {
                if (!stop_fall)
                if (((*iter)->type == BLOCK_AG && CheckFallUp((*iter),(*iter2))) ||
                   ((*iter)->type != BLOCK_AG && CheckFallDown((*iter),(*iter2))))
                {//sprawdza czy obiekt nie powinen si zatrzyma
                    stop_fall = true; //gdy pole poniej zajte = koniec spadania
                    if ((*iter)->type == BLOCK_AG)
                    { //dla antygrawitacyjnych musz by specjalne flagi by unikn zderze pomidzy polami
                        if (!(*iter2)->falling || (*iter)->y < 48 || (*iter)->y%48 == 0)
                            (*iter)->y = (*iter)->y - (*iter)->y%48;
                        else (*iter)->y = (*iter)->y - (*iter)->y%48 + 48;

                        (*iter)->m_start_pos = (*iter)->y;
                    }
                    break;
                }
            }
            if (stop_fall)
            {
                (*iter)->falling = false;
                if ((*iter)->type == BLOCK_AG)
                    defpart->CreateDust((*iter)->x+24,(*iter)->y-12+24,false); //particlesy[chmura kurzu]
                else if ((*iter)->type != BLOCK_MAGIC)
                {
                    FSOUND_PlaySound(3,SndFall);
                    FSOUND_SetVolume(3,menu.GetSoundVol());
                    defpart->CreateDust((*iter)->x+24,(*iter)->y+48+24,false); //particlesy[chmura kurzu]
                }
            }
            else
            {
                if ((*iter)->type == BLOCK_AG) //antygrawitacyjne spadaj do gry
                    (*iter)->y -= (*iter)->m_fall_speed;
                else
                    (*iter)->y += (*iter)->m_fall_speed; //opdanicie obiektu (V == 1 pole na 4 logiczne klatki)
                fall_flag = false;
            }
        }
        ++iter;
    }
    if (fall_flag) g.SetSthFalling(false); //jeli nic nie spada to nie ma potrzeby sprawdzania
    g.SetAfterRotation(false);
    g.SetCheckGravity(false);
}
//-----//
/*
  DESTROYBLOCKS: Kasowanie obiektw wyznaczonych przez funkcj FindAdjacentBlocks
                 (czyli na podstawie CheckMap[][])
*/
std::list<CObject*>::iterator CObject::DestroyBlocks(bool map[][8])
{
    std::list<CObject*>::iterator ret_iter = objlist.begin();
    for (int i = 0; i < 8; ++i)
    for (int j = 0; j < 8; ++j)
    {
        if (map[i][j]) //jeli w CheckMap zostao ustawione true tzn e trzeba usun obiekt
        {              //pooony na tym polu
            for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
            {
                if ((*iter)->x == j*48 && (*iter)->y == i*48 && (*iter)->can_collide)
                {
                    logf("* Destroying object -> type = ");logf((*iter)->type);
                    logf(" at (");logf((*iter)->x);logf(",");logf((*iter)->y);logf(")\n");
                    defpart->CreateExplo((*iter)->x+24,(*iter)->y+24,(*iter)->type); //wybuch
                    defpart->CreateDust((*iter)->x,(*iter)->y+24,true);
                    defpart->CreateAdditiveCircle((*iter)->x+48,(*iter)->y+48,2,64,ol::Rgba::RED);
                    delete *iter;
                    iter = objlist.erase(iter);
                    if (iter != objlist.begin())
                    {
                        ret_iter = iter;
                        --ret_iter;
                    }
                    else ret_iter = iter;
                    g.SetCheckGravity(true);//wymuszenie sprawdzenia grawitacji w nastpnej klatce
                    map[i][j] = 0; //wyzerowanie CheckMap == obiekt ju nie wymaga usunicia
                    g.IncreasePlayerScore(125/(g.GetPlayerMoves()+5)+5);
                    //^ Punkty za niszczenie obiektw (bazowane na iloci ruchw gracza)
                    FSOUND_PlaySound(4,SndExplo);
                    FSOUND_SetVolume(4,menu.GetSoundVol());
                    //g.SetUpdateUI(true); //aktualizacja interfejsu
                    break;
                }
            }
        }
    }
    return ret_iter;
}
//-----//
/*
  FINDADJACENTBLOCKS: Rekurencyjna funkcja wyszukujca obiekty tego samego typu
                      ssiadujce z danym, zapisuje wyniki w CheckMap[][]
*/
int CObject::FindAdjacentBlocks(bool map[][8], int &count) const
{
    if (type == BLOCK_WALL) return BLOCK_WALL;
    ++count; //block_count (referencyjnie) zwikszamy przy kadym wejciu do funkcji
             //(przy kadym znalezionym ssiadujcym obiekcie)
    map[y/48][x/48] = true;

    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        if (type == (*iter)->type && ((x == (*iter)->x + 48 && y == (*iter)->y)
                                  || (x == (*iter)->x - 48 && y == (*iter)->y)
                                  || (x == (*iter)->x && y == (*iter)->y + 48)
                                  || (x == (*iter)->x && y == (*iter)->y - 48))
                                  && !map[(*iter)->y/48][(*iter)->x/48]) //niedopuszczalne jest...
        {                                           //...sprawdzenie kilka razy tego samego obiektu
            (*iter)->FindAdjacentBlocks(map,count);
        }
    return type;
}
//-----//
/*
  GETNUMBEROFTYPEBLOCKS: Zwraca liczb obiektw o podanym typie
*/
int CObject::GetNumberOfTypeBlocks(const int t) const
{
    int cnt = 0;
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        if ((*iter)->type == t)
            ++cnt;
    return cnt;
}
//-----//
/*
  CHECKDESTROYBLOCKS: Funkcja zlecajca wyszukiwanie ssiadujcych obiektw tego
                      samego typu by dao si znale te ktre naley usun
                      (w trybach MODE_CLASSIC i MODE_ALL)
*/
void CObject::CheckDestroyBlocks(const int num)
{
    bool CheckMap[8][8] = {{0}};
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
    {
        int block_count = 0; //= referencja ktra wskae liczb ssiadujcych obiektw
        int block_type = (*iter)->FindAdjacentBlocks(CheckMap,block_count);
        int block_type_num = GetNumberOfTypeBlocks(block_type);
        if (num > 0 && block_count >= num) //ssiadowa musi minimum num obiektw
            iter = DestroyBlocks(CheckMap); //usunicie obiektw wskazanych przez CheckMap
        else if (num == -1 && block_count == block_type_num)
            iter = DestroyBlocks(CheckMap); //usunicie obiektw wskazanych przez CheckMap w trybie MODE_ALL
        else
            for (int i = 0; i < 8; ++i)
            for (int j = 0; j < 8; ++j)
                CheckMap[i][j] = 0;
    }
}
//-----//
/*
*/
int CObject::FindBlocksAtPlaces(bool map[][8])
{
    int num = 0;
    std::list<ol::Vec2D*> placelist;
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
    {
        if ((*iter)->type == BLOCK_PLACEMENT)
            placelist.push_back(new ol::Vec2D((*iter)->x,(*iter)->y));
    }

    for (std::list<ol::Vec2D*>::iterator placeiter = placelist.begin(); placeiter != placelist.end(); ++placeiter)
    {
        for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
        {
            if ((*iter)->type == type && (*iter)->x == (*placeiter)->x && (*iter)->y == (*placeiter)->y)
            {
                map[(*iter)->y/48][(*iter)->x/48] = true;
                ++num;
            }
        }
    }

    for (std::list<ol::Vec2D*>::iterator placeiter = placelist.begin(); placeiter != placelist.end(); ++placeiter)
        delete *placeiter;
    placelist.clear();

    return num;
}
//-----//
/*
  CHECKBLOCKSATPLACE: Sprawdza czy mona usun klocki w trybie MODE_ATPLACE
*/
void CObject::CheckBlocksAtPlace()
{
    bool CheckMap[8][8] = {{0}};
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
    {
        if ((*iter)->type == BLOCK_PLACEMENT)
        {
            for (std::list<CObject*>::iterator iter2 = objlist.begin(); iter2 != objlist.end(); ++iter2)
            {
                if ((*iter2)->x == (*iter)->x && (*iter2)->y == (*iter)->y && (*iter2)->type != BLOCK_PLACEMENT)
                {
                    if ((*iter2)->FindBlocksAtPlaces(CheckMap) == GetNumberOfTypeBlocks((*iter2)->type))
                        iter = DestroyBlocks(CheckMap);
                    else
                        for (int i = 0; i < 8; ++i)
                        for (int j = 0; j < 8; ++j)
                            CheckMap[i][j] = false;
                    break;
                }
            }
        }
    }
}
//-----//
/*
  DESTROYALLBLOCKS: Niszczy ca list obiektw
*/
void CObject::DestroyAllBlocks()
{
    if (!objlist.empty())
    {
        for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
            delete *iter;
        objlist.clear();
    }
}
//-----//
/*
  DRAWOBJS: Wyrysowanie obiektw na bufor (na podstawie listy)
*/
void CObject::DrawObjs(const int offset)
{
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
    {
        if ((*iter)->type != BLOCK_PLACEMENT)
        {
            if (!g.GetRotAngle())
                ObjBmp.Blit(offset + (*iter)->x - ((*iter)->type - 1)*tile, offset + (*iter)->y,
                            ol::Clipped(((*iter)->type - 1)*tile, 0, 48, 48),1.0);
            else
                switch (g.GetRotAngle())
                {
                    case 1: ObjBmp.BlitRotated(offset+(*iter)->x+24,24+offset+(*iter)->y-((*iter)->type - 1)*tile,24,24,AL_PI/2,  ol::Clipped(((*iter)->type - 1)*tile,0,48,48)); break;
                    case 2: ObjBmp.BlitRotated(offset+(*iter)->x+24+((*iter)->type - 1)*tile,24+offset+(*iter)->y,24,24,AL_PI,    ol::Clipped(((*iter)->type - 1)*tile,0,48,48)); break;
                    case 3: ObjBmp.BlitRotated(offset+(*iter)->x+24,24+offset+(*iter)->y+((*iter)->type - 1)*tile,24,24,AL_PI/2*3,ol::Clipped(((*iter)->type - 1)*tile,0,48,48)); break;
                }
        }
    }
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
    { //BLOCK_PLACEMENT musz(!) by narysowane na kocu (eby byy warstw wyej)
        if ((*iter)->type == BLOCK_PLACEMENT)
        {
            ObjBmp.Blit(offset + (*iter)->x - ((*iter)->type - 1)*tile, offset + (*iter)->y,
                    ol::Clipped(((*iter)->type - 1)*tile, 0, 48, 48),1.0);
        }
    }
    for (std::list<CObject*>::iterator iter = objlist.begin(); iter != objlist.end(); ++iter)
    { //narysowanie powiat obiektw
        if ((*iter)->type == BLOCK_PLACEMENT)
        {
            (*iter)->glow_rad += rand()%3-1;
            if ((*iter)->glow_rad < 2) (*iter)->glow_rad = 2;
            else if ((*iter)->glow_rad > 40) (*iter)->glow_rad = 40;
        }
        ol::Blenders::Set(ol::ADDITIVE_BLENDER);
        ol::Circle((*iter)->x+24+offset,(*iter)->y+24+offset,(*iter)->glow_rad).Draw((*iter)->m_color,ol::Rgba(0.3,0.3,0.3,0.0));
        ol::Blenders::Set(ol::ALPHA_BLENDER);
    }
}
