#ifndef MENU_H_H_
#define MENU_H_H_

#include <OpenLayer.hpp>
#include <string>
#include <FMOD/fmod.h>
#include "ConstEnums.h"
//-----//
class CButton;
class CMenu
{
    int pressed;
    bool m_pressed_with_mouse, m_mouse_trace;
    int m_current_colorpack, m_current_screen, m_lang;
    int m_sound_volume, m_music_volume;
    int m_classic_unlocked, m_all_unlocked, m_tutorial_unlocked, m_place_unlocked;
    bool m_key_lock, m_quit, m_redraw;
    CButton *btn;
    std::string m_player_name;
    ol::TextRenderer MenuFont18, MenuFont36;
    ol::Rgba TextColor;
    void MenuLoop();
    void Destroy();
    void KeyInput();
    void ProcessPressed();
    void StartBGMusic();

    void ReadData(std::string);
    void SaveData() const;
    void InitLangButtons();
    void InitButtons(int);
    void InputPlayerName();

    public:
        static void EncryptFile(std::string,std::string);
        void MenuInit();
        void ReInit();
        void UpdateUnlocked(int,int,int);
        void SetSoundVol(int,bool);
        void SetMusicVol(int,bool);
        int GetCurrentColorpack()               { return m_current_colorpack; }
        void SetCurrentColorpack(int i)         { m_current_colorpack = i; TextColor = MAKE_CURRENT_TEXT; }
        ol::TextRenderer& GetMenuFont(bool b)   { return (b) ? MenuFont18 : MenuFont36; }
        ol::Rgba& GetTextColor()                { return TextColor; }
        int GetLang()                           { return m_lang; }
        int GetSoundVol()                       { return m_sound_volume; }
        int GetMusicVol()                       { return m_music_volume; }
        bool GetMouseTrace()                    { return m_mouse_trace; }
        std::string GetPlayerName()             { return m_player_name; }
        void SetMouseTrace(bool b)              { m_mouse_trace = b; }

        CMenu() :   MenuFont18("G/va.ttf",12,18,ol::Rgba::RED),
                    MenuFont36("G/va.ttf",24,36,ol::Rgba::RED),
                    TextColor(ol::Rgba::RED)
        {
            pressed = -1;
            m_quit = false;
            m_redraw = true;
            m_classic_unlocked = 1;
            m_all_unlocked = 1;
            m_current_screen = SCREEN_MAIN;
            m_lang = LANG_PL;
            m_current_colorpack = COLORPACK_BLUE;
            m_sound_volume = 200;
            m_music_volume = 200;
        }
        ~CMenu()
        {
            MenuFont18.Destroy();
            MenuFont36.Destroy();
        }
};
extern CMenu menu;
extern FSOUND_STREAM *bgmusic;
void display_switch_out();
void display_switch_in();
//-----//
#endif
