#include "Menu.h"
//-----//
#include <OpenLayer.hpp>

#include "Game.h"
#include "Button.h"
#include "LevelEditor.h"
#include "DrawFuncs.h"
#include "ConstEnums.h"
#include "logf.h"

#define VERSION_TXT "v1.0, b10.12.08, by Fayl"
CMenu menu;
FSOUND_STREAM *bgmusic = NULL;
//-----//
/*
  PROCESSPRESSED: Obsługa wciśniętego przycisku
*/
void CMenu::ProcessPressed()
{
    switch (m_current_screen)
    {
        case SCREEN_MAIN:
            if      (pressed == BUTTON_START)       InitButtons(SCREEN_START);
            else if (pressed == BUTTON_EXIT)        m_quit = true;
            else if (pressed == BUTTON_OPTIONS)     InitButtons(SCREEN_OPTIONS);
            else if (pressed == BUTTON_LEVELEDITOR) InitButtons(SCREEN_PREEDITOR);
            else if (pressed == BUTTON_REPLAYS)     InitButtons(SCREEN_REPLAYS);
            else if (pressed == BUTTON_NAMECHANGE)  InputPlayerName();
            break;
        case SCREEN_OPTIONS:
            if      (pressed == BUTTON_OPTLANGUAGE)     InitLangButtons();
            else if (pressed == BUTTON_LANGPL) { m_lang = LANG_PL; g.SetLang(m_lang); InitButtons(SCREEN_OPTIONS); }
            else if (pressed == BUTTON_LANGEN) { m_lang = LANG_EN; g.SetLang(m_lang); InitButtons(SCREEN_OPTIONS); }
            else if (pressed == BUTTON_BACKFROMOPTIONS) InitButtons(SCREEN_MAIN);
            break;
        case SCREEN_START:
            if (pressed == BUTTON_CLASSICLEVELS)        InitButtons(SCREEN_CLASSICLEVEL);
            else if (pressed == BUTTON_CUSTOMLEVELS)    InitButtons(SCREEN_CUSTOMLEVEL);
            else if (pressed == BUTTON_ALLLEVELS)       InitButtons(SCREEN_ALLLEVEL);
            else if (pressed == BUTTON_TUTORIALLEVELS)  InitButtons(SCREEN_TUTORIALLEVEL);
            else if (pressed == BUTTON_PLACELEVELS)     InitButtons(SCREEN_PLACELEVEL);
            else if (pressed == BUTTON_BACKFROMSTART)   InitButtons(SCREEN_MAIN);
            break;
        case SCREEN_PREEDITOR:
            if      (pressed == BUTTON_EDITORSTARTNEW) { edit->EditorInit(""); InitButtons(SCREEN_PREEDITOR); }
            else if (pressed == BUTTON_BACKFROMPREEDITOR)   InitButtons(SCREEN_MAIN);
            else if (pressed > 100)                    { edit->EditorInit(btn->GetPressedName(pressed)); InitButtons(SCREEN_PREEDITOR); }
            break;
        case SCREEN_CLASSICLEVEL:
            if      (pressed > 100) { g.GameInit(pressed-100,MODE_CLASSIC); InitButtons(SCREEN_CLASSICLEVEL); }
            else if (pressed == BUTTON_BACKFROMCLASSICLEVEL) InitButtons(SCREEN_START);
            break;
        case SCREEN_CUSTOMLEVEL:
            if (pressed > 100) { g.GameInit(btn->GetPressedName(pressed),0); }
            else if (pressed == BUTTON_BACKFROMCUSTOMLEVELS) InitButtons(SCREEN_START);
            break;
        case SCREEN_ALLLEVEL:
            if (pressed > 100)      {g.GameInit(pressed-100,MODE_ALL); InitButtons(SCREEN_ALLLEVEL); }
            else if (pressed == BUTTON_BACKFROMALLLEVELS)   InitButtons(SCREEN_START);
            break;
        case SCREEN_TUTORIALLEVEL:
            if (pressed > 100)      { g.GameInit(pressed-100,MODE_TUTORIAL); InitButtons(SCREEN_TUTORIALLEVEL); }
            else if (pressed == BUTTON_BACKFROMTUTORIAL) InitButtons(SCREEN_START);
            break;
        case SCREEN_PLACELEVEL:
            if (pressed > 100)      { g.GameInit(pressed-100,MODE_ATPLACE); InitButtons(SCREEN_PLACELEVEL); }
            else if (pressed == BUTTON_BACKFROMPLACELEVELS) InitButtons(SCREEN_START);
            break;
        case SCREEN_REPLAYS:
            if (pressed > 100)      { g.SetReplayMode(true); g.GameInit(btn->GetPressedName(pressed),-1); g.SetReplayMode(false); }
            else if (pressed == BUTTON_BACKFROMREPLAYS) InitButtons(SCREEN_MAIN);
    }
    pressed = -1;
    m_key_lock = true;
}
//-----//
/*
  KEYINPUT: sprawdza wciśnięte klawisze
*/
void CMenu::KeyInput()
{
    m_pressed_with_mouse = false;
    if (!m_key_lock)
    {
        if (key[KEY_UP])
        {
            if (m_current_screen == SCREEN_CLASSICLEVEL || m_current_screen == SCREEN_ALLLEVEL || m_current_screen == SCREEN_TUTORIALLEVEL)
                btn->SelectUpperButton();
            else
                btn->SelectPrevButton();
            m_key_lock = true;
        }
        else if (key[KEY_DOWN])
        {
            if (m_current_screen == SCREEN_CLASSICLEVEL || m_current_screen == SCREEN_ALLLEVEL || m_current_screen == SCREEN_TUTORIALLEVEL)
                btn->SelectLowerButton();
            else
                btn->SelectNextButton();
            m_key_lock = true;
        }
        else if (key[KEY_LEFT])
        {
            if (btn->GetSelectedScrollable())
            {
                sbtn->LeftKeyAction();
                m_redraw = true; rest(50);
            }
            else
            {
                btn->SelectPrevButton();
                m_key_lock = true;
            }
        }
        else if (key[KEY_RIGHT])
        {
            if (btn->GetSelectedScrollable())
            {
                sbtn->RightKeyAction();
                m_redraw = true; rest(50);
            }
            else
            {
                btn->SelectNextButton();
                m_key_lock = true;
            }
        }
        else if (key[KEY_ENTER] || key[KEY_SPACE])
        {
            pressed = btn->GetSelectedButton();
            if (pressed)
            {
                FSOUND_SetVolumeAbsolute(1,m_sound_volume);
                FSOUND_PlaySound(1,SndEnter);
            }
        }
        else if (key[KEY_ESC])
        {
            btn->SelectLastButton();
            m_key_lock = true;
        }
        else if (pressed == -1)//mouse_b == 1)
        {
            pressed = btn->CheckMouseInput(mouse_x,mouse_y,mouse_b);
            if (pressed != -1)
            {
                m_key_lock = true;
                m_pressed_with_mouse = true;
            }
        }
    }
    else if (!key[KEY_UP] && !key[KEY_DOWN] && !key[KEY_SPACE] && !key[KEY_ENTER]
             && !key[KEY_RIGHT] && !key[KEY_LEFT] && !mouse_b)
    {
        m_key_lock = false; //blokada zapobiega kilkukrotnemu wciskaniu przycisku...
    }   //...z powodu zbyt szybkiej reakcji programu (żeby zniknęła - trzeba puścić klawisz)
}
//-----//
/*
  MENULOOP: Pętla główna menu
*/
void CMenu::MenuLoop()
{
    pressed = -1;
    m_pressed_with_mouse = false;
    m_key_lock = true;
    ol::Bitmap logo("G/logo.png");
    while(!m_quit)
    {
        //if (m_key_lock || m_redraw)
        {
            m_redraw = false;
            ol::Canvas::Fill(MAKE_CURRENT_COLOR);
            btn->DrawButtons();
            if (m_current_screen == SCREEN_ALLLEVEL   || m_current_screen == SCREEN_CLASSICLEVEL ||
                m_current_screen == SCREEN_PLACELEVEL || m_current_screen == SCREEN_START)
                    DrawHiScores(m_current_screen,btn->GetSelectedButton(),MenuFont36);

            MenuFont18.Print(VERSION_TXT,500,23);

            if (m_current_screen != SCREEN_CUSTOMLEVEL && m_current_screen != SCREEN_PREEDITOR && m_current_screen != SCREEN_REPLAYS)
            logo.BlitDistorted(140,20,500,20,520,120,120,120,ol::Tinted(MAKE_CURRENT_COLOR.WithAlpha(0.5)));
            draw_mouse();
            ol::Canvas::Refresh();
        }
        KeyInput();
        if (pressed != -1)
            ProcessPressed();
        rest(10);
    }
}
//-----//
/*
  INITBUTTONS: Przyciski na ekranie
*/
void CMenu::InitButtons(int actual_screen)
{
    m_current_screen = actual_screen;
    btn->DestroyAllButtons();

    switch(actual_screen)
    {
        case SCREEN_MAIN:
            btn->CreatePressButton(BUTTON_NAMECHANGE,380,440,-1,20,lang[m_lang][TXT_NAMECH]+m_player_name, false,true );
            btn->CreatePressButton(BUTTON_START,      50,210,-1,36,lang[m_lang][TXT_START],  true, false);
            btn->CreatePressButton(BUTTON_OPTIONS,    50,250,-1,36,lang[m_lang][TXT_OPTIONS],false,false);
            btn->CreatePressButton(BUTTON_REPLAYS,    50,290,-1,36,lang[m_lang][TXT_REPLAY], false,false);
            btn->CreatePressButton(BUTTON_LEVELEDITOR,50,330,-1,36,lang[m_lang][TXT_EDITOR], false,false);
            btn->CreatePressButton(BUTTON_EXIT,       50,370,-1,36,lang[m_lang][TXT_EXIT],   false,false);
            break;
        case SCREEN_OPTIONS:
            btn->CreatePressButton(BUTTON_OPTLANGUAGE,    50,130,-1,36,lang[m_lang][TXT_LANGUAGE],  true, false);
            btn->CreateScrollButton(BUTTON_OPTSPEED,      50,170,-1,36,lang[m_lang][TXT_GAMESPEED], false,false,g.GetGameSpeed(),  20,50);
            btn->CreateScrollButton(BUTTON_OPTMUSIC,      50,210,-1,36,lang[m_lang][TXT_MUSICVOL],  false,false,m_music_volume,     0,255);
            btn->CreateScrollButton(BUTTON_OPTSOUND,      50,250,-1,36,lang[m_lang][TXT_SOUNDVOL],  false,false,GetSoundVol(),      0,255);
            btn->CreateScrollButton(BUTTON_OPTCOLOR,      50,290,-1,36,lang[m_lang][TXT_COLORPACK], false,false,m_current_colorpack,0,5);
            btn->CreateScrollButton(BUTTON_OPTTRACE,      50,330,-1,36,lang[m_lang][TXT_MOUSETRACE],false,false,m_mouse_trace,      0,1);
            btn->CreateScrollButton(BUTTON_AUTOHS,        50,370,-1,36,lang[m_lang][TXT_AUTOHS],    false,false,g.GetAutoHS(),      0,1);
            btn->CreatePressButton(BUTTON_BACKFROMOPTIONS,50,410,-1,36,lang[m_lang][TXT_BACK],      false,false);
            break;
        case SCREEN_START:
            btn->CreatePressButton(BUTTON_TUTORIALLEVELS,50,170,-1,36,lang[m_lang][TXT_TUTORIAL],false,false);
            btn->CreatePressButton(BUTTON_CLASSICLEVELS, 50,210,-1,36,lang[m_lang][TXT_CLASSIC], true, false);
            btn->CreatePressButton(BUTTON_ALLLEVELS,     50,250,-1,36,lang[m_lang][TXT_ALL],     false,false);
            btn->CreatePressButton(BUTTON_PLACELEVELS,   50,290,-1,36,lang[m_lang][TXT_PLACE],   false,false);
            btn->CreatePressButton(BUTTON_CUSTOMLEVELS,  50,330,-1,36,lang[m_lang][TXT_CUSTOM],  false,false);
            btn->CreatePressButton(BUTTON_BACKFROMSTART, 50,370,-1,36,lang[m_lang][TXT_BACK],    false,false);
            break;
        case SCREEN_CLASSICLEVEL:
            for (int i = 1; i <= MAX_CLASSIC_LEVEL_NUMBER; ++i)
            {
                if (i > m_classic_unlocked) break;
                btn->CreatePressButton(i+100,10+((i-1)%4)*50,150+((i-1)/4)*50,-1,36,ol::ToString(i),false,false);
            }
            btn->CreatePressButton(BUTTON_BACKFROMCLASSICLEVEL,50,370,-1,36,lang[m_lang][TXT_BACK],true,false);
            break;
        case SCREEN_TUTORIALLEVEL:
            for (int i = 1; i <= MAX_TUTORIAL_LEVEL_NUMBER; ++i)
            {
                if (i > m_tutorial_unlocked) break;
                btn->CreatePressButton(i+100,50+((i-1)%3)*50,150+((i-1)/3)*50,-1,36,ol::ToString(i),false,false);
            }
            btn->CreatePressButton(BUTTON_BACKFROMTUTORIAL,50,370,-1,36,lang[m_lang][TXT_BACK],true,false);
            break;
        case SCREEN_ALLLEVEL:
            for (int i = 1; i <= MAX_ALL_LEVEL_NUMBER; ++i)
            {
                if (i > m_all_unlocked) break;
                btn->CreatePressButton(i+100,10+((i-1)%4)*50,150+((i-1)/4)*50,-1,36,ol::ToString(i),false,false);
            }
            btn->CreatePressButton(BUTTON_BACKFROMALLLEVELS,50,370,-1,36,lang[m_lang][TXT_BACK],true,false);
            break;
        case SCREEN_PLACELEVEL:
            for (int i = 1; i <= MAX_PLACE_LEVEL_NUMBER; ++i)
            {
                if (i > m_place_unlocked) break;
                btn->CreatePressButton(i+100,10+((i-1)%4)*50,150+((i-1)/4)*50,-1,36,ol::ToString(i),false,false);
            }
            btn->CreatePressButton(BUTTON_BACKFROMPLACELEVELS,50,370,-1,36,lang[m_lang][TXT_BACK],true,false);
            break;
        case SCREEN_CUSTOMLEVEL:
            al_ffblk mapfile;
            if (al_findfirst("user_maps/*.usrmap",&mapfile,FA_ALL) == 0)
            for (int i = 0; i < MAX_CUSTOM_LEVEL_NUMBER; ++i)
            {
                btn->CreatePressButton(i+101,50+180*(i/15),50+(i%15)*20,-1,20,mapfile.name,false,true);
                if (al_findnext(&mapfile) != 0) break;
            }
            al_findclose(&mapfile);
            btn->CreatePressButton(BUTTON_BACKFROMCUSTOMLEVELS,50,370,-1,36,lang[m_lang][TXT_BACK],true,false);
            break;
        case SCREEN_PREEDITOR:
            al_ffblk mapfile1;
            if (al_findfirst("user_maps/*.usrmap",&mapfile1,FA_ALL) == 0)
            for (int i = 0; i < MAX_CUSTOM_LEVEL_NUMBER; ++i)
            {
                    btn->CreatePressButton(i+101,50+180*(i/15),50+(i%15)*20,-1,20,mapfile1.name,false,true);
                if (al_findnext(&mapfile1) != 0) break;
            }
            al_findclose(&mapfile1);
            btn->CreatePressButton(BUTTON_EDITORSTARTNEW,50,370,-1,36,lang[m_lang][TXT_NEWMAP],false,false);
            btn->CreatePressButton(BUTTON_BACKFROMPREEDITOR,450,370,-1,36,lang[m_lang][TXT_BACK],true,false);
            break;
        case SCREEN_REPLAYS:
            al_ffblk mapfile2;
            if (al_findfirst("rpl/*.replay",&mapfile2,FA_ALL) == 0)
            for (int i = 0; i < MAX_CUSTOM_LEVEL_NUMBER; ++i)
            {
                    btn->CreatePressButton(i+101,50+180*(i/15),50+(i%15)*20,-1,20,mapfile2.name,false,true);
                if (al_findnext(&mapfile2) != 0) break;
            }
            al_findclose(&mapfile2);
            btn->CreatePressButton(BUTTON_BACKFROMREPLAYS,450,370,-1,36,lang[m_lang][TXT_BACK],true,false);
            break;
    }
}
//-----//
void CMenu::InitLangButtons() //(osobna funkcja(chwilowo?), bo tu pomimo zmiany przyciskow nie zmienia sie ekran)
{
    m_current_screen = SCREEN_OPTIONS;
    btn->DestroyAllButtons();
    btn->CreatePressButton(BUTTON_LANGPL,50,290,-1,36,lang[m_lang][TXT_LANGPL],false, false);
    btn->CreatePressButton(BUTTON_LANGEN,50,330,-1,36,lang[m_lang][TXT_LANGEN],true, false);
}
//-----//
/*
  REINIT: Przywraca menu do działania po wyjściu z planszy
*/
void CMenu::ReInit()
{
    StartBGMusic();
    logf("* Reinitializing menu\n");
    //i już? :P
}
//-----//
/*
  UPDATEUNLOCKED:
*/
void CMenu::UpdateUnlocked(int lvl, int mode, int tutorial)
{
    int flag = false;
    if (!tutorial)
        switch (mode)
        {
            case MODE_CLASSIC:
                if (lvl > m_classic_unlocked)
                {
                    m_classic_unlocked = lvl;
                    flag = true;
                }
                break;
            case MODE_ALL:
                if (lvl > m_all_unlocked)
                {
                    m_all_unlocked = lvl;
                    flag = true;
                }
                break;
            case MODE_ATPLACE:
                if (lvl > m_place_unlocked)
                {
                    m_place_unlocked = lvl;
                    flag = true;
                }
                break;
        }
    else if (lvl > m_tutorial_unlocked)
    {
        m_tutorial_unlocked = lvl;
        flag = true;
    }

    if (flag)
    {
        SaveData();
    }
}
//-----//
/*
  STARTBGMUSIC:
*/
void CMenu::StartBGMusic()
{
    FSOUND_Stream_Stop(bgmusic);
    FSOUND_Stream_Close(bgmusic);
    bgmusic = FSOUND_Stream_Open ("Snd/menu.ogg",FSOUND_LOOP_NORMAL,0,0);
    FSOUND_Stream_Play (0,bgmusic);
    FSOUND_SetVolume(0,menu.GetMusicVol());
    set_display_switch_callback(SWITCH_OUT,display_switch_out);
    set_display_switch_callback(SWITCH_IN, display_switch_in );
}
void CMenu::SetSoundVol(int i, bool rel)
{
    m_sound_volume = (rel) ? m_sound_volume + i : i;
    FSOUND_SetVolumeAbsolute(FSOUND_ALL,m_sound_volume);
    FSOUND_SetVolumeAbsolute(0,m_music_volume);
}
void CMenu::SetMusicVol(int i, bool rel)
{
    m_music_volume = (rel) ? m_music_volume + i : i;
    FSOUND_SetVolumeAbsolute(0,GetMusicVol());
}
//-----//
void CMenu::EncryptFile(std::string filename, std::string key)
{
    std::ifstream LOAD(filename.c_str(),std::ios::ate);
    if (LOAD.is_open())
    {
        int size = LOAD.tellg();
        char* buf = new char [size];
        LOAD.seekg (0, std::ios::beg);
        LOAD.read(buf,size);
        LOAD.close();

        for(int i = 0, place = 0; i < size; ++i, ++place)
        {
            buf[i] ^= key.at(place);
            if (place >= static_cast<int>(key.length()-1)) place = 0;
        }
        std::ofstream SAVE(filename.c_str(),std::ios::trunc);
        SAVE.write(buf,size);
        SAVE.close();
        delete [] buf;
    }
}
//-----//
/*
  SAVEDATA:
*/
void CMenu::SaveData() const
{
    set_config_file("data.oof");
    set_config_int("Levels", "Classic",  m_classic_unlocked);
    set_config_int("Levels", "All",      m_all_unlocked);
    set_config_int("Levels", "Place",    m_place_unlocked);
    set_config_int("Levels", "Tutorial", m_tutorial_unlocked);
    set_config_int("Display","Trace",    m_mouse_trace);
    set_config_int("Display","Colorpack",m_current_colorpack);
    set_config_int("Display","Sound",    m_music_volume);
    set_config_int("Display","Music",    m_sound_volume);
    set_config_int("Game",   "Speed",    g.GetGameSpeed());
    set_config_int("Game",   "Lang",     m_lang);
    set_config_int("Game",   "AutoHS",   g.GetAutoHS());
    set_config_string("Game","Name",     m_player_name.c_str());
    flush_config_file();
}
//-----//
/*
  READDATA:
*/
void CMenu::ReadData(std::string filename)
{
    int gspeed, gauto;
    set_config_file(filename.c_str());
    m_classic_unlocked =    get_config_int("Levels","Classic",  1);
    m_all_unlocked =        get_config_int("Levels","All",      1);
    m_place_unlocked =      get_config_int("Levels","Place",    1);
    m_tutorial_unlocked =   get_config_int("Levels","Tutorial", 1);
    m_mouse_trace =         get_config_int("Display","Trace",   1);
    m_current_colorpack =   get_config_int("Display","Colorpack",5);
    m_music_volume =        get_config_int("Display","Sound",   200);
    m_sound_volume =        get_config_int("Display","Music",   200);
    gspeed =                get_config_int("Game","Speed",      35);
    m_lang =                get_config_int("Game","Lang",       1);
    gauto =                 get_config_int("Game","AutoHS",     1);
    m_player_name =      get_config_string("Game","Name",       "");
    flush_config_file();
    TextColor = MAKE_CURRENT_TEXT;
    MenuFont18.SetColor(TextColor);
    MenuFont36.SetColor(TextColor);
    g.SetLang(m_lang);
    g.SetGameSpeed(gspeed,false);
    g.SetAutoHS(gauto);
    g.SetColorpack(m_current_colorpack);
    SetSoundVol(m_sound_volume,false);
    SetMusicVol(m_music_volume,false);
}
//-----//
void CMenu::InputPlayerName()
{
    ol::Canvas::SetTo(ol::SCREEN_FRONTBUF);
    ol::Canvas::Fill(MAKE_CURRENT_COLOR);
    draw_box(260,260,600,400,CURRENT_CLR,CURRENT_CLG,CURRENT_CLB);
    MenuFont36.Print(lang[m_lang][TXT_INPUTNAME],280,330);
    InputName(m_player_name,MenuFont18,300,350);
    ol::Canvas::SetTo(ol::SCREEN_BACKBUF);
    InitButtons(SCREEN_MAIN);
}
//-----//
/*
  INIT: Tworzy przyciski menu, wchodzi w pętlę oczekującą na wciśnięcie klawisza
*/
void CMenu::MenuInit()
{
    flush_config_file();
    logf("* Initializing menu\n");
    g.CreateBitmaps();

    SndEnter = FSOUND_Sample_Load(1,"Snd/button2.ogg",0,0,0);
    SndScroll = FSOUND_Sample_Load(2,"Snd/button.ogg",0,0,0);
    StartBGMusic();

    ReadData("data.oof");
    InitButtons(SCREEN_MAIN);
    while (m_player_name == "")
        InputPlayerName();
    MenuLoop();
    SaveData();
    Destroy();
}
//-----//
void CMenu::Destroy()
{
    FSOUND_Stream_Close(bgmusic);
    FSOUND_Sample_Free(SndEnter);
    FSOUND_Sample_Free(SndScroll);
}
//-----//
void display_switch_out()
{
    FSOUND_SetPaused(FSOUND_ALL,true);
}
void display_switch_in()
{
    FSOUND_SetPaused(FSOUND_ALL,false);
}
