#ifndef LEVELEDITOR_H_
#define LEVELEDITOR_H_

#include <OpenLayer.hpp>
#include <string>

#include "ConstEnums.h"
//-----//
class CBoard;
class CButton;
class CEditor
{
    int m_selected_block, pressed, m_level_mode;
    bool m_editor_quit;
    bool m_nameinput_active;
    CBoard *board;
    ol::TextRenderer EditFont18;
    CButton *ebtn;
    std::string m_mapname;
    ol::Bitmap ObjBmpLvl;

    void EditorLoop();
    void KeyInput();
    void SaveMap() const;
    void InitButtons() const;
    void ProcessKeys();
    void ProcessGraphics();
    //void InsertMapName();

    public:
        void EditorInit(std::string);

    CEditor()
    {
        m_selected_block = 1;
        m_level_mode = MODE_CLASSIC;
        m_nameinput_active = false;
        pressed = 0;
    }
};
extern CEditor *edit;
//-----//
#endif
