#include "LevelEditor.h"
//-----//
#include <OpenLayer.hpp>
#include <FMOD/fmod.h>
#include <loadpng.h>
#include <iostream>
#include <fstream>

#include "BlockBoard.h"
#include "Menu.h"
#include "Game.h"
#include "Button.h"
#include "Object.h"
#include "Particles.h"
#include "DrawFuncs.h"
#include "ConstEnums.h"

CEditor *edit = new CEditor();

FSOUND_SAMPLE *SndSelect, *SndPlace;
//-----//
/*
  SAVEMAP: Zapis mapy do pliku
*/
void CEditor::SaveMap() const
{
    std::string tmp("user_maps/");
    tmp += m_mapname;
    if (tmp.find(".usrmap") == std::string::npos) tmp += ".usrmap";
    std::ofstream SAVE(tmp.c_str(),std::ios::trunc);

    int map[8][8] = {{0}};
    obj->CreateObjectMap(map); //tworzy mapę planszy z zaznaczonymi obiektami

    SAVE << m_level_mode << "\n";
    for(int i = 0; i < 8; ++i)
    {
        for(int j = 0; j < 8; ++j)
            SAVE << map[j][i] << " ";
        SAVE << "\n";
    }
    SAVE.close();
}
//-----//
/*
  KEYINPUT: Sprawdza wciśnięte klawisze i myszkę
*/
void CEditor::KeyInput()
{
    if (mouse_b == 1 && mouse_x > 24 && mouse_x < 384+24 &&
        mouse_y > 24 && mouse_y < 384+24 && m_selected_block > 0) //klik LPM w polu mapy
    {
            int temp_tile_x = mouse_x - (mouse_x-24)%48 - 24,
                temp_tile_y = mouse_y - (mouse_y-24)%48 - 24;
            if (obj->GetTypeAtXY(temp_tile_x,temp_tile_y) != m_selected_block)
            {
                obj->CreateBlock(temp_tile_x,temp_tile_y,m_selected_block);
                FSOUND_PlaySound(2,SndPlace);
                FSOUND_SetVolumeAbsolute(2,menu.GetSoundVol());
                defpart->CreateDust(temp_tile_x,temp_tile_y+24,false);
            }
    }
    else if (mouse_b == 2 && mouse_x > 24 && mouse_x < 384+24 &&
        mouse_y > 24 && mouse_y < 384+24 && m_selected_block > 0) //klik PPM w polu mapy
    {
            int temp_tile_x = mouse_x - (mouse_x-24)%48 - 24,
                temp_tile_y = mouse_y - (mouse_y-24)%48 - 24;
            if (obj->GetTypeAtXY(temp_tile_x,temp_tile_y) != 0)
            {
                obj->DestroyBlock(temp_tile_x,temp_tile_y);
                FSOUND_PlaySound(2,SndPlace);
                FSOUND_SetVolumeAbsolute(2,menu.GetSoundVol());
                defpart->CreateDust(temp_tile_x,temp_tile_y+24,true);
            }
    }
    if (mouse_b == 1 && mouse_x > 24 && mouse_x < 24+ObjBmp.Width() &&
        mouse_y > 420 && mouse_y < 420+ObjBmp.Height()) //klik w zestaw klocków
    {
            int temp_old_selected = m_selected_block;
            m_selected_block = (mouse_x-24)/48+1;
            if (temp_old_selected != m_selected_block)
            {
                FSOUND_PlaySound(1,SndSelect);
                FSOUND_SetVolumeAbsolute(1,menu.GetSoundVol());
            }
    }

    if (mouse_b == 1 && mouse_x > 462 && mouse_x < 610 && mouse_y > 318 && mouse_y < 345)
        m_nameinput_active = true; //klik w miejsce na nazwę mapy
    else if (mouse_b == 1)
        m_nameinput_active = false;

    if (m_nameinput_active)
    {
        InputName(m_mapname,EditFont18,462,318);
        m_nameinput_active = false;
    }
}
//-----//
/*
  PROCESSKEYS: Sprawdza wciśnięte przyciski [nie klawisze]
*/
void CEditor::ProcessKeys()
{
    if (pressed == BUTTON_EDITSAVEMAP)
    {
        SaveMap();
        m_editor_quit = true;
    }
    else if (pressed == BUTTON_EDITMODEC)
    {
        ebtn->SelectButton(BUTTON_EDITMODEC);
        m_level_mode = MODE_CLASSIC;

    }
    else if (pressed == BUTTON_EDITMODEA)
    {
        ebtn->SelectButton(BUTTON_EDITMODEA);
        m_level_mode = MODE_ALL;
    }
    else if (pressed == BUTTON_EDITMODEP)
    {
        ebtn->SelectButton(BUTTON_EDITMODEP);
        m_level_mode = MODE_ATPLACE;
    }
    else if (pressed == BUTTON_TESTMAP)
    {
        std::string tmpname = m_mapname;
        m_mapname = ".tmp.";
        SaveMap();
        g.GameInit(".tmp..usrmap");
        board->LoadBoard("user_maps/.tmp..usrmap",true);
        m_mapname = tmpname;
    }
    else if (pressed == BUTTON_BACKFROMEDITOR)
    {
        m_editor_quit = true;
    }
    pressed = 0;
}
//-----//
/*
  PROCESSGRAPHICS: Odmalowuje wszystkie potrzebne elementy na bitmapie editbuf
*/
void CEditor::ProcessGraphics()
{
     int cl = menu.GetCurrentColorpack();
    ol::Canvas::Fill(ol::Rgba(clpack[cl][0],clpack[cl][1],clpack[cl][2]));
    draw_box(24-8,24-8,24+48*8+8,24+48*8+8,clpack[cl][0],clpack[cl][1],clpack[cl][2],8);
    obj->DrawObjs(24);
    ObjBmpLvl.Blit(24,420);
    ebtn->DrawButtons();

    draw_box(462,318,610,345,clpack[cl][0],clpack[cl][1],clpack[cl][2],2);
    draw_box((m_selected_block-1)*48+22,418,m_selected_block*48+26,470,200,200,200,2,false);
    EditFont18.Print(lang[menu.GetLang()][TXT_MAPNAME],432,310);
    EditFont18.Print(m_mapname,462,340);
    if (m_selected_block && mouse_x > 24 && mouse_x < 48*8+24 && mouse_y > 24 && mouse_y < 48*8+24)
        ObjBmpLvl.Blit(mouse_x - (mouse_x + 24)%48 - (m_selected_block - 1)*48,
                       mouse_y - (mouse_y + 24)%48, ol::Clipped((m_selected_block - 1)*48, 0, 48, 48));

    defpart->ProcessParticles();
    defpart->DrawParticles();
    draw_mouse();
    ol::Canvas::Refresh();
    //blit(editbuf,screen,0,0,0,0,640,480);
}
//-----//
/*
  EDITORLOOP: Pętla główna edytora
*/
void CEditor::EditorLoop()
{
    while(mouse_b);
    while(!m_editor_quit)
    {
        KeyInput();

        if (mouse_b)
            pressed = ebtn->CheckMouseInput(mouse_x,mouse_y,mouse_b);
        if (pressed)
            ProcessKeys();

        ProcessGraphics();
        rest(10);
    }
}
//-----//
/*
  INITBUTTONS: Przyciski w edytorze
*/
void CEditor::InitButtons() const
{
    ebtn->DestroyAllButtons();
    ebtn->CreatePressButton(BUTTON_EDITSAVEMAP,450,360,-1,40,lang[menu.GetLang()][TXT_SAVEEXIT],false,false);
    ebtn->CreatePressButton(BUTTON_BACKFROMEDITOR,450,400,-1,40,lang[menu.GetLang()][TXT_BACK],false,false);
    ebtn->CreatePressButton(BUTTON_TESTMAP,432,150,-1,40,lang[menu.GetLang()][TXT_TESTMAP],false,false);
    ebtn->CreatePressButton(BUTTON_EDITMODEC,432,220,-1,20,lang[menu.GetLang()][TXT_CLASSIC],true,true);
    ebtn->CreatePressButton(BUTTON_EDITMODEA,432,240,-1,20,lang[menu.GetLang()][TXT_ALL],false,true);
    ebtn->CreatePressButton(BUTTON_EDITMODEP,432,260,-1,20,lang[menu.GetLang()][TXT_PLACE],false,true);
}
//-----//
/*
  EDITORINIT: Inicjalizuje edytor - planszę, bitmapy, fonty; przechodzi do pętli
*/
void CEditor::EditorInit(std::string mapname)
{
    if (mapname.empty())
        board->LoadBoard("user_maps/map0.defmap",true);
    else
    {
        std::string tmp("user_maps/");
        tmp += mapname;
        board->LoadBoard(tmp,true);
    }
    ObjBmpLvl.Load("G/block2.png");
    ObjBmp.Load("G/block2.png");
    SndSelect = FSOUND_Sample_Load(11,"Snd/select.ogg",0,0,0);
    SndPlace = FSOUND_Sample_Load(12,"Snd/place.ogg",0,0,0);
    EditFont18 = menu.GetMenuFont(true);
    InitButtons();
    m_mapname = mapname;
    m_editor_quit = false;
    EditorLoop();
    ObjBmp.Destroy();
    FSOUND_Sample_Free(SndSelect);
    FSOUND_Sample_Free(SndPlace);
}
//-----//
