#include "Game.h"
//-----//
#include <OpenLayer.hpp>
#include <FMOD/fmod.h>
#include <fstream>

#include "BlockBoard.h"
#include "Object.h"
#include "Menu.h"
#include "ConstEnums.h"
#include "Particles.h"

//-----//
CGame g;
FSOUND_SAMPLE *SndFall = NULL, *SndRotate = NULL, *SndExplo = NULL, *SndWin = NULL;
//-----//
/*
  INIT: Odpowiada za wczytanie i utworznie planszy oraz inicjalizację liczników;
        po skończeniu wywołuje pętlę główną
*/
void CGame::GameInit()
{
    cb = new CBoard();
    defpart->ParticleInit();             //inicjalizacja cząsteczek
    ObjBmp.Load("G/block2.png");
    obj->AdjustAGBlocks();
    rot_angle = 0;
    obj->DrawObjs(48);
    GameFont24.SetColor(menu.GetTextColor());
    GameFont32.SetColor(menu.GetTextColor());
    GameFont48.SetColor(menu.GetTextColor());
    if (!m_replay_mode) m_movestr = "S";
    else m_level_was_replayed = true;

    ol::FpsCounter::Start(m_game_speed*1.5);
    is_right_after_rotation = true;
    m_return_to_menu = false;
    m_level_finished = false;
    m_key_left = false;
    m_key_right = false;
    m_lock_keys = true;
    m_map_just_started = 1.0;

    m_PlayerMoves = 0;

    FSOUND_Stream_Stop(bgmusic);
    FSOUND_Stream_Close(bgmusic);
    bgmusic = FSOUND_Stream_Open("Snd/game.ogg",FSOUND_LOOP_NORMAL,0,0);
    FSOUND_Stream_Play(0,bgmusic);
    SndFall = FSOUND_Sample_Load(3,"Snd/fall.ogg",0,0,0);
    SndExplo = FSOUND_Sample_Load(4,"Snd/explo.ogg",0,0,0);
    SndWin = FSOUND_Sample_Load(5,"Snd/win.ogg",0,0,0);
    SndRotate = FSOUND_Sample_Load(6,"Snd/rot.ogg",0,0,0);
    FSOUND_SetVolume(FSOUND_ALL,menu.GetSoundVol());
    FSOUND_SetVolume(0,menu.GetMusicVol());

    GameLoop();
    //
    UnInit();
    menu.ReInit();
}
void CGame::GameInit(const int level_num, const int game_mode)
{
    m_level = level_num;
    m_game_mode = game_mode;
    m_tutorial = false;
    std::string lvl;
    switch(m_game_mode)
    {
        case MODE_CLASSIC:  lvl = "M/cmap"; break;
        case MODE_ALL:      lvl = "M/amap"; break;
        case MODE_ATPLACE:  lvl = "M/pmap"; break;
        case MODE_TUTORIAL:
            lvl = "M/tmap";
            m_tutorial = true;
            break;
        default: allegro_message("beee");
    }
    lvl += ol::ToString(level_num);
    lvl += ".defmap";

    //CMenu::EncryptFile(lvl,"p455W0RdZ");
    if (m_tutorial)
    {
            std::ifstream LOAD(lvl.c_str());
            LOAD >> m_game_mode; LOAD.close();
    }
    cb->LoadBoard(lvl,m_tutorial);           //Załadowanie obiektów z pliku
    //CMenu::EncryptFile(lvl,"p455W0RdZ");
    m_mapname = lvl;
    m_custom_map = false;
    GameInit();
}
void CGame::GameInit(const std::string txt, int game_mode/** = 0*/)
{
    m_level = 0;
    std::string tmp;
    if (!game_mode)
    {
        m_custom_map = true;
        tmp = "user_maps/";
    }
    else if (game_mode < 0)
        tmp = "rpl/";
    tmp += txt;
    std::ifstream LOAD(tmp.c_str());
    if (!game_mode)
    {
        LOAD >> m_game_mode;
        LOAD.close();
        m_mapname = tmp;
        cb->LoadBoard(tmp,true);           //Załadowanie obiektów z pliku
    }
    else if (game_mode < 0)
    {
        getline(LOAD,m_mapname);
        LOAD >> m_game_mode;
        getline(LOAD,m_movestr);
        LOAD.close();
        if (m_mapname.find("user_maps/") != std::string::npos)
            cb->LoadBoard(m_mapname,true);
        else
        {
            //CMenu::EncryptFile(m_mapname,"p455W0RdZ");
            if (m_mapname.find("M/tmap") != std::string::npos)
                cb->LoadBoard(m_mapname,true);
            else
                cb->LoadBoard(m_mapname,false);
            //CMenu::EncryptFile(m_mapname,"p455W0RdZ");
        }
    }
    GameInit();
}
//-----//
void CGame::UnInit()
{
    is_sth_falling = false;
    is_right_after_rotation = false;
    m_show_popups = true;
    m_PlayerPoints = 0;
    m_PlayerMoves = -1;
    m_level = 0;

    Destroy();
    obj->DestroyAllBlocks();
    defpart->DestroyParticles();
    defpart->Destroy();

    ol::FpsCounter::Pause();
}
void CGame::CreateBitmaps()
{
    RotationBuf = new ol::Bitmap(400,400);
}
//-----//
/*
  DESTROY: Usunięcie bitmap z klasy CGame
*/
void CGame::Destroy()
{
    delete cb; cb = NULL;
    FSOUND_Sample_Free(SndFall);
    FSOUND_Sample_Free(SndExplo);
    FSOUND_Sample_Free(SndWin);
    FSOUND_Sample_Free(SndRotate);
}
