#ifndef GAME_H_H_
#define GAME_H_H_
//-----//
#include <OpenLayer.hpp>
#include <string>
#include "Button.h"
#include "ConstEnums.h"
class CBoard;
class CGame
{
    ol::Bitmap *RotationBuf;
    ol::TextRenderer GameFont24, GameFont32, GameFont48;
    bool m_key_left, m_key_right, m_lock_keys;
    bool is_board_rotating, is_sth_falling, is_right_after_rotation, m_check_gravity;
    bool m_level_finished, m_show_popups, m_return_to_menu;
    bool m_custom_map, m_autohs;
    int rot_angle, rotate;
    int m_block_num;
    CBoard *cb;
    int m_current_colorpack, m_lang, m_game_speed;
    int m_PlayerPoints, m_PlayerMoves, m_level, m_game_mode, m_tutorial, m_replay_mode;
    bool m_level_was_replayed;
    float m_map_just_started;
    std::string m_mapname, m_movestr, m_tempstr;

    void ProcessLogic();
    void ProcessGraphic();
    void ProcessKeys();
    void ProcessReplay();
    void GameLoop();
    void Destroy();
    void KeyInput();
    void DrawUI() const;
    void MarkLevelFinished();
    void FinishLevel();
    void ShowPopups();
    void SaveReplay(const std::string&) const;
    void CheckHiScore();

    public:
        void GameInit(int,int);
        void GameInit(std::string,int=0);
        void GameInit();
        void UnInit();
        void CreateBitmaps();
        bool GetBoardRotating()         { return is_board_rotating; }
        bool GetSthFalling()            { return is_sth_falling; }
        bool GetAfterRotation()         { return is_right_after_rotation; }
        bool GetCheckGravity()          { return m_check_gravity; }
        void SetSthFalling(bool b)      { is_sth_falling = b; }
        void SetAfterRotation(bool b)   { is_right_after_rotation = b; }
        void SetBoardRotating(bool b)   { is_board_rotating = b; }
        void SetReplayMode(bool b)      { m_replay_mode = b; }
        void SetCheckGravity(bool b)    { m_check_gravity = b; }
        void IncreasePlayerScore(int i) { m_PlayerPoints += i; }
        int GetPlayerMoves()            { return m_PlayerMoves; }
        void SetLang(int i)             { m_lang = i; }
        void SetGameSpeed(int i,bool rel){ m_game_speed = (rel) ? m_game_speed + i : i; }
        int GetGameSpeed()              { return m_game_speed; }
        int GetRotAngle()               { return rot_angle; }
        void SetColorpack(int i)        { m_current_colorpack = i; }
        void SetAutoHS(bool b)          { m_autohs = b; }
        bool GetAutoHS()                { return m_autohs; }

    CGame()
        : GameFont24("G/ex.ttf",18,24),
          GameFont32("G/ex.ttf",24,32),
          GameFont48("G/ex.ttf",30,40),
          m_movestr("S")
    {
        m_key_left = false;
        m_key_right = false;
        m_lock_keys = false;
        is_board_rotating = false;
        is_sth_falling = false;
        is_right_after_rotation = true;
        m_check_gravity = true;
        m_replay_mode = false;
        m_level_was_replayed = false;
        m_show_popups = true;
        m_level_finished = false;
        m_game_mode = MODE_CLASSIC;
        m_autohs = true;
        m_block_num = 3;
        rot_angle = 3;
        m_PlayerPoints = 0;
        m_PlayerMoves = -1;
    }
    ~CGame()
    {
        delete RotationBuf;
        GameFont24.Destroy();
        GameFont32.Destroy();
        GameFont48.Destroy();
    }
};
extern CGame g;

extern FSOUND_SAMPLE *SndFall, *SndRotate, *SndExplo, *SndWin;
//-----//
#endif
