#include "Game.h"
//-----//
#include <OpenLayer.hpp>
#include <FMOD/fmod.h>

#include "BlockBoard.h"
#include "Button.h"
#include "Object.h"
#include "Particles.h"
#include "Menu.h"
#include "ConstEnums.h"
#include "DrawFuncs.h"
#include "logf.h"

float tmr;
//-----//
/*
  PROCESSKEYS: Gdy wciśnięty jest klawisz - zaczynany jest obrót planszy
*/
void CGame::ProcessKeys()
{
    if (m_key_left || m_key_right)
    {
        is_board_rotating = true;
        if (m_key_left)
        {
            rotate = LEFT;
            if (!m_replay_mode) m_movestr += "L";
        }
        else
        {
            rotate = RIGHT;
            if (!m_replay_mode) m_movestr += "R";
        }
        m_key_left = false;
        m_key_right = false;

        if (!m_level_finished) ++m_PlayerMoves; //zwiększamy licznik ruchów
        FSOUND_PlaySound(6,SndRotate);
        FSOUND_SetVolume(6,menu.GetSoundVol());
    }
}
//-----//
/*
  KEYINPUT: Sprawdzane są wciśnięte klawisze i ustawiane flagi
            //lewo i prawo naraz == nic się nie dzieje
*/
void CGame::KeyInput()
{
    if ((key[KEY_LEFT] || mouse_b == 1) && !m_lock_keys)
    {
        m_key_left = true;
        m_lock_keys = true;
    }
    else if ((key[KEY_RIGHT] || mouse_b == 2) && !m_lock_keys)
    {
        m_key_right = true;
        m_lock_keys = true;
    }
    else if (!key[KEY_LEFT] && !key[KEY_RIGHT] && !mouse_b)
        m_lock_keys = false;

    if (key[KEY_X])
    {
        m_PlayerPoints = 0;
        m_PlayerMoves = 0;
        is_sth_falling = false;
        is_right_after_rotation = true;
        m_show_popups = true;
        m_map_just_started = 1.0;
        m_level_finished = false;
        m_movestr = "S";
        if (m_custom_map)
            cb->LoadBoard(m_mapname,true);
        else
        {
            //CMenu::EncryptFile(m_mapname,"p455W0RdZ");
            if (m_tutorial) cb->LoadBoard(m_mapname,true);
            else            cb->LoadBoard(m_mapname,false);
            //CMenu::EncryptFile(m_mapname,"p455W0RdZ");
        }
    }
    if (key[KEY_S])
    {
        std::string str("last");
        ol::FpsCounter::Pause();
        InputName(str,GameFont24,462,318);
        SaveReplay(str);
        ol::FpsCounter::Resume();
    }
    if ((m_level_finished) && (key[KEY_ENTER] || key[KEY_SPACE] || mouse_b == 4))
        FinishLevel();
}
//-----//
/*
  SAVEREPLAY:
*/
void CGame::SaveReplay(const std::string &str) const
{
    std::string name("rpl/");
    name += str;
    name += ".replay";
    std::ofstream SAVE(name.c_str());
    if (SAVE.is_open())
    {
        SAVE << m_mapname << "\n";
        SAVE << m_game_mode << " ";
        SAVE << m_movestr;
        SAVE << "E";
        SAVE.close();
        logf("* Saved replay named ");logf(name);logf(".\n");
    }
    else logf("! Could not save replay\n");
}
//-----//
/*
  CHECKHISCORE:
*/
void CGame::CheckHiScore()
{
    std::string sect, name[3], tmp("");
    int pts[3] = {0};
    set_config_file("hsc.oof");
    switch(m_game_mode)
    {
        case MODE_CLASSIC: sect = "C"; break;
        case MODE_ALL: sect = "A"; break;
        case MODE_ATPLACE: sect = "P"; break;
    }
    for(int i = 1; i <= 3; ++i)
    {
        name[i-1] = get_config_string((sect+ol::ToString(m_level)).c_str(),("Name" + ol::ToString(i)).c_str(), "Nullman");
        pts[i-1] =     get_config_int((sect+ol::ToString(m_level)).c_str(),( "Pts" + ol::ToString(i)).c_str(), 10/i);
    }
    for(int i = 1; i <= 3; ++i)
    {
        if (m_PlayerPoints > pts[i-1])
        {
            int overall = 0;

            if (i < 3) { name[2] = name[1]; pts[2] = pts[1]; }
            if (i < 2) { name[1] = name[0]; pts[1] = pts[0]; }

            pts[i-1]  = m_PlayerPoints;
            name[i-1] = menu.GetPlayerName();

            if (!m_autohs)
            {
                draw_box(150,150,400,400,CURRENT_CLR,CURRENT_CLG,CURRENT_CLB);
                GameFont48.Print(lang[m_lang][TXT_HISCORES],220,200);
                if (i != 1) GameFont32.Print(name[0],160,250); GameFont32.Print(ol::ToString(pts[0]),360,250);
                if (i != 2) GameFont32.Print(name[1],160,300); GameFont32.Print(ol::ToString(pts[1]),360,300);
                if (i != 3) GameFont32.Print(name[2],160,350); GameFont32.Print(ol::ToString(pts[2]),360,350);
                ol::Canvas::Refresh();
                InputName(name[i-1],GameFont24,160,i*50+180);
            }
            for(int i = 1; i <= 3; ++i)
            {
                set_config_string((sect+ol::ToString(m_level)).c_str(),("Name" + ol::ToString(i)).c_str(), name[i-1].c_str());
                   set_config_int((sect+ol::ToString(m_level)).c_str(),( "Pts" + ol::ToString(i)).c_str(), pts[i-1]);
            }
            for(int i = 1; i < 10; ++i)
                overall += get_config_int((sect+ol::ToString(i)).c_str(),"Pts1",0);
            set_config_int((sect+sect).c_str(),"Pts",overall);
            flush_config_file();
            break;
        }
    }
}
//-----//
/*
  DRAWUI: Wyrysowuje na bitmapie wszystkie elementy UI po prawej stronie ekranu
*/
void CGame::DrawUI() const
{
    draw_box(440,20,630,460,CURRENT_CLR,CURRENT_CLG,CURRENT_CLB,10);
    if      (!m_custom_map)               GameFont32.Print(lang[m_lang][TXT_LEVEL] + ol::ToString(m_level),460,70);
    if      (m_game_mode == MODE_CLASSIC) GameFont32.Print(lang[m_lang][TXT_CLASSICMODE],460,120);
    else if (m_game_mode == MODE_ALL)     GameFont32.Print(lang[m_lang][TXT_ALLMODE],460,120);
    else if (m_game_mode == MODE_ATPLACE) GameFont32.Print(lang[m_lang][TXT_PLACEMODE],460,120);
    GameFont32.Print(lang[m_lang][TXT_POINTS] + ol::ToString(m_PlayerPoints),460,170);
    GameFont32.Print(lang[m_lang][TXT_MOVES] + ol::ToString(m_PlayerMoves),460,220);
}
//-----//
/*
  FINISHLEVEL: Przejście do następnej planszy
*/
void CGame::FinishLevel()
{
    ol::FpsCounter::Pause();
    if (!m_custom_map)
    {
        if (!m_autohs) CheckHiScore();
        m_level_finished = false;
        ++m_level;
        SaveReplay("auto-atnewlvl");
        m_movestr = "S";
        m_level_was_replayed = false;
        menu.UpdateUnlocked(m_level,m_game_mode,m_tutorial);
        defpart->DestroyParticles();

        std::string tmp;
        if (m_tutorial) tmp = "M/tmap";
        else if (m_game_mode == MODE_CLASSIC) tmp = "M/cmap";
        else if (m_game_mode == MODE_ALL) tmp = "M/amap";
        else if (m_game_mode == MODE_ATPLACE) tmp = "M/pmap";
        tmp += ol::ToString(m_level);
        tmp += ".defmap";
        m_mapname = tmp;

        //CMenu::EncryptFile(tmp,"p455W0RdZ");
        if (m_tutorial) //jeśli to tutorial to odczytujemy tryb planszy
        {
            if (m_level > MAX_TUTORIAL_LEVEL_NUMBER)
            {
                draw_popup(GameFont24,320,240,300,150,lang[m_lang][TXT_TUT_END],true);
                m_return_to_menu = true;
                return;
            }
            std::ifstream LOAD(tmp.c_str());
            if (LOAD.is_open()) { LOAD >> m_game_mode; LOAD.close(); }
            m_show_popups = true;
        }
        else
        {
            if ((m_game_mode == MODE_CLASSIC && m_level > MAX_CLASSIC_LEVEL_NUMBER) ||
                (m_game_mode == MODE_ALL     && m_level > MAX_ALL_LEVEL_NUMBER) ||
                (m_game_mode == MODE_ATPLACE && m_level > MAX_PLACE_LEVEL_NUMBER))
            {
                draw_popup(GameFont24,320,240,300,150,lang[m_lang][TXT_LVL_END],true);
                m_return_to_menu = true;
                return;
            }
        }
        cb->LoadBoard(tmp,m_tutorial);
        //CMenu::EncryptFile(tmp,"p455W0RdZ");
        m_map_just_started = 1.0;
        m_PlayerMoves = 0;
        m_PlayerPoints = 0;
        rot_angle = 3;
        is_right_after_rotation = true;
    }
    ol::FpsCounter::Resume();
}
//-----//
/*
  MARKLEVELFINISHED: Po usunięciu wszystkich klocków z planszy, gra czeka aż coś zostanie wciśnięte
*/
void CGame::MarkLevelFinished()
{
    logf("* Level ");logf(m_level);logf(" completed!\n");
    FSOUND_PlaySound(5,SndWin);
    FSOUND_SetVolume(5,menu.GetSoundVol());
    for(int i = 0; i < 15; ++i)
        defpart->CreateStars(rand()%350+24,rand()%400+24,m_current_colorpack);
    if (m_autohs && !m_tutorial && !m_level_was_replayed)
        CheckHiScore();
    m_level_finished = true;
}
//-----//
void CGame::ProcessReplay()
{
    char tmp = m_movestr.at(0);
    m_movestr.erase(0,1);
    switch (tmp)
    {
        case 'S': case ' ': break; //nvm ;]
        case 'R': m_key_right = true; break;
        case 'L': m_key_left = true;  break;
        case 'E': m_replay_mode = false; m_movestr = m_tempstr; m_movestr.erase(m_movestr.end()-1); break;
        default: logf("! Error reading replay file!\n"); m_return_to_menu = true; break;
    }
}
//-----//
void CGame::ShowPopups()
{
    ol::FpsCounter::Pause();
    switch(m_level)
    {
        case 1: draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L1A],true);
                draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L1B],true);
                draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L1C],true); break;
        case 2: draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L2A],true); break;
        case 3: draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L3A],true); break;
        case 4: draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L4A],true); break;
        case 5: draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L5A],true); break;
        case 6: draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L6A],true); break;
        case 7: draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L7A],true); break;
        case 8: draw_popup(GameFont24,320,400,400,150,lang[m_lang][TXT_TUT_L8A],true); break;
    }
    m_show_popups = false;
    ol::FpsCounter::Resume();
}
//-----//
/*
  PROCESSLOGIC:
*/
void CGame::ProcessLogic()
{
    if (!is_board_rotating)
    {
            if (!is_sth_falling && !is_right_after_rotation)
            {
                ProcessKeys(); //przetworzenie wciśniętych klawiszy
                if (m_replay_mode) ProcessReplay();
            }
    }
    else
        cb->RotateBoard(rotate); // obliczenie obrotu planszy

    if (!is_board_rotating && is_right_after_rotation && m_PlayerMoves != 0)
    {
        rot_angle += (rotate - 1) ? 1 : -1; //zmiana aktualnego położenia planszy (obrót klocków)
        rot_angle = (rot_angle < 0) ? 3 : (rot_angle > 3) ? 0 : rot_angle;
    }
    obj->Gravity();     //obliczenia grawitacji
    if (!is_sth_falling)
    {
        if (m_game_mode == MODE_CLASSIC) //znikanie klocków
            obj->CheckDestroyBlocks(m_block_num);
        else if (m_game_mode == MODE_ALL)
            obj->CheckDestroyBlocks(-1);
        else if (m_game_mode == MODE_ATPLACE)
            obj->CheckBlocksAtPlace();
    }
    defpart->ProcessParticles(); //obliczenie cząsteczkowe
    obj->AdjustAGBlocks(); //ustawienie flag dla BLOCK_AG
    if (!m_level_finished && obj->GetNumberOfBlocksLeft() == 0)
        MarkLevelFinished();
}
//-----//
/*
  PROCESSGRAPHIC:
*/
void CGame::ProcessGraphic()
{
    if (!is_board_rotating)
    {
        ol::Canvas::Fill(MAKE_CURRENT_COLOR);
        draw_box(16,16,24+8*48+8,24+8*48+8,CURRENT_CLR,CURRENT_CLG,CURRENT_CLB,8);//obramowanie mapy
        obj->DrawObjs(24);  //...i obiekty
    }
    else
    {
        ol::Canvas::SetTo(*RotationBuf);
        ol::Canvas::Fill(MAKE_CURRENT_COLOR);
        draw_box(0,0,RotationBuf->Width(),RotationBuf->Height(),CURRENT_CLR,CURRENT_CLG,CURRENT_CLB,8);//obramowanie mapy
        obj->DrawObjs(8);
        ol::Canvas::SetTo(ol::SCREEN_BACKBUF);
        ol::Canvas::Fill(MAKE_CURRENT_COLOR);
        if (cb->GetRotation())
            RotationBuf->BlitRotated(216,216,200,200,AL_PI/128*cb->GetRotation());
        else RotationBuf->Blit(16,16);
    }

    DrawUI(); //jak trzeba to odrysowujemy UI

    if (m_level_finished) //na koniec planszy napisy (w tym rekordy)
    {
        GameFont48.Print(lang[m_lang][TXT_ENDLEVEL],224 - GameFont48.Width(lang[m_lang][TXT_ENDLEVEL])/2,224);
        if (m_custom_map)   GameFont24.Print(lang[m_lang][TXT_CHELPER],5,440);
        else                GameFont24.Print(lang[m_lang][TXT_HELPER],5,440);
        if (m_autohs && !m_custom_map && !m_tutorial)
        {
            GameFont24.Print(lang[m_lang][TXT_HISCORES],480,300);
            set_config_file("hsc.oof");
            for(int i = 1; i <= 3; ++i)
            {
                std::string str;
                switch(m_game_mode)
                {
                    case MODE_ALL: str = "A"; break;
                    case MODE_CLASSIC: str = "C"; break;
                    case MODE_ATPLACE: str = "P"; break;
                }
                GameFont24.Print(get_config_string((str+ol::ToString(m_level)).c_str(),("Name"+ol::ToString(i)).c_str(),"Nullman"),460,335+(i-1)*30);
                GameFont24.Print(ol::ToString(get_config_int((str+ol::ToString(m_level)).c_str(),("Pts"+ol::ToString(i)).c_str(),10/i)),590,335+(i-1)*30);
            }
        }
    }

    if (m_show_popups && m_tutorial) ShowPopups();

    if (!m_tutorial && m_map_just_started > 0)
    {
        m_map_just_started -= 0.02;
        ol::Blenders::Set(ol::SUBTRACTIVE_BLENDER);
        ol::Rect(0,0,640,480).Draw(ol::Rgba(m_map_just_started,m_map_just_started,m_map_just_started,m_map_just_started));
        ol::Blenders::Set(ol::ALPHA_BLENDER);
    }
    defpart->DrawParticles();

    GameFont24.Print("To reset map press X, to save replay S",5,460);
    ol::Canvas::Refresh();
}
//-----//
/*
  GAMELOOP: Pętla główna gry
*/
void CGame::GameLoop()
{
    logf("* Entering game loop...\n");
    tmr = 0.0;
    float Delta = 0;
    if (m_replay_mode) m_tempstr = m_movestr;
    while((!key[KEY_ESC] || is_board_rotating) && !m_return_to_menu)
    {
        ol::FpsCounter::NewFrameStarted();
        Delta = ol::FpsCounter::GetDeltaTime();
        if (m_map_just_started <= 0 || m_tutorial) tmr += Delta;

        while((!key[KEY_ESC] || is_board_rotating) && tmr >= 1.0)
        {
            tmr -= 1.0;
            ProcessLogic();
        }
        if (!m_replay_mode)
        {
            if (!is_board_rotating && !is_sth_falling)
                KeyInput(); //Sprawdzenie wciśniętych klawiszy
        }
        ProcessGraphic();
        rest(1);
    }
    SaveReplay("auto-atexit");
    logf("* Exiting game loop.\n");
}
