#include "DrawFuncs.h"

#include <OpenLayer.hpp>
#include <string>
#include "ConstEnums.h"
#include "Menu.h"
#include "LevelEditor.h"
//-----//
std::list<ol::Vec2D> mouse_trace;
//-----//
/*
  DRAW_MOUSE: Narysowanie kursora i jego ladu
*/
void draw_mouse()
{
    static short kk;
    if (menu.GetMouseTrace())
    {
        mouse_trace.push_back( *(new ol::Vec2D(mouse_x,mouse_y)));
        if (kk < 20) ++kk;
        else
        {
            delete &(*mouse_trace.begin());
            mouse_trace.erase(mouse_trace.begin());
        }
        ol::Blenders::Set(ol::ADDITIVE_BLENDER);
        ol::LineStrip(mouse_trace,5).Draw(ol::Rgba(0.3,0.3,0.3,0.0),ol::Rgba(0.5,0.5,0.5,0.7));
        ol::Blenders::Set(ol::ALPHA_BLENDER);
    }
    else
    {
        kk = 0;
        mouse_trace.clear();
    }
    ol::Circle(ol::Vec2D(mouse_x,mouse_y),5).Draw(ol::Rgba::RED,ol::Rgba::BLUE.WithAlpha(0.3));
}

//-----//
/*
  DRAWBOX: Tworzy pole wygldajce jak 3d (wklse)
*/
void draw_box(int x, int y, int x2, int y2,
              float clr, float clg, float clb, int s/** = 4*/, bool with_bg /** = true*/)
{
    if (with_bg)
        ol::Rect(x + s, y + s, x2 - x - s*2, y2 - y - s*2).Draw(ol::Rgba(clr,clg,clb).MixWith(ol::Rgba::BLACK,0.05));
    for (int i = 0; i < s; ++i)
    {
        ol::Line(ol::Vec2D(x,y+i),ol::Vec2D(x2-i,y+i)).Draw(ol::Rgba(clr,clg,clb).MixWith(ol::Rgba::BLACK,0.25));
        ol::Line(ol::Vec2D(x+i,y),ol::Vec2D(x+i,y2-i)).Draw(ol::Rgba(clr,clg,clb).MixWith(ol::Rgba::BLACK,0.25));
        ol::Line(ol::Vec2D(x+i,y2-i),ol::Vec2D(x2,y2-i)).Draw(ol::Rgba(clr,clg,clb).MixWith(ol::Rgba::WHITE,0.2));
        ol::Line(ol::Vec2D(x2-i,y+i),ol::Vec2D(x2-i,y2)).Draw(ol::Rgba(clr,clg,clb).MixWith(ol::Rgba::WHITE,0.2));
    }
}
//-----//
/*
  DRAWPOPUP: Namazanie okienka z pojawiajcym si tekstem
*/
void draw_popup(ol::TextRenderer &tr, int cx, int cy, int w, int h, std::string txt, bool arrow)
{
    clear_keybuf();
    ol::Bitmap buf(640,480);
    int cl = menu.GetCurrentColorpack();
    ol::Rgba curr_cl(clpack[cl][0],clpack[cl][1],clpack[cl][2]);
    buf.CopyFromScreen(0,0);

    int tmpx = cx, tmpy = cy, tmpx2 = cx, tmpy2= cy, tpos = 0, line_count = 0, start_pos = 0;
    int tpospx = tr.Width(txt.substr(start_pos,tpos-start_pos));
    std::string::iterator iter = txt.begin();

    while(tmpx >= cx - w/2)
    {
        buf.Blit(0,0);
        ol::Line(ol::Vec2D(tmpx,tmpy),ol::Vec2D(tmpx2,tmpy)).Draw(ol::Rgba::BLACK.WithAlpha(0.5));
        tmpx -= 4; tmpx2 += 4;
        ol::Canvas::Refresh();
        if (key[KEY_SPACE] || key[KEY_ENTER] || mouse_b == 4)
        {
            rest(200); break;
        }
        rest(1);
    }
    tmpx = cx - w/2; tmpx2 = cx + w/2 -1;
    while(tmpy != cy - h/2)
    {
        buf.Blit(0,0);
        ol::Rect(ol::Vec2D(tmpx,  tmpy  ),ol::Vec2D(tmpx2-tmpx  ,tmpy2-tmpy  )).Draw(curr_cl.WithAlpha(0.5));
        ol::Rect(ol::Vec2D(tmpx+2,tmpy+2),ol::Vec2D(tmpx2-tmpx-4,tmpy2-tmpy-4)).Draw(ol::Rgba(0.0,0.0,0.0,0.5));
        --tmpy; ++tmpy2;
        ol::Canvas::Refresh();
        if (key[KEY_SPACE] || key[KEY_ENTER] || mouse_b == 4)
        {
            tmpy = cy - h/2; tmpy2 = cy + h/2;
            buf.Blit(0,0);
            ol::Rect(ol::Vec2D(tmpx,  tmpy  ),ol::Vec2D(tmpx2-tmpx  ,tmpy2-tmpy  )).Draw(curr_cl.WithAlpha(0.5));
            ol::Rect(ol::Vec2D(tmpx+2,tmpy+2),ol::Vec2D(tmpx2-tmpx-4,tmpy2-tmpy-4)).Draw(ol::Rgba(0.0,0.0,0.0,0.5));
            ol::Canvas::Refresh();
            rest(200); break;
        }
        rest(15);
    }
    --tmpy2;
    bool keypr = false;
    ol::Blenders::Set(ol::ADDITIVE_BLENDER);
    ol::Canvas::SetTo(ol::SCREEN_FRONTBUF);
    while(iter != txt.end())
    {
        if ((key[KEY_ENTER] || key[KEY_SPACE] || mouse_b == 4) && !keypr) keypr = true;
        if (txt.at(tpos) == '\n')
        {
            start_pos = tpos + 1;
            ++line_count;
        }
        else
        {
            tr.Print(ol::ToString(txt.at(tpos)),tmpx+20+tpospx,tmpy+30+line_count*32);
        }
        ++iter; ++tpos;
        tpospx = tr.Width(txt.substr(start_pos,tpos-start_pos));
        ol::Canvas::Refresh();
        if (!keypr) rest(70);
    }
    ol::Canvas::SetTo(ol::SCREEN_BACKBUF);
    ol::Blenders::Set(ol::ALPHA_BLENDER);
    clear_keybuf();
    while(!(key[KEY_ENTER] || key[KEY_SPACE] || mouse_b == 4)) rest(1);
    rest(200); clear_keybuf();
    while(tmpy < cy)
    {
        buf.Blit(0,0);
        ol::Rect(ol::Vec2D(tmpx,  tmpy  ),ol::Vec2D(tmpx2-tmpx  ,tmpy2-tmpy  )).Draw(curr_cl.WithAlpha(0.5));
        ol::Rect(ol::Vec2D(tmpx+2,tmpy+2),ol::Vec2D(tmpx2-tmpx-4,tmpy2-tmpy-4)).Draw(ol::Rgba(0.0,0.0,0.0,0.5));
        ++tmpy; --tmpy2;
        ol::Canvas::Refresh();
        if (key[KEY_SPACE] || key[KEY_ENTER] || mouse_b == 4)
        {
            buf.Blit(0,0);
            return;
        }
        rest(15);
    }
    while(tmpx < cx)
    {
        buf.Blit(0,0);
        ol::Line(ol::Vec2D(tmpx,tmpy),ol::Vec2D(tmpx2,tmpy)).Draw(ol::Rgba::BLACK.WithAlpha(0.5));
        tmpx += 4; tmpx2 -= 4;
        ol::Canvas::Refresh();
        if (key[KEY_SPACE] || key[KEY_ENTER] || mouse_b == 4)
        {
            buf.Blit(0,0);
            return;
        }
        rest(1);
    }
    buf.Blit(0,0);
}
//-----//
/*
  InputName: Umoliwia wprowadzenie nazwy mapy (zapisaujc j w fname)
*/
void InputName(std::string &fname, ol::TextRenderer &tr, int x, int y)
{
    int cl = menu.GetCurrentColorpack();
    unsigned int len = fname.length(), pos = len, caret = tr.Width(fname);
    bool refr = true;
    std::string::iterator iter = fname.end();
    clear_keybuf();
    ol::Canvas::SetTo(ol::SCREEN_FRONTBUF);
    do
    {
        if(keypressed())
        {
            int newkey = readkey();
            char ASCII = newkey & 0xFF;
            char scancode = newkey >> 8;
            if(ASCII >= 32 && ASCII <= 126)
            {
                if (pos < 15)
                {
                    iter = fname.insert(iter,ASCII);
                    ++len; ++pos; ++iter;
                    refr = true;
                }
            }
            else if (scancode == KEY_LEFT)
            {
                if (pos > 0) { --pos; --iter; refr = true; }
            }
            else if (scancode == KEY_RIGHT)
            {
                if (pos < fname.length()) { ++pos; ++iter; refr = true; }
            }
            else if (scancode == KEY_BACKSPACE)
            {
                if (pos > 0) { --pos; iter = fname.erase(iter-1); refr = true; }
            }
            else if (scancode == KEY_DEL)
            {
                if (pos < fname.length()) { iter = fname.erase(iter); refr = true; }
            }
            caret = tr.Width(fname.substr(0,pos));
        }
        if (refr)
        {
            refr = false;
            draw_box(x,y,x+148,y+27,clpack[cl][0],clpack[cl][1],clpack[cl][2],2);
            ol::Line(ol::Vec2D(x+caret,y+2),ol::Vec2D(x+caret,y+22)).Draw(ol::Rgba::WHITE);
            tr.Print(fname,x,y+22);
            ol::Canvas::Refresh();
        }
        rest(10);
    } while(!key[KEY_ENTER] || mouse_b == 4);
    ol::Canvas::SetTo(ol::SCREEN_BACKBUF);
}
//-----//
/*
  DRAWHISCORES: Wypisuje w menu rekordy
*/
void DrawHiScores(int scr, int bt, ol::TextRenderer &tr)
{
    std::string sect, name;
    int pts;
    int m_current_colorpack = menu.GetCurrentColorpack();
    if (scr != SCREEN_START)
    {
        if (bt < 100)
            return;

        draw_box(200,150,600,400,CURRENT_CLR,CURRENT_CLG,CURRENT_CLB);
        tr.Print(lang[menu.GetLang()][TXT_HISCORES],260,200);
        set_config_file("hsc.oof");
        switch(scr)
        {
            case SCREEN_ALLLEVEL: sect = "A"; break;
            case SCREEN_CLASSICLEVEL: sect = "C";  break;
            case SCREEN_PLACELEVEL: sect = "P"; break;
        }

        for(int i = 1; i <= 3; ++i)
        {
            name = get_config_string((sect+ol::ToString(bt-100)).c_str(),("Name"+ol::ToString(i)).c_str(),"Nullman");
            pts =     get_config_int((sect+ol::ToString(bt-100)).c_str(),( "Pts"+ol::ToString(i)).c_str(),10/i);
            tr.Print(name,210,200+i*50);
            tr.Print(ol::ToString(pts),540,200+i*50);
        }
    }
    else if (bt >= BUTTON_CLASSICLEVELS && bt <= BUTTON_PLACELEVELS)
    {
        draw_box(310,150,620,250,CURRENT_CLR,CURRENT_CLG,CURRENT_CLB);
        tr.Print(lang[menu.GetLang()][TXT_OVERALLSC],335,190);
        switch (bt)
        {
            case BUTTON_CLASSICLEVELS: sect = "CC"; break;
            case BUTTON_ALLLEVELS:     sect = "AA"; break;
            case BUTTON_PLACELEVELS:   sect = "PP"; break;
        }
        set_config_file("hsc.oof");
        pts = get_config_int(sect.c_str(),"Pts",0);
        tr.Print(ol::ToString(pts),400,230);
    }
}
