#ifndef CONST_ENUMS_H_
#define CONST_ENUMS_H_

#include <string>

#define MAKE_CURRENT_COLOR ol::Rgba(clpack[m_current_colorpack][0],\
                                    clpack[m_current_colorpack][1],\
                                    clpack[m_current_colorpack][2])
#define MAKE_CURRENT_TEXT  ol::Rgba(cltext[m_current_colorpack][0],\
                                    cltext[m_current_colorpack][1],\
                                    cltext[m_current_colorpack][2])
#define CURRENT_CLR clpack[m_current_colorpack][0]
#define CURRENT_CLG clpack[m_current_colorpack][1]
#define CURRENT_CLB clpack[m_current_colorpack][2]
const int MAX_STRING_NUMBER = 52;
const int BUTTON_SIZE_X = 100,
          BUTTON_SIZE_Y = 40;
const int tile = 48;
const int MAX_CLASSIC_LEVEL_NUMBER  = 16; //chwilowe wartości
const int MAX_CUSTOM_LEVEL_NUMBER   = 45;
const int MAX_ALL_LEVEL_NUMBER      = 16;
const int MAX_TUTORIAL_LEVEL_NUMBER = 8;
const int MAX_PLACE_LEVEL_NUMBER    = 16;

extern std::string lang[2][MAX_STRING_NUMBER]; //tekst
//
enum /*Indeksy bloków*/
{
    BLOCK_EMPTY = 0,
    BLOCK_RED,
    BLOCK_GREEN,
    BLOCK_BLUE,
    BLOCK_YELLOW,
    BLOCK_WALL,
    BLOCK_MAGIC,
    BLOCK_AG,
    BLOCK_TELE,
    BLOCK_PLACEMENT
};
//
enum /*Kierunki*/
{
    LEFT = 1,
    RIGHT,
    UP,
    DOWN
};
//
enum /*Tryby gry*/
{
    MODE_CLASSIC = 1, //określona liczba musi sąsiadować by obiekty zniknęły
    MODE_ALL, //wszystkie obiekty danego typu musza sąsiadować by zniknęły
//    MODE_SET, //określony układ znika
    MODE_TUTORIAL,
    MODE_ATPLACE, //klocki znikają w odpowiednim miejscu
    MODE_MULTI
};
//
enum /*Zestawy kolorów*/
{
    COLORPACK_GREEN = 0,
    COLORPACK_RED,
    COLORPACK_BLUE,
    COLORPACK_YELLOW,
    COLORPACK_GRAY,
    COLORPACK_DARKGREY,
    COLORPACK_MAX //ten ma być ostatni
};

const float clpack[COLORPACK_MAX][3] =
{
    {0.1,0.3,0.1},  //zielony
    {0.6,0.3,0.3},  //czerwony
    {0.2,0.2,0.6},  //niebieski
    {0.6,0.4,0.2},  //żółty
    {0.7,0.7,0.7},  //szary
    {0.3,0.3,0.3}   //ciemnoszary
};
const float cltext[COLORPACK_MAX][3] =
{
    {0.6,0.3,0.3},
    {0.1,0.3,0.1},
    {0.6,0.4,0.2},
    {0.2,0.2,0.6},
    {0.3,0.3,0.3},
    {0.7,0.7,0.7}
};
//
enum /*Języki*/
{
    LANG_PL = 0,
    LANG_EN
};
//
enum /*Indeksy przycisków*/
{
    BUTTON_START = 1,           // menu główne -> wybór trybu
    BUTTON_EXIT,                // menu_główne -> wyjście
    BUTTON_OPTIONS,             // menu główne -> opcje
    BUTTON_LEVELEDITOR,         // menu główne -> ekran wyboru mapy edytora
    BUTTON_MULTIPLAYER,         // menu główne -> multiplayer
    BUTTON_REPLAYS,             // menu główne -> powtórki
    BUTTON_OPTLANGUAGE,         // opcje -> zmiana języka
    BUTTON_OPTSPEED,            // opcje -> zmiana prędkości
    BUTTON_OPTSOUND,            // opcje -> zmiana głośności dźwięku
    BUTTON_OPTMUSIC,            // opcje -> zmiana głośności muzyki
    BUTTON_OPTCOLOR,            // opcje -> zmiana kolorów
    BUTTON_OPTTRACE,            // opcje -> ślad myszy
    BUTTON_AUTOHS,              // opcje -> automatyczne wpisywanie na listę
    BUTTON_BACKFROMOPTIONS,     // opcje -> menu główne
    BUTTON_CUSTOMLEVELS,        // wybór trybu -> plansze z edytora
    BUTTON_TUTORIALLEVELS,      // wybór trybu -> tutorial
    BUTTON_CLASSICLEVELS,       // wybór trybu -> plansze klasyczne
    BUTTON_ALLLEVELS,           // wybór trybu -> plansze MODE_ALL
    BUTTON_PLACELEVELS,         // wybór trybu -> plansze MODE_ATPLACE
    BUTTON_BACKFROMSTART,       // wybór trybu -> menu główne
    BUTTON_BACKFROMMULTI,       // wybór trybu -> multiplayer
    BUTTON_BACKFROMCLASSICLEVEL,// MODE_CLASSIC -> wybór trybu
    BUTTON_EDITORSTARTNEW,      // ekran wyboru mapy edytora -> edytor
    BUTTON_BACKFROMPREEDITOR,   // ekran wyboru mapy edytora -> menu główne
    BUTTON_EDITSAVEMAP,         // edytor -> zapis mapy
    BUTTON_TESTMAP,             // edytor -> gra próbna
    BUTTON_BACKFROMEDITOR,      // edytor -> preeditor
    BUTTON_BACKFROMCUSTOMLEVELS,// plansze z edytora -> wybór trybu
    BUTTON_BACKFROMALLLEVELS,   // MODE_ALL -> wybór trybu
    BUTTON_BACKFROMTUTORIAL,    // MODE_TUTORIAL -> wybór trybu
    BUTTON_BACKFROMPLACELEVELS, // MODE_ATPLACE -> wybór trybu
    BUTTON_EDITMODEC,           // edytor / wybór trybu (classic)
    BUTTON_EDITMODEA,           // edytor / wybór trybu (all)
    BUTTON_EDITMODEP,           // edytor / wybór trybu (place)
    BUTTON_LANGPL,              // opcje -> język polski
    BUTTON_LANGEN,              // opcje -> język angielski
    BUTTON_BACKFROMREPLAYS,     // powtórki -> menu główne
    BUTTON_NAMECHANGE           // menu główne -> zmiana imienia
};
//
enum /*Ekrany menu*/
{
    SCREEN_MAIN = 1,
    SCREEN_START,
    SCREEN_OPTIONS,
    SCREEN_CLASSICLEVEL,
    SCREEN_CUSTOMLEVEL,
    SCREEN_TUTORIALLEVEL,
    SCREEN_ALLLEVEL,
    SCREEN_PLACELEVEL,
    SCREEN_MULTIPLAYER,
    SCREEN_PREEDITOR,
    SCREEN_EDITOR,
    SCREEN_REPLAYS
};
//
enum /*Rodzaje efektów cząsteczkowych*/
{
    PARTICLETYPE_DUST = 1,
    PARTICLETYPE_EXPLO,
    PARTICLETYPE_ADDCIRCLE,
    PARTICLETYPE_STAR
};
//
enum /*Teksty*/
{
    TXT_START = 0,
    TXT_OPTIONS,
    TXT_EDITOR,
    TXT_MULTIPLAYER,
    TXT_EXIT,
    TXT_BACK,
    TXT_CLASSIC,
    TXT_ALL,
    TXT_PLACE,
    TXT_CUSTOM,
    TXT_TUTORIAL,
    TXT_REPLAY,
    TXT_NEWMAP,
    TXT_LEVEL,
    TXT_POINTS,
    TXT_MOVES,
    TXT_CLASSICMODE,
    TXT_ALLMODE,
    TXT_PLACEMODE,
    TXT_ENDLEVEL,
    TXT_HELPER,
    TXT_CHELPER,
    TXT_HISCORES,
    TXT_OVERALLSC,
    TXT_INPUTNAME,
    TXT_TUT_L1A,
    TXT_TUT_L1B,
    TXT_TUT_L1C,
    TXT_TUT_L2A,
    TXT_TUT_L3A,
    TXT_TUT_L4A,
    TXT_TUT_L5A,
    TXT_TUT_L6A,
    TXT_TUT_L7A,
    TXT_TUT_L8A,
    TXT_TUT_END,
    TXT_LVL_END,
    TXT_LANGUAGE,
    TXT_LANGPL,
    TXT_LANGEN,
    TXT_GAMESPEED,
    TXT_MUSICVOL,
    TXT_SOUNDVOL,
    TXT_COLORPACK,
    TXT_MOUSETRACE,
    TXT_AUTOHS,
    TXT_SAVEEXIT,
    TXT_MAPNAME,
    TXT_TESTMAP,
    TXT_NAMECH
};
#endif
