#ifndef BUTTON_H_H_
#define BUTTON_H_H_
//-----//
#include <iostream>
#include <string>
#include <FMOD/fmod.h>
class CButton
{
    protected:
        int index;
        int x, y, w, h;
        bool m_smallfont, m_scrollable;
        std::string txt;

        CButton(int _i, int _x, int _y, int _w, int _h, std::string _txt, bool _sel, bool _small)
            : index(_i), x(_x), y(_y), w(_w), h(_h), m_smallfont(_small), txt(_txt), selected(_sel)
        {}

    public:
        CButton() {}
        virtual ~CButton() {}
        void DrawButtons();
        virtual void DrawButton() = 0;
        //virtual void ChangeScrollPos(int) {}
        void CreatePressButton(int,int,int,int,int,std::string,bool,bool);
        void CreateScrollButton(int,int,int,int,int,std::string,bool,bool,int,int,int);
        void SelectNextButton();
        void SelectPrevButton();
        void SelectUpperButton();
        void SelectLowerButton();
        void SelectLastButton();
        void SelectButton(int);
        int GetSelectedButton();
        std::string GetPressedName(int);
        void DestroyAllButtons();
        int CheckMouseInput(int,int,int);
        bool GetSelectedScrollable();

        bool selected;
};
//-----//
class CPressButton : public CButton
{
    void DrawButton();

    public:
        virtual ~CPressButton() {}

        CPressButton(int _i, int _x, int _y, int _w, int _h, std::string _txt,bool _sel, bool _small)
            : CButton(_i,_x,_y,_w,_h,_txt,_sel,_small)
        {
            m_scrollable = false;
        }

};
//-----//
class CScrollButton : public CButton
{
    int value, min_value, max_value;

    void DrawButton();

    public:
        CScrollButton() {}
        virtual ~CScrollButton() {}
        void SetValue(int i) { value = i; }
        void LeftKeyAction();
        void RightKeyAction();
        void ChangeScrollPos(int);

        CScrollButton(int _i, int _x, int _y, int _w, int _h, std::string _txt,
                                        bool _sel, bool _small, int v, int minv, int maxv)
            : CButton(_i,_x,_y,_w,_h,_txt,_sel,_small),
              value(v),
              min_value(minv), max_value(maxv)
        {
            m_scrollable = true;
        }
};
extern CScrollButton *sbtn;

extern FSOUND_SAMPLE *SndEnter, *SndScroll;
#endif
