#include "Button.h"
//-----//
#include <OpenLayer.hpp>
#include <FMOD/fmod.h>
#include <string>
#include <vector>

#include "Menu.h"
#include "Game.h"
#include "ConstEnums.h"
//-----//
std::vector<CButton*> btnvec;
CScrollButton *sbtn = new CScrollButton();

FSOUND_SAMPLE *SndEnter = NULL, *SndScroll = NULL;
//-----//
/*
  CHECKMOUSEINPUT: Sprawdza położenie/przyciski myszy względem elementów menu
*/
int CButton::CheckMouseInput(int mx, int my, int mb)
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
        if (!(*iter)->m_scrollable)
        {
            if (mx > (*iter)->x && mx < (*iter)->x + (*iter)->w &&
                my > (*iter)->y && my < (*iter)->y + (*iter)->h)
            {
                if (mb == 1)
                {
                    FSOUND_PlaySound(1,SndEnter);
                    FSOUND_SetVolumeAbsolute(1,menu.GetSoundVol());
                    return (*iter)->index;
                }
                else
                {
                    (*iter)->SelectButton((*iter)->index);
                    return -1;
                }
            }
        }
        else if ((*iter)->m_scrollable)
        {
            if (mx > (*iter)->x + (*iter)->w + 10 && mx < (*iter)->x + (*iter)->w + 110 &&
                my > (*iter)->y && my < (*iter)->y + (*iter)->h)
            {
                if (mb == 1)
                {
                    FSOUND_PlaySound(1,SndScroll);
                    FSOUND_SetVolumeAbsolute(1,menu.GetSoundVol());
                    static_cast<CScrollButton*>((*iter))->ChangeScrollPos( mx - ((*iter)->x + (*iter)->w + 10));
                    break;
                }
                else
                {
                    (*iter)->SelectButton((*iter)->index);
                    return -1;
                }
            }
        }
    return -1;
}
//-----//
/*
  CHANGESCROLLPOS: Przesuwa scrolla na przycisku
*/
void CScrollButton::ChangeScrollPos(int input_x)
{
    float tmpval = (input_x / 100.0)*(max_value - min_value) + min_value;

    value = ( tmpval - static_cast<int>(tmpval) < 0.5 ) ? static_cast<int>(tmpval) : static_cast<int>(tmpval) + 1;
    switch (index)
    {
        case BUTTON_OPTSPEED: g.SetGameSpeed(value,false); break;
        case BUTTON_OPTSOUND: menu.SetSoundVol(value,false); FSOUND_SetVolumeAbsolute(FSOUND_ALL,menu.GetSoundVol()); FSOUND_SetVolumeAbsolute(0,menu.GetMusicVol());break;
        case BUTTON_OPTMUSIC: menu.SetMusicVol(value,false); FSOUND_SetVolumeAbsolute(0,menu.GetMusicVol()); break;
        case BUTTON_OPTCOLOR:
                menu.SetCurrentColorpack(value);
                g.SetColorpack(value);
                menu.GetMenuFont(false).SetColor(menu.GetTextColor());
                menu.GetMenuFont(true ).SetColor(menu.GetTextColor());
        case BUTTON_OPTTRACE: menu.SetMouseTrace(value); break;
        case BUTTON_AUTOHS: g.SetAutoHS(value); break;
    }
}
//-----//
/*
  GETSELECTEDNAME: Zwraca napis na przycisku o indeksie indx
*/
std::string CButton::GetPressedName(int indx)
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
        if ((*iter)->index == indx) return (*iter)->txt;
    return "";
}
/*
  GETSELECTEDBUTTON: Znajduje aktualnie zaznaczony przycisk i zwraca jego indeks
*/
int CButton::GetSelectedButton()
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
        if((*iter)->selected) return (*iter)->index;
    return -1;
}
//-----//
/*
  SELECTBUTTON: Zaznacza pzrycisk o indeksie i (i odznacza pozostałe)
*/
void CButton::SelectButton(int i)
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
    {
        if ((*iter)->index == i)
            (*iter)->selected = true;
        else if ((*iter)->selected)
            (*iter)->selected = false;
    }
}
//-----//
/*
  SELECTLASTBUTTON: Zaznacza ostatni przycisk na liście
*/
void CButton::SelectLastButton()
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
        if ((*iter)->selected) (*iter)->selected = false;
    (btnvec.back())->selected = true;
}
//-----//
/*
  SELECTNEXTBUTTON: Zaznacza kolejny przycisk na liście (o ile istnieje)
*/
void CButton::SelectNextButton()
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
    {
        if ((*iter)->selected)
        {
            if ((*iter) != btnvec.back())
            {
                (*iter)->selected = false;
                (*(++iter))->selected = true;
                FSOUND_SetVolumeAbsolute(2,menu.GetSoundVol());
                FSOUND_PlaySound(2,SndScroll);
                return;
            }
        }
    }
}
//-----//
/*
  SELECTPREVBUTTON: Zaznacza poprzedni przycisk na liście (o ile istnieje)
*/
void CButton::SelectPrevButton()
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
    {
        if ((*iter)->selected)
        {
            if ((*iter) != btnvec.front())
            {
                (*iter)->selected = false;
                (*(--iter))->selected = true;
                FSOUND_SetVolumeAbsolute(2,menu.GetSoundVol());
                FSOUND_PlaySound(2,SndScroll);
                return;
            }
        }
    }
}

//-----//
/*
  SELECTUPPERBUTTON: Zaznacza przycisk o 10 miejsc wstecz na liście (o ile istnieje)
*/
void CButton::SelectUpperButton()
{
    int flag = 0;
    std::vector<CButton*>::iterator it1;
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
    {
        if ((*iter)->selected)
        {
            (*iter)->selected = false;
            it1 = iter;
            break;
        }
    }
    while(it1 != btnvec.begin())
    {
        if (++flag == 10)
        {
            (*it1)->selected = true;
            flag = -1;
            break;
        }
        --it1;
    }
    if (flag != -1)
        (btnvec.front())->selected = true;
    FSOUND_SetVolumeAbsolute(2,menu.GetSoundVol());
    FSOUND_PlaySound(2,SndScroll);
}
//-----//
/*
  SELECTLOWERBUTTON: Zaznacza przycisk o indeksie o 10 większym na liście (o ile istnieje)
*/
void CButton::SelectLowerButton()
{
    int flag = 0;
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
    {
        if ((*iter)->selected)
        {
            (*iter)->selected = false;
            flag = 1;
        }
        if (flag)
            if (++flag == 11)
            {
                (*iter)->selected = true;
                flag = -1;
            }
    }
    if (flag != -1)
        (btnvec.back())->selected = true;
    FSOUND_SetVolumeAbsolute(2,menu.GetSoundVol());
    FSOUND_PlaySound(2,SndScroll);
}
//-----//
/*
  DESTROYALLBUTTONS: Kasuje całą listę przycisków
*/
void CButton::DestroyAllButtons()
{
    if (!btnvec.empty())
    {
        for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
            delete *iter;
        btnvec.clear();
    }
}
//-----//
/*
  GETSELECTEDSCROLLABLE: Sprawdza czy przycisk posiada scroll
*/
bool CButton::GetSelectedScrollable()
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
    {
        if ((*iter)->selected)
            return (*iter)->m_scrollable;
    }
    return false;
}
//-----//
/*
  SCROLLBUTTON~KEYACTION
*/
void CScrollButton::LeftKeyAction()
{
    CScrollButton *SBtn = NULL;
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
        if ((*iter)->selected)
        {
            SBtn = static_cast<CScrollButton*>(*iter);
            break;
        }
    switch (SBtn->index)
    {
        case BUTTON_OPTSPEED:
            if (SBtn->value > SBtn->min_value)
            {
                g.SetGameSpeed(-1,true);
                --SBtn->value;
            }
            break;
        case BUTTON_OPTSOUND:
            if (SBtn->value > SBtn->min_value + 10)
            {
                menu.SetSoundVol(-10,true);
                SBtn->value -= 10;
            }
            else
            {
                menu.SetSoundVol(0,false);
                SBtn->value = SBtn->min_value;
            }
            break;
        case BUTTON_OPTMUSIC:
            if (SBtn->value > SBtn->min_value + 10)
            {
                menu.SetMusicVol(-10,true);
                SBtn->value -= 10;
            }
            else
            {
                menu.SetMusicVol(0,false);
                SBtn->value = SBtn->min_value;
            }
            break;
        case BUTTON_OPTCOLOR:
            if (SBtn->value > SBtn->min_value)
            {
                --SBtn->value;
                menu.SetCurrentColorpack(SBtn->value);
                g.SetColorpack(SBtn->value);
                rest(200);
                menu.GetMenuFont(false).SetColor(menu.GetTextColor());
                menu.GetMenuFont(true ).SetColor(menu.GetTextColor());
            }
            break;
        case BUTTON_OPTTRACE:
            if (SBtn->value  == 1)
            {
                SBtn->value = 0;
                menu.SetMouseTrace(false);
            }
            break;
    }
}
//-----//
void CScrollButton::RightKeyAction()
{
    CScrollButton *SBtn = NULL;
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
        if ((*iter)->selected)
        {
            SBtn = static_cast<CScrollButton*>(*iter);
            break;
        }
    switch (SBtn->index)
    {
        case BUTTON_OPTSPEED:
            if (SBtn->value < SBtn->max_value)
            {
                g.SetGameSpeed(1,true);
                ++SBtn->value;
            }
            break;
        case BUTTON_OPTSOUND:
            if (SBtn->value < SBtn->max_value - 10)
            {
                menu.SetSoundVol(10,true);
                SBtn->value += 10;
            }
            else
            {
                menu.SetSoundVol(255,false);
                SBtn->value = SBtn->max_value;
            }
            break;
        case BUTTON_OPTMUSIC:
            if (SBtn->value < SBtn->max_value - 10)
            {
                menu.SetMusicVol(10,true);
                SBtn->value += 10;
            }
            else
            {
                menu.SetMusicVol(255,false);
                SBtn->value = SBtn->max_value;
            }
            break;
        case BUTTON_OPTCOLOR:
            if (SBtn->value < SBtn->max_value)
            {
                ++SBtn->value;
                menu.SetCurrentColorpack(SBtn->value);
                g.SetColorpack(SBtn->value);
                rest(200);
                menu.GetMenuFont(false).SetColor(menu.GetTextColor());
                menu.GetMenuFont(true ).SetColor(menu.GetTextColor());
            }
            break;
        case BUTTON_OPTTRACE:
            if (SBtn->value  == 0)
            {
                SBtn->value = 1;
                menu.SetMouseTrace(true);
            }
            break;
    }
}
//-----//
/*
  PRESSBUTTON~DRAW:
*/
void CPressButton::DrawButton()
{
    int cl = menu.GetCurrentColorpack();
    ol::Rgba bgcl(clpack[cl][0],clpack[cl][1],clpack[cl][2]);
    ol::Rgba txcl(cltext[cl][0],cltext[cl][1],cltext[cl][2]);
    if (selected)
    {
        ol::Rect(x, y+4, w, h).Draw(txcl);
        ol::Rect(x+2, y+2+4, w-4, h-4).Draw(bgcl.MixWith(ol::Rgba::BLACK,0.1));
        menu.GetMenuFont(m_smallfont).Print(txt, x + 5, y + h/2 + 18 - m_smallfont*9);
    }
    else
    {
        menu.GetMenuFont(m_smallfont).SetColor(menu.GetTextColor().WithAlpha(0.5));
        menu.GetMenuFont(m_smallfont).Print(txt, x + 5, y + h/2 + 18 - m_smallfont*9);
        menu.GetMenuFont(m_smallfont).SetColor(menu.GetTextColor().WithAlpha(1.0));
    }
}
//-----//
/*
  SCROLLBUTTON~DRAW:
*/
void CScrollButton::DrawButton()
{
    int cl = menu.GetCurrentColorpack();
    ol::Rgba bgcl(clpack[cl][0],clpack[cl][1],clpack[cl][2]);
    ol::Rgba txcl(cltext[cl][0],cltext[cl][1],cltext[cl][2]);
    if (selected)
    {
        ol::Rect(x, y+4, w, h).Draw(txcl);
        ol::Rect(x+2, y+2+4, w-4, h-4).Draw(bgcl.MixWith(ol::Rgba::BLACK,0.1));
        menu.GetMenuFont(m_smallfont).Print(txt, x + 5, y + h/2 + 18 + m_smallfont*9);
    }
    else
    {
        menu.GetMenuFont(m_smallfont).SetColor(menu.GetTextColor().WithAlpha(0.5));
        menu.GetMenuFont(m_smallfont).Print(txt, x + 5, y + h/2 + 18 + m_smallfont*9);
        menu.GetMenuFont(m_smallfont).SetColor(menu.GetTextColor().WithAlpha(1.0));
    }
    //część scrollowa
    int percent_value = value*100/max_value - min_value;
    ol::Rect(x + w + 10, y + 15, 100, 10).Draw(txcl);
    ol::Rect(x + w + 10 + percent_value, y + 5, 12, 30).Draw(txcl);
    ol::Rect(x + w + 10 + percent_value + 2, y + 7, 8, 26).Draw(ol::Rgba::BLACK);
}
//-----//
/*
  DRAWBUTTONS: Wyrysowuje wszystkie przyciski z listy na bufor
*/
void CButton::DrawButtons()
{
    for (std::vector<CButton*>::iterator iter = btnvec.begin(); iter != btnvec.end(); ++iter)
        (*iter)->DrawButton();
}
//-----//
/*
  CREATEBUTTON: Tworzy nowy przycisk i dodaje go do listy
*/
void CButton::CreatePressButton(int _i, int _x, int _y, int _w, int _h,
                            std::string _txt, bool sel, bool _smallfont)
{
    CButton *btn = new CPressButton(_i,_x,_y,menu.GetMenuFont(_smallfont).Width(_txt)+10,
                               _h,_txt,sel,_smallfont);
    btnvec.push_back(btn);
}
//
void CButton::CreateScrollButton(int _i, int _x, int _y, int _w, int _h,
                            std::string _txt, bool sel, bool _smallfont, int val, int minval, int maxval)
{
    CButton *btn = new CScrollButton(_i,_x,_y,menu.GetMenuFont(_smallfont).Width(_txt)+10,
                               _h,_txt,sel,_smallfont,val,minval,maxval);
    btnvec.push_back(btn);
}
//-----//
