#include "BlockBoard.h"
//-----//
#include <OpenLayer.hpp>
#include <fstream>
#include <string>
#include <list>

#include "Game.h"
#include "DrawFuncs.h"
#include "Object.h"
#include "ConstEnums.h"
#include "logf.h"
//-----//
/*
  LOADBOARD: Ładowanie z pliku mapy o nazwie z parametru, przypisanie obiektów do listy
            plansze zrobione w edytorze mają (chwilowo?) dodatkową zmienną którą trzeba
            usunąć w zwykłych planszach
            Funkcja wywoływana przy inicjowaniu gry oraz po przejściu planszy
*/
void CBoard::LoadBoard(const std::string mapname, const bool throw_away_first_var)
{
    obj->DestroyAllBlocks();
    std::ifstream LOAD(mapname.c_str());
    if (LOAD.is_open())
    {
        int tmpval;
        if (throw_away_first_var) LOAD >> tmpval;
        for (int i = 0; i < BOARD_SIZE; ++i)
        for (int j = 0; j < BOARD_SIZE; ++j)
        {
            LOAD >> tmpval;
            if (tmpval > 0) //gdy na danym polu mapy ma być obiekt
            {
                if (tmpval == BLOCK_WALL)
                    obj->CreateBlock(j*tile,i*tile,tmpval,false,true); //tworzy obiekt w kontenerze
                else obj->CreateBlock(j*tile,i*tile,tmpval,true,true); //
            }
        }
        logf("* Successfully loaded map: "); logf(mapname); logf("\n");
    }
    else
    {
        allegro_message("No more maps? (unexpected)");
        logf("! Cannot load map: ");
        logf(mapname);
        rest(500);
        exit(0);
    }
}
//-----//
/*
  ROTATEBOARD: Oblicza obrót planszy
*/
void CBoard::RotateBoard(const int dir)
{
    static int cnt;
    if (dir == RIGHT)
    {
        if (set_rot)
        {
            rot0 = (rot + 64)%255;
            set_rot = false;
        }
        rot += 2;
        ++cnt;
    }
    else if (dir == LEFT)
    {
        if (set_rot)
        {
            rot0 = (rot - 64)%255;
            set_rot = false;
        }
        rot -= 2;
        ++cnt;
    }
    rot %= 255;
    if (rot == rot0)
    {
        cnt = 0;
        g.SetBoardRotating(false);
        g.SetAfterRotation(true);
        set_rot = true; //to musi być prawdą przy pierwszym wejściu w każdym obrocie (ustala obrót docelowy)
        rot = 0;
        obj->SwapCoords(dir); //'obrócenie' koordynatów obiektów zgodnie z nowym układem planszy
        clear_keybuf();
    }
}
