#include "config.h"

#include "allegro.h"

#include <string.h>

#define FROM_SOUND_C
#include "sound.h"
#undef FROM_SOUND_C

#include "globvars.h"

#include "math.h"
#include "stuff.h"

enum
{
DIRECT_WAV,
DIRECT_BEAT
};

// # is octave


#define L_0 128
#define L_1 64
#define L_2 32
#define L_3 21
#define L_4 16
#define L_6 11
#define L_8 8
#define L_12 6
#define L_16 4
#define L_32 2

/*
#define L_0 64
#define L_1 32
#define L_2 16
#define L_3 11
#define L_4 8
#define L_6 6
#define L_8 4
#define L_16 2
*/
/*
#define L_0 48
#define L_1 24
#define L_2 12
#define L_3 8
#define L_4 6
#define L_6 4
#define L_8 3
#define L_16 2*/

#define PAN_L 64
#define PAN_C 127
#define PAN_R 192



#define BASE_TONE 200
int tone [NO_TONES];


enum
{
    SOUNDMODE_STEREO,
    SOUNDMODE_MONO,
    SOUNDMODE_REVERSED
};

enum
{
BEAT_NONE,
BEAT_SILENT,
BEAT_DRUM1,
BEAT_DRUM2,
BEAT_DRUM3,
BEAT_DRUM4,
BEAT_CYMBAL1,
BEAT_HAT1,
BEAT_HAT2,
BEAT_BLER,
BEAT_DEEPDRUM,
BEAT_SNARE,
BEAT_SNARE2,
BEAT_STONK,
BEAT_THUMP,
BEAT_WARM,
BEAT_WARM2,
BEAT_WARM3,
BEAT_WARM4,
BEAT_DOUBLEW,
BEAT_WARMUP,
BEAT_WARMUP2,
BEAT_WARMUP3,
BEAT_WARMUP4,
BEAT_CLAR,
BEAT_CLAR2,
BEAT_ACC,

BEAT_ARP,
BEAT_ARP2,
BEAT_ARP3,
BEAT_ARP_LONG,
BEAT_FLUTE,
BEAT_FLUTE2,
BEAT_FLUTE3,
BEAT_MELO,
BEAT_MELO2,
BEAT_MELO3,

BEAT_ZONE1,
BEAT_ZONE2,
BEAT_ZONE3,
BEAT_HIGH,
BEAT_LOW1,
BEAT_LOW2,

BEAT_BEEP,
BEAT_BEEP2,
BEAT_FUN0,
BEAT_FUN,
BEAT_FUN2,
BEAT_FUN3,
BEAT_ORGAN,

NO_BEATS,
BEAT_END

};

// when on the next tick we're going to play a note with an attached event, set this to something
//  for the relevant event so that if the event is ready it can be done
//int synch_ready [NO_EVENTS];
// when we've done something, set this to the note that we want to play.
//int synch_done [NO_DONE];
// both externed in sound.h

enum // keep these in proper order!
{
 SUBMUSIC_EMPTY,
 SUBMUSIC_L1_BASIC,
 SUBMUSIC_L1_BASIC2,
 SUBMUSIC_L1_BASIC3,
 SUBMUSIC_L1_BASIC4,
 SUBMUSIC_L1_BASIC5,
 SUBMUSIC_L1_BASIC6,
 SUBMUSIC_L1_BASIC7,
 SUBMUSIC_L1_BASIC8,

 SUBMUSIC_L1_UP,
 SUBMUSIC_L1_UP2,
 SUBMUSIC_L1_UP3,
 SUBMUSIC_L1_UP4,
 SUBMUSIC_L1_UP5,
 SUBMUSIC_L1_UP6,
 SUBMUSIC_L1_UP7,
 SUBMUSIC_L1_UP8,

 SUBMUSIC_L1_SONG,
 SUBMUSIC_L1_SONG2,
 SUBMUSIC_L1_SONG3,
 SUBMUSIC_L1_SONG4,
 SUBMUSIC_L1_SONG5,
 SUBMUSIC_L1_SONG6,
 SUBMUSIC_L1_SONG7,
 SUBMUSIC_L1_SONG8,

 SUBMUSIC_L1_ACC,
 SUBMUSIC_L1_ACC2,

// STAGE 2

 SUBMUSIC_L2_BASIC,
 SUBMUSIC_L2_BASIC2,
 SUBMUSIC_L2_BASIC3,

 SUBMUSIC_L2_MBASIC,
 SUBMUSIC_L2_MBASIC2,
 SUBMUSIC_L2_MBASIC3,

 SUBMUSIC_L2_MELODY,
 SUBMUSIC_L2_MELODY2,
 SUBMUSIC_L2_MELODY3,
 SUBMUSIC_L2_MELODY4,

//  STAGE 3

 SUBMUSIC_L3_BASE1,
 SUBMUSIC_L3_BASE2,
 SUBMUSIC_L3_BASE3,
 SUBMUSIC_L3_HIGH1,
 SUBMUSIC_L3_HIGH2,
 SUBMUSIC_L3_HIGH3,
 SUBMUSIC_L3_HIGH4,
 SUBMUSIC_L3_HIGH5,
 SUBMUSIC_L3_LOW1,

// try STAGE 3 again!

 SUBMUSIC_L3_BEEP1,
 SUBMUSIC_L3_BEEP2,
 SUBMUSIC_L3_BEEP3,
 SUBMUSIC_L3_BEEP4,
 SUBMUSIC_L3_FUN1,
 SUBMUSIC_L3_FUN2,
 SUBMUSIC_L3_FUN3,
 SUBMUSIC_L3_FUN4,
 SUBMUSIC_L3_FUN5,
 SUBMUSIC_L3_FUN6,
 SUBMUSIC_L3_FUN7, // partial - more complete
 SUBMUSIC_L3_FUN8, // partial - less
 SUBMUSIC_L3_ORGAN,
 SUBMUSIC_L3_ORGAN2,
 SUBMUSIC_L3_ORGAN3,

 SUBMUSIC_END,

 SUBMUSIC_L1_BASIC_RAND,
 SUBMUSIC_L1_UP_RAND,
 SUBMUSIC_L1_SONG_RAND,

 SUBMUSIC_L3_KEYCHANGE,

 NO_SUBMUSICS
};

#define NO_MUSICS 256
#define SUBMUSICS 3


int music [NO_OVERMUSICS] [NO_MUSICS] [SUBMUSICS] =
{
 {

  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP3, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP4, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP5, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP6, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP7, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP8, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC3, SUBMUSIC_L1_SONG3, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG4, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP4, SUBMUSIC_L1_SONG2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG3, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC5, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG4, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP6, SUBMUSIC_L1_SONG2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG3, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC7, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG4, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC8, SUBMUSIC_L1_SONG2, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC8, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC7, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC6, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC5, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC4, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC3, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP3, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_ACC, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP4, SUBMUSIC_L1_ACC2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_ACC, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP5, SUBMUSIC_L1_ACC2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_ACC, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP6, SUBMUSIC_L1_ACC2, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP2, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC3, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP4, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC5, SUBMUSIC_L1_SONG2, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC2, SUBMUSIC_L1_SONG2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC3, SUBMUSIC_L1_SONG3, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC4, SUBMUSIC_L1_SONG4, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC5, SUBMUSIC_L1_SONG5, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC6, SUBMUSIC_L1_SONG6, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC7, SUBMUSIC_L1_SONG7, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC8, SUBMUSIC_L1_SONG8, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_ACC, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP3, SUBMUSIC_L1_ACC2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_ACC, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP4, SUBMUSIC_L1_ACC2, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_ACC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_ACC2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_ACC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_ACC2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_BASIC2, SUBMUSIC_L1_SONG2, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_BASIC3, SUBMUSIC_L1_SONG3, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_BASIC4, SUBMUSIC_L1_SONG4, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_BASIC5, SUBMUSIC_L1_SONG5, SUBMUSIC_L1_ACC2},

  {SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_SONG, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_SONG_RAND, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_UP, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L1_UP2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_UP_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_UP_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_UP_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_L1_SONG, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_UP, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_UP_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC2},
  {SUBMUSIC_L1_BASIC, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC},
  {SUBMUSIC_L1_BASIC_RAND, SUBMUSIC_L1_SONG_RAND, SUBMUSIC_L1_ACC2},


  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },

 {


  {SUBMUSIC_L2_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC3, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC2, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC3, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC2, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC3, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},

  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC3, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC2, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},

  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC2, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC3, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC2, SUBMUSIC_L2_MELODY3, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY2, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC3, SUBMUSIC_L2_MELODY3, SUBMUSIC_EMPTY},

  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY3, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC3, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC, SUBMUSIC_L2_MELODY3, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_BASIC2, SUBMUSIC_L2_MELODY, SUBMUSIC_EMPTY},

  {SUBMUSIC_L2_MBASIC, SUBMUSIC_L2_MELODY4, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_MBASIC2, SUBMUSIC_L2_MELODY4, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_MBASIC, SUBMUSIC_L2_MELODY4, SUBMUSIC_EMPTY},
  {SUBMUSIC_L2_MBASIC3, SUBMUSIC_L2_MELODY4, SUBMUSIC_EMPTY},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },

 {
/*
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN},
*/

 {SUBMUSIC_L3_BEEP1, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP4, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN8, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN7, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN3, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN2, SUBMUSIC_L3_BEEP1, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN3, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_FUN2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN3, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_FUN2, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_FUN4, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_KEYCHANGE, 4, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN3, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN3, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_FUN3, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP2, SUBMUSIC_L3_FUN4, SUBMUSIC_L3_ORGAN},
// {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN3, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP2, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN},
// {SUBMUSIC_L3_BEEP4, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_KEYCHANGE, -3, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN8, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_FUN7, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_FUN4, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_KEYCHANGE, 0, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN4, SUBMUSIC_L3_ORGAN3},
 {SUBMUSIC_L3_BEEP4, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN3, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_FUN4, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN3},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN3, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_BEEP3, SUBMUSIC_L3_FUN4, SUBMUSIC_L3_ORGAN3},
 {SUBMUSIC_L3_FUN3, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_KEYCHANGE, 4, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN3, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP3, SUBMUSIC_L3_FUN4, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_KEYCHANGE, 7, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN2, SUBMUSIC_L3_BEEP1, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN5, SUBMUSIC_L3_ORGAN2, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_FUN2, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN3},
 {SUBMUSIC_L3_FUN6, SUBMUSIC_EMPTY, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_KEYCHANGE, 0, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN2, SUBMUSIC_L3_ORGAN},
 {SUBMUSIC_L3_BEEP1, SUBMUSIC_L3_FUN4, SUBMUSIC_L3_ORGAN2},
 {SUBMUSIC_L3_BEEP3, SUBMUSIC_L3_FUN3, SUBMUSIC_L3_ORGAN3},
 {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},

/*
 {SUBMUSIC_L3_BASE1, SUBMUSIC_L3_HIGH1, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BASE2, SUBMUSIC_L3_HIGH2, SUBMUSIC_L3_LOW1},
 {SUBMUSIC_L3_BASE3, SUBMUSIC_L3_HIGH3, SUBMUSIC_L3_LOW1},

 {SUBMUSIC_L3_BASE1, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BASE2, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BASE3, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BASE1, SUBMUSIC_L3_HIGH1, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BASE2, SUBMUSIC_L3_HIGH2, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BASE3, SUBMUSIC_L3_HIGH3, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BASE1, SUBMUSIC_L3_HIGH4, SUBMUSIC_EMPTY},
 {SUBMUSIC_L3_BASE2, SUBMUSIC_L3_HIGH5, SUBMUSIC_EMPTY},
 {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY}
*/
 }


};



#define VOL_L 100
#define VOL_M 170
#define VOL_H 255

SAMPLE *sounds [NO_WAVS];

SAMPLE *beat [NO_BEATS];

enum
{
SM_BEAT,
SM_TONE,
SM_LENGTH,
SM_VOL,
SM_PAN,
SM_ALT_TONE,
SM_SIZE
};

int submusic [NO_SUBMUSICS] [51] [SM_SIZE] =
{
 {
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARM3, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM4, NOTE_4C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3A, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARM2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_4DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_4G, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARM2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARM4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },


 {
  {BEAT_WARM2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARM4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM3, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM3, NOTE_3A, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARM3, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM2, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_2AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM3, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARM3, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM4, NOTE_4C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM4, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARM4, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARM2, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },




 {
  {BEAT_WARMUP3, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3A, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARMUP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_4DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_4G, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARMUP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARMUP4, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },


 {
  {BEAT_WARMUP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },


 {
  {BEAT_WARMUP4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3A, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARMUP3, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_2AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_WARMUP3, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_4C, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP3, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_WARMUP4, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_WARMUP2, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_4C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3A, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },


 {
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_2C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_2AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_CLAR, NOTE_2DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_2AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_2AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_4C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },


 {
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_CLAR2, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3A, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_CLAR2, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_2AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_CLAR2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_4C, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR2, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_CLAR, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CLAR, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },



 {
  {BEAT_ACC, NOTE_3C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ACC, NOTE_3C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ACC, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ACC, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ACC, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ACC, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ACC, NOTE_3G, L_2, VOL_L, PAN_C, 0},
  {BEAT_ACC, NOTE_3C, L_2, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

// Stage 2

// Minor

 {
  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_1A, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2D, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_1F, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_2A, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3A, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_2A, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2E, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_1G, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_2G, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3G, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3G, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_2G, L_4, VOL_L, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

// Major

 {
  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_1G, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_2G, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3G, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_2G, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_1G, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_2E, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3E, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_2E, L_4, VOL_L, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_1F, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_2F, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3F, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_2F, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_1G, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_2G, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3G, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_4C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3C, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_1G, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_2G, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_3G, L_4, VOL_L, PAN_C, 0},

  {BEAT_ARP_LONG, NOTE_2C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3G, L_3, VOL_L, PAN_C, 0},
  {BEAT_ARP3, NOTE_3C, L_2, VOL_L, PAN_C, 0},
  {BEAT_ARP2, NOTE_2G, L_4, VOL_L, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },


 {
  {BEAT_MELO3, NOTE_3C, L_2, VOL_L, PAN_C, NOTE_4C},
  {BEAT_MELO2, NOTE_4C, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO2, NOTE_3AS, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_MELO, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO, NOTE_3E, L_4, VOL_L, PAN_C, NOTE_3A},
  {BEAT_MELO2, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO, NOTE_3E, L_4, VOL_L, PAN_C, NOTE_3A},
  {BEAT_MELO, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_4C},
  {BEAT_MELO2, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_3C},
  {BEAT_MELO, NOTE_3F, L_4, VOL_L, PAN_C, NOTE_3D},
  {BEAT_MELO2, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO2, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_4C},
  {BEAT_MELO3, NOTE_2AS, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_MELO3, NOTE_3C, L_2, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_2AS},
  {BEAT_MELO2, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO, NOTE_3AS, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_MELO2, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_3C},
  {BEAT_MELO, NOTE_4C, L_4, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3AS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO2, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO2, NOTE_3D, L_4, VOL_L, PAN_C, NOTE_4C},
  {BEAT_MELO, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_3F},
  {BEAT_MELO, NOTE_2AS, L_4, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_MELO, NOTE_2AS, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO3, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_MELO3, NOTE_3G, L_2, VOL_L, PAN_C, NOTE_4C},
  {BEAT_MELO2, NOTE_2AS, L_4, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_MELO, NOTE_2G, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO2, NOTE_2AS, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_3C},
  {BEAT_MELO2, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_MELO, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO2, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO2, NOTE_3D, L_4, VOL_L, PAN_C, NOTE_4C},
  {BEAT_MELO, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_3F},
  {BEAT_MELO, NOTE_2AS, L_4, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO, NOTE_3AS, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_MELO, NOTE_2G, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO3, NOTE_3DS, L_4, VOL_L, PAN_C, NOTE_3DS},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_MELO3, NOTE_3C, L_2, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3E, L_4, VOL_L, PAN_C, NOTE_2AS},
  {BEAT_MELO2, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO, NOTE_3AS, L_4, VOL_L, PAN_C, NOTE_3E},
  {BEAT_MELO2, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_3C},
  {BEAT_MELO, NOTE_4C, L_4, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3AS, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO, NOTE_3G, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO2, NOTE_3E, L_4, VOL_L, PAN_C, NOTE_3AS},
  {BEAT_MELO2, NOTE_3D, L_4, VOL_L, PAN_C, NOTE_4C},
  {BEAT_MELO, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_3F},
  {BEAT_MELO, NOTE_2AS, L_4, VOL_L, PAN_C, NOTE_2G},
  {BEAT_MELO2, NOTE_3C, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO, NOTE_3E, L_4, VOL_L, PAN_C, NOTE_3E},
  {BEAT_MELO, NOTE_2AS, L_4, VOL_L, PAN_C, NOTE_3G},
  {BEAT_MELO3, NOTE_3E, L_4, VOL_L, PAN_C, NOTE_3E},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ZONE3, NOTE_2C, L_4, 30, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 110, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2C, L_4, 130, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2C, L_4, 150, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2C, L_4, 150, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 130, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 110, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2C, L_1, 30, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ZONE3, NOTE_2E, L_4, 30, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 110, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2E, L_4, 130, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2E, L_4, 150, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2E, L_4, 150, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 130, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 110, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2E, L_1, 30, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ZONE3, NOTE_2G, L_4, 30, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 110, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2G, L_4, 130, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2G, L_4, 150, PAN_C, 0},
  {BEAT_ZONE2, NOTE_2G, L_4, 150, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 130, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 110, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_2G, L_1, 30, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

/*
 {
  {BEAT_ZONE3, NOTE_1G, L_4, 30, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 110, PAN_C, 0},
  {BEAT_ZONE2, NOTE_1G, L_4, 130, PAN_C, 0},
  {BEAT_ZONE2, NOTE_1G, L_4, 150, PAN_C, 0},
  {BEAT_ZONE2, NOTE_1G, L_4, 150, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 130, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 110, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1G, L_1, 30, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ZONE3, NOTE_1A, L_4, 30, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 110, PAN_C, 0},
  {BEAT_ZONE2, NOTE_1A, L_4, 130, PAN_C, 0},
  {BEAT_ZONE2, NOTE_1A, L_4, 150, PAN_C, 0},
  {BEAT_ZONE2, NOTE_1A, L_4, 150, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 130, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 110, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 90, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 70, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_4, 50, PAN_C, 0},
  {BEAT_ZONE3, NOTE_1A, L_1, 30, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },
*/
 {
  {BEAT_SILENT, NOTE_1C, L_1 + L_2, 0, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 240, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 230, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 220, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 210, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 200, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 190, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 180, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 170, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 160, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 150, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 140, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 130, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 120, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 110, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 100, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 90, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 80, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 70, PAN_C, 0},
  {BEAT_HIGH, NOTE_3C, L_8, 60, PAN_C, 0},
  {BEAT_END, L_1,0,0}
 },

 {
  {BEAT_SILENT, NOTE_1C, L_1 + L_2, 0, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 240, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 230, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 220, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 210, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 200, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 190, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 180, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 170, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 160, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 150, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 140, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 130, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 120, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 110, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 100, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 90, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 80, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 70, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 60, PAN_C, 0},
  {BEAT_END, L_1,0,0}
 },

 {
  {BEAT_SILENT, NOTE_1C, L_1 + L_2, 0, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 240, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 230, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 220, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 210, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 200, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 190, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 180, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 170, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 160, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 150, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 140, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 130, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 120, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 110, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 100, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 90, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 80, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 70, PAN_C, 0},
  {BEAT_HIGH, NOTE_3AS, L_8, 60, PAN_C, 0},
  {BEAT_END, L_1,0,0}
 },

 {
  {BEAT_SILENT, NOTE_1C, L_1 + L_2, 0, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 240, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 230, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 220, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 210, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 200, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 190, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 180, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 170, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 160, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 150, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 140, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 130, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 120, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 110, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 100, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 90, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 80, PAN_C, 0},
  {BEAT_HIGH, NOTE_2G, L_8, 70, PAN_C, 0},
  {BEAT_HIGH, NOTE_3G, L_8, 60, PAN_C, 0},
  {BEAT_END, L_1,0,0}
 },

 {
  {BEAT_SILENT, NOTE_1C, L_1 + L_2, 0, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 250, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 240, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 230, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 220, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 210, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 200, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 190, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 180, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 170, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 160, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 150, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 140, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 130, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 120, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 110, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 100, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 90, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 80, PAN_C, 0},
  {BEAT_HIGH, NOTE_2E, L_8, 70, PAN_C, 0},
  {BEAT_HIGH, NOTE_3E, L_8, 60, PAN_C, 0},
  {BEAT_END, L_1,0,0}
 },

 {
  {BEAT_LOW2, NOTE_4C, L_2, VOL_H, PAN_C, 0},
  {BEAT_LOW1, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_LOW2, NOTE_3G, L_4, VOL_H, PAN_C, 0},
  {BEAT_LOW2, NOTE_4C, L_2, VOL_M, PAN_C, 0},
  {BEAT_LOW1, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_LOW1, NOTE_2C, L_4, VOL_H, PAN_C, 0},
  {BEAT_LOW2, NOTE_3G, L_2, VOL_M, PAN_C, 0},
  {BEAT_LOW1, NOTE_3C, L_2, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },
/*
 {
  {BEAT_BEEP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3C, L_2, VOL_M, PAN_C, 0},
  {BEAT_BEEP, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3D, L_2, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3C, L_2, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_4C, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_BEEP, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },
*/
 {
  {BEAT_BEEP2, NOTE_2C, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3G, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3E, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2A, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3C, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3D, L_2, VOL_M, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_BEEP2, NOTE_3C, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2G, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_3E, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_3C, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2A, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_3DS, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2A, L_2, VOL_M, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_BEEP2, NOTE_2G, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2G, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2G, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2G, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2A, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2A, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_M, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_BEEP2, NOTE_2C, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2DS, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2G, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_3C, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2G, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_1AS, L_2, VOL_M, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN, NOTE_2C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN0, NOTE_1C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN0, NOTE_1E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1G, L_4, VOL_L, PAN_C, 0},

  {BEAT_FUN, NOTE_1AS, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN0, NOTE_1C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN0, NOTE_1E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1G, L_4, VOL_L, PAN_C, 0},

  {BEAT_FUN, NOTE_1A, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN0, NOTE_0A, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN0, NOTE_1C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1G, L_4, VOL_L, PAN_C, 0},

  {BEAT_FUN, NOTE_1AS, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN0, NOTE_0AS, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN0, NOTE_1D, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1G, L_4, VOL_L, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },
/*
 {
  {BEAT_FUN2, NOTE_3C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN2, NOTE_2E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_L, PAN_C, 0},

  {BEAT_FUN2, NOTE_2AS, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN2, NOTE_2E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_L, PAN_C, 0},

  {BEAT_FUN2, NOTE_2A, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN2, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_L, PAN_C, 0},

  {BEAT_FUN2, NOTE_2AS, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1AS, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN2, NOTE_2D, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_L, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },
*/
 {
  {BEAT_FUN2, NOTE_3C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},

  {BEAT_FUN2, NOTE_2A, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_1E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2DS, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2AS, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2DS, L_4, VOL_H, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN2, NOTE_2C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2E, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2AS, L_4, VOL_M, PAN_C, 0},

  {BEAT_FUN2, NOTE_1A, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_3G, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1G, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1AS, L_4, VOL_H, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN2, NOTE_2C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1AS, L_4, VOL_M, PAN_C, 0},

  {BEAT_FUN2, NOTE_2E, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3E, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3G, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_3A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_4C, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN3, NOTE_3A, L_4, VOL_M, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN2, NOTE_3C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3DS, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},

  {BEAT_FUN2, NOTE_2A, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2E, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_1E, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN3, NOTE_2A, L_4, VOL_H, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN2, NOTE_2C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},

  {BEAT_FUN2, NOTE_1A, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2A, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_1E, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1DS, L_4, VOL_H, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN2, NOTE_3C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2A, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3C, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3D, L_2, VOL_M, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN2, NOTE_3C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_2, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_2, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2A, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3C, L_2, VOL_M, PAN_C, 0},

  {BEAT_BEEP2, NOTE_2AS, L_2, VOL_H, PAN_C, 0},
  {BEAT_BEEP2, NOTE_3D, L_2, VOL_M, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3E, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3E, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3E, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2AS, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ORGAN, NOTE_2C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3E, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3A, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3E, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3A, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3E, L_4, VOL_L, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },
/*
 {
  {BEAT_ORGAN, NOTE_3C, L_2, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_2, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_2, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_2, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2A, L_2, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3E, L_2, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2AS, L_2, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_2, VOL_H, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ORGAN, NOTE_3C, L_1, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3G, L_1, VOL_M, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2G, L_1, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_1, VOL_H, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_ORGAN, NOTE_3C, L_1, VOL_H, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3C, L_1, VOL_M, PAN_C, 0},
  {BEAT_ORGAN, NOTE_2A, L_1, VOL_M, PAN_C, 0},
  {BEAT_ORGAN, NOTE_3E, L_1, VOL_H, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },
*/
/*
 {
  {BEAT_FUN2, NOTE_2C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1AS, L_4, VOL_M, PAN_C, 0},

  {BEAT_FUN2, NOTE_2DS, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_3G, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_3AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_4C, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN3, NOTE_3AS, L_4, VOL_M, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN2, NOTE_3C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3DS, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},

  {BEAT_FUN2, NOTE_2AS, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1AS, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1AS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2DS, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_1AS, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_1AS, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN3, NOTE_2AS, L_4, VOL_H, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_FUN2, NOTE_2C, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_3G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_3C, L_4, VOL_M, PAN_C, 0},

  {BEAT_FUN2, NOTE_1A, L_2 - L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_2A, L_8, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_2E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2A, L_4, VOL_L, PAN_C, 0},
  {BEAT_FUN, NOTE_1DS, L_8, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2DS, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1AS, L_8, VOL_H, PAN_C, 0},
  {BEAT_FUN, NOTE_1DS, L_4, VOL_H, PAN_C, 0},

  {BEAT_END, L_1,0,0},
 },
*/
/*
 {
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_2A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_3E, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_2A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN2, NOTE_2A, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_1G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2F, L_4, VOL_M, PAN_C, 0},
  {BEAT_FUN, NOTE_2D, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },
*/
 {
  {BEAT_DRUM1, NOTE_2C, L_1, VOL_M, PAN_C, 0},
  {BEAT_DRUM1, NOTE_2C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CYMBAL1, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_CYMBAL1, NOTE_3C, L_2, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

/*
 {
  {BEAT_BLER, NOTE_3C, L_6, VOL_L, PAN_C, 0},
  {BEAT_HAT2, NOTE_2C, L_12, VOL_L, PAN_C, 0},
  {BEAT_HAT2, NOTE_2C, L_12, VOL_L, PAN_C, 0},
  {BEAT_STONK, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_BLER, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_BLER, NOTE_3G, L_6, VOL_L, PAN_C, 0},
  {BEAT_STONK, NOTE_3C, L_3, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_BLER, NOTE_2C, L_3, VOL_L, PAN_C, 0},
  {BEAT_STONK, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_BLER, NOTE_3G, L_4 + L_6, VOL_L, PAN_C, 0},
  {BEAT_STONK, NOTE_3E, L_3, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_BLER, NOTE_3C, L_6, VOL_L, PAN_C, 0},
  {BEAT_HAT2, NOTE_2C, L_12, VOL_L, PAN_C, 0},
  {BEAT_HAT2, NOTE_2C, L_12, VOL_L, PAN_C, 0},
  {BEAT_STONK, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_BLER, NOTE_3G, L_6 - 1, VOL_L, PAN_C, 0},
  {BEAT_STONK, NOTE_3E, L_6, VOL_M, PAN_C, 0},
  {BEAT_STONK, NOTE_3E, L_6, VOL_M, PAN_C, 0},
  {BEAT_STONK, NOTE_2G, L_4, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

 {
  {BEAT_BLER, NOTE_2C, L_6, VOL_L, PAN_C, 0},
  {BEAT_HAT2, NOTE_2C, L_12, VOL_L, PAN_C, 0},
  {BEAT_HAT2, NOTE_2C, L_12, VOL_L, PAN_C, 0},
  {BEAT_STONK, NOTE_3C, L_4, VOL_M, PAN_C, 0},
  {BEAT_BLER, NOTE_3G, L_4, VOL_L, PAN_C, 0},
  {BEAT_HAT2, NOTE_2C, L_12, VOL_L, PAN_C, 0},
  {BEAT_HAT2, NOTE_2C, L_12, VOL_L, PAN_C, 0},
  {BEAT_STONK, NOTE_3G, L_3, VOL_M, PAN_C, 0},
  {BEAT_END, L_1,0,0},
 },

*/

};

int music_pos;
int overmusic_pos;
int to_change_music;
int submusic_playing [SUBMUSICS];
int submusic_pos [SUBMUSICS];
int submusic_count [SUBMUSICS];
int submusic_finished [SUBMUSICS];

int to_play_beat [SUBMUSICS];
int to_play_tone [SUBMUSICS];
int to_play_alt_tone [SUBMUSICS];
int to_play_vol [SUBMUSICS];
int to_play_pan [SUBMUSICS];

int keychange;

//int which_music;
//int change_music; // when current music finishes, change.

void load_sample_in(int samp, const char *sfile, int direct);


void play_beat(int beat, int f, int vol, int pan, int alt_f, int ptone, int palt_tone);



/*
Call at startup of program.
*/
void init_sound(void)
{

   options.sound_mode = get_config_int("Misc", "StereoMode", SOUNDMODE_STEREO);
   // defaults to stereo in playing functions as well

// first we'll populate the tone array with the right frequencies:
   int i, j;
   float t;
   for (i = 0; i < NO_TONES; i ++)
   {
    t = (float) BASE_TONE;
    for (j = 0; j < i; j ++)
    {
     t *= (float) 1.059463094359;//(1000 + (1000 / 18)) / 1000;
    }
    tone [i] = t;
    // saves me from having to remember how to use the pow function
   }

   reserve_voices(16, 0); // not sure this is necessary
   if (install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) == -1)
   {
    exit(1); // don't bother with proper error handling yet. This should just disable sound.
   }
   set_volume(255, 0);

// effect samples:
   load_sample_in(WAV_SHOT, "shot", DIRECT_WAV);
   load_sample_in(WAV_SHOT2, "shot2", DIRECT_WAV);
   load_sample_in(WAV_BANG2, "bang2", DIRECT_WAV);
   load_sample_in(WAV_BANG1, "bang1", DIRECT_WAV);
   load_sample_in(WAV_BANG3, "bang3", DIRECT_WAV);
   load_sample_in(WAV_BANG4, "bang4", DIRECT_WAV);
   load_sample_in(WAV_CHARGE, "charge", DIRECT_WAV);
   load_sample_in(WAV_BOMB, "bomb", DIRECT_WAV);
   load_sample_in(WAV_FIRE, "fire", DIRECT_WAV);
   load_sample_in(WAV_CHIRP, "chirp", DIRECT_WAV);

   load_sample_in(WAV_HIGHZAP, "highzap", DIRECT_WAV);
   load_sample_in(WAV_INTER, "inter", DIRECT_WAV);
   load_sample_in(WAV_KILL, "kill", DIRECT_WAV);
   load_sample_in(WAV_SWEEP, "sweep", DIRECT_WAV);
   load_sample_in(WAV_ROBOT, "robot", DIRECT_WAV);
   load_sample_in(WAV_BEAM1, "beam1", DIRECT_WAV);
   load_sample_in(WAV_BEAM2, "beam2", DIRECT_WAV);
   load_sample_in(WAV_BEAM3, "beam3", DIRECT_WAV);
   load_sample_in(WAV_DOUBLE, "double", DIRECT_WAV);
   load_sample_in(WAV_LEVEL, "level", DIRECT_WAV);
   load_sample_in(WAV_BLIP, "blip", DIRECT_WAV);


// music samples:
/*
   load_sample_in(WAV_DRUM1, "drum1", DIRECT_BEAT);
   load_sample_in(WAV_DRUM2, "drum2", DIRECT_BEAT);
   load_sample_in(WAV_DRUM3, "drum3", DIRECT_BEAT);
   load_sample_in(WAV_CYMBAL1, "cymbal1", DIRECT_BEAT);
   load_sample_in(WAV_DRUM4, "drum4", DIRECT_BEAT);
   load_sample_in(WAV_HAT1, "hat1", DIRECT_BEAT);
   load_sample_in(WAV_HAT2, "hat2", DIRECT_BEAT);
   load_sample_in(WAV_BLER, "bler", DIRECT_BEAT);
   load_sample_in(WAV_DEEPDRUM, "deepdrum", DIRECT_BEAT);
   load_sample_in(WAV_SNARE, "snare", DIRECT_BEAT);
   load_sample_in(WAV_SNARE2, "snare2", DIRECT_BEAT);
   load_sample_in(WAV_STONK, "stonk", DIRECT_BEAT);
   load_sample_in(WAV_THUMP, "thump", DIRECT_BEAT);
*/
   load_sample_in(WAV_WARM, "warm", DIRECT_BEAT);
   load_sample_in(WAV_WARM2, "warm2", DIRECT_BEAT);
   load_sample_in(WAV_WARM3, "warm3", DIRECT_BEAT);
   load_sample_in(WAV_WARM4, "warm4", DIRECT_BEAT);
//   load_sample_in(WAV_DOUBLEW, "doublew", DIRECT_BEAT);
   load_sample_in(WAV_WARMUP, "warmup1", DIRECT_BEAT);
   load_sample_in(WAV_WARMUP2, "warmup2", DIRECT_BEAT);
   load_sample_in(WAV_WARMUP3, "warmup3", DIRECT_BEAT);
   load_sample_in(WAV_WARMUP4, "warmup4", DIRECT_BEAT);
   load_sample_in(WAV_CLAR, "clar", DIRECT_BEAT);
   load_sample_in(WAV_CLAR2, "clar2", DIRECT_BEAT);
   load_sample_in(WAV_ACC, "acc", DIRECT_BEAT);

   load_sample_in(WAV_ARP, "arp", DIRECT_BEAT);
   load_sample_in(WAV_ARP2, "arp2", DIRECT_BEAT);
   load_sample_in(WAV_ARP3, "arp3", DIRECT_BEAT);
   load_sample_in(WAV_ARP_LONG, "arp_long", DIRECT_BEAT);
   load_sample_in(WAV_FLUTE, "flute", DIRECT_BEAT);
   load_sample_in(WAV_FLUTE2, "flute2", DIRECT_BEAT);
   load_sample_in(WAV_FLUTE3, "flute3", DIRECT_BEAT);
   load_sample_in(WAV_MELO, "melo", DIRECT_BEAT);
   load_sample_in(WAV_MELO2, "melo2", DIRECT_BEAT);
   load_sample_in(WAV_MELO3, "melo3", DIRECT_BEAT);

   load_sample_in(WAV_ZONE1, "zone1", DIRECT_BEAT);
   load_sample_in(WAV_ZONE2, "zone2", DIRECT_BEAT);
   load_sample_in(WAV_ZONE3, "zone3", DIRECT_BEAT);
   load_sample_in(WAV_HIGH, "high", DIRECT_BEAT);
   load_sample_in(WAV_LOW1, "low1", DIRECT_BEAT);
   load_sample_in(WAV_LOW2, "low2", DIRECT_BEAT);

   load_sample_in(WAV_BEEP, "beep", DIRECT_BEAT);
   load_sample_in(WAV_BEEP2, "beep2", DIRECT_BEAT);
   load_sample_in(WAV_FUN0, "fun0", DIRECT_BEAT);
   load_sample_in(WAV_FUN, "fun", DIRECT_BEAT);
   load_sample_in(WAV_FUN2, "fun2", DIRECT_BEAT);
   load_sample_in(WAV_FUN3, "fun3", DIRECT_BEAT);
   load_sample_in(WAV_ORGAN, "organ", DIRECT_BEAT);

//   load_sample_in(WAV_, "", DIRECT_BEAT);


}

// Called at startup of each game
void init_beat(void)
{

 music_pos = 0;
// which_music = MUSIC_L1_1;
// change_music = 0;

 int i;

 for (i = 0; i < SUBMUSICS; i ++)
 {
  submusic_pos [i] = 0;
  submusic_count [i] = 5;
  submusic_finished [i] = 0;
  to_play_beat [i] = BEAT_NONE;

 }
}

// called at startup of new level
void init_beat_new_level(void)
{

 music_pos = 0;
// which_music = OVERMUSIC_L1_1;
 //change_music = 0;
 switch(arena.level)
 {
  default:
  case 1:
   overmusic_pos = OVERMUSIC_L1_1;
   break;
  case 2:
   overmusic_pos = OVERMUSIC_L2_1;
   break;
  case 3:
   overmusic_pos = OVERMUSIC_L3_1;
   keychange = 0;
   break;
 }
//   overmusic_pos = OVERMUSIC_L2_1;


 to_change_music = -1;



 int i;

 for (i = 0; i < SUBMUSICS; i ++)
 {
  submusic_playing [i] = SUBMUSIC_EMPTY;
  submusic_pos [i] = 0;
  submusic_count [i] = 0;
  submusic_finished [i] = 0;
  to_play_beat [i] = BEAT_NONE;

  submusic_playing [i] = music [overmusic_pos] [music_pos] [i];
 }


}


void run_beat(void)
{

// return;

 int i;


// char go_to_next = 0;

 for (i = 0; i < SUBMUSICS; i ++)
 {
  if (to_play_beat [i] != BEAT_NONE)
  {
   play_beat(to_play_beat [i], tone [to_play_tone [i]], to_play_vol [i], to_play_pan [i], tone [to_play_alt_tone [i]], to_play_tone [i], to_play_alt_tone [i]);
   to_play_beat [i] = BEAT_NONE;
  }
//  if (submusic_count [i] > 0)
//   go_to_next = 0;
 }
  if (submusic [submusic_playing [0]] [submusic_pos [0]] [SM_BEAT] == BEAT_END
      && submusic_count [0] <= 0)
      {
        music_pos ++;
        if (music [overmusic_pos] [music_pos] [0] == SUBMUSIC_END)
        {
         music_pos = 0;
        }
        if (to_change_music != -1)
        {
         overmusic_pos = to_change_music;
         to_change_music = -1;
        }
        for (i = 0; i < SUBMUSICS; i ++)
        {
         submusic_pos [i] = 0;
         submusic_count [i] = 0;
//         submusic_playing [i] = music [overmusic_pos] [music_pos] [i];
         switch(music [overmusic_pos] [music_pos] [i])
         {
          case SUBMUSIC_L3_KEYCHANGE:
           keychange = music [overmusic_pos] [music_pos] [1];
           music_pos ++;
           submusic_playing [i] = music [overmusic_pos] [music_pos] [i];
           break;

          default:
           submusic_playing [i] = music [overmusic_pos] [music_pos] [i];
           break;
          case SUBMUSIC_L1_BASIC_RAND:
           submusic_playing [i] = SUBMUSIC_L1_BASIC2 + grand(7);
           break;
          case SUBMUSIC_L1_UP_RAND:
           submusic_playing [i] = SUBMUSIC_L1_UP2 + grand(7);
           break;
          case SUBMUSIC_L1_SONG_RAND:
           submusic_playing [i] = SUBMUSIC_L1_SONG2 + grand(7);
           break;

         }
        }


   //go_to_next = 1;
      }




 for (i = 0; i < SUBMUSICS; i ++)
 {
   if (submusic_playing [i] == SUBMUSIC_EMPTY)
    continue;   // remember to set finished to 1 when setting submusic to _empty!!!
   submusic_count [i] --;
   // if count == 1, synch_events!
   if (submusic_count [i] <= 0)
   {
    if (submusic [submusic_playing [i]] [submusic_pos [i]] [SM_BEAT] == BEAT_END)
    {
//     if (go_to_next == 1) // makes sure all submusics are aligned
//      submusic_pos [i] = 0;
     // we've finished the submusic, including any pause at the end, so set a new submusic here
     continue;
    }
    to_play_beat [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_BEAT];
    to_play_tone [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_TONE];
    to_play_alt_tone [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_ALT_TONE];
    to_play_vol [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_VOL];
    to_play_pan [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_PAN];
/*    play_beat(submusic [submusic_playing [i]] [submusic_pos [i]] [SM_BEAT],
        tone [submusic [submusic_playing [i]] [submusic_pos [i]] [SM_TONE]],
        submusic [submusic_playing [i]] [submusic_pos [i]] [SM_VOL],
        submusic [submusic_playing [i]] [submusic_pos [i]] [SM_PAN]);*/
    submusic_count [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_LENGTH];
//    if (arena.level == 3)
//     submusic_count [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_LENGTH] * 0.8;
    submusic_pos [i] ++;

   }
//   if (submusic_pos [i]

 }

}

void play_beat(int beat, int f, int vol, int pan, int alt_f, int ptone, int palt_tone)
{
 switch(beat)
 {
     case BEAT_DRUM1:
      play_musicwfvp(WAV_DRUM1, f + grand(100), vol, pan);
      break;
     case BEAT_DRUM2:
      play_musicwfvp(WAV_DRUM2, f, vol, pan);
      break;
     case BEAT_DRUM3:
      play_musicwfvp(WAV_DRUM3, f, vol, pan);
      break;
     case BEAT_DRUM4:
      play_musicwfvp(WAV_DRUM4, f, vol, pan);
      break;
     case BEAT_HAT1:
      play_musicwfvp(WAV_HAT1, f, vol, pan);
      break;
     case BEAT_HAT2:
      play_musicwfvp(WAV_HAT2, f, vol, pan);
      break;
     case BEAT_CYMBAL1:
      play_musicwfvp(WAV_CYMBAL1, f * 2, vol, pan);
      break;
     case BEAT_BLER:
      play_musicwfvp(WAV_BLER, f, vol, pan);
      break;
     case BEAT_DEEPDRUM:
      play_musicwfvp(WAV_DEEPDRUM, f, vol, pan);
      break;
     case BEAT_SNARE:
      play_musicwfvp(WAV_SNARE, f, vol, pan);
      break;
     case BEAT_SNARE2:
      play_musicwfvp(WAV_SNARE2, f, vol, pan);
      break;
     case BEAT_STONK:
      play_musicwfvp(WAV_STONK, f, vol, pan);
      break;
     case BEAT_THUMP:
      play_musicwfvp(WAV_THUMP, f, vol, pan);
      break;
     case BEAT_WARM:
      play_musicwfvp(WAV_WARM, f, vol, pan);
      break;
     case BEAT_WARM2:
      play_musicwfvp(WAV_WARM2, f, vol, pan);
      break;
     case BEAT_WARM3:
      play_musicwfvp(WAV_WARM3, f, vol, pan);
      break;
     case BEAT_WARM4:
      play_musicwfvp(WAV_WARM4, f, vol, pan);
      break;
     case BEAT_WARMUP:
      play_musicwfvp(WAV_WARMUP, f, vol, pan);
      break;
     case BEAT_WARMUP2:
      play_musicwfvp(WAV_WARMUP2, f, vol, pan);
      break;
     case BEAT_WARMUP3:
      play_musicwfvp(WAV_WARMUP3, f, vol, pan);
      break;
     case BEAT_WARMUP4:
      play_musicwfvp(WAV_WARMUP4, f, vol, pan);
      break;
     case BEAT_DOUBLEW:
      play_musicwfvp(WAV_DOUBLEW, f, vol, pan);
      break;
     case BEAT_CLAR:
      play_musicwfvp(WAV_CLAR, f, vol, pan);
      break;
     case BEAT_CLAR2:
      play_musicwfvp(WAV_CLAR2, f, vol, pan);
      break;
     case BEAT_ACC:
      play_musicwfvp(WAV_ACC, f, vol, pan);
      break;
     case BEAT_ARP:
      play_musicwfvp(WAV_ARP, f, vol / 2, pan);
      break;
     case BEAT_ARP2:
      play_musicwfvp(WAV_ARP2, f, vol / 2, pan);
      break;
     case BEAT_ARP3:
      play_musicwfvp(WAV_ARP3, f, vol / 2, pan);
      break;
     case BEAT_ARP_LONG:
      play_musicwfvp(WAV_ARP_LONG, f, vol / 2, pan);
      break;
     case BEAT_FLUTE:
      play_musicwfvp(WAV_FLUTE, f, vol, pan);
      break;
     case BEAT_FLUTE2:
      play_musicwfvp(WAV_FLUTE2, f, vol, pan);
      break;
     case BEAT_FLUTE3:
      play_musicwfvp(WAV_FLUTE3, f, vol, pan);
      break;
     case BEAT_MELO:
      if (coin())
       f = alt_f;
      play_musicwfvp(WAV_MELO, f, vol, pan);
      break;
     case BEAT_MELO2:
      if (coin())
       f = alt_f;
      play_musicwfvp(WAV_MELO2, f, vol, pan);
      break;
     case BEAT_MELO3:
      if (coin())
       f = alt_f;
      play_musicwfvp(WAV_MELO3, f, vol, pan);
      break;
     case BEAT_ZONE1:
      play_musicwfvp(WAV_ZONE1, f, vol, pan);
      break;
     case BEAT_ZONE2:
     case BEAT_ZONE3:
      if (coin())
       play_musicwfvp(WAV_ZONE2, f, vol / 2, pan);
        else
         play_musicwfvp(WAV_ZONE3, f, vol / 2, pan);
      break;
     case BEAT_HIGH:
      play_musicwfvp(WAV_FUN, f, vol, pan);
      break;
     case BEAT_LOW1:
      play_musicwfvp(WAV_FUN2, f, vol, pan);
      break;
     case BEAT_LOW2:
      play_musicwfvp(WAV_FUN3, f, vol, pan);
      break;
     case BEAT_BEEP:
      play_musicwfvp(WAV_FUN, tone [ptone + keychange], vol, pan);
      break;
     case BEAT_BEEP2:
      if (ptone > NOTE_2C && grand(5) == 0)
       play_musicwfvp(WAV_FUN2, tone [ptone + keychange], vol, pan);
        else
         play_musicwfvp(WAV_FUN2, tone [ptone + keychange], vol, pan);
      break;

/*     case BEAT_FUN0:
      play_musicwfvp(WAV_FLUTE, tone [ptone + keychange] * 4, vol, pan);
      break;
     case BEAT_FUN:
      if (ptone > NOTE_2C && grand(5) == 0)
       play_musicwfvp(WAV_FLUTE, tone [ptone + keychange] * 2, vol, pan);
        else
         play_musicwfvp(WAV_FLUTE, tone [ptone + keychange] * 4, vol, pan);
      break;
     case BEAT_FUN2:
      if (ptone > NOTE_2C && grand(4) == 0)
       play_musicwfvp(WAV_FLUTE, tone [ptone + keychange] * 2, vol, pan);
        else
         play_musicwfvp(WAV_FLUTE2, tone [ptone + keychange] * 4, vol, pan);
      break;
     case BEAT_FUN3:
      if (ptone > NOTE_2C && grand(3) == 0)
       play_musicwfvp(WAV_FLUTE, tone [ptone + keychange] * 2, vol, pan);
        else
        play_musicwfvp(WAV_FLUTE2, tone [ptone + keychange] * 4, vol, pan);
      break;*/

     case BEAT_FUN0:
      play_musicwfvp(WAV_FUN, tone [ptone + keychange], vol, pan);
      break;
     case BEAT_FUN:
      if (ptone > NOTE_2C && grand(5) == 0)
       play_musicwfvp(WAV_FUN2, tone [ptone + keychange] / 2, vol, pan);
        else
         play_musicwfvp(WAV_FUN2, tone [ptone + keychange], vol, pan);
      break;
     case BEAT_FUN2:
      if (ptone > NOTE_2C && grand(4) == 0)
       play_musicwfvp(WAV_FUN3, tone [ptone + keychange] / 2, vol, pan);
        else
         play_musicwfvp(WAV_FUN3, tone [ptone + keychange], vol, pan);
      break;
     case BEAT_FUN3:
      if (ptone > NOTE_2C && grand(3) == 0)
       play_musicwfvp(WAV_FUN3, tone [ptone + keychange] / 2, vol, pan);
        else
        play_musicwfvp(WAV_FUN3, tone [ptone + keychange], vol, pan);
      break;

     case BEAT_ORGAN:
//      play_musicwfvp(WAV_FUN2, tone [ptone + keychange], vol, pan);
         play_musicwfvp(WAV_ARP, tone [ptone + keychange] * 2, vol, pan);
      break;

/*     case BEAT_:
      play_effectwfvp(WAV_, f, vol, pan);
      break;*/

/*  case BEAT_LONG:
   play_effectwfvp(WAV_LONG, f, vol, pan);
   break;
  case BEAT_LONG2:
   play_effectwfvp(WAV_LONG2, f, vol, pan);
   break;*/
 }

}



void change_music(int mto)
{
  to_change_music = mto;
}







/*
Loads a .wav file. Should be in the .wavs subdirectory
*/
void load_sample_in(int samp, const char *sfile, int direct)
{

 char sfile_name [50];

 if (direct == DIRECT_WAV)
  strcpy(sfile_name, ".//wavs//");
   else
    strcpy(sfile_name, ".//beat//");
 strcat(sfile_name, sfile);
 strcat(sfile_name, ".wav");

 sounds [samp] = load_sample(sfile_name);

 if (sounds [samp] == NULL)
 {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error: Unable to load sound file: %s", sfile_name);
      exit(1);
 }
}


/*
Pass e.g. WAV_FIRE to this and it plays it
*/
void play_effect(int sample)
{

 play_sample(sounds [sample], 200, 127, 1000, 0);

}

/*
plays sample at frequency f (normal is 1000), volume v (255 is max), x position x (middle is 127)
*/
void play_musicwfvp(int sample, int f, int v, int pan)
{

 switch(options.sound_mode)
 {
  case SOUNDMODE_MONO:
   pan = 127;   break;
  case SOUNDMODE_REVERSED:
   pan = 255 - pan;   break;
 }

 v = (v * options.ambience_volume) / 100;

 play_sample(sounds [sample], v, pan, f, 0);

}


/*
plays sample at frequency f (normal is 1000), volume v (255 is max), x position x (middle is 127)
*/
void play_effectwfvx(int sample, int f, int v, int x)
{
//return;
// int pan = x / 2500; // this gives us a # from 0 to 255, from the left of the screen to the right. For stereo

 int pan = x / 5030; // this gives us a # from 0 to 255, from the left of the screen to the right. For stereo
 pan += 64;

 switch(options.sound_mode)
 {
  case SOUNDMODE_MONO:
   pan = 127;   break;
  case SOUNDMODE_REVERSED:
   pan = 255 - pan;   break;
 }

 v = (v * options.sfx_volume) / 100;

 play_sample(sounds [sample], v, pan, f, 0);

}







