#include "Intro.h"
#include "Game.h"
#include "LightningArc.h"
#include "CommonFunctions.h"
#include "music.h"
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <time.h>
#include <math.h>

extern int RATE;
extern int WIDTH, HEIGHT;
extern BITMAP* buffer;

typedef struct {
  int dstx, dsty;
  int color, outcolor;
  int rx, ry;
  int size;
  int dist;
} Bubble;

static BITMAP *echodot, *sh07, *sh07_small, *black;
Bubble* bubbles;
static long counter;
static enum { LIGHTNING,
	      ECHODOT_FI,
	      ECHODOT_S,
	      BUBBLES,
	      BUBBLES_2,
	      DESTROY } state;
int stateChanged = 0;

static void Intro_cleanup()
{
  free(bubbles);
  destroy_bitmap(sh07);
  destroy_bitmap(echodot);
  destroy_bitmap(sh07_small);
  destroy_bitmap(black);
}

static int bubbleCompare(const void* p1, const void* p2)
{
  return (((Bubble*)p1)->size - ((Bubble*)p2)->size);
}

void Intro_init()
{
  int x,y,dist;
  int r,g,b;
  Bubble* cur;
  counter = 0;
  sh07 = load_pcx("media/gfx/sh07.pcx",NULL);
  echodot = load_pcx("media/gfx/echodot.pcx",NULL);
  sh07_small = create_bitmap(80,60);
  stretch_blit(sh07,sh07_small,0,0,640,480,0,0,80,60);
  black = create_bitmap(WIDTH,HEIGHT);
  clear(black);
  bubbles = (Bubble*)malloc(80*60*sizeof(Bubble));
  for (y=0; y<60; ++y)
  {
    for (x=0; x<80; ++x)
    {
      cur = &bubbles[y*80+x];
      cur->color = _getpixel16(sh07_small,x,y);
      r = getr16(cur->color)/2; g = getg16(cur->color)/2; b = getb16(cur->color)/2;
      cur->outcolor = makecol16(r,g,b);
      dist = rand()%200+50;
      cur->dstx = x*8;
      cur->dsty = y*8;
      cur->rx = cur->dstx+(WIDTH/2-cur->dstx)*dist/(WIDTH/2);
      cur->ry = cur->dsty+(HEIGHT/2-cur->dsty)*dist/(HEIGHT/2);
      cur->size = dist+7;
      cur->dist = dist;
    }
  }
  qsort(bubbles,80*60,sizeof(Bubble),bubbleCompare);
  srand(time(0));
  state = LIGHTNING;
  music_play("media/music/3.xm",0);
}

static inline void nextState()
{
  state++;
  counter = 0;
  stateChanged = 1;
}

typedef struct {
  int x,y;
  int state;
} Glow;

void Intro_lightning_draw()
{
  static float angle = 0;
  static float angle_plus = 0;
  static Glow glows[50] = {{0,0,0}};
  static int glow_pos = 0;
  int i = 0;
  int glow_str;

  angle += angle_plus;
  angle_plus += 0.0005;
  int d = WIDTH/2 - counter;
  int dx = d*cos(angle);
  int dy = d*sin(angle);
  int x1 = WIDTH/2 - dx;
  int x2 = WIDTH/2 + dx;
  int y1 = HEIGHT/2 - dy;
  int y2 = HEIGHT/2 + dy;
  clear(buffer);
  lightningArc(x1,y1,x2,y2);
  glows[glow_pos+1].x = x1;
  glows[glow_pos+1].y = y1;
  glows[glow_pos+1].state = 25;
  glows[glow_pos+2].x = x2;
  glows[glow_pos+2].y = y2;
  glows[glow_pos+2].state = 25;
  glow_pos+=2;
  if (glow_pos > 47) glow_pos = 0;
  for (i=0; i<50; ++i)
  {
    if (glows[i].state > 0)
    {
      glows[i].state--;
      glow_str = glows[i].state*255/25;
      circlefill(buffer,glows[i].x,glows[i].y,2,makecol16(glow_str,glow_str,glow_str*2/3+85));
    }
  }
}

static inline int counterExpired(int seconds)
{
  if (counter>seconds*RATE) return 1;
  return 0;
}

void Intro_bubbles_logic()
{
  int i;
  Bubble* cur;
  for (i=0; i<80*60; ++i)
  {
    cur = &bubbles[i];
    if (cur->dist > 0)
    {
      cur->dist--;
      cur->size--;
      cur->rx += numReduce(cur->dstx-cur->rx);
      cur->ry += numReduce(cur->dsty-cur->ry);
    }
  }
  if (counter>230) nextState();
}

void Intro_bubbles2_logic()
{
  static int do_ = 0;
  int i;
  Bubble* cur;
  do_++;
  do_%=2;
  for (i=0; i<80*60; ++i)
  {
    cur = &bubbles[i];
    if (cur->size > 0 && do_)
    {
      cur->size--;
    }
  }
  if (counterExpired(3)) nextState();
}

LogicReturn Intro_logic()
{
  if (key[KEY_ESC])
  {
    //Intro_cleanup();
    //Game_ChangeState(STATE_GAME);
    //return LR_EXIT;
    music_stop();
    nextState();
    state = DESTROY;
  }

  switch (state)
  {
    case LIGHTNING:
      if (counter >= WIDTH*17/32) nextState();
      break;
    case ECHODOT_FI:
      if (counter >= 30) nextState();
      break;
    case ECHODOT_S:
      if (counterExpired(2)) {
	nextState();
      }
      break;
    case BUBBLES:
      if (counter == 20)
      {
	music_play("media/music/4.xm",0);
      }
      Intro_bubbles_logic();
      break;
    case BUBBLES_2:
      Intro_bubbles2_logic();
      break;
    case DESTROY:
      if (counter == 0)
      {
	set_trans_blender(255,255,255,10);
      }
      if (counterExpired(1))
      {
	Intro_cleanup();
	Game_ChangeState(STATE_TITLE);
	return LR_EXIT;
      }
      break;
  }
  if (!stateChanged) counter++;

  return LR_NOOP;
}

static void Intro_echodot_draw()
{
  clear_to_color(buffer,makecol16(255,255,255));
  blit(echodot,buffer,0,0,(WIDTH-echodot->w)/2,(HEIGHT-echodot->h)/2,echodot->w,echodot->h);
}

static void bubbleDraw(int i)
{
  Bubble* b = &bubbles[i];
  if (b->size <= 0) return;
  if (b->dist < 20)
  {
    if (b->dist > 0)
    {
      circle(buffer,b->rx,b->ry,b->size,b->outcolor);
    }
    else
    {
      blit(sh07,buffer,b->dstx,b->dsty,b->dstx,b->dsty,8,8);
    }
    circlefill(buffer,b->rx,b->ry,b->size-1,b->color);
  }
}

void Intro_draw()
{
  int i;
  if (stateChanged)
  {
    stateChanged = 0;
    return;
  }
  switch (state)
  {
    case LIGHTNING:
      Intro_lightning_draw();
      break;
    case ECHODOT_FI:
      clear_to_color(buffer,makecol16(counter*8,counter*8,counter*8));
      break;
    case ECHODOT_S:
      Intro_echodot_draw();
      break;
    case BUBBLES:
      Intro_echodot_draw();
      for (i=0;i<80*60;++i)
      {
	bubbleDraw(i);
      }
      break;
    case BUBBLES_2:
      blit(sh07,buffer,0,0,0,0,WIDTH,HEIGHT);
      for (i=0;i<80*60;++i)
      {
	bubbleDraw(i);
      }
      break;
    case DESTROY:
      draw_trans_sprite(buffer,black,0,0);
      break;
  }
}


