#include <allegro.h>
#include <stdio.h>
#include "Game.h"
#include "Intro.h"
#include "Title.h"
#include "InGame.h"
#include "Highscore.h"
#include "music.h"

extern int WIDTH,HEIGHT;
extern int WIDESCREEN;
extern int WSCRWIDTH;
extern int FULLSCREEN;
const int TILE = 32;

struct {
  LogicReturn (*fn_logic) (void);
  void (*fn_draw) (void);
} stateFunctions;

extern int logicLeft;
extern BITMAP* buffer;
extern BITMAP* wscrbuf[];
GameResults gameResults;

GameState gameState = STATE_INTRO;

static int gameRunning;

void Game_ChangeState(GameState state)
{
  gameRunning = 0;
  gameState = state;
}

void Game()
{
  static int wscrtick = 0;
  int tmp;
  LogicReturn logicReturn;

  game_outer_loop:;
  switch (gameState)
  {
    case STATE_INTRO:
      Intro_init();
      stateFunctions.fn_logic = Intro_logic;
      stateFunctions.fn_draw = Intro_draw;
      break;
    case STATE_TITLE:
      Title_init();
      stateFunctions.fn_logic = Title_logic;
      stateFunctions.fn_draw = Title_draw;
      break;
    case STATE_GAME:
      InGame_init();
      stateFunctions.fn_logic = InGame_logic;
      stateFunctions.fn_draw = InGame_draw;
      break;
    case STATE_HIGHSCORE:
      Highscore_init();
      stateFunctions.fn_logic = Highscore_logic;
      stateFunctions.fn_draw = Highscore_draw;
      break;
    case STATE_QUIT:
      return;
    default:
      fprintf(stderr,"Unsupported gameState (%d)!\n",(int)gameState);
      return;
  }
  gameRunning = 1;
  logicReturn = LR_NOOP;

  logicLeft = 0;
  while (gameRunning)
  {
    while (logicLeft>0)
    {
      logicReturn = stateFunctions.fn_logic();
      music_buffer_refill();
      if (key[KEY_ALT] && key[KEY_ENTER])
      {
	FULLSCREEN ^= 1;
	tmp = logicLeft;
	if (FULLSCREEN)
	{
	  set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,WIDTH,HEIGHT,0,0);
	}
	else
	{
	  set_gfx_mode(GFX_AUTODETECT_WINDOWED,WIDTH,HEIGHT,0,0);
	}
	logicLeft = tmp;
	key[KEY_ALT] = 0;
	key[KEY_ENTER] = 0;
      }
      if (logicReturn == LR_EXIT) break;
      logicLeft--;
    }
    if (logicReturn == LR_EXIT) break;
    stateFunctions.fn_draw();
    if (WIDESCREEN)
    {
      stretch_blit(buffer,screen,0,0,WIDTH,HEIGHT,wscrbuf[wscrtick]->w,0,WSCRWIDTH,SCREEN_H);
      blit(wscrbuf[wscrtick],screen,0,0,0,0,wscrbuf[wscrtick]->w,wscrbuf[wscrtick]->h);
      blit(wscrbuf[wscrtick],screen,0,0,WSCRWIDTH+wscrbuf[wscrtick]->w,0,wscrbuf[wscrtick]->w,wscrbuf[wscrtick]->h);
      wscrtick++;
      if (wscrtick > 15) wscrtick = 0;
    }
    else
    {
      blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
    }
    while (logicLeft<=0)
    {
      rest(1);
      music_buffer_refill();
    }
  }
  goto game_outer_loop;
}

