#include <allegro.h>
#include "Game.h"
#include "Title.h"
#include "music.h"

extern BITMAP* buffer;
extern int WIDTH, HEIGHT;

static BITMAP *title_bmp, *black;
static BITMAP* scrollbmp;
static FONT *fnt_sans;

extern int logicLeft;

static void Title_cleanup()
{
  music_stop();
  destroy_bitmap(title_bmp);
  destroy_bitmap(black);
  destroy_bitmap(scrollbmp);
  destroy_font(fnt_sans);
}

//Screen timing
static int init = 0; // Abuse of global variables - only blend in the first time
static int stay;
static int exit_;

static int quit;

static int scrollpos;
static const char* scrolltext = 
  "==- Lily v1.021 -=="
  "                                                                    "
  "Some time ago there was a girl named Lily"
  "                                                                    "
  "In this game YOU are Lily"
  "                                                                    "
  "Do as you like, but beware... Lily is evil!"
  "                                                                    "
  "                                                                    "
  "Walk with the cursor keys (or WSAD)"
  "                                                                    "
  "Shoot using the mouse"
  "                                                                    "
  "Press ALT+ENTER to toggle fullscreen                                "
  "                                                                    "
  "                                                                    "
  "All content (c) 2008 by Simon Parzer, for details see readme.txt    "
  "                                                                    ";

void Title_init()
{
  title_bmp = load_pcx("media/gfx/title.pcx",NULL);
  black = create_bitmap(WIDTH,HEIGHT);
  clear(black);
  fnt_sans = load_font("media/font/sans.pcx",NULL,NULL);
  scrollbmp = create_bitmap(text_length(fnt_sans,scrolltext)+1,text_height(fnt_sans)+1);
  clear_to_color(scrollbmp,makecol16(255,0,255));
  textout_ex(scrollbmp,fnt_sans,scrolltext,1,1,makecol16(150,100,150),-1);
  textout_ex(scrollbmp,fnt_sans,scrolltext,0,0,makecol16(255,200,255),-1);
  stay = 1;
  exit_ = 0;
  quit = 0;
  scrollpos = WIDTH;
  music_play("media/music/2.xm",1);
  clear_keybuf(); //keypressed() usage in Title_logic()
}

LogicReturn Title_logic()
{
  static int d = 0;
  if (init <= 50)
  {
    init++;
    return LR_NOOP;
  }
  else if (stay)
  {
    if (keypressed())
    {
      logicLeft = 0;
      stay = 0;
    }
    scrollpos-=1+d;
    d^=1;
    if (scrollpos < -scrollbmp->w) scrollpos = 0;
    return LR_NOOP;
  }
  else if (exit_ <= 50)
  {
    exit_++;
    if (exit_ > 50)
    {
      Title_cleanup();
      if (quit)
      {
	Game_ChangeState(STATE_QUIT);
      }
      else
      {
	Game_ChangeState(STATE_GAME);
      }
      return LR_EXIT;
    }
  }
  if (key[KEY_ESC])
  {
    stay = 0;
    quit = 1;
    key[KEY_ESC] = 0;
  }
  return LR_NOOP;
}

static void draw_bg()
{
  blit(title_bmp,buffer,0,0,0,0,WIDTH,HEIGHT);
}

static void draw_shadow()
{
  if (init <= 50)
  {
    set_trans_blender(255,255,255,255 - init*255/50);
    draw_trans_sprite(buffer,black,0,0);
  }
  else if (exit_ <= 50)
  {
    set_trans_blender(255,255,255,exit_*255/50);
    draw_trans_sprite(buffer,black,0,0);
  }
}

static void draw_scroller()
{
  int w = scrollbmp->w+scrollpos;
  const int y = HEIGHT-scrollbmp->h-1;
  DUMB_IT_SIGRENDERER* mrnd = music_get_renderer();
  const int cur_music_row = dumb_it_sr_get_current_row(mrnd);
  int mrow = cur_music_row%4;

  line(buffer,0,y-1,WIDTH,y-1,makecol16(30+mrow*15,0,0));
  rectfill(buffer,0,y,WIDTH,HEIGHT,makecol16(20+mrow*10,0,0));
  if (w > WIDTH) w = WIDTH;
  masked_blit(scrollbmp,buffer,-scrollpos,0,0,y,WIDTH,scrollbmp->h);
  if (w < WIDTH)
  {
    masked_blit(scrollbmp,buffer,0,0,w,y,WIDTH-w,scrollbmp->h);
  }
}

void Title_draw()
{
  draw_bg();
  draw_scroller();
  draw_shadow();
}

