#include "music.h"

#include <string.h>
#include <malloc.h>

static int playing;
static int do_repeat;

DUH* mod = NULL;
AL_DUH_PLAYER *dp;

int music_init( void )
{
  dumb_register_stdfiles();
  dumb_resampling_quality = 4;
  dumb_it_max_to_mix = 128;
  playing = 0;
  do_repeat = 0;
  return 0;
}

void music_buffer_refill( void )
{
  if (!playing) return;
  al_poll_duh(dp);
}

DUH* music_load( const char* file )
{
  DUH* duh;
  duh = dumb_load_it(file);
  if (!duh) {
    duh = dumb_load_xm(file);
    if (!duh) {
      duh = dumb_load_s3m(file);
      if (!duh) {
	duh = dumb_load_mod(file);
	if (!duh) {
	  fprintf(stderr,"Failed to load %s!\n", file);
	  return NULL;
	}
      }
    }
  }
  return duh;
}

SAMPLE* music_create_sample( DUH* duh, int order )
{
  const long bufsize = sizeof(unsigned short)*44100*10;
  const int render_at_once = 16384;
  unsigned short* renderbuffer = malloc(bufsize); //~860 KiB buffer, enough space for 10 seconds
  long pos, rendered;
  DUH_SIGRENDERER* duh_renderer = dumb_it_start_at_order(duh,1,order); //MONO sample
  DUMB_IT_SIGRENDERER* it_renderer = duh_get_it_sigrenderer(duh_renderer);
  SAMPLE* sample;

  dumb_it_set_loop_callback(it_renderer,dumb_it_callback_terminate,NULL);
  dumb_it_set_xm_speed_zero_callback(it_renderer,dumb_it_callback_terminate,NULL);

  pos = 0;
  do 
  {
    rendered = 
      duh_render(duh_renderer,16,1,1.0f,65536.0f/44100,render_at_once,renderbuffer+pos); //Always render 16 KiB at once
    pos += rendered;
    if (pos >= bufsize - render_at_once) break;
  } while (rendered >= render_at_once);

  duh_end_sigrenderer(duh_renderer);

  sample = create_sample(16,0,44100,pos);
  memcpy((void*)sample->data,(const void*)renderbuffer,pos*sizeof(unsigned short));
  free(renderbuffer);
  return sample;
}

int music_play( const char* file, int repeat )
{
  if (mod != NULL || playing)
  {
    music_stop();
  }
  mod = music_load(file);
  dp = al_start_duh(mod, 2, 0, 1.0f,4096,44100);
  if (!repeat)
  {
    dumb_it_set_loop_callback(duh_get_it_sigrenderer(al_duh_get_sigrenderer(dp)),dumb_it_callback_terminate,NULL);
  }
  do_repeat = repeat;
  playing = 1;
  return 0;
}

DUMB_IT_SIGRENDERER* music_get_renderer()
{
  return duh_get_it_sigrenderer(al_duh_get_sigrenderer(dp));
}

void music_unload( DUH* duh )
{
  unload_duh(duh);
}

int music_stop( void )
{
  if (playing)
  {
    al_stop_duh(dp);
    dp = NULL;
    music_unload(mod);
    mod = NULL;
    playing = 0;
  }
  return 0;
}

int music_quit( void )
{
  dumb_exit();
  return 0;
}

