#include "LightningArc.h"
#include "CommonFunctions.h"
#include <allegro.h>

extern BITMAP* buffer;
extern int WIDTH, HEIGHT;

typedef struct {
  int x,y;
} Point;

static inline int _larc_randadd(int val)
{
  return val + rand()%40-20;
}

static void lightLine(int x1, int y1, int x2, int y2)
{
  const int inside = makecol16(255,255,255);
  const int outside = makecol16(127,127,255);

  // (dx dy) ... "Reduced" normal vector
  int dy = numReduce(x2-x1);
  int dx = numReduce(y2-y1);
  line(buffer,x1+dx,y1,x2+dx,y2,outside);
  line(buffer,x1-dx,y1,x2-dx,y2,outside);
  line(buffer,x1,y1-dy,x2,y2-dy,outside);
  line(buffer,x1,y1+dy,x2,y2+dy,outside);
  line(buffer,x1,y1,x2,y2,inside);
}

void lightningArc(int x1, int y1, int x2, int y2)
{
  static Point pos[2];
  int i;
  const int dx = x2-x1;
  const int dy = y2-y1;

  pos[1].x = x1;
  pos[1].y = y1;
  for (i=1; i<16; ++i)
  {
    pos[0].x = pos[1].x;
    pos[0].y = pos[1].y;
    pos[1].x = _larc_randadd(x1 + dx*i/16);
    pos[1].y = _larc_randadd(y1 + dy*i/16);
    lightLine(pos[0].x, pos[0].y, pos[1].x, pos[1].y);
  }
  lightLine(pos[1].x,pos[1].y,x2,y2);
}

void lightningArc2(int x1, int y1, int x2, int y2)
{
  int dx, dy;
  int x = x1, y = y1;
  int i;
  dx = x2 - x1;
  dy = y2 - y1;
  x2 = _larc_randadd(x2);
  y2 = _larc_randadd(y2);

  i=2;
  while (x > 0 && x < WIDTH && y > 0 && y < HEIGHT)
  {
    lightLine(x,y,x2,y2);
    x = x2;
    y = y2;
    x2 = _larc_randadd(x1+dx*i);
    y2 = _larc_randadd(y1+dy*i);
    i++;
  }
}

