#include <allegro.h>
#include <string.h>
#include <stdio.h>
#include "Game.h"
#include "Highscore.h"
#include "music.h"

extern BITMAP* buffer;
extern int WIDTH, HEIGHT;
extern int RATE;

extern GameResults gameResults;
extern int logicLeft;

static FONT* fnt_sans;
static BITMAP* black;
static BITMAP* scrollbmp;
static int scrollpos;
static char* scrolltext;
static int scrolltime;

typedef struct {
  char name[21];
  int score;
} Entry;

static struct {
  Entry entries[10];
} Scores;

static void Highscore_load()
{
  FILE* f;
  int i,c;
  char chr;
  int num;
	int readc;

  f = fopen("scores.lly","rb");
  if (!f)
  {
    return; //Default values will take over
  }
  for (i=0; i<10; ++i)
  {
    Entry* e = &Scores.entries[i];
    for(c=0; c<20; ++c)
    {
      readc = fread(&chr,sizeof(char),1,f);
      e->name[c] = chr^13;
    }
    e->name[20] = 0;
    readc = fread(&num,sizeof(int),1,f);
    e->score = num^13;
  }
  fclose(f);
}

static void Highscore_save()
{
  FILE* f;
  int i,c;
  char chr;
  int num;
	int writec;

  f = fopen("scores.lly","wb");
  for (i=0; i<10; ++i)
  {
    Entry* e = &Scores.entries[i];
    for(c=0; c<20; ++c)
    {
      chr = e->name[c]^13;
      writec = fwrite(&chr,sizeof(char),1,f);
    }
    num = e->score^13;
    writec = fwrite(&num,sizeof(int),1,f);
  }
  fclose(f);
}

static void Highscore_cleanup()
{
  Highscore_save();
  destroy_bitmap(black);
  destroy_font(fnt_sans);
  music_stop();
}

static void insertScore(int i, int score)
{
  int j;
  for (j=10-1; j>i; --j)
  {
    Scores.entries[j] = Scores.entries[j-1];
  }
  Scores.entries[i].score = score;
  memset(Scores.entries[i].name,0,20);
}

//Input
static int input;
static int cursor;
static int newpos;

//Screen timing
static int init;
static int stay;
static int exit_;

static void Highscore_insert()
{
  int i;
  for (i=0; i<10; ++i)
  {
    if (Scores.entries[i].score < gameResults.finalScore)
    {
      insertScore(i,gameResults.finalScore);
      input = 1;
      newpos = i;
      break;
    }
  }
}

static void updateScroller()
{
	static int d=0;
	scrollpos-=1+d;
	d^=1;
	if (scrollpos < -scrollbmp->w) scrollpos = 0;
	scrolltime++;
}

static void Highscore_input()
{
  Entry* e = &Scores.entries[newpos];
  int k,c;
  k = readkey();
  clear_keybuf();
  c = k&0xff;
  if ((c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || (c >= '0' && c <= '9'))
  {
    e->name[cursor] = (char)c;
    cursor++;
    if (cursor >= 20)
    {
      input = 0;
      stay = 201;
    }
  }
  else if (k>>8 == KEY_BACKSPACE && cursor > 0) //Backspace
  {
    cursor--;
    e->name[cursor] = 0;
  }
  else if (k>>8 == KEY_ENTER) //Return
  {
    input = 0;
    stay = 201;
  }
  logicLeft = 0; //Hack to account for readkey logic delay
}

static void generateScrolltext()
{
	int hours, minutes, seconds;
	char* lbuf = malloc(100);
	char* buf = malloc(1024*8);
	int rnd;
	buf[0] = 0;
#define append(x) \
strcat(buf,x);\
strcat(buf,"                                                                   ")
	rnd = rand()%5;
	switch (rnd)
	{
		case 0:
			append("As every way comes to its end, your game is over now.");
			break;
		case 1:
			append("Do you see the plane, high above the ground, higher than earth itself?");
			break;
		case 2:
			append("Game is over. And somewhere, a little girl rests in peace.");
			break;
		case 3:
			append("Moments ago, the air was full with laughter and explosions. Can you believe it?");
			break;
		case 4:
			append("So much fire, so many flames, and no one can dance anymore.");
			break;
	}
	append("But don't worry   ...   Lily is free now.");
	sprintf(lbuf, "Your final score: %d", gameResults.finalScore); append(lbuf);
	if (input) // A new highscore
	{
		switch (newpos)
		{
			case 0:
				append("And a new god was born. Your place is on the lonely top.");
				break;
			case 1:
				append("You were awfully good, but somewhere, someone did better than you.");
				break;
			case 2:
				append("Third place, and still no bronze medal. You would have earned it.");
				break;
			case 3:
				append("A well deserved fourth place.");
				break;
			case 4:
				append("Fifth place - still in the upper half.");
				break;
			case 5:
				append("Sixth place - today is a good day.");
				break;
			case 6:
				append("Seventh place - you are famous now.");
				break;
			case 7:
				append("Eighth place - that's not bad at all.");
				break;
			case 8:
				append("Ninth place - still an achievment.");
				break;
			case 9:
				append("By sheer luck, you made the top ten.");
				break;
		}
	}
	else
	{
		rnd = rand()%5;
		switch (rnd)
		{
			case 0:
				append("Sorry, but that didn't earn you a medal.");
				break;
			case 1:
				append("It's a shame, but that didn't do it.");
				break;
			case 2:
				append("We all know you tried hard, but trying isn't an achievment.");
				break;
			case 3:
				append("You want your name in the top ten? Try again!");
				break;
			case 4:
				append("Hint: Try to dodge explosions next time.");
				break;
		}
	}
	
	seconds = gameResults.secondsSurvived;
	minutes = seconds/60;
	seconds -= minutes*60;
	hours = minutes/60;
	minutes -= hours*60;
	if (hours > 0)
	{
		sprintf(lbuf,"You survived for %d hours, %d minutes and %d seconds",hours,minutes,seconds); append(lbuf);
	}
	else if (minutes > 0)
	{
		sprintf(lbuf,"You survived for %d minutes and %d seconds",minutes,seconds); append(lbuf);
	}
	else
	{
		sprintf(lbuf,"You survived for %d seconds",seconds); append(lbuf);
	}
	/*
	sprintf(lbuf,"There were %d planes. You killed %d of them and dodged %d falling planes.", 
		gameResults.planesMissed+gameResults.planesKilled,gameResults.planesKilled,gameResults.planesDodged);
	append(lbuf);*/
	sprintf(lbuf,"You fired %d strokes of lightning, where %d of them killed someone.",
		gameResults.lightningHit+gameResults.lightningMissed, gameResults.lightningHit);
	append(lbuf);
	sprintf(lbuf,"You made %d lightning combos (hit at least 3 planes with one lightning stroke).",
		gameResults.comboCount);
	append(lbuf);
	/*sprintf(lbuf,"There were %d bomb explosions. You got hit by %d of them.",
		gameResults.bombsDodged+gameResults.bombsHit, gameResults.bombsHit);
	append(lbuf);*/
	append("You killed 1 child. 1 of them was your best friend.");
	append("That's all.");
	append("oOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOoOo");

	scrolltext = strdup(buf);
	free(buf);
	free(lbuf);
}

void Highscore_init()
{
  int i;

  init = 0;
  stay = 0;
  exit_ = 50;

  input = 0;
  cursor = 0;
  newpos = -1;

  fnt_sans = load_font("media/font/sans.pcx",NULL,NULL);
  black = create_bitmap(WIDTH,HEIGHT);
  clear(black);

  for (i=0; i<10; ++i)
  {
    strcpy(Scores.entries[i].name,"Simon");
    Scores.entries[i].score = 20000 - i*1250;
  }
  Highscore_load();
  Highscore_insert();

	generateScrolltext();
	scrollpos = WIDTH;
  scrollbmp = create_bitmap(text_length(fnt_sans,scrolltext)+1,text_height(fnt_sans)+1);
  clear_to_color(scrollbmp,makecol16(255,0,255));
  textout_ex(scrollbmp,fnt_sans,scrolltext,1,1,makecol16(100,100,150),-1);
  textout_ex(scrollbmp,fnt_sans,scrolltext,0,0,makecol16(200,200,255),-1);
	scrolltime = 0;

  clear_keybuf();
  key[KEY_ESC] = 0;
  music_play("media/music/9.xm",1);
}

LogicReturn Highscore_logic()
{
	updateScroller();
  if (init <= 50)
  {
    init++;
    return LR_NOOP;
  }
  else if (stay < 200)
  {
    if (!input)
    {
      stay++;
    }
    else
    {
			if (keypressed())
			{
      	Highscore_input();
			}
    }
  }
  else if (exit_ <= 50)
  {
    if (keypressed())
    {
      exit_--;
    }
    if (exit_ < 0)
    {
      Highscore_cleanup();
      Game_ChangeState(STATE_TITLE);
      return LR_EXIT;
    }
  }
  if (key[KEY_ESC])
  {
    stay = 201;
    key[KEY_ESC] = 0;
  }
  return LR_NOOP;
}

static void draw_scroller()
{
	static int last_time = 0;
  int w = scrollbmp->w+scrollpos;
  const int y = HEIGHT-scrollbmp->h-1;
  DUMB_IT_SIGRENDERER* mrnd = music_get_renderer();
  const int cur_music_row = dumb_it_sr_get_current_row(mrnd);
  int mrow = cur_music_row%9;
	int beat, linecolor, color;
	int decay; // Ticks since last beat
	int fade; // Calculated from decay
	int tmpvalue; // Temporary color component holder
	if (last_time == 0)
	{
		last_time = scrolltime;
	}
	if (mrow%3 == 0)
	{
		last_time = scrolltime;
	}
	decay = scrolltime - last_time;
	fade = decay*100/RATE; // color drops 100 points per second

	beat = mrow/3;
	switch (beat)
	{
		case 0:
			tmpvalue = 200-fade;
			if (tmpvalue < 0) tmpvalue = 0;
			linecolor = makecol16(tmpvalue*2/3+55,tmpvalue/3+55,tmpvalue+55);
			color = makecol16(tmpvalue*3/5,tmpvalue/2,tmpvalue);
			break;
		case 1:
			tmpvalue = 200-fade;
			if (tmpvalue < 0) tmpvalue = 0;
			linecolor = makecol16(tmpvalue/2+55,tmpvalue/2+55,tmpvalue+55);
			color = makecol16(tmpvalue/2,tmpvalue/2,tmpvalue);
			break;
		case 2:
			tmpvalue = 200-fade;
			if (tmpvalue < 0) tmpvalue = 0;
			linecolor = makecol16(tmpvalue/3+55,tmpvalue/2+55,tmpvalue+55);
			color = makecol16(tmpvalue/3,tmpvalue/2,tmpvalue);
			break;
	}

  line(buffer,0,y-1,WIDTH,y-1,linecolor);
  rectfill(buffer,0,y,WIDTH,HEIGHT,color);
  if (w > WIDTH) w = WIDTH;
  masked_blit(scrollbmp,buffer,-scrollpos,0,0,y,WIDTH,scrollbmp->h);
  if (w < WIDTH)
  {
    masked_blit(scrollbmp,buffer,0,0,w,y,WIDTH-w,scrollbmp->h);
  }
}

static void draw_bg()
{
  int c = 0;
  int y = 0;
  for (y=0; y<HEIGHT; ++y)
  {
    c = y*200/HEIGHT;
    hline(buffer,0,y,WIDTH,makecol16(c,c,255));
  }
}

static void draw_shadow()
{
  if (init <= 50)
  {
    set_trans_blender(255,255,255,255 - init*255/50);
    draw_trans_sprite(buffer,black,0,0);
  }
  else if (exit_ <= 50)
  {
    set_trans_blender(255,255,255,255 - exit_*255/50);
    draw_trans_sprite(buffer,black,0,0);
  }
}

static void draw_title()
{
  const int top = 50;
  textout_centre_ex(buffer,fnt_sans,"TOP 10 PLAYERS",WIDTH/2+1,top,makecol16(0,0,50),-1);
  textout_centre_ex(buffer,fnt_sans,"TOP 10 PLAYERS",WIDTH/2,top,makecol16(255,255,255),-1);
}

static void draw_entries()
{
  int i;
  int c = 200;
  const int top = 100;
  const int height = text_height(fnt_sans) + 5;
  char text[36]; //A few more than needed, just in case
  for (i=0; i<10; ++i)
  {
    if (i == newpos && input)
    {
      sprintf(text,"%s| %12d",Scores.entries[i].name,Scores.entries[i].score);
    }
    else
    {
      sprintf(text,"%s %12d",Scores.entries[i].name,Scores.entries[i].score);
    }
    textout_centre_ex(buffer,fnt_sans,text,WIDTH/2+1,top+i*height+1,makecol16(100-c/2,100-c/2,100-c/2),-1);
    textout_centre_ex(buffer,fnt_sans,text,WIDTH/2,top+i*height,makecol16(c+55,c,10),-1);
    c -= 9;
  }
}

static void draw_input()
{ // Currently not needed as the input cared gets appended to the entry name and drawn with it
}

void Highscore_draw()
{
  draw_bg();
  draw_title();
  draw_entries();
  draw_input();
	draw_scroller();
  draw_shadow();
}

