#define KILL_WIDESCREEN 0

#include <allegro.h>
#include <string.h>
#include <stdio.h>

#include "Game.h"
#include "music.h"

const int WIDTH = 640;
const int HEIGHT = 480;
const int RATE = 60;
int WSCRWIDTH;
int WIDESCREEN = 0;
int FULLSCREEN = 0;

volatile int logicLeft = 0;
BITMAP* buffer;
BITMAP* wscrbuf[16];

static void logicCount()
{
  logicLeft++;
}

void create_wscrbuf()
{
  int normalw = SCREEN_H * 1333 / 1000;
  int dw = SCREEN_W - normalw;
  int ldw = dw/2;
  int i,j;

  WSCRWIDTH = normalw;

  for (i=0;i<16;++i)
  {
    wscrbuf[i] = create_bitmap(ldw,SCREEN_H);
    clear_to_color(wscrbuf[i],makecol16(255,255,255));
    for (j=0;j<ldw*SCREEN_H*2/3;++j)
    {
      _putpixel16(wscrbuf[i],rand()%wscrbuf[i]->w,rand()%wscrbuf[i]->h,makecol16(0,0,0));
    }
  }
}

void destroy_wscrbuf()
{
}

int main(int argc, char** argv)
{
  int _gfx_mode = GFX_AUTODETECT_WINDOWED;
#if KILL_WIDESCREEN
  int scrw,scrh;
#endif

  allegro_init();
  install_timer();
  install_keyboard();
  install_mouse();
#ifdef DIGI_ALSA
if (install_sound(DIGI_ALSA,MIDI_NONE,0) != 0)
{
#endif
  if (install_sound(DIGI_AUTODETECT,MIDI_NONE,0) != 0)
  {
    fprintf(stderr,"WAAAH! Sound not working!\n");
  }
#ifdef DIGI_ALSA
}  
#endif
  music_init();
  
  set_color_depth(16);
  if (argc > 1 && strcmp(argv[1],"-f") == 0)
  {
    _gfx_mode = GFX_AUTODETECT_FULLSCREEN;
    FULLSCREEN = 1;
#if KILL_WIDESCREEN
    get_desktop_resolution(&scrw,&scrh);
    if (scrw*100/scrh > 150)
    { // F*CKING WIDESCREEN
      WIDESCREEN = 1;
      set_gfx_mode(_gfx_mode,scrw,scrh,0,0);
    }
    else
#endif
    {
      set_gfx_mode(_gfx_mode,WIDTH,HEIGHT,0,0);
    }
  }
  else
  {
    set_gfx_mode(_gfx_mode,WIDTH,HEIGHT,0,0);
  }
  buffer = create_bitmap(640,480);
  clear(buffer);
  rest(500);
  install_int_ex(logicCount,BPS_TO_TIMER(RATE));
  if (WIDESCREEN)
  {
    create_wscrbuf();
  }

  Game();

  if (WIDESCREEN)
  {
    destroy_wscrbuf();
  }
  remove_int(logicCount);
  music_quit();
  printf("===== Thanks for playing! =====\n");
  allegro_exit();
  return 0;
}
END_OF_MAIN();

