/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include <FMOD/fmod.h>

#include <allegro.h>
#include "main.h"
#include "bsgExplosion.h"
#include "spartan.h"
#include "AIdef.h"
#include "Particle.h"


Bitmap    * g_pimMissile=NULL;
Bitmap    * g_pimMissileShadow=NULL;

bsgSpartan::~bsgSpartan()
{


}


bsgSpartan::bsgSpartan()
{
m_blPlayerBullet=false;
m_fSpeed=0;
m_nZ=2;
m_pTarget=NULL;
m_nMaxHealth=100;
m_nHealth=m_nMaxHealth;
m_fSteer=0.04;
m_nType=ID_MISSILE;
m_blDestroyed=false;
m_blCanCollide=false;
SetImage(g_pimMissile);
SetShadow(g_pimMissileShadow);
m_fFuel=400;
m_blIgnited=false;
}

void bsgSpartan::DoCollision(bsgSprite * a_pSprite)
{
if ((a_pSprite!=NULL)&& (a_pSprite->m_nTeam!=m_nTeam)&& (a_pSprite->m_nType>ID_NONE))
   {
        a_pSprite->m_nHealth-=300;
        m_fFuel=0;
        m_nHealth=0;
        m_fSpeed=a_pSprite->m_fSpeed;

        if (a_pSprite->m_nHealth>0)
        {
            IncScore(1);
        }
        else
        {
            IncScore(10);
        }
    }
};


void bsgSpartan::do_ai(float a_fLagCount)
{
if (m_blIgnited)
   {
   m_blCanCollide=true;
   m_fFuel-=a_fLagCount;
   int nOfsx=2;
   int nOfsy=1;
   float l1x=(m_fX+((-nOfsx*m_fCosAngle)-(-nOfsy*m_fSinAngle)));
   float l1y=(m_fY+((-nOfsy*m_fCosAngle)+(-nOfsx*m_fSinAngle)));
   float fSpread,fSpread2;

   for (int i=0;i<10;i++)
       {
       fSpread=float((rand()%1000)-500)/20000;
       fSpread2=float(rand()%100)/60;
       bsgParticle * p;
       p=new(bsgParticle);
       p->m_nZ=m_nZ-1;
       p->m_fX=l1x;
       p->m_fY=l1y;
       p->m_fAngle=m_fAngle+fSpread;
       p->m_fSpeed=m_fSpeed - fSpread2;
       m_pEngine->add(p);
       }

   if (m_fSpeed < 15) m_fSpeed+=a_fLagCount*0.03;
   if ((m_pTarget!=NULL)&&(m_pTarget->m_blDestroyed)) m_pTarget=NULL;

   if ((m_pTarget!=NULL)&&(!m_pTarget->m_blDestroyed))
      {
         m_fAngleSeek=waypoint(m_pTarget->m_fX,m_pTarget->m_fY);
      }
   else
      {
       m_fAngleSeek=m_fAngle;
      }

   if ( m_fFuel<340)
      {
        Control();
      }
   }
else
   {
      m_pTarget=SeekTarget();
      if ((m_pTarget!=NULL)&&(distance(m_fX,m_fY,m_pTarget->m_fX,m_pTarget->m_fY)<400))
         {
            m_blIgnited=true;
         }
   }


if ((m_fFuel<=0)&&(!m_blDestroyed))
   {
   m_blDestroyed=true;
   m_blCanCollide=false;
   m_nHealth=0;
   bsgExplosion * e;
   e=new(bsgExplosion);
   e->m_nZ=m_nZ+1;
   e->m_fX=m_fX;
   e->m_fY=m_fY;
   e->m_fAngle=m_fAngle;
   e->m_fSpeed=m_fSpeed;
   m_pEngine->add(e);

   float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
   int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_EXPLODE));
   if (fD<400)
   {
      FSOUND_SetVolume(nCannelHandle,255);
   }
   else
   {
      FSOUND_SetVolume(nCannelHandle,100);
   }


   }
};


void bsgSpartan::Control()
{
    float fStr=m_fSteer;
    if ((m_fAngle<m_fAngleSeek)&&(m_fAngleSeek-m_fAngle>PI))
    {
        fStr=-fStr;
    }
    if ((m_fAngleSeek<m_fAngle)&&(m_fAngle-m_fAngleSeek>PI))
    {
        fStr=-fStr;
    }
    if (m_fAngleSeek-m_fAngle>0.05)
    {
        m_fAngle+=fStr;
    }
    if (m_fAngle-m_fAngleSeek>0.05)
    {
        m_fAngle-=fStr;
    }
    if (m_fAngle>2*PI)
    {
        m_fAngle=m_fAngle-(2*PI);
    }
    if (m_fAngle<0)
    {
        m_fAngle=(2*PI)+m_fAngle;
    }
    if (m_fAngleSeek>2*PI)
    {
        m_fAngleSeek=m_fAngleSeek-(2*PI);
    }
    if (m_fAngleSeek<0)
    {
        m_fAngleSeek=(2*PI)+m_fAngleSeek;
    }
}


bool LoadMissileSprites()
{
    g_pimMissile = new Bitmap("Gfx/Still/spartan.png");
    g_pimMissileShadow = new Bitmap("Gfx/Still/spartanshd.png");

    if ((g_pimMissile!=NULL)&&(g_pimMissileShadow!=NULL))
    {
            return true;
    }
    else
    {
           return false;
    }
}







