/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#ifndef _BSGSHIP
#define _BSGSHIP
#include "Engine.h"



class bsgShip:public bsgSprite
{
protected:
    int m_nAI;
    int m_nOldAI;
    int m_nFireDelay;
    int m_nCurrentFriend,m_nCurrentEnemy;
    float m_fSteer;
    float m_fFireDelaySpartan;
    bool Ai_Move(float a_fLagCount);
    void Ai_Escort(float a_fLagCount);
    int m_nWaypointX;
    int m_nWaypointY;




public:

    bsgShip();
    virtual ~bsgShip();

    float m_fAngleSeek;

    bool m_blLaunching,m_blDocking;
    int m_blRetreat;

    int m_nTargetType;
    void FireSpartan();
    int m_nMissiles;
    int m_nID;
    int m_nEscortID;

    float m_fWX,m_fWY;// waypoints for missions

    bsgShip * m_pTarget;
    bsgShip * m_pHardcodedTarget;
    bsgShip * m_pEscort;

    float m_fWantedSpeed;
    double evade(float a_fTX,float a_fTY,int a_nWidth,int a_nLength);
    void SetWaypoint(float a_fX,float a_fY,bool a_blIgnoreTargets);
    virtual void DoCollision(bsgSprite * a_pSprite);
    virtual void Control();
    virtual bsgShip * SeekTarget();
    bsgShip * bsgShip::SeekObstacle();
    bsgShip * SeekTarget(int a_nType);
    bsgShip * SeekFriend(int a_nType);
    bsgShip * SeekNextFriend();
    bsgShip * SeekNextEnemy();
    void SeekEscort();
    virtual void draw(int a_nCameraX,int a_nCameraY);

};





#endif

