/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <FMOD/fmod.h>

#include "bsgShip.h"
#include "main.h"
#include "AIdef.h"
#include "bsgSmoke.h"
#include "spartan.h"
#include "bsgBullet.h"

extern TextRenderer * g_pTahoma;
extern float g_fRotation;
extern bool g_blDebug;

bsgShip::bsgShip()
{
    m_blCanCollide=true;
    m_nMissiles=0;
    m_nMaxHealth=400;
	m_nHealth=m_nMaxHealth;
    m_fX=5000;
    m_fY=5000;
    m_nZ=10;
    m_fWantedSpeed=0;
    m_fSteer=0.02;
    m_fAngleSeek=0;
    m_pTarget=NULL;
    m_nType=ID_SHIP;
    m_nTargetType=ID_ANY;
    m_nOldAI = AI_NONE;
    m_blMustSurvive=false;
    m_fWX=0;
    m_fWY=0;
    m_pHardcodedTarget=NULL;
    m_pEscort=NULL;
    m_nID = 0;
    m_nEscortID = 0;
    m_blRetreat = false;
    m_fFireDelaySpartan=0;
    m_nCurrentFriend=1;
    m_nCurrentEnemy=1;
}

bsgShip::~bsgShip()
{


}




void bsgShip::DoCollision(bsgSprite * a_pSprite)
{
    if ((a_pSprite!=NULL)&& (a_pSprite->m_nType>ID_NONE)&&(a_pSprite->m_nType<ID_BULLET)&&(a_pSprite->m_nTeam!=m_nTeam))
    {
        if (((bsgBullet *)a_pSprite)->m_fEnergy<85)
        {

        bsgSmoke * pS;
        pS=new bsgSmoke;
        pS->m_fX=a_pSprite->m_fX;
        pS->m_fY=a_pSprite->m_fY;
        pS->m_fAngle=m_fAngle;
        pS->m_fSpeed=m_fSpeed-0.1;
        pS->m_nZ=m_nZ+1;
        m_pEngine->add(pS);
        m_nHealth-=35;

        if (((bsgBullet *)a_pSprite)->m_blPlayerBullet)
        {
            if (m_nHealth>0)
            {
               IncScore(1);
            }
            else
            {
                IncScore(10);
            }
        }

        a_pSprite->m_blDestroyed=true;

        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_HIT));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }

        }
   }
}

void bsgShip::Control()
{
    float fStr=m_fSteer;
    if (m_fSpeed<0.5) fStr=0;

    if (m_fAngle<m_fAngleSeek)
    {
       fStr=m_fAngleSeek-m_fAngle;
    }

    if (m_fAngleSeek<m_fAngle)
    {
       fStr=m_fAngle-m_fAngleSeek;
    }

    if (fStr>m_fSteer)
    {
      fStr=m_fSteer;
    }

    if ((m_fAngle<m_fAngleSeek)&&(m_fAngleSeek-m_fAngle>PI))
    {
        fStr=-fStr;
    }
    if ((m_fAngleSeek<m_fAngle)&&(m_fAngle-m_fAngleSeek>PI))
    {
        fStr=-fStr;
    }
    if (m_fAngleSeek-m_fAngle>(fStr*2))
    {
        m_fAngle+=fStr;
    }
    if (m_fAngle-m_fAngleSeek>(fStr*2))
    {
        m_fAngle-=fStr;
    }
    if (m_fAngle>2*PI)
    {
        m_fAngle=m_fAngle-(2*PI);
    }
    if (m_fAngle<0)
    {
        m_fAngle=(2*PI)+m_fAngle;
    }
    if (m_fAngleSeek>2*PI)
    {
        m_fAngleSeek=m_fAngleSeek-(2*PI);
    }
    if (m_fAngleSeek<0)
    {
        m_fAngleSeek=(2*PI)+m_fAngleSeek;
    }




}



void bsgShip::SeekEscort()
{
    bool blReady = false;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    while ((p!=m_pEngine->m_lstItems.end())&&(!blReady))
    {
        bsgSprite * pHulp=((bsgSprite *)*p);
        if (pHulp->m_nType >= ID_SHIP)
        {
            if ((((bsgShip *)pHulp)->m_nID == m_nEscortID)&&(m_nEscortID>0))
            {
                m_pEscort = ((bsgShip *)pHulp);
                blReady = true;
            }
        }
        p++;
    }
}


bsgShip * bsgShip::SeekTarget()
{
    bsgSprite * pTarget=NULL;
    float nDist=VIEW_DISTANCE;
    float nD;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    while (p!=m_pEngine->m_lstItems.end())
    {
        bsgSprite * pHulp=((bsgSprite *)*p);
        if ((pHulp->m_nTeam!=m_nTeam)&&(!pHulp->m_blDestroyed)&&(!pHulp->m_blDisabled)&&(pHulp->m_nType>=ID_TARGETABLE)&&(pHulp!=this))
        {
            nD=distance(m_fX,m_fY,pHulp->m_fX,pHulp->m_fY);
            if (nD<=nDist)
            {
                pTarget=pHulp;
                nDist=nD;
            }
        }
        p++;
    }
    return ((bsgShip *) pTarget);
}


bsgShip * bsgShip::SeekObstacle()
{
    bsgSprite * pTarget=NULL;
    float nDist=200;
    float nD;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    while (p!=m_pEngine->m_lstItems.end())
    {
        bsgSprite * pHulp=((bsgSprite *)*p);
        if ((pHulp->m_nZ>6)&&(!pHulp->m_blDestroyed)&&(!pHulp->m_blDisabled)&&(pHulp->m_nType>=ID_TARGETABLE)&&(pHulp!=this))
        {
            nD=distance(m_fX,m_fY,pHulp->m_fX,pHulp->m_fY);
            if (nD<=nDist)
            {
                pTarget=pHulp;
                nDist=nD;
            }
        }
        p++;
    }
    return ((bsgShip *) pTarget);
}




bsgShip * bsgShip::SeekTarget(int a_nType)
{
    bsgSprite * pTarget=NULL;
    float nDist=VIEW_DISTANCE;
    float nD;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    while (p!=m_pEngine->m_lstItems.end())
    {
        bsgSprite * pHulp=((bsgSprite *)*p);
        if ((pHulp->m_nTeam!=m_nTeam)&&(!pHulp->m_blDestroyed)&&(!pHulp->m_blDisabled)&&(pHulp->m_nType==a_nType)&&(pHulp!=this))
        {
            nD=distance(m_fX,m_fY,pHulp->m_fX,pHulp->m_fY);
            if (nD<=nDist)
            {
                pTarget=pHulp;
                nDist=nD;
            }
        }
        p++;
    }
    return ((bsgShip *) pTarget);
}

bsgShip * bsgShip::SeekFriend(int a_nType)
{
    bsgSprite * pTarget=NULL;
    float nDist=VIEW_DISTANCE;
    float nD;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    while (p!=m_pEngine->m_lstItems.end())
    {
        bsgSprite * pHulp=((bsgSprite *)*p);
        if ((pHulp->m_nTeam==m_nTeam)&&(!pHulp->m_blDestroyed)&&(!pHulp->m_blDisabled)&&((pHulp->m_nType==a_nType)||(a_nType==ID_ANY))&&(pHulp!=this))
        {
            nD=distance(m_fX,m_fY,pHulp->m_fX,pHulp->m_fY);
            if (nD<=nDist)
            {
                pTarget=pHulp;
                nDist=nD;
            }
        }
        p++;
    }
    return ((bsgShip *) pTarget);
}


bsgShip * bsgShip::SeekNextFriend()
{
    bsgSprite * pTarget=NULL;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    int nNr=0;
    while (p!=m_pEngine->m_lstItems.end())
    {
        bsgSprite * pHulp=((bsgSprite *)*p);
        if ((pHulp->m_nTeam==MEM_COLONY)&&(pHulp->m_nType>=ID_TARGETABLE)&&(!pHulp->m_blDisabled)&&(!pHulp->m_blDestroyed)&&(pHulp!=this))
        {
            nNr++;
            if (nNr==m_nCurrentFriend)
            {
                pTarget=pHulp;
            }
        }
        p++;
    }

    if ((pTarget==NULL)&&(nNr>0))
    {
        m_nCurrentFriend=1;
        pTarget=SeekNextFriend();
    }
    else
    {
        m_nCurrentFriend++;
    }

    return ((bsgShip *) pTarget);
}

bsgShip * bsgShip::SeekNextEnemy()
{
    bsgSprite * pTarget=NULL;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    int nNr=0;
    while (p!=m_pEngine->m_lstItems.end())
    {
        bsgSprite * pHulp=((bsgSprite *)*p);
        if ((pHulp->m_nTeam==MEM_CYLON)&&(pHulp->m_nType>=ID_TARGETABLE)&&(!pHulp->m_blDisabled)&&(!pHulp->m_blDestroyed)&&(pHulp!=this))
        {
            nNr++;
            if (nNr==m_nCurrentEnemy)
            {
                pTarget=pHulp;
            }
        }
        p++;
    }

    if ((pTarget==NULL)&&(nNr>0))
    {
        m_nCurrentEnemy=1;
        pTarget=SeekNextEnemy();
    }
    else
    {
        m_nCurrentEnemy++;
    }
    return ((bsgShip *) pTarget);
}




void bsgShip::FireSpartan()
{

    if ((m_fFireDelaySpartan<=0)&&(m_nMissiles>0))
    {
        bsgSpartan * pS;
        int nOfsX=-5;
        int nOfsY=0;

        float fL1X=(m_fX+((-nOfsX*cos(m_fAngle))-(-nOfsY*sin(m_fAngle))));
        float fL1Y=(m_fY+((-nOfsY*cos(m_fAngle))+(-nOfsX*sin(m_fAngle))));

        pS=new bsgSpartan;
        pS->m_fX=fL1X;
        pS->m_fY=fL1Y;
        pS->m_nZ=m_nZ-1;
        pS->m_blIgnited=true;

        if ((m_pTarget!=NULL)&&(m_pTarget->m_nTeam!=m_nTeam))
        {
           pS->m_pTarget=m_pTarget;
        }
        else
        {
          pS->m_pTarget=NULL;
        }

        pS->m_fSpeed=m_fSpeed;
        pS->m_fAngle=m_fAngle;
        pS->m_nTeam=m_nTeam;

        if (m_nType==ID_PLAYER)
        {
           pS->m_blPlayerBullet=true;
        }

        m_pEngine->add(pS);
        m_fFireDelaySpartan=600;
        m_nMissiles--;
    }
}



void bsgShip::SetWaypoint(float a_fX,float a_fY,bool a_blIgnoreTargets)
{
  m_fWX=a_fX;
  m_fWY=a_fY;
  if (m_nType!=ID_PLAYER) m_fSpeed=m_fMaxSpeed/3;
  if (a_blIgnoreTargets)
  {
     m_nAI=AI_MOVE;
  }
  else
  {
     m_nAI=AI_CHASE;

  }
}


void bsgShip::Ai_Escort(float a_fLagCount)
{
    if (m_pEscort!=NULL)
    {
       m_fAngleSeek=waypoint(m_pEscort->m_fX,m_pEscort->m_fY);
       float dist = distance(m_fX,m_fY,m_pEscort->m_fX,m_pEscort->m_fY);
       m_fSpeed=dist/50;

       if (m_fSpeed>m_fMaxSpeed)
        {
            m_fSpeed=m_fMaxSpeed;
        }

        if (m_fSpeed<m_fMaxSpeed/2)
        {
            m_fSpeed=m_fMaxSpeed/2;
        }

       if (dist <100)
       {
          m_nAI=m_nOldAI;
       }

    }
    else
    {
      m_nAI=m_nOldAI;
    }

}

bool bsgShip::Ai_Move(float a_fLagCount)
{
    m_fSpeed = m_fMaxSpeed/2;
    m_fAngleSeek=waypoint(m_fWX,m_fWY);
    float fD = distance(m_fX,m_fY,m_fWX,m_fWY);
    if (fD<100)
    {
        if (m_blRetreat)
        {
           m_blDisabled  = true;
           m_blOutOfGame = true;
        }
        return true;
    }
    else
    {
        return false;
    }
}


double bsgShip::evade(float a_fTX,float a_fTY,int a_nWidth,int a_nLength)
{
   float fL    = a_fTX - m_fX;
   float fW    = a_fTY - m_fY;
   int Width = a_nWidth/2;

   float CosAngle = cos(-m_fAngle);
   float SinAngle = sin(-m_fAngle);

   int PX = int (m_fX + m_fCosAngle * fL - m_fSinAngle * fW);
   int PY = int (m_fY + m_fSinAngle * fL + m_fCosAngle * fW);

   if ((PX > m_fX) && (PX < m_fX+a_nLength)&&
       (PY > m_fY-Width)&&(PY < m_fY+Width))
   {
       if (PY < m_fY)
	   {
			return -1;
	   }
	   else
	   {
			return 1;
	   }
   }
   else
   {
		return 0;
   }
}



void bsgShip::draw(int a_nCameraX,int a_nCameraY)
{
  bsgSprite::draw(a_nCameraX,a_nCameraY);


  if (g_blDebug)
  {
    int nDrawX=int(SCREENCENTER_X+(m_fX-a_nCameraX));
    int nDrawY=int(SCREENCENTER_Y+(m_fY-a_nCameraY));

    if (m_pTarget!=NULL)
    {
        int nTDrawX=int(SCREENCENTER_X+(m_pTarget->m_fX-a_nCameraX));
        int nTDrawY=int(SCREENCENTER_Y+(m_pTarget->m_fY-a_nCameraY));

        if (m_nTeam==MEM_COLONY)
        {
            GfxRend::Line(nDrawX, nDrawY, nTDrawX, nTDrawY,Rgba::BLUE);
        }
        else
        {
            GfxRend::Line(nDrawX, nDrawY, nTDrawX, nTDrawY,Rgba::RED);
        }
    }


    switch (m_nAI)
    {
        case AI_NONE:
             GfxRend::Circle(nDrawX, nDrawY, 20,Rgba::BLACK);
            break;

        case AI_CHASE:
             GfxRend::CircleOutline(nDrawX, nDrawY, 20,Rgba::RED);
             break;

        case AI_EVADE :
             GfxRend::CircleOutline(nDrawX, nDrawY, 20,Rgba::GREEN);
             break;

        case AI_MOVE :
             GfxRend::CircleOutline(nDrawX, nDrawY, 20,Rgba::BLUE);
             break;

        case AI_WANDER :
             GfxRend::CircleOutline(nDrawX, nDrawY, 20,Rgba::BLACK);
             break;

        case AI_HOLD   :
             GfxRend::CircleOutline(nDrawX, nDrawY, 20,Rgba::BLACK);
             break;

        case AI_GET_BULLETS:
             g_pTahoma->Print("BULLETS",nDrawX, nDrawY);
             break;

        case AI_DOCK:
             GfxRend::CircleOutline(nDrawX, nDrawY, 20,Rgba::YELLOW);
             break;

        case AI_PLAYER :
             GfxRend::CircleOutline(nDrawX, nDrawY, 20,Rgba::WHITE);
             break;

        case AI_LAUNCH :
             GfxRend::CircleOutline(nDrawX, nDrawY, 20,Rgba::BLACK);
             break;


    }
}


}






