/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <FMOD/fmod.h>
#include "main.h"
#include "AIDef.h"
#include "bsgPlayer.h"
#include "bsgExplosion.h"
#include "bsgBattlestar.h"

extern bool g_blDebug;


void bsgPlayer::do_ai(float a_fLagCount)
{
    if (g_blDebug)
    {
        m_nHealth=m_nMaxHealth;
    }



    if ((m_nHealth<=0)&&(!m_blDestroyed))
    {
        m_blDestroyed=true;
        bsgExplosion * pE;
        pE=new bsgExplosion;
        pE->m_nZ=m_nZ+1;
        pE->m_fX=m_fX;
        pE->m_fY=m_fY;
        pE->m_fAngle=m_fAngle;
        pE->m_fSpeed=m_fSpeed;
        m_pEngine->add(pE);
        FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_EXPLODE));
    }
    else if (m_blDocking)
    {
        Ai_Dock(a_fLagCount);
        Control();
    }
    else if (m_blLaunching)
    {
        Ai_Launch(a_fLagCount);
        Control();
    }
    else
    {
        // mouse steering

        if (m_nZ>2)
        {
            int nMX,nMY;
            float fDM;
            get_mouse_mickeys(&nMX,&nMY);
            fDM=nMX*0.005;
            if (fDM>0.1) fDM=0.1;
            if (fDM<-0.1)fDM=-0.1;
            m_fAngle+=fDM;

            if ((key[KEY_UP])||(key[KEY_W]))
            {
                m_fSpeed+=0.10;
            }
            else if ((key[KEY_DOWN])||(key[KEY_S]))
            {
                m_fSpeed -=0.10;
            }
            else if (m_fSpeed > 6.0)
            {
                m_fSpeed-=0.05;
            }




            if (m_fSpeed<0.0)
            {
                m_fSpeed=0.0;
            }

            if (m_fSpeed>10.0)
            {
                m_fSpeed=10.0;
            }

            if (key[KEY_LEFT])
            {
                m_fAngle-=(0.10 - m_fSpeed / 6.0 * 0.05);
            }

            if (key[KEY_RIGHT])
            {
                m_fAngle+=(0.10 - m_fSpeed / 6.0 * 0.05);
            }

            if ((key[KEY_SPACE])||(mouse_b & 1))
            {
                Fire();
            }

            if ((key[KEY_M])||(mouse_b & 2))
            {
                FireSpartan();
            }


            if ((key[KEY_E])&&(m_pTarget!=NULL))
            {
               m_fSpeed=m_pTarget->m_fSpeed;

            }

            if (key[KEY_B])
            {
               m_pTarget=(bsgShip *)m_pBattlestar;
            }


            if (key[KEY_D])
            {
               if (m_pBattlestar->m_pLeftBay!=NULL)
               {
                    m_nBAY=BAY_LEFT;
               }
               else if (m_pBattlestar->m_pRightBay!=NULL)
               {
                   m_nBAY=BAY_RIGHT;
               }


               if ((m_pBattlestar->m_pLeftBay!=NULL)||(m_pBattlestar->m_pRightBay!=NULL))
               {
                  if (distance(m_fX,m_fY,m_pBattlestar->m_fX,m_pBattlestar->m_fY)<500)
                  {
                     m_blDocking=true;
                  }

               }
            }


            if ((m_pTarget!=NULL)&&(m_pTarget->m_blDestroyed))
            {
                m_pTarget=NULL;
            }

            if (m_fFireDelay>0)
            {
                m_fFireDelay-=(a_fLagCount*2);
            }

            if (m_fFireDelaySpartan>0)
            {
                m_fFireDelaySpartan-=(a_fLagCount*2);
            }

        }

        if (key[KEY_T])
           {
              m_pTarget=SeekTarget();
           }

        if (key[KEY_F])
        {
           m_pTarget=SeekFriend(ID_ANY);
        }

        if ((key[KEY_R])&&(!m_blKey_R))
        {
           m_pTarget=SeekNextFriend();
           m_blKey_R=true;
        }

        if (!key[KEY_R])
        {
           m_blKey_R=false;
        }

        if ((key[KEY_Y])&&(!m_blKey_Y))
        {
           m_pTarget=SeekNextEnemy();
           m_blKey_Y=true;
        }

        if (!key[KEY_Y])
        {
           m_blKey_Y=false;
        }
    }


    // Truncate Angle
    if (m_fAngle>2*PI)
    {
       m_fAngle=m_fAngle-(2*PI);
    }

    if (m_fAngle<0)
    {
      m_fAngle=(2*PI)+m_fAngle;
    }

    m_nAI=AI_PLAYER;
}



bsgPlayer::bsgPlayer()
{



    m_blFireLinked      = true;
    m_blKey_X           = false;
    m_blOdd             = false;
    m_nTeam             = MEM_COLONY;
    m_nType             = ID_PLAYER;
    m_nAI               = AI_PLAYER;
    m_nBAY              = BAY_LEFT;
    m_fFireDelay        =  0;
    m_fSpeed            =  0;
    m_fMaxSpeed         =  6;
    m_fFireDelaySpartan =  0;
    m_fSteer            =  0.03;
    m_nMissiles         =  6;
    m_nZ                =  1;
}


bsgPlayer::~bsgPlayer()
{



}


