#ifndef _BSGMISSION
#define _BSGMISSION

#include <list>
#include <string>
#include <vector>

using namespace std;

class bsgSprite;
class bsgViper;
class bsgBattlestar;

class bsgMission
{
 private:
 // Must be destroyed for mission to succeed
 list <bsgSprite *>  m_vTargetGoal;

 // Must Survive for mission to succeed
 list <bsgSprite *>  m_vProtectGoal;




 // the current line
 int nLineIndex;
 // vector of lines describing the mission
 vector <string> m_vDescription;

 // vector of lines describing the mission
 vector <string> m_vEpilogue;


 // This ship MUST reach a certain position
 bsgSprite * m_pTraveler;

 // the game engine;
 bsgEngine  * m_pEngine;

 // The player
 bsgPlayer  * m_pPlayer;

 // The Battlestar
 bsgBattlestar  * m_pGalactica;

 string m_strNextMission;

 // the score in this mission;
 int m_nScore,
     m_nTargets,
     m_nProtects;

 float  m_fTX,
        m_fTY;

 bool m_blFail;


 protected:



 public:

 bool failed();
 bool succeeded();

  // constructor
 bsgMission();

 //Destructor
 ~bsgMission();

 // Update the Target and Protect lists
 void updateLists();

 void addTarget  ( bsgSprite * a_pSprite);
 void addCritical( bsgSprite * a_pSprite);
 int GetTargets();
 int GetProcects();

 bool m_blTargetEscaped;
 bsgPlayer * GetPlayer();
 bsgBattlestar * GetGalactica();

 string GetFirstLine();
 string GetNextLine();

 string GetFirstEpLine();
 string GetNextEpLine();
 string GetNextMission();

 bool readMission (bsgEngine  * a_pEngine,const char * a_szFilename);

};




#endif
