/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/



#ifndef _BSGBATTLESTAR
#define _BSGBATTLESTAR

#include "Engine.h"
#include "main.h"
#include "bsgTurret.h"
#include "bsgPlayer.h"
#include "bsgShip.h"
#include "bsgLeftBay.h"


class bsgBattlestar:public bsgSprite
{
private:
      bsgShip *  m_pTarget;

      float m_fLaunchTimer;
      int m_nEnemies;



public:

    bsgTurret * m_pTurret1;
    bsgTurret * m_pTurret2;
    bsgLeftBay * m_pLeftBay;
    bsgLeftBay * m_pRightBay;


    int m_nVipersInAction;

    bsgBattlestar();
    virtual ~bsgBattlestar();

    int m_nVipersBay1;
    int m_nVipersBay2;
    int m_nShuttles;


    bool m_blIncoming1;
    bool m_blIncoming2;
    bool m_nPlayerDocked;


    bsgPoint GetILSPoint(int a_nILSState, int a_nLandingBay);
    void Launch_Viper(bool a_blDefense);
    void Launch_Viper2(bool a_blDefense);
    void SetPosition(int a_nX,int a_nY);
    bsgShip * SeekTarget();

    void Launch_Player();
    void bsgBattlestar::move(float a_fLagCount);
    virtual void draw(int a_nCameraX,int a_nCameraY); // Draws this sprite proportional to the camera
    virtual void do_ai(float a_fLagCount);
};

bool LoadBattlestarSprites();
#endif
