/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include <allegro.h>
#include <OpenLayer.hpp>
#include <string>
#include <assert.h>


#include "main.h"
#include "AIdef.h"
#include "Engine.h"
#include "bsgBattlestar.h"
#include "bsgShip.h"
#include "bsgViper.h"
#include "bsgPlayer.h"
#include "bsgRaider.h"
#include "bsgBullet.h"
#include "bsgSmoke.h"
#include "bsgExplosion.h"
#include "particle.h"
#include "spartan.h"
#include "bsgTurret.h"
#include "bsgShuttle.h"
#include "bsgTanker.h"
#include "bsgMission.h"
#include "bsgGUI.h"



using namespace ol;
using namespace std;

float g_fDeltaTime=0;
float g_fMenuY=-480;
int   g_nFramesPerSecond;
int   g_nGameState=GS_NONE;
int   g_nScore=0;
float g_fLookAhead=0.0000000;
float g_fRotation=0;
bool  g_blDebug = false;

int g_nMX,g_nMY;
ofstream g_Logfile ("bsg.log");



float HPI=PI/2;

bsgBattlestar * g_pGalactica=NULL;


bool  blMenuActive=false;
bool g_blGameOverStarted=false;
float g_fGameOverTimer=2000;

TextRenderer * g_pTahoma=NULL;
TextRenderer * g_pBattlestarFont=NULL;
TextRenderer * g_pTIFont=NULL;
bsgEngine    * g_pEngine=NULL;
bsgMission   * g_pMission=NULL;

bsgGUI             * g_pGui = NULL;

Bitmap    * g_pimCursor=NULL;
Bitmap    * g_pimCompass;
Bitmap    * g_pimCompassTop;
Bitmap    * g_pimMenu=NULL;
Bitmap    * g_pimIntro=NULL;


vector< Bitmap *> g_vimTargetInfo;

FSOUND_SAMPLE * samp_Laser= NULL;
FSOUND_SAMPLE * samp_ViperLaser= NULL;
FSOUND_SAMPLE * samp_RaiderLaser= NULL;
FSOUND_SAMPLE * samp_Hit     = NULL;
FSOUND_SAMPLE * samp_Explode = NULL;
FSOUND_SAMPLE * samp_Intro = NULL;
int g_nCannelHandle;

string strText;
string strScore;
string strFramerate;
string g_strNextMission;
string g_strCurrentMission;

bsgPlayer * g_pPlayer=NULL;
int g_CurrentSelection=-1;
bsgPlayerInfo * g_pCurrentRecord=NULL;
bsgChoosePlayerDLG * g_pDlg=NULL;

bool g_blNewChooseDlg=false;

void Do_Intro(float a_fLagTime);
void Do_Menu(float a_fLagTime);
void Do_Briefing(float a_fLagTime);
void Do_Game(float a_fLagTime);
void Do_Failed(float a_fLagTime);
void Do_Debriefing(float a_fLagTime);

void DrawTargetInformation (bsgSprite * a_pTarget,int a_nDistance);
void Make_Mission();

void DoSelection (const char * a_strPlayer);


bsgEngine  * GetEngine()
{
    return g_pEngine;
}

bool Setup_Game()
{
    g_fRotation=0;

    bool blReturnVal=false;
    // Set up the program with all possible drivers //
    blReturnVal=Setup::SetupProgram();

    if (blReturnVal)
    {
        blReturnVal=Setup::SetupScreen( 800, 600, /*WINDOWED*/ FULLSCREEN);
    }

    // Initialisatie FMod ******************************************************************
    if (FSOUND_GetVersion() < FMOD_VERSION)
    {
        printf("Error : You are using the wrong DLL version!  You should be using FMOD %.02f\n", FMOD_VERSION);
        exit(1);
    }
    if (!FSOUND_Init(32000, 64, 0))
    {
        exit(1);
    }

    samp_Laser=FSOUND_Sample_Load(FSOUND_FREE,"sound/laser.wav",FSOUND_LOOP_OFF,0,0);
    samp_ViperLaser=FSOUND_Sample_Load(FSOUND_FREE,"sound/viper_fire.wav",FSOUND_LOOP_OFF,0,0);
    samp_RaiderLaser=FSOUND_Sample_Load(FSOUND_FREE,"sound/raider_fire.wav",FSOUND_LOOP_OFF,0,0);
    samp_Hit=FSOUND_Sample_Load(FSOUND_FREE,"sound/hit.wav",FSOUND_LOOP_OFF,0,0);
    samp_Explode=FSOUND_Sample_Load(FSOUND_FREE,"sound/explode.wav",FSOUND_LOOP_OFF,0,0);

    if (blReturnVal)
    {
        g_pEngine   = new bsgEngine();

        init_particles();

        g_pTahoma = new TextRenderer( "Fonts/smalltext.ttf", 15, 15, Rgba::WHITE );
        assert(g_pTahoma!=NULL);

        g_pBattlestarFont = new TextRenderer( "Fonts/BATTLEST.ttf", 15, 15, Rgba::YELLOW );
        assert(g_pBattlestarFont!=NULL);


        Rgba col(0,255,255);
        g_pTIFont=new TextRenderer( "Fonts/TI.ttf", 8, 8, col );
        assert(g_pTIFont!=NULL);

        g_pimCursor = new Bitmap("Gfx/Still/Cursor1.png");
        assert(g_pimCursor!=NULL);

        g_pimCompass= new Bitmap("Gfx/Still/Compass.png");
        assert(g_pimCompass!=NULL);

        g_pimCompassTop= new Bitmap("Gfx/Still/CompassTop.png");
        assert(g_pimCompass!=NULL);

        g_vimTargetInfo = Bitmap::LoadListOfBitmaps("Gfx/TargetInfo/TI", "png", 3);
        assert(!g_vimTargetInfo.empty());

        g_pimIntro = new Bitmap("Gfx/Menu/Intro.png");
        assert(g_pimIntro!=NULL);

        g_pimMenu = new Bitmap("Gfx/Menu/Deck.png");
        assert(g_pimMenu!=NULL);


        if (!g_pEngine->Load_Blibs())
        {
          allegro_message( "Radar blibs could not be loaded!" );
          exit( -1 );
        }

        if (!LoadBattlestarSprites())
        {
          allegro_message( "Battlestar sprites could not be loaded!" );
          exit( -1 );
        }

        if (!LoadTurretSprites())
        {
          allegro_message( "Turret sprites could not be loaded!" );
          exit( -1 );
        }

        if (!LoadRaiderSprites())
        {
          allegro_message( "Raider sprites could not be loaded!" );
          exit( -1 );
        }

        if (!LoadViperSprites())
        {
          allegro_message( "Viper sprites could not be loaded!" );
          exit( -1 );
        }

        if (!LoadBulletSprites())
        {
          allegro_message( "bullet sprites could not be loaded!" );
          exit( -1 );
        }

        if (!LoadMissileSprites())
        {
           allegro_message( "missile sprites could not be loaded!" );
           exit( -1 );
        }

        if (!LoadSmokeSprites())
        {
            allegro_message( "Smoke sprites could not be loaded!" );
            exit( -1 );
        }

        if (!LoadExplosionSprites())
        {
            allegro_message( "Explosion sprites could not be loaded!" );
            exit( -1 );
        }

        if (!LoadShuttleSprites())
        {
          allegro_message( "Battlestar sprites could not be loaded!" );
          exit( -1 );
        }

        if (!LoadTankerSprites())
        {
          allegro_message( "Tanker sprites could not be loaded!" );
          exit( -1 );
        }

        Canvas::SetTo( SCREEN_BACKBUF );

        samp_Intro=FSOUND_Sample_Load(FSOUND_FREE,"sound/Theme.mp3",FSOUND_LOOP_OFF,0,0);
        g_nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,samp_Intro);


        g_Logfile << "Starting GUI \n";
        g_Logfile.flush();
        g_pGui = new bsgGUI(g_pTahoma,g_pimCursor); // make a gui object
        g_pGui->m_blVisible = false;
        g_blNewChooseDlg    = true;
        g_nGameState=GS_INTRO;


    }
    else
    {
       allegro_message( "Setup error" );
       exit( -1 );
    }
    Settings::SetAntialiasing( true );
    return blReturnVal;
}



void Make_Mission()
{
    g_Logfile << " creating mission  \n" ;
    g_Logfile.flush();

    srand((unsigned)time(0));
    if (g_pMission!=NULL)
    {
      delete g_pMission;
    }
    g_pMission=new bsgMission;

    g_pEngine->killAll();
    g_nScore=0;
    g_blGameOverStarted=false;
    g_fGameOverTimer=3000;

    g_strNextMission=g_pCurrentRecord->m_szMission;


    //g_strNextMission="Missions/Mission3.vf";

    if ((g_strNextMission=="")||(g_strNextMission=="<EMPTY>"))
    {
        g_strCurrentMission="Missions/Start.vf";
        g_pMission->readMission(g_pEngine,"Missions/Start.vf");
        g_strNextMission=g_pMission->GetNextMission();
    }
    else if ((g_strNextMission=="TEST"))
    {
        g_strCurrentMission="Missions/test.vf";
        g_pMission->readMission(g_pEngine,"Missions/test.vf");
        g_strNextMission=g_pMission->GetNextMission();
    }
    else
    {
        g_strCurrentMission=g_strNextMission;
        g_pMission->readMission(g_pEngine,g_strNextMission.c_str());
        g_strNextMission=g_pMission->GetNextMission();
    }

    g_pPlayer    = g_pMission->GetPlayer();
    g_pGalactica = g_pMission->GetGalactica();
    assert(g_pGalactica!=NULL);



    if (g_pPlayer!=NULL)
    {
        g_fLookAhead=250;
        g_pEngine->SetCamera(int(g_pPlayer->m_fX + cos(g_pPlayer->m_fAngle) * g_fLookAhead),
                             int(g_pPlayer->m_fY + sin(g_pPlayer->m_fAngle) * g_fLookAhead),
                             true);
    }
    else
    {
        g_pEngine->SetCamera(int(g_pGalactica->m_fX)+800, int(g_pGalactica->m_fY),true);
    }

    g_fRotation=0;
    g_pEngine->init_stars();
    g_pEngine->init_stars();

    g_Logfile << " Mission created  \n" ;
    g_Logfile.flush();
}






int main()
{

    if (Setup_Game())
    {
        // Run the game loop until esc is pressed //

        // Set up the delta time routines with the default fps of 72.0 //
        FpsCounter::Start(75.0);
        while( g_nGameState!=GS_EXIT )
        {
            FpsCounter::NewFrameStarted();
            g_fDeltaTime=FpsCounter::GetDeltaTime();

            switch(g_nGameState)
            {
                case GS_INTRO:
                Do_Intro(g_fDeltaTime);
                break;

                case GS_MENU:
                Do_Menu(g_fDeltaTime);
                // Do gui stuff
                g_pGui->Handle();
                g_pGui->Remove();
                g_pGui->Draw();
                g_pGui->Remove();
                break;

                case GS_BRIEFING:
                Do_Briefing(g_fDeltaTime);
                break;

                case GS_PLAYING:
                Do_Game(g_fDeltaTime);
                break;

                case GS_MISSIONCOMPLETE:
                Do_Debriefing(g_fDeltaTime);
                break;


                case GS_MISSIONFAILED:
                Do_Failed(g_fDeltaTime);
                break;

            }




            Canvas::Refresh();
            Canvas::Fill( Rgba::BLACK );
        }
    }
    else
    {
        g_pimCursor->Destroy();
        g_pimCompass->Destroy();
        g_pimCompassTop->Destroy();
   }

    delete g_pMission;
    delete g_pGui;
    g_Logfile.close();
    return 0;
}
END_OF_MAIN()



void Do_Intro(float a_fLagTime)
{
    char szOpenGLText[256];



    if ((keypressed()) || (mouse_b & 1))
     {
        g_nGameState=GS_MENU;
        g_pimIntro->Destroy();
        g_pGui->m_blVisible=true;
        while (keypressed())
        {
          readkey();
        }
        FSOUND_StopSound(g_nCannelHandle);
        FSOUND_Sample_Free(samp_Intro);
     }


     g_pimIntro->Blit(0,0);

     sprintf(szOpenGLText," Graphics Driver: OpenGL %s (%s)\n"
    "%s detected\n"
    "Set %dx%d %dbpp %s mode\n Make sure you have the latest OpenGL drivers for your video card !",
    glGetString(GL_VERSION), glGetString(GL_VENDOR),
    glGetString(GL_RENDERER),
    SCREEN_W, SCREEN_H, bitmap_color_depth(screen),
    (gfx_driver->windowed ? "windowed" : "fullscreen"));

    g_pTahoma->Print(szOpenGLText,10,10);



}

void Do_Menu(float a_fLagTime)
{
     if (g_blNewChooseDlg)
     {
       g_Logfile << "Creating Choose player dialog \n";
       g_Logfile.flush();
       g_pDlg = new bsgChoosePlayerDLG(20,20,DoSelection);
       g_pDlg->SetCaption("Choose a player");

       if (g_CurrentSelection>-1)
       {
          g_pDlg->SetSelection(g_CurrentSelection);
       }

       g_pGui->Add(g_pDlg);

       g_blNewChooseDlg=false;
     }

     if (key[KEY_ESC])
     {
       g_Logfile << "Doing Exit \n";
       g_Logfile.flush();

        g_nGameState=GS_EXIT;
     }
     g_pimMenu->Blit(0,0);

}

void Do_Briefing(float a_fLagTime)
{
    if ((key[KEY_ENTER]) ||(mouse_b & 1))
     {
        g_Logfile << " <<<<  STARTING GAME  >>>> \n" ;
        g_Logfile.flush();
        while (key[KEY_ENTER])
        g_nGameState=GS_PLAYING;
        g_pEngine->StartTimer();
     }

     if (key[KEY_ESC])
     {
        g_nGameState=GS_MENU;
        while (key[KEY_ESC])
        {

        }
        g_blNewChooseDlg=true;
        g_pGui->m_blVisible = true;
     }

     string strLine;
     strLine=g_pMission->GetFirstLine();
     int nPos=1;
     while (strLine!="<EOL>")
     {
         g_pBattlestarFont->Print(strLine,10,nPos*20);
         strLine=g_pMission->GetNextLine();
         nPos++;
     }




     g_pBattlestarFont->Print("Press [Enter] to start or [Esc] to go back",10,550);

}

void Do_Debriefing(float a_fLagTime)
{

     if (keypressed() ||(mouse_b & 1))
     {
        g_nGameState=GS_MENU;
        while (keypressed())
        {
           readkey();
        }

        g_blNewChooseDlg = true;
        g_pGui->m_blVisible=true;
     }

     string strLine;
     strLine=g_pMission->GetFirstEpLine();
     int nPos=1;
     while (strLine!="<EOL>")
     {
         g_pBattlestarFont->Print(strLine,10,nPos*20);
         strLine=g_pMission->GetNextEpLine();
         nPos++;
     }

}




void Do_Game(float a_fLagTime)
{
    //Transforms::SetRotationPivot( 400,400);
    g_pEngine->UpdateTimer();



    float fX1,fY1,fX2,fY2;
    float fAngle;
    int nS=40;
    int nL=8;

    Rgba col;

    if (key[KEY_ESC])
    {
        g_nGameState=GS_BRIEFING;
        while(key[KEY_ESC]);
    }

    if (key[KEY_F12])
    {
       g_blDebug = ! g_blDebug;
       while(key[KEY_F12]);
    }


    //Logic
    g_pEngine->move(g_fDeltaTime);
    g_pMission->updateLists();
    g_pEngine->kill();

    Transforms::SetRotation(g_fRotation-(PI/2));
    g_fLookAhead = 250;


    // Render stars
    g_pEngine->draw_stars();

    // normal rendering
    g_pEngine->draw();

    Transforms::ResetTransforms();

    if ((g_pPlayer!=NULL)&&(!g_pPlayer->m_blDestroyed))
    {


        if ((!g_pPlayer->m_blDocking)||(g_pPlayer->m_nILSPoint<2))
        {
           g_fRotation=-g_pPlayer->m_fAngle;
           if (g_fLookAhead==0)
           {
              g_pEngine->SetCamera(int(g_pPlayer->m_fX),int(g_pPlayer->m_fY),false);
           }
           else
           {
              g_pEngine->SetCamera(int(g_pPlayer->m_fX + cos(g_pPlayer->m_fAngle) * g_fLookAhead),
                                   int(g_pPlayer->m_fY + sin(g_pPlayer->m_fAngle) * g_fLookAhead),
                                   true);
           }
        }
        else
        {
           bsgPoint point = g_pGalactica->GetILSPoint(3,g_pPlayer->m_nBAY);
           g_pEngine->SetCamera(int(g_pPlayer->m_fX + g_fLookAhead),point.m_nY,true);

           g_fRotation=0;

        }

        Rgba col=Rgba::RED;
        if (g_pPlayer->m_nHealth>(g_pPlayer->m_nMaxHealth*2/3))
        {
           col=Rgba::GREEN;
        }
        else if (g_pPlayer->m_nHealth>(g_pPlayer->m_nMaxHealth*1/3))
        {
           col=Rgba::YELLOW;
        }



        GfxRend::Rect(0,580,(110/float(g_pPlayer->m_nMaxHealth))* g_pPlayer->m_nHealth,5,col);
        strText="Missiles : "+ToString(g_pPlayer->m_nMissiles);
        g_pTahoma->Print(strText,0,600);

        // target reticle
        if ((g_pPlayer->m_pTarget!=NULL)&&(!g_pPlayer->m_pTarget->m_blDestroyed))
        {

            int nDistToTarget=int(distance(g_pPlayer->m_fX,g_pPlayer->m_fY,
                                       g_pPlayer->m_pTarget->m_fX,
                                       g_pPlayer->m_pTarget->m_fY));

            DrawTargetInformation(g_pPlayer->m_pTarget,nDistToTarget/100);


            col=Rgba::RED;
            fAngle=g_pPlayer->waypoint(g_pPlayer->m_pTarget->m_fX,g_pPlayer->m_pTarget->m_fY);
            if (g_pPlayer->m_pTarget->m_nTeam==g_pPlayer->m_nTeam)
            {
                col=Rgba::GREEN;
            }

            fAngle+=g_fRotation-(PI/2);

            fX1=(nS*cos(fAngle));
            fY1=(nS*sin(fAngle));
            fX2=((nS+nL)*cos(fAngle));
            fY2=((nS+nL)*sin(fAngle));

            GfxRend::Line(400+fX1, 550+fY1, 400+fX2, 550+fY2,col);
        }
        // overmap
        if (key[KEY_Q])
        {
           Transforms::SetRotation(g_fRotation-(PI/2));
           g_pEngine->draw_large_sensor(400,300, g_pPlayer);
           Transforms::ResetTransforms();
        }

        // Draw radiocompass...
        g_pimCompass->Blit(0,555);
        float fAngle=g_pPlayer->m_fAngle+(PI/2);
        bool blNPrinted=false;

        for ( int i=5;i<105;i++)
        {
           if (fAngle>2*PI)
            {
               fAngle=fAngle-(2*PI);
            }

            if (fAngle<0)
            {
               fAngle=(2*PI)+fAngle;
            }

            if ((!blNPrinted)&&((fAngle>(2*PI)-0.02)||(fAngle< 0.02)))
            {
                g_pTahoma->Print("N",i-5,570);
                blNPrinted=true;
            }

            for (int a=1;a<12;a++)
            {
                if ((fAngle>((PI/6)*a)-0.02)&&(fAngle<((PI/6)*a)+0.02))
                {
                    switch(a)
                    {
                         case 3:
                          g_pTahoma->Print("E",i-8,570);
                         break;

                         case 6:
                          g_pTahoma->Print("S",i-4,570);
                         break;

                         case 9:
                          g_pTahoma->Print("W",i-5,570);
                         break;

                         default:
                          g_pTahoma->Print(".",i,567);
                    }
                }
            }

            fAngle=fAngle-(PI/100);
        }

        g_pimCompassTop->Blit(0,555);
    }
    else
    {
        g_pPlayer=NULL;

        if ((g_pGalactica->m_nPlayerDocked)&&(!g_pEngine->m_blTransition))
        {
          g_pTahoma->Print("Press L to launch your viper !",10,10);
        }

        if (g_pGalactica!=NULL)
        {
           g_pEngine->Translate(int(g_pGalactica->m_fX),int(g_pGalactica->m_fY));
        }

    }


    if (!g_blGameOverStarted)
    {
        if ((g_pPlayer==NULL)&&(!g_pGalactica->m_nPlayerDocked))
        {
            g_blGameOverStarted=true;
            g_fGameOverTimer=500;
        }
        else if (g_pMission->failed())
        {
            // mission crap !
            g_blGameOverStarted=true;
            g_fGameOverTimer=200;
        }
        else if ((g_pGalactica->m_pLeftBay==NULL)&&(g_pGalactica->m_pRightBay==NULL))
        {
            g_pPlayer=NULL;
            if (g_pGalactica!=NULL)
            {
                g_pEngine->Translate(int(g_pGalactica->m_fX),int(g_pGalactica->m_fY));
            }
            g_blGameOverStarted=true;
            g_fGameOverTimer=1000;
        }
    }
    else
    {
         g_fGameOverTimer-=a_fLagTime;

         if (g_fGameOverTimer<=0)
         {
            g_nGameState=GS_MISSIONFAILED;
            strcpy(g_pCurrentRecord->m_szMission,g_strCurrentMission.c_str());
            g_pCurrentRecord->m_nPoints+=g_nScore;
            saveRecords();
            while (keypressed())
            {
              readkey();
            }

         }

     }

    if ((g_pMission->succeeded())&&(!g_blGameOverStarted))
    {
       g_pTahoma->Print("Mission completed ! , Land on the Galactica to end the mission",10,10);
       if ((g_pPlayer==NULL)&&(g_pGalactica->m_nPlayerDocked))
       {
          g_nGameState=GS_MISSIONCOMPLETE;
          strcpy(g_pCurrentRecord->m_szMission,g_strNextMission.c_str());
          g_pCurrentRecord->m_nPoints+=g_nScore;
          saveRecords();
          while (keypressed())
          {
            readkey();
          }

       }
    }


    g_pTahoma->Print(g_pEngine->GetTimestring(),740,10);
    //float fps = FpsCounter::GetFps();
    //g_pTahoma->Print("Frames per second: " + ToString(fps),10,10);

}

void Do_Failed(float a_fLagTime)
{
     if ((g_pGalactica->m_pLeftBay==NULL)&&(g_pGalactica->m_pRightBay==NULL))
     {
        g_pBattlestarFont->Print("With the landingbays destroyed",10,30);
        g_pBattlestarFont->Print("All you can do is wait until you run out of fuel",10,70);
     }
     else if (g_pMission->failed())
     {
       // post mission lost text
       g_pBattlestarFont->Print("The mission was lost...",10,30);

       if (g_pMission->m_blTargetEscaped)
       {
          g_pBattlestarFont->Print("One of your targets was able to reach hyperspace...",10,70);
       }
     }
     else
     {
        g_pBattlestarFont->Print("Rest in pieces...",10,30);
     }


     g_pBattlestarFont->Print("Try again ? Y/N",10,90);


     if ((key[KEY_ESC])||(key[KEY_N]))
     {
        g_nGameState=GS_MENU;
        while ((key[KEY_ESC])||(key[KEY_N]))
        {

        }

        g_blNewChooseDlg = true;
        //g_pGui->m_blVisible=true;
     }

     if (key[KEY_Y])
     {
        Make_Mission();
        g_nGameState=GS_BRIEFING;
        while ((key[KEY_Y]));
     }
}


FSOUND_SAMPLE * GetSample(int a_nSample)
{
    switch (a_nSample)
    {
    case SND_LASER:
         return samp_Laser;
         break;

    case SND_VIPERLASER:
         return samp_ViperLaser;
         break;

    case SND_RAIDERLASER:
         return samp_RaiderLaser;
         break;

    case SND_HIT:
         return samp_Hit;
         break;

    case SND_EXPLODE:
         return samp_Explode;
         break;

    default:
              exit(1);
              return  NULL;

    }

}


void SetPlayerPointer(bsgPlayer * a_pPlayer)
{
    g_pPlayer=a_pPlayer;
}

void IncScore(int a_nPoints)
{
  g_nScore+=a_nPoints;
}


void DrawTargetInformation (bsgSprite * a_pTarget,int a_nDistance)
{
     string strText;
     GfxRend::Rect(680,550,120,50,Rgba::BLUE);
     if ((a_pTarget !=NULL)&&(!a_pTarget->m_blDestroyed))
     {
        int nTargetInfo=-1;

        switch (a_pTarget->m_nType)
        {
         case ID_RAIDER :
              nTargetInfo=TI_RAIDER;
              strText="CYLON RAIDER";
              break;

        case  ID_TANKER :
              nTargetInfo=TI_TANKER;
              strText="CYLON TANKER";
              break;

        case  ID_VIPER :
              nTargetInfo=TI_VIPER;
              strText="COLONIAL VIPER";
              break;

        case  ID_SHUTTLE :
              nTargetInfo=TI_SHUTTLE;
              strText="COLONIAL SHUTTLE";
              break;

        case  ID_GALACTICA :
              nTargetInfo=TI_BATTLESTAR;
              strText="COLONIAL BATTLESTAR";
              break;

        case  ID_MISSILE :
              nTargetInfo=TI_MISSILE;
              strText="MISSILE";
              break;

        case  ID_TURRET :
              nTargetInfo=TI_TURRET;
              strText="TURRET";
              break;

        case  ID_GALACTICA_PART :
              nTargetInfo=TI_BATTLESTAR;
              strText="GALACTICA SECTION";
              break;



        }
       if ((nTargetInfo>-1)&&(nTargetInfo<g_vimTargetInfo.size()))
       {
          ((Bitmap *)g_vimTargetInfo[nTargetInfo])->Blit(750,555);
       }


       g_pTIFont->Print(strText,682,560);

       float fDiv=(a_pTarget->m_nHealth)/float(a_pTarget->m_nMaxHealth);
       strText="HEALTH: "+ ToString(int(fDiv*100))+"%";
       g_pTIFont->Print(strText,682,570);

       strText="DIST. : "+ ToString(a_nDistance);
       g_pTIFont->Print(strText,682,580);

       strText="SPEED : "+ ToString(int(a_pTarget->m_fSpeed*10));
       g_pTIFont->Print(strText,682,590);

     }
}





void DoSelection (const char * a_strPlayer)
{
    g_Logfile << "Invoking callback function for ChoosePlayerDialog\n";
    g_Logfile.flush();
    if (strcmp(a_strPlayer,"<NONE>"))
    {
       if (g_pDlg!=NULL)
       {
         g_pCurrentRecord   = g_pDlg->GetRecord(a_strPlayer);
         g_CurrentSelection = g_pDlg->GetSelection();
         assert(g_pCurrentRecord!=NULL);
       }


       if (g_pCurrentRecord!=NULL)
       {
         Make_Mission();
         g_nGameState=GS_BRIEFING;
         g_pGui->m_blVisible=false;
         g_Logfile << " Doing mission briefing  \n" ;
         g_Logfile.flush();
       }
       else
       {
           allegro_message( "Failure in player record!" );
           exit( -1 );
       }
    }
    else
    {

    }
}






