/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/





#include <time.h>
#include <string>
#include "Engine.h"
#include "AIdef.h"
#include "main.h"

#define Number_Of_Stars 200


Bitmap * g_pimGalactica_Blib;
Bitmap * g_pimRaider_Blib;
Bitmap * g_pimViper_Blib;
Bitmap * g_pimSpartan_Blib;
Bitmap * g_pimShuttle_Blib;
Bitmap * g_pimTanker_Blib;

struct bsgStar
{
	float m_fX,m_fY;
	int m_nZ;
};

Rgba * pStarcol[5];

bsgStar zStar[Number_Of_Stars];

/*
TSprite methods
*/

void bsgSprite::DoCollision(bsgSprite * a_pSprite)
{

}


void bsgSprite::SetImage(Bitmap * a_pImage)
{
	m_pImage=a_pImage;
}

void bsgSprite::SetShadow(Bitmap * a_pImage)
{
	m_pShadow=a_pImage;
}


double bsgSprite::waypoint(float a_fX,float a_fY)
{
	float fDX=m_fX-a_fX;
	float fDY=m_fY-a_fY;
	if (fDX!=0)
	{
		return atan2(fDY,fDX)+PI;
	}
	else return 0;
}

void bsgSprite::draw(int a_nCameraX,int a_nCameraY)
{
	int nDrawX=int(SCREENCENTER_X+(m_fX-a_nCameraX));
	int nDrawY=int(SCREENCENTER_Y+(m_fY-a_nCameraY));
	int nShadowX=nDrawX+(m_nZ*2);
	int nShadowY=nDrawY+(m_nZ*2);

	// only draw what we see
	int nImageMidX=m_pImage->Width()/2;
	int nImageMidY=m_pImage->Height()/2;

	if (m_nType<ID_GASEOUS)
	{
       Blenders::Set(ADDITIVE_BLENDER);

    }
    else
    {
       if ((m_pShadow!=NULL)&&(nShadowX+nImageMidX>-200)&&(nShadowX-nImageMidX<1000)&&(nShadowY+nImageMidY>-200)&&(nShadowY-nImageMidY<1000))
	   {
    	m_pShadow->BlitRotated(nShadowX, nShadowY,m_fAngle,0.5);
	   }
    }

    if ((m_pImage!=NULL)&&(nDrawX+nImageMidX>-200)&&(nDrawX-nImageMidX<1000)&&(nDrawY+nImageMidY>-200)&&(nDrawY-nImageMidY<1000))
	    {
		   m_pImage->BlitRotated(nDrawX, nDrawY,m_fAngle,m_fOpacity);
	    }


    if (m_nType<ID_GASEOUS)
	{
       Blenders::Set(ALPHA_BLENDER);
    }

}



void bsgSprite::precalc()
{
  m_fCosAngle = cos(m_fAngle);
  m_fSinAngle = sin(m_fAngle);
}



void bsgSprite::move(float a_fLagCount)
{
	if (m_fSpeed!=0)
	{
	  m_fX=m_fX+m_fCosAngle*m_fSpeed*a_fLagCount;
	  m_fY=m_fY+m_fSinAngle*m_fSpeed*a_fLagCount;
	}
}


void bsgSprite::do_ai(float a_fLagCount)
{


}

bsgSprite::bsgSprite()
{
	m_pEngine=GetEngine();
	m_blDestroyed       = false;
	m_blCanCollide      = false;
	m_blMustSurvive     = false;
	m_blDisabled        = false;
	m_blTimedMovement   = false;
	m_blOutOfGame       = false;

	m_fSpeed     =   0;
	m_fX         =   0;
	m_fY         =   0;
	m_nZ         =   0;
	m_nMaxHealth = 100;
	m_nHealth    = m_nMaxHealth;
	m_fAngle     =   0;
	m_fOpacity   =   1.0;

	m_nType   = ID_NONE;
	m_pImage  = NULL;
	m_pShadow = NULL;


    m_nTimeSec = 0;   // the time to appear in the game
    m_nTimeMin = 0;
}

bsgSprite::~bsgSprite()
{

}



/*
TEngine methods
*/

void bsgEngine::add(bsgSprite * a_pSprite)
{
	m_lstItems.push_back(a_pSprite);
	m_lstItems.sort(Comp);
	a_pSprite->m_pEngine=this;
}


void bsgEngine::Sort()
{
    m_lstItems.sort(Comp);
}





void bsgEngine::SetCamera(int a_nCameraX,int a_nCameraY, bool a_blLookAhead)
{
    m_nCameraX=a_nCameraX;
	m_nCameraY=a_nCameraY;
}



void bsgEngine::kill()
{
	std::list<bsgSprite *>::iterator p=m_lstItems.begin();
	while (p!=m_lstItems.end())
	{
		bsgSprite* pDummy=((bsgSprite *)*p);
		if (pDummy->m_blDestroyed)
		{
			p=m_lstItems.erase(p);
			if (pDummy->m_nType==ID_RAIDER)
			{
                m_nRaiders--; // just for demo !
			}
		delete pDummy;
		}
		else
		{
			p++;
		}
	}
}




void bsgEngine::killAll()
{
    if (!m_lstItems.empty())
    {
      std::list<bsgSprite *>::iterator p=m_lstItems.begin();
	  while (p!=m_lstItems.end())
	  {
		bsgSprite* pDummy=((bsgSprite *)*p);
		p=m_lstItems.erase(p);
		delete pDummy;
      }
    }


     m_nCount   = 0;
	 m_nRaiders = 0;
	 m_nSeekX   = 0;
     m_nSeekY   = 0;
     m_blTransition = false;
}


void bsgEngine::reset_movement()
{
   m_nOldX=m_nCameraX;
   m_nOldY=m_nCameraY;
}



void bsgEngine::draw()
{
	std::list<bsgSprite *>::iterator p=m_lstItems.begin();
	while (p!=m_lstItems.end())
	{
		bsgSprite* pDummy=((bsgSprite *)*p);
		if ((pDummy!=NULL)&&(!pDummy->m_blDestroyed)&&(!pDummy->m_blDisabled))
		{
			pDummy->draw(m_nCameraX,m_nCameraY);
		}

		p++;
	}

}


void bsgEngine::draw_sensor(int a_nX,int a_nY)
{
float xx,yy,dd;
std::list<bsgSprite *>::iterator p=m_lstItems.begin();
	while (p!=m_lstItems.end())
	{
	  bsgSprite* pDummy=((bsgSprite *)*p);
      dd=distance(m_nCameraX,m_nCameraY,pDummy->m_fX,pDummy->m_fY);

      if ((pDummy!=NULL)&&(!pDummy->m_blDestroyed)&&(!pDummy->m_blDisabled)&& (pDummy->m_nType>=ID_SHIP)&&(pDummy->m_nType!=ID_PLAYER)&&(dd<2500))
         {
            xx=(pDummy->m_fX-m_nCameraX)/100;
            yy=(pDummy->m_fY-m_nCameraY)/100;


            if (pDummy->m_nType==ID_MISSILE)
            {
                GfxRend::Point( a_nX+xx,a_nY+yy,Rgba(255,255,0));
            }
            else if (pDummy->m_nTeam==MEM_COLONY)
            {
                GfxRend::Point( a_nX+xx,a_nY+yy,Rgba(0,255,0));
            }
            else if (pDummy->m_nTeam==MEM_CYLON)
            {
                GfxRend::Point( a_nX+xx,a_nY+yy,Rgba(255,0,0));
            }

          }
      p++;
      }

GfxRend::Point( a_nX,a_nY,Rgba(100,100,255));
}











/*
void bsgEngine::draw_large_sensor(int a_nX,int a_nY, bsgSprite *a_pPlayer)
{
    float xx,yy,dd,ss;
  std::list<bsgSprite *>::iterator p=m_lstItems.begin();
	while (p!=m_lstItems.end())
	{
	  bsgSprite* pDummy=((bsgSprite *)*p);
      dd=distance(a_pPlayer->m_fX,a_pPlayer->m_fY,pDummy->m_fX,pDummy->m_fY);
      if ((pDummy!=NULL)&&(!pDummy->m_blDestroyed) && (pDummy->m_nType>=ID_SHIP)&&(pDummy->m_nType!=ID_PLAYER)&&(dd<5000))
         {
            xx=(pDummy->m_fX - a_pPlayer->m_fX) * (300 - 20) / dd;
            yy=(pDummy->m_fY - a_pPlayer->m_fY) * (300 - 20) / dd;

            // size (radius) of symbol
            if (dd < 600)
               ss = 20;
            else
            {
                ss = 6000 / (dd - 300);
                if (ss < 2)
                    ss = 2;
            }

            if (pDummy->m_nType==ID_MISSILE)
            {
                GfxRend::CircleOutline( a_nX+xx, a_nY+yy, ss, Rgba(255,255,0));
            }
            else if (pDummy->m_nTeam==MEM_COLONY)
            {
                GfxRend::CircleOutline( a_nX+xx, a_nY+yy, ss, Rgba(0,255,0));
            }
            else if (pDummy->m_nTeam==MEM_CYLON)
            {
                GfxRend::CircleOutline( a_nX+xx, a_nY+yy, ss, Rgba(255,0,0));
            }

          }
      p++;
      }
}
*/

void bsgEngine::StartTimer()
{
  time (&m_tmStartTime);
  time (&m_tmCurrentTime);
}

void bsgEngine::UpdateTimer()
{
   time (&m_tmCurrentTime);
   m_tmCurrentTime-=m_tmStartTime;
   pTime = gmtime (&m_tmCurrentTime);
}

string bsgEngine::GetTimestring()
{
    string strText;
    strText=ToString(pTime->tm_hour)+":"+ToString(pTime->tm_min)+":"+ToString(pTime->tm_sec);
    return strText;
}


void bsgEngine::draw_large_sensor(int a_nX,int a_nY, bsgSprite *a_pPlayer)
{
    Blenders::Set(ADDITIVE_BLENDER);
    #define MAX_SENSOR_RANGE 5000.0

    float xx,yy,dd,ss,aa;
    int nDrawX;
	int nDrawY;

    // background
    GfxRend::Circle( a_nX, a_nY, 100, Rgba(0,128,255,255));
    for (int r=30; r < 99; r = (100 + r)/2)
    {
        //GfxRend::CircleOutline( a_nX, a_nY, r, Rgba(255,255,255,128), 0, 1);
        GfxRend::EllipseOutline( a_nX, a_nY, r, 100, Rgba(255,255,255,128), PI * -0.5, 0.9);
        GfxRend::EllipseOutline( a_nX, a_nY, 100, r, Rgba(255,255,255,128), PI * 0.5, 0.9);
    }
    // you are here

  std::list<bsgSprite *>::iterator p=m_lstItems.begin();
	while (p!=m_lstItems.end())
	{
	  bsgSprite* pDummy=((bsgSprite *)*p);
      dd=distance(a_pPlayer->m_fX,a_pPlayer->m_fY,pDummy->m_fX,pDummy->m_fY);
      if ((pDummy!=NULL)&&(!pDummy->m_blDestroyed)&&(!pDummy->m_blDisabled)&& ((pDummy->m_nType>ID_SHIP)||((pDummy->m_nType==ID_GALACTICA)))&&(pDummy->m_nType!=ID_PLAYER)&&(dd<MAX_SENSOR_RANGE))
         {
            aa = atan2(a_pPlayer->m_fY-pDummy->m_fY, a_pPlayer->m_fX-pDummy->m_fX)+PI;
            xx= cos(aa)*100*(dd*4.0+MAX_SENSOR_RANGE)/(MAX_SENSOR_RANGE*5.0);
            yy= sin(aa)*100*(dd*4.0+MAX_SENSOR_RANGE)/(MAX_SENSOR_RANGE*5.0);


            // size (radius) of symbol
            if (dd < 200)
               ss = 7;
            else
            {
                ss = 6000 / dd;
                if (ss < 1)
                    ss = 1;
                else if (ss > 7)
                    ss = 7;
            }


            if (pDummy->m_nType==ID_GALACTICA)
            {
               nDrawX=int(xx-30);
	           nDrawY=int(yy-12);
               if ((nDrawX<85)&&(nDrawX>-85)&&(nDrawY<85)&&(nDrawY>-85))
               {
                  g_pimGalactica_Blib->BlitStretched(a_nX+nDrawX, a_nY+nDrawY,6*ss,3* ss);
               }
            }
            if (pDummy->m_nType==ID_MISSILE)
            {
                if (ss > 4) ss = 4;
                g_pimSpartan_Blib->BlitTransformed(a_nX+xx, a_nY+yy,ss*2,ss,pDummy->m_fAngle);

            }
            else if (pDummy->m_nType==ID_VIPER)
            {
               if (ss > 4) ss = 4;
               g_pimViper_Blib->BlitTransformed(a_nX+xx, a_nY+yy,ss*3,ss*2,pDummy->m_fAngle);
            }

            else if (pDummy->m_nType==ID_SHUTTLE)
            {
               if (ss > 4) ss = 4;
               g_pimShuttle_Blib->BlitTransformed(a_nX+xx, a_nY+yy,ss*3,ss,pDummy->m_fAngle);
            }

            else if (pDummy->m_nType==ID_RAIDER)
            {
               if (ss > 4) ss = 4;
               g_pimRaider_Blib->BlitTransformed(a_nX+xx, a_nY+yy,ss*2,ss*3,pDummy->m_fAngle);
            }

            else if (pDummy->m_nType==ID_TANKER)
            {
               if (ss > 4) ss = 4;
               g_pimTanker_Blib->BlitTransformed(a_nX+xx, a_nY+yy,ss*4,ss,pDummy->m_fAngle);
            }


          }
      p++;
      }

      Blenders::Set(ALPHA_BLENDER);
}

void bsgEngine::Translate(int a_nX, int a_nY)
{
    if (!m_blTransition)
    {
      m_nSeekX=a_nX;
      m_nSeekY=a_nY;
      m_blTransition=true;
    }
}

void bsgEngine::move(float a_fLagCount)
{

    if (m_blTransition)
    {
        if ((m_nCameraX<m_nSeekX)&&(m_nSeekX-m_nCameraX>a_fLagCount*4))
        {
          m_nCameraX+=int(a_fLagCount*4);
        }
        else if ((m_nCameraX>m_nSeekX)&&(m_nCameraX-m_nSeekX>a_fLagCount*4))
        {
          m_nCameraX-=int(a_fLagCount*4);
        }


        if ((m_nCameraY<m_nSeekY)&&(m_nSeekY-m_nCameraY>a_fLagCount*4))
        {
           m_nCameraY+=int(a_fLagCount*4);
        }
        else if ((m_nCameraY>m_nSeekY)&&(m_nCameraY-m_nSeekY>a_fLagCount*4))
        {
            m_nCameraY-=int(a_fLagCount*4);
        }

        if (( abs(m_nCameraX-m_nSeekX)<5)&&(abs(m_nCameraY-m_nSeekY)<5))
        {
            m_blTransition = false;
            m_nCameraX     = m_nSeekX;
            m_nCameraY     = m_nSeekY;
        }

    }


	std::list<bsgSprite *>::iterator p=m_lstItems.begin();
	while (p!=m_lstItems.end())
	{
		bsgSprite*pDummy=((bsgSprite *)*p);

		if ((pDummy->m_blDisabled)&&(!pDummy->m_blOutOfGame))
		{
          int nStartSec=pDummy->m_nTimeMin*60;
          nStartSec+=pDummy->m_nTimeSec;
          int nTimeSec=pTime->tm_min*60;
          nTimeSec+=pTime->tm_sec;

          if (nTimeSec>=nStartSec)
          {
             pDummy->m_blDisabled=false;
          }

        }

        if (pDummy->m_blTimedMovement)
		{
          int nStartSec=pDummy->m_nTimeMin*60;
          nStartSec+=pDummy->m_nTimeSec;
          int nTimeSec=pTime->tm_min*60;
          nTimeSec+=pTime->tm_sec;

          if (nTimeSec>=nStartSec)
          {
             pDummy->m_fSpeed=pDummy->m_fMaxSpeed;
             pDummy->m_blTimedMovement=false;
          }

        }


        if ((pDummy!=NULL)&&(!pDummy->m_blDestroyed)&&(!pDummy->m_blDisabled))
		{
			pDummy->do_ai(a_fLagCount);
			pDummy->precalc();
			pDummy->move(a_fLagCount);
			if ((pDummy->m_blCanCollide)&&(pDummy->m_nZ>2))
			{
				std::list<bsgSprite *>::iterator q=m_lstItems.begin();
				while (q!=m_lstItems.end())
				{
					bsgSprite*pDummy2=*q;

					if (pDummy2!=pDummy)
					{
						// Check collision !!!
						if (detect_collision(pDummy,pDummy2)) pDummy->DoCollision(pDummy2);
					}
					q++;
				}
			}
		}
		p++;
	}

}

bool bsgEngine::detect_collision(bsgSprite * pSprite1,bsgSprite * pSprite2)
{

	float CosAngle = cos(-(pSprite1->m_fAngle));
    float SinAngle = sin(-(pSprite1->m_fAngle));

	float px = pSprite2->m_fX - pSprite1->m_fX;
	float py = pSprite2->m_fY - pSprite1->m_fY;
	int PX = int (pSprite1->m_fX + CosAngle * px - SinAngle * py);
    int PY = int (pSprite1->m_fY + SinAngle * px + CosAngle * py);
    int DX = pSprite1->m_pImage->Width() / 2;
    int DY = pSprite1->m_pImage->Height() /2;

	if ((PX > pSprite1->m_fX-DX) && (PX < pSprite1->m_fX+DX)&&
       (PY > pSprite1->m_fY-DY)&&(PY < pSprite1->m_fY+DY))
   {
      return true;
   }
   else
   {
	  return false;
   }
}



bsgEngine::bsgEngine()
{
	m_nCount=0;
	m_nCameraX=5000;
	m_nCameraY=5000;
	m_nOldX=m_nCameraX;
	m_nOldY=m_nCameraY;
	m_nRaiders=0;
	m_nSeekX=0;
    m_nSeekY=0;
    m_blTransition=false;
	init_stars();
}

bsgEngine::~bsgEngine()
{

}

void bsgEngine::init_stars()
{
	for (int nZ=0;nZ<5;nZ++)
    {
		pStarcol[nZ]= new Rgba(((200/(nZ+1))+55),((200/(nZ+1))+55),((200/(nZ+1))+55),255);
    }

	for (int nI=0;nI<Number_Of_Stars;nI++)
    {
		zStar[nI].m_fX=(rand()%1000) - 100;
		zStar[nI].m_fY=(rand()%1000) - 100;
		zStar[nI].m_nZ=(rand()%5);
    }
    reset_movement();
}


void bsgEngine::update_stars()
{
	float fDX=m_nOldX-m_nCameraX;
	float fDY=m_nOldY-m_nCameraY;
	m_nOldX=m_nCameraX;
	m_nOldY=m_nCameraY;
	for (int nI=0;nI<Number_Of_Stars;nI++)
    {
		zStar[nI].m_fX+=int(fDX/(zStar[nI].m_nZ+1));
		zStar[nI].m_fY+=int(fDY/(zStar[nI].m_nZ+1));

		if (zStar[nI].m_fX<-100)
		{
			zStar[nI].m_fX=899;
			zStar[nI].m_fY=rand()%700;
			zStar[nI].m_nZ=(rand()%5);
		}

		if (zStar[nI].m_fX>899)
		{
			zStar[nI].m_fX=-100;
			zStar[nI].m_fY=rand()%700;
			zStar[nI].m_nZ=(rand()%5);
		}

		if (zStar[nI].m_fY<-100)
		{
			zStar[nI].m_fY=699;
			zStar[nI].m_fX=rand()%900;
			zStar[nI].m_nZ=(rand()%5);
		}

		if (zStar[nI].m_fY>699)
		{
			zStar[nI].m_fY=-100;
			zStar[nI].m_fX=rand()%900;
			zStar[nI].m_nZ=(rand()%5);
		}
    }
}

void bsgEngine::draw_stars()
{
	Settings::SetAntialiasing(false);
	float fDX=m_nOldX-m_nCameraX;
	float fDY=m_nOldY-m_nCameraY;
	m_nOldX=m_nCameraX;
	m_nOldY=m_nCameraY;

	for (int nI=0;nI<Number_Of_Stars;nI++)
    {
		zStar[nI].m_fX+=fDX/(zStar[nI].m_nZ+1);
		zStar[nI].m_fY+=fDY/(zStar[nI].m_nZ+1);

		if (zStar[nI].m_fX<-100)
		{
			zStar[nI].m_fX=899;
			zStar[nI].m_fY=rand()%700;
			zStar[nI].m_nZ=(rand()%5);
		}

		if (zStar[nI].m_fX>899)
		{
			zStar[nI].m_fX=-100;
			zStar[nI].m_fY=rand()%700;
			zStar[nI].m_nZ=(rand()%5);
		}

		if (zStar[nI].m_fY<-100)
		{
			zStar[nI].m_fY=699;
			zStar[nI].m_fX=rand()%900;
			zStar[nI].m_nZ=(rand()%5);
		}

		if (zStar[nI].m_fY>699)
		{
			zStar[nI].m_fY=-100;
			zStar[nI].m_fX=rand()%900;
			zStar[nI].m_nZ=(rand()%5);
		}
		GfxRend::Point( zStar[nI].m_fX, zStar[nI].m_fY,*pStarcol[zStar[nI].m_nZ]);
    }
    Settings::SetAntialiasing(true);
}

bool bsgEngine::Load_Blibs()
{
g_pimGalactica_Blib = new Bitmap("Gfx/Still/Galactica_blib.png");
if (g_pimGalactica_Blib == NULL) return false;

g_pimRaider_Blib    = new Bitmap("Gfx/Still/Raider_blib.png");
if (g_pimRaider_Blib == NULL) return false;

g_pimViper_Blib     = new Bitmap("Gfx/Still/Viper_blib.png");
if (g_pimViper_Blib == NULL) return false;

g_pimSpartan_Blib = new Bitmap("Gfx/Still/Spartan_blib.png");
if (g_pimSpartan_Blib == NULL) return false;

g_pimShuttle_Blib = new Bitmap("Gfx/Still/Shuttle_blib.png");
if (g_pimShuttle_Blib == NULL) return false;

g_pimTanker_Blib = new Bitmap("Gfx/Still/Tanker_blib.png");
if (g_pimTanker_Blib == NULL) return false;

return true;
}

float distance(float a_fX1,float a_fY1,float a_fX2,float a_fY2)
{
	float fDX=a_fX1-a_fX2;
	float fDY=a_fY1-a_fY2;
	if (fDX==0) return (fDY < 0) ? -fDY : fDY;
	else if (fDY==0) return (fDX < 0) ? -fDX : fDX;
	else return int(sqrt((fDX*fDX)+(fDY*fDY)));
}



bool Comp(const bsgSprite *p1, const bsgSprite *p2)
{
	return (p1->m_nZ < p2->m_nZ);
}





