/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include <allegro.h>
#include "particle.h"
#include "AIdef.h"

Rgba * pc_smoke[255];
Rgba * pc_engine[255];
Rgba * pc_engine2[255];


void init_particles()
{
for (int i=0;i<256;i++)
    {
       pc_smoke[i]= new Rgba(255,255,255,i);
    }
}


bsgParticle::bsgParticle()
{
m_nKind=P_SMOKE;
m_nCol=255;
m_fLife=50;
m_nWait=2;
m_fSpeed=0;
m_nType=ID_NONE;
m_pImage = NULL;
m_pShadow = NULL;
m_blCanCollide=false;
}


bsgParticle::~bsgParticle()
{

}


void bsgParticle::do_ai(float a_fLagCount)
{
m_fLife-=a_fLagCount;
if (m_fSpeed>0)
 {
   m_fSpeed-=0.4;
   if (m_fSpeed<0) m_fSpeed=0;
 }

if (m_fSpeed<0)
 {
   m_fSpeed+=0.4;
   if (m_fSpeed>0) m_fSpeed=0;
 }




m_nCol=int(m_fLife*4);
if (m_fLife<=0) m_blDestroyed=true;
}

void bsgParticle::draw(int a_nCameraX,int a_nCameraY)
{
int nDrawX=int(SCREENCENTER_X+(m_fX-a_nCameraX));
int nDrawY=int(SCREENCENTER_Y+(m_fY-a_nCameraY));

// only draw what we see

if ((nDrawX>=-100)&&(nDrawY<900)&&(nDrawY>=-100)&&(nDrawY<700))
   {
   switch (m_nKind)
          {
          case P_SMOKE:
            GfxRend::Point( nDrawX, nDrawY, *pc_smoke[m_nCol]);
          break;

          case 2:

          break;

          case 3:

          break;
          }
   }
   else
   {
      m_blDestroyed=true;
   }
}

