/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/



#ifndef _BSGVIPER
#define _BSGVIPER

#include <allegro.h>
#include "Engine.h"
#include "bsgShip.h"


class bsgBattlestar;

class bsgViper:public bsgShip
{
private:


protected:

    bool m_blFireLinked;
    float m_fFireDelay;
    bool m_blOdd;
    bool m_blInitDocking;
    bsgPoint m_IlsPoint;

    void Ai_Evade(float a_fLagCount);
    void Ai_Chase(float a_fLagCount);
    void Ai_Dock (float a_fLagCount);
    void Ai_Launch(float a_fLagCount);
    void Fire();

public:
    int m_nBAY;
    bsgBattlestar * m_pBattlestar;
    int m_nPosture;

    int m_nILSPoint;
    bsgViper();
    virtual ~bsgViper();

    virtual void do_ai(float a_fLagCount);
    void launch();
    void land();

    int m_nWingNr;

    void SetBay(int a_nLaunchBay);

    bsgViper(int a_nLaunchBay, bsgBattlestar * a_pBattlestar);

};


bool LoadViperSprites();

#endif
