/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <FMOD/fmod.h>
#include <assert.h>

#include "AIDef.h"
#include "bsgViper.h"
#include "bsgBullet.h"
#include "bsgExplosion.h"
#include "spartan.h"
#include "bsgBattlestar.h"



Bitmap    * g_pimViper=NULL;
Bitmap    * g_pimViperShadow=NULL;
extern bool g_blDebug;


bsgViper::bsgViper()
{
    m_nTeam=MEM_COLONY;
    m_nType=ID_VIPER;
    m_nPosture=POS_DEFEND_GALACTICA;
    m_pBattlestar=NULL;
    m_nAI=AI_CHASE;
    m_fFireDelay=0;
    m_fSpeed=0;
    m_fMaxSpeed=6;


    m_fFireDelaySpartan=0;
    m_fSteer=0.03;
    m_blFireLinked=true;
    m_blDocking=false;
    m_blLaunching=false;
    m_blOdd=false;
    m_pBattlestar=NULL;
    m_nMissiles=0;
    m_blInitDocking=false;
    SetImage(g_pimViper);
    SetShadow(g_pimViperShadow);

    m_nMaxHealth=300;
	m_nHealth=m_nMaxHealth;

    m_nILSPoint=0;

    m_fX=5000;
    m_fY=4890;

    m_nZ=1;
}




bsgViper::bsgViper(int a_nLaunchBay, bsgBattlestar * a_pBattlestar)
{
    m_nTeam=MEM_COLONY;
    m_nType=ID_VIPER;
    m_nPosture=POS_DEFEND_GALACTICA;
    m_pBattlestar=a_pBattlestar;
    m_nAI=AI_CHASE;
    m_fFireDelay=0;
    m_fSpeed=0;
    m_fMaxSpeed=6;
    m_nBAY = a_nLaunchBay;

    m_fFireDelaySpartan=0;
    m_fSteer=0.03;
    m_blFireLinked=true;
    m_blDocking=false;
    m_blLaunching=false;
    m_blOdd=false;
    m_nMissiles=0;
    m_blInitDocking=false;
    SetImage(g_pimViper);
    SetShadow(g_pimViperShadow);

    m_nMaxHealth=300;
	m_nHealth=m_nMaxHealth;

    m_nILSPoint=0;
    m_nZ = 1;
}



bsgViper::~bsgViper()
{

}




void bsgViper::do_ai(float a_fLagCount)
{
    bsgSprite * pObstacle = SeekObstacle();

    if (g_blDebug)
    {
        m_nHealth=m_nMaxHealth;
    }

    if (m_nTargetType==ID_ANY)
    {
        m_pTarget=SeekTarget();
    }
    else
    {
        m_pTarget=SeekTarget(m_nTargetType);
    }


    if ((m_pTarget!=NULL)&&(m_pTarget->m_blDestroyed))
    {
        m_pTarget=NULL;
    }

    if ((m_pEscort != NULL)&&(m_nAI != AI_ESCORT))
    {
       float dist = distance(m_fX,m_fY,m_pEscort->m_fX,m_pEscort->m_fY);

       if (dist > 1000)
       {
            m_nOldAI = m_nAI;
            m_nAI= AI_ESCORT;
       }

       if (m_pEscort->m_blDestroyed)
       {
         m_pEscort=NULL;
       }
    }



    if ( (m_pBattlestar!=NULL) && (m_nAI!=AI_DOCK)&&
         (m_pTarget==NULL) && ((m_nAI==AI_CHASE)||(m_nAI==AI_EVADE)))
    {
        if (! m_pBattlestar->m_blIncoming1)
        {
           m_pBattlestar->m_blIncoming1=true;
           m_nBAY=BAY_LEFT;
           m_nAI=AI_DOCK;
        }
        else if (! m_pBattlestar->m_blIncoming2)
        {
           m_pBattlestar->m_blIncoming2=true;
           m_nBAY=BAY_RIGHT;
           m_nAI=AI_DOCK;
        }

    }



    switch(m_nAI)
    {
        case AI_CHASE:
        Ai_Chase(a_fLagCount);
        break;

        case AI_EVADE:
        Ai_Evade(a_fLagCount);
        break;

        case AI_MOVE:
        if (Ai_Move(a_fLagCount))
        {
             m_fSpeed=0;
             m_nAI=AI_CHASE;
        }

        break;

        case AI_DOCK:
        if (((m_pBattlestar!=NULL)&&(m_pTarget==NULL)) || (m_nILSPoint <2))
        {
           Ai_Dock(a_fLagCount);
        }
        else
        {
           if (m_nBAY==BAY_LEFT)
           {
             m_pBattlestar->m_blIncoming1=false;
           }
           else
           {
             m_pBattlestar->m_blIncoming2=false;
           }
           m_nAI=AI_CHASE;
           m_nZ=10;
           m_nILSPoint=0;
           m_pEngine->Sort();
        }
        break;

        case AI_ESCORT:
        Ai_Escort(a_fLagCount);
        break;

        case AI_LAUNCH:
        Ai_Launch(a_fLagCount);
        break;
    }





    if (m_fSpeed<0)
    {
        m_fSpeed=0;
    }
    if (m_fSpeed>m_fMaxSpeed)
    {
        m_fSpeed=m_fMaxSpeed;
    }

    if (m_fFireDelay>0)
    {
        m_fFireDelay-=a_fLagCount;
    }

    if (m_fFireDelaySpartan>0)
    {
       m_fFireDelaySpartan-=(a_fLagCount*2);
    }





    if ((m_nHealth<=0)&&(!m_blDestroyed))
    {
        m_blDestroyed=true;
        bsgExplosion * pE;
        pE=new bsgExplosion;
        pE->m_nZ=m_nZ+1;
        pE->m_fX=m_fX;
        pE->m_fY=m_fY;
        pE->m_fAngle=m_fAngle;
        pE->m_fSpeed=m_fSpeed;
        m_pEngine->add(pE);



        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_EXPLODE));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }



        if (m_pBattlestar!=NULL)
        {
            ((bsgBattlestar *)m_pBattlestar)->m_nVipersInAction--;
        }

    }
    else
    {
        if (pObstacle != NULL)
        {
            double e = evade(pObstacle->m_fX,pObstacle->m_fY,50,200);
            if ( e!=0 )
            {
                m_fAngleSeek = m_fAngle + e;
                m_fSpeed = m_fMaxSpeed /2;
            }
        }


        if (! m_blLaunching) Control();
    }

}

void bsgViper::Fire()
{

    if (m_fFireDelay<=0)
    {
        bsgBullet * pB;
        int nOfsX=-10;
        int nOfsY=6;

        if (m_blFireLinked)
        {

        float fL1X=(m_fX+((-nOfsX*m_fCosAngle)-(-nOfsY*m_fSinAngle)));
        float fL1Y=(m_fY+((-nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));
        float fL2X=(m_fX+((-nOfsX*m_fCosAngle)-(+nOfsY*m_fSinAngle)));
        float fL2Y=(m_fY+((+nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));

        pB=new bsgBullet(BT_LASER1);
        pB->m_fX=fL1X;
        pB->m_fY=fL1Y;
        pB->m_nZ=m_nZ-1;
        pB->m_fSpeed=m_fSpeed+6;
        pB->m_fAngle=m_fAngle;
        pB->m_nTeam=m_nTeam;
        if (m_nType==ID_PLAYER)
        {
            pB->m_blPlayerBullet=true;
        }


        m_pEngine->add(pB);

        pB=new bsgBullet(BT_LASER1);
        pB->m_fX=fL2X;
        pB->m_fY=fL2Y;
        pB->m_nZ=m_nZ-1;
        pB->m_fSpeed=m_fSpeed+6;
        pB->m_fAngle=m_fAngle;
        pB->m_nTeam=m_nTeam;
        if (m_nType==ID_PLAYER)
        {
            pB->m_blPlayerBullet=true;
        }
        m_pEngine->add(pB);

        m_fFireDelay=40;
        }
        else
        {
          if (m_blOdd)
          {
            float fL1X=(m_fX+((-nOfsX*m_fCosAngle)-(-nOfsY*m_fSinAngle)));
            float fL1Y=(m_fY+((-nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));


            pB=new bsgBullet(BT_LASER1);
            pB->m_fX=fL1X;
            pB->m_fY=fL1Y;
            pB->m_nZ=m_nZ-1;
            pB->m_fSpeed=m_fSpeed+6;
            pB->m_fAngle=m_fAngle;
            pB->m_nTeam=m_nTeam;
            m_pEngine->add(pB);
            m_fFireDelay=20;
          }
          else
          {
             float fL2X=(m_fX+((-nOfsX*m_fCosAngle)-(+nOfsY*m_fSinAngle)));
             float fL2Y=(m_fY+((+nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));

             pB=new bsgBullet(BT_LASER1);
             pB->m_fX=fL2X;
             pB->m_fY=fL2Y;
             pB->m_nZ=m_nZ-1;
             pB->m_fSpeed=m_fSpeed+6;
             pB->m_fAngle=m_fAngle;
             pB->m_nTeam=m_nTeam;
             m_pEngine->add(pB);
             m_fFireDelay=20;
          }

          m_blOdd=!m_blOdd;
        }


        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_VIPERLASER));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }



    }

}


void bsgViper::launch()
{
    m_nAI=AI_LAUNCH;
}


void bsgViper::land()
{
    m_nAI=AI_DOCK;
}

void bsgViper::SetBay(int a_nLaunchBay)
{
    m_nBAY=a_nLaunchBay;
}


void bsgViper::Ai_Chase(float a_fLagCount)
{
    if (m_pTarget!=NULL)
    {
        float fD = distance(m_fX,m_fY,m_pTarget->m_fX,m_pTarget->m_fY);
        float fShotLead=fD/8;
        float fSX=m_pTarget->m_fX+m_pTarget->m_fCosAngle*m_pTarget->m_fSpeed*fShotLead;
        float fSY=m_pTarget->m_fY+m_pTarget->m_fSinAngle*m_pTarget->m_fSpeed*fShotLead;

        m_fAngleSeek=waypoint(fSX,fSY);

        m_fSpeed=fD/50;

        float fT=m_fAngleSeek-m_fAngle;
        if (fT<0)
            fT=-fT;
        if ((fD<=600)&&(fD>100)&&(fT<0.1))
        {
            Fire();
        }

        if ((fD<=1500)&&(fD>300)&&(fT<0.2))
        {
            FireSpartan();
        }

        if (fD<100)
        {
           m_nAI=AI_EVADE;
        }
    }
    else
    {
        // ToDo pick another AI state



    }

}



void bsgViper::Ai_Evade(float a_fLagCount)
{
    if (m_pTarget!=NULL)
    {
        float fD = distance(m_fX,m_fY,m_pTarget->m_fX,m_pTarget->m_fY);

        float fSX=m_pTarget->m_fX;
        float fSY=m_pTarget->m_fY;
        float fTargetAngle=waypoint(fSX,fSY);
        m_fAngleSeek=fTargetAngle+2*PI;
        m_fSpeed=m_fMaxSpeed;

        float fT=fTargetAngle-m_fAngle;
        if (fT<0)
        {
            fT=-fT;
        }

        if ((fD<=600)&&(fD>100)&&(fT<0.1))
        {
            Fire();
        }

        if ((fD>600)||(fT<1))
        {
           m_nAI=AI_CHASE;
        }

    }
    else
    {
        m_fSpeed=m_fMaxSpeed/2;
        // ToDo pick another AI state
        if (m_pBattlestar!=NULL)
        {
           SetWaypoint(m_pBattlestar->m_fX,m_pBattlestar->m_fY,false);
        }
    }
}



void bsgViper::Ai_Dock(float a_fLagCount)
{

    if (m_nILSPoint<4)
    {
        m_IlsPoint      = m_pBattlestar->GetILSPoint(m_nILSPoint,m_nBAY);
        m_fAngleSeek    = waypoint(m_IlsPoint.m_nX,m_IlsPoint.m_nY);

        float fD = distance(m_fX,m_fY,m_IlsPoint.m_nX,m_IlsPoint.m_nY);

        float fAdjustSpeed=m_fMaxSpeed;
        if (m_nILSPoint>1) fAdjustSpeed=m_fMaxSpeed+3;

        if (m_fSpeed<fAdjustSpeed/((m_nILSPoint+1)))
        {
           m_fSpeed+=0.4;
        }

        if (m_fSpeed>fAdjustSpeed/((m_nILSPoint+1)))
        {
           m_fSpeed-=0.4;
        }

        if (fD<50-(m_nILSPoint*10))
        {
            m_nILSPoint++;
            if (m_nILSPoint > 2)
            {
               m_nZ=1;
               m_pEngine->Sort();
               m_pTarget=NULL;
            }
        }
    }
    else
    {
         m_fSpeed=0;
         m_blDocking=false;
         m_nZ = 1;
         assert(m_pBattlestar!=NULL);

         if (m_nType==ID_PLAYER)
         {
             m_pBattlestar->m_nPlayerDocked=true;
             m_blDestroyed=true;
             m_pBattlestar->m_nVipersInAction--;
         }
         else
         {
             if ( m_nBAY==BAY_LEFT)
             {
                m_pBattlestar->m_nVipersBay1++;
                m_pBattlestar->m_blIncoming1=false;
                m_pBattlestar->m_nVipersInAction--;
             }
             else if ( m_nBAY==BAY_RIGHT)
             {
                 m_pBattlestar->m_nVipersBay2++;
                 m_pBattlestar->m_blIncoming2=false;
                 m_pBattlestar->m_nVipersInAction--;
             }

             m_blDestroyed=true;
         }
    }
}


void bsgViper::Ai_Launch(float a_fLagCount)
{
    if (m_nZ<10)
    {
        m_nZ=1;

        if (m_fSpeed==0)
        {
           m_nWaypointX=int(m_fX+500);
           m_nWaypointY=int(m_fY);
           m_fAngleSeek=waypoint(m_nWaypointX,m_nWaypointY);
        }

        float fD = distance(m_fX,m_fY,m_nWaypointX,m_nWaypointY);

        m_fSpeed=m_fMaxSpeed;

        if (fD<20)
        {
            m_nZ=10;
            m_pEngine->Sort();
        }

    }
    else
    {
         m_blLaunching = false;
         m_nILSPoint   = 0;
         m_blInitDocking=true;
         switch (m_nPosture)
         {
           case POS_DEFEND_GALACTICA:
              SetWaypoint(m_fX-100*m_nWingNr,m_fY-200,false);
           break;

           case POS_SKIRMISH:
              SetWaypoint(m_fX+200,m_fY,false);
           break;

           case POS_STRIKE:
              SetWaypoint(m_fX,m_fY,false);
              // for now
           break;

         }
    }
}


bool LoadViperSprites()
{
    g_pimViper = new Bitmap("Gfx/Still/Viper.png");
    g_pimViperShadow = new Bitmap("Gfx/Still/Vipershd.png");

    if ((g_pimViper!=NULL)&&(g_pimViperShadow!=NULL))
    {
            return true;
    }
    else
    {
           return false;
    }
}











