/*
Copyright (C) 2006  E.J.M. Martens

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <FMOD/fmod.h>

#include "AIDef.h"
#include "main.h"
#include "bsgTurret.h"
#include "bsgBullet.h"
#include "bsgExplosion.h"

Bitmap    * g_pimTurret=NULL;


bsgTurret::bsgTurret(int a_nTurretType)
{
    m_nTeam=MEM_COLONY;
    m_nType=ID_TURRET;
    m_fFireDelay=0;
    m_fSpeed=0;
    m_fMaxSpeed=0;
    m_fSteer=0.03;
    m_nMaxHealth=900;
	m_nHealth=m_nMaxHealth;
    SetImage(g_pimTurret);

    switch(a_nTurretType)
    {
       case TT_LEFT:
       m_nTurretType=TT_LEFT;
       m_fMinAngle=PI+0.1;
       m_fMaxAngle=2*PI-0.2;
       m_fAngle=m_fMinAngle;
       m_fAngleSeek=m_fMinAngle;
       break;

       case TT_RIGHT:
       m_nTurretType=TT_RIGHT;
       m_fMinAngle=0.2;
       m_fMaxAngle=PI-0.1;
       m_fAngle=m_fMaxAngle;
       m_fAngleSeek=m_fMaxAngle;
       break;

       case TT_360:
       m_nTurretType=TT_360;
       m_fMinAngle=-1;
       m_fMaxAngle=-1;
       m_fAngle=0;
       m_fAngleSeek=0;
       break;
     }
}


bsgTurret::~bsgTurret()
{

}


void bsgTurret::do_ai(float a_fLagCount)
{
    m_pTarget=SeekTarget();


    if ((m_pTarget!=NULL)&&(m_pTarget->m_blDestroyed))
    {
        m_pTarget=NULL;
    }

    if (m_fFireDelay>0)
    {
        m_fFireDelay-=a_fLagCount;
    }

    if (m_pTarget!=NULL)
    {
        float fD = distance(m_fX,m_fY,m_pTarget->m_fX,m_pTarget->m_fY);


        float fSX=m_pTarget->m_fX+m_pTarget->m_fCosAngle*m_pTarget->m_fSpeed*(fD/10);
        float fSY=m_pTarget->m_fY+m_pTarget->m_fSinAngle*m_pTarget->m_fSpeed*(fD/10);

        m_fAngleSeek=waypoint(fSX,fSY);
        float fT=m_fAngleSeek-m_fAngle;

        if (fT<0)
        {
            fT=-fT;
        }

        m_fSteer=fT/5;
        if (m_fSteer>0.1)
        {
          m_fSteer=0.1;
        }

        if ((fD<=600)&&(fD>150)&&(fT<0.1))
        {
            Fire();
        }
    }
    else
    {
         m_fSteer=0.02;
         switch (m_nTurretType)
         {
         case TT_RIGHT:
              m_fAngleSeek=PI/2;
              break;

         case TT_LEFT:
              m_fAngleSeek=2*PI-(PI/2);
              break;

         case TT_360:
              m_fAngleSeek=m_fRestAngle;
              break;
         }

    }

    if ((m_nHealth<=0)&&(!m_blDestroyed))
    {
        m_blDestroyed=true;
        bsgExplosion * pE;
        pE=new bsgExplosion;
        pE->m_nZ=m_nZ+1;
        pE->m_fX=m_fX;
        pE->m_fY=m_fY;
        pE->m_fAngle=m_fAngle;
        pE->m_fSpeed=m_fSpeed;
        m_pEngine->add(pE);

        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_EXPLODE));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }

    }
    else
    {
        Control();
    }

}

void bsgTurret::Fire()
{

    if (m_fFireDelay<=0)
    {
        bsgBullet * pB;
        int nOfsX=-10;
        int nOfsY=6;

        float fL1X=(m_fX+((-nOfsX*m_fCosAngle)-(-nOfsY*m_fSinAngle)));
        float fL1Y=(m_fY+((-nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));
        float fL2X=(m_fX+((-nOfsX*m_fCosAngle)-(+nOfsY*m_fSinAngle)));
        float fL2Y=(m_fY+((+nOfsY*m_fCosAngle)+(-nOfsX*m_fSinAngle)));

        pB=new bsgBullet(BT_LASER1);
        pB->m_fX=fL1X;
        pB->m_fY=fL1Y;
        pB->m_nZ=m_nZ-1;
        pB->m_fSpeed=8;
        pB->m_fAngle=m_fAngle;
        pB->m_nTeam=m_nTeam;
        m_pEngine->add(pB);

        pB=new bsgBullet(BT_LASER1);
        pB->m_fX=fL2X;
        pB->m_fY=fL2Y;
        pB->m_nZ=m_nZ-1;
        pB->m_fSpeed=8;
        pB->m_fAngle=m_fAngle;
        pB->m_nTeam=m_nTeam;
        m_pEngine->add(pB);

        m_fFireDelay=40;

        float fD = distance(m_fX,m_fY,m_pEngine->m_nCameraX,m_pEngine->m_nCameraY);
        int nCannelHandle=FSOUND_PlaySound(FSOUND_FREE,GetSample(SND_LASER));
        if (fD<400)
        {
            FSOUND_SetVolume(nCannelHandle,255);
        }
        else
        {
            FSOUND_SetVolume(nCannelHandle,100);
        }

    }
}

void bsgTurret::setFiringArc(float a_fMinArc,float a_fMaxArc)
{
   m_fMinAngle=a_fMinArc;
   m_fMaxAngle=a_fMaxArc;
}


void bsgTurret::move(float a_fLagCount)
{



}


void bsgTurret::Control()
{
    float fStr=m_fSteer;

    if (m_fAngle<m_fAngleSeek)
    {
        m_fAngle+=fStr;
    }
    if (m_fAngle>m_fAngleSeek)
    {
        m_fAngle-=fStr;
    }
    if (m_fAngle>2*PI)
    {
        m_fAngle=m_fAngle-(2*PI);
    }
    if (m_fAngle<0)
    {
        m_fAngle=(2*PI)+m_fAngle;
    }
    if (m_fAngleSeek>2*PI)
    {
        m_fAngleSeek=m_fAngleSeek-(2*PI);
    }
    if (m_fAngleSeek<0)
    {
        m_fAngleSeek=(2*PI)+m_fAngleSeek;
    }

    if (m_nTurretType!=TT_360)
    {
        if (m_fAngle<m_fMinAngle)
        {
           m_fAngle=m_fMinAngle;
        }

        if (m_fAngle>m_fMaxAngle)
        {
           m_fAngle=m_fMaxAngle;
        }
    }
}



bsgShip * bsgTurret::SeekTarget()
{
    bsgSprite * pTarget=NULL;
    float nDist=VIEW_DISTANCE;
    float nD;
    std::list<bsgSprite *>::iterator p=m_pEngine->m_lstItems.begin();
    while (p!=m_pEngine->m_lstItems.end())
    {
        bsgSprite * pHulp=((bsgSprite *)*p);
        if ((pHulp->m_nTeam!=m_nTeam)&&(!pHulp->m_blDestroyed)&&(pHulp->m_nType>=ID_TARGETABLE)&&(pHulp!=this))
        {
            nD=distance(m_fX,m_fY,pHulp->m_fX,pHulp->m_fY);
            if (nD<=nDist)
            {
                pTarget=pHulp;
                nDist=nD;
            }
        }
        p++;
    }
    return ((bsgShip *) pTarget);
}



bool LoadTurretSprites()
{
    g_pimTurret = new Bitmap("Gfx/Still/Turret.png");
    if (g_pimTurret!=NULL)
    {
            return true;
    }
    else
    {
           return false;
    }
}



















